// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _PDG_FES_SETUP_H_
#define _PDG_FES_SETUP_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	transmit_fes_type[3:0], medium_prot_type[6:4], su_response_type[9:7], reserved_0_a[17:10], mprot_required_bw20[18], mprot_required_bw40[19], mprot_required_bw80[20], ppdu_allowed_bw20[21], ppdu_allowed_bw40[22], ppdu_allowed_bw80[23], other_queues_more_data[24], bw_indication_enable[25], set_fc_pwr_mgt[26], reserved_0_b[31:27]
//	1	location_req[0], location_type[1], expect_ndp[2], ndp_feedback_type[3], reserved_0a[4], ndp_nc_index[7:5], ndp_nc_override[8], expect_cbf[9], cbf_user_number[11:10], uapsd_rem_resp_frame_cnt[19:12], bf_type[21:20], bf_entire_pkt[22], implicit_bf[23], reserved_1b[27:24], channel_capture[28], reserved_1c[29], clpc_en[30], measure_power[31]
//	2	max_fes_time[15:0], max_ppdu_time[31:16]
//	3	max_txop_time[15:0], extend_duration_value[31:16]
//	4	duration_field_ctrl[1:0], duration_extension[2], group_id[8:3], reserved_4[31:9]
//	5-6	struct tx_rate_setting tx_rate_ctr_mprot_bw20;
//	7-8	struct tx_rate_setting tx_rate_ctr_mprot_bw40;
//	9-10	struct tx_rate_setting tx_rate_ctr_mprot_bw80;
//	11-12	struct tx_rate_setting response_rate_mprot_bw20;
//	13-14	struct tx_rate_setting response_rate_mprot_bw40;
//	15-16	struct tx_rate_setting response_rate_mprot_bw80;
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_PDG_FES_SETUP 17

struct pdg_fes_setup {
    volatile uint32_t transmit_fes_type               :  4, //[3:0]
                      medium_prot_type                :  3, //[6:4]
                      su_response_type                :  3, //[9:7]
                      reserved_0_a                    :  8, //[17:10]
                      mprot_required_bw20             :  1, //[18]
                      mprot_required_bw40             :  1, //[19]
                      mprot_required_bw80             :  1, //[20]
                      ppdu_allowed_bw20               :  1, //[21]
                      ppdu_allowed_bw40               :  1, //[22]
                      ppdu_allowed_bw80               :  1, //[23]
                      other_queues_more_data          :  1, //[24]
                      bw_indication_enable            :  1, //[25]
                      set_fc_pwr_mgt                  :  1, //[26]
                      reserved_0_b                    :  5; //[31:27]
    volatile uint32_t location_req                    :  1, //[0]
                      location_type                   :  1, //[1]
                      expect_ndp                      :  1, //[2]
                      ndp_feedback_type               :  1, //[3]
                      reserved_0a                     :  1, //[4]
                      ndp_nc_index                    :  3, //[7:5]
                      ndp_nc_override                 :  1, //[8]
                      expect_cbf                      :  1, //[9]
                      cbf_user_number                 :  2, //[11:10]
                      uapsd_rem_resp_frame_cnt        :  8, //[19:12]
                      bf_type                         :  2, //[21:20]
                      bf_entire_pkt                   :  1, //[22]
                      implicit_bf                     :  1, //[23]
                      reserved_1b                     :  4, //[27:24]
                      channel_capture                 :  1, //[28]
                      reserved_1c                     :  1, //[29]
                      clpc_en                         :  1, //[30]
                      measure_power                   :  1; //[31]
    volatile uint32_t max_fes_time                    : 16, //[15:0]
                      max_ppdu_time                   : 16; //[31:16]
    volatile uint32_t max_txop_time                   : 16, //[15:0]
                      extend_duration_value           : 16; //[31:16]
    volatile uint32_t duration_field_ctrl             :  2, //[1:0]
                      duration_extension              :  1, //[2]
                      group_id                        :  6, //[8:3]
                      reserved_4                      : 23; //[31:9]
    struct            tx_rate_setting                       tx_rate_ctr_mprot_bw20;
    struct            tx_rate_setting                       tx_rate_ctr_mprot_bw40;
    struct            tx_rate_setting                       tx_rate_ctr_mprot_bw80;
    struct            tx_rate_setting                       response_rate_mprot_bw20;
    struct            tx_rate_setting                       response_rate_mprot_bw40;
    struct            tx_rate_setting                       response_rate_mprot_bw80;
};

/*

transmit_fes_type
			
			<enum 0 self_gen_bar> A self-generated BAR frame is
			transmitted. 
			
			SU transmission only.
			
			<enum 1 self_gen_data_null> A self-generated Data null
			frame is transmitted. SU transmission only.
			
			<enum 2 self_gen_qos_null> A self-generated QoS null
			frame is transmitted. SU transmission only.
			
			<enum 3 self_gen_cf_end> A self-generated CF-end frame
			is transmitted. SU transmission only
			
			<enum 4 regular_transmission>  A Scheduled SU
			transmission
			
			
			
			15-5 Reserved

medium_prot_type
			
			Self Gen Medium Protection type used
			
			0: No protection
			
			1: RTS (legacy)
			
			2: RTS (11ac static bandwidth)
			
			3: RTS (11ac dynamic bandwidth)
			
			4: CTS2Self
			
			5-7: Reserved

su_response_type
			
			PPDU transmission Response type expected in case of SU
			transmission
			
			0: No response expected
			
			1: ACK expected2: BA expected
			
			3: Action No Ack frame expected (after NDP)
			
			7-4: Reserved

reserved_0_a
			

mprot_required_bw20
			
			Field only valid when ppdu_allowed_bw20 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 20 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0. <legal all>

mprot_required_bw40
			
			Field only valid when ppdu_allowed_bw40 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 40 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0<legal all>

mprot_required_bw80
			
			Field only valid when ppdu_allowed_bw80 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 80 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0. <legal all>

ppdu_allowed_bw20
			
			When set, allow PPDU transmission with 20 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0. <legal all>

ppdu_allowed_bw40
			
			When set, allow PPDU transmission with 40 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0. <legal all>

ppdu_allowed_bw80
			
			When set, allow PPDU transmission with 80 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0 <legal all>

other_queues_more_data
			
			This setting is passed on to the PCU in the
			PCU_PPDU_SETUP TLV. It is used by the PCU TX to determine if
			it needs to set the More data bit in the FC field for the
			transmitted frames

bw_indication_enable
			
			Indicates that the self gen frame requires bw indication
			in service and TA[0] set to 1.

set_fc_pwr_mgt
			
			When set, the TX PCU will set the power management bit
			in the Frame Control field for the transmitted frames.
			
			This will only be set for the SW generated path.
			
			<legal all>

reserved_0_b
			
			<legal 0>

location_req
			
			When set, a TX_LOCATION_REQ TLV should be generated by
			the PCU to the PHY TX  before this transmission starts.

location_type
			
			This field is only valid when Location_req is set.
			
			This field is used to define what kind of RTT response
			is required by the MAC and it is inserted into the
			TX_LOCATION_REQ TLV generated by the TX PCU
			
			<enum 0     ifft_response>   Indicates iFFT response
			format
			
			
			<legal 0-1>

expect_ndp
			
			When set, a TX_EXPECT_NDP TLV should be generated by the
			TX PCU to the PHY.
			
			
			
			Used for debugging purposes and to allow alternative
			Frame eschange sequences

ndp_feedback_type
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			<enum 2     11ac_su>  Expect 11ac NDP and create SU
			feedback
			
			<enum 3     11ac_mu>  Expect 11ac NDP and create MU
			feedback
			
			<legal 2-3>

reserved_0a
			
			Reserved: Generator should set to 0 and consumer shall
			ignore. <legal 0>

ndp_nc_index
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			Defines the dimension Nc for the beamforming feedback
			matrix. Nc_index values > 3 are not supported in Beeliner.
			
			<legal 0-3>

ndp_nc_override
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			This bit is set if the PHY is required to override its
			internally-calculated Nc value with the one provided by the
			MAC in this TLV.  <legal 0-1>

expect_cbf
			
			When set, a TX_EXPECT_NDP TLV should be generated by the
			TX PCU to the PHY after the transmission of the PPDU.

cbf_user_number
			
			This field is only valid when expect_cbf is set.
			
			This field is inserted into the TX_EXPECT_CBF TLV
			generated by the TX PCU.
			
			
			
			Defines the source of the expected CBF.  
			
			<legal 0-3>

uapsd_rem_resp_frame_cnt
			
			Field only valid in case of U-APSD response handling
			
			
			
			This field indicates the remaining  maximum number of
			frames to transmit for the uapsd response. If this number is
			reached, the PDG should indicate to the PCU to set the EOSP
			bit in the QoS control field.
			
			<legal all>

bf_type
			
			<enum 0     NO_BF> Transmit a non-beamformed packet
			
			<enum 1     LEGACY_BF> Transmit a legacy beamformed
			packet.  This means beamforming starts at the L-STF.  The
			possible preamble formats are 11a, 11n mixed mode and 11ac. 
			This is used to support legacy implicit beamforming. 
			
			<enum 2     SU_BF> Transmit a single-user beamformed
			packet starting at the HT-STF or VHT-STF.
			
			<enum 3     MU_BF> Transmit a multi-user beamformed
			packet starting at the VHT-STF.
			
			<legal 0-3>

bf_entire_pkt
			
			When this flag is set, the PHY TX shall begin applying
			beamforming weights at the start of the packet. If this flag
			is not set, the PHY TX shall begin applying weights at the
			start of the non-legacy portion of the packet. <legal 0-1>

implicit_bf
			
			When this flag is set, the SVD module should perform
			implicit feedback computation on the next received packet.
			<legal 0-1>

reserved_1b
			
			<legal 0>

channel_capture
			
			When set, indicates that the BB should be armed to
			capture the channel on the next received packet. This
			channel estimate is passed to the MAC if the packet is
			successfully received. 
			
			Copied by PDG into the channel_capture field in the
			PPDU_TX_PHY_DESC TLV
			
			<legal 0-1>

reserved_1c
			
			<legal 0>

clpc_en
			
			This field enables closed-loop TPC operation by enabling
			CLPC adjustment of DAC gain for the next packet.
			
			<enum 0     clpc_off> TPC error update disabled
			
			<enum 1     clpc_on> TPC error will be applied to DAC
			gain setting for the next packet
			
			<legal 0-1>

measure_power
			
			This field enables the TPC to use power measurement for
			current packet in CLPC updates.
			
			<enum 0     measure_dis> TPC will not latch power
			measurement result for current packet
			
			<enum 1     measure_en> TPC will latch power measurement
			result for current packet

max_fes_time
			
			The maximum medium time (in us) that the total Frame
			exchange sequence is allowed to take.  <legal all>

max_ppdu_time
			
			The maximum medium time (in us) that the PPDU Frame is
			allowed to take. <legal all>

max_txop_time
			
			The maximum TXOP time (in us) that is remaining for the
			upcoming Frame Exchange Sequence (FES). The final maximum
			duration for the upcoming FES is the smallest of
			max_fes_time and max_TXOP_time.
			
			The max_TXOP_time field can also be used for determining
			the Duration value that should be inserted into the Frames.
			
			
			
			  <legal all>

extend_duration_value
			
			Field only valid when Duration_extension is set.
			
			The amount of time (in us) added to the calculated
			duration value

duration_field_ctrl
			
			Duration field value generation control
			
			0: Set duration field to 0
			
			1: Protect entire FES
			
			2: protect entire TXOP
			
			<legal 0-2>

duration_extension
			
			Duration extension control
			
			0: No action
			
			1: Add the extra_duration_value to the calculated
			duration field.

group_id
			
			Field only valid when Transmit_fes_type indicates a
			regular (non self generated) transmission
			
			
			
			When PDG detects that the transmission is at a VHT rate,

reserved_4
			
			<legal 0>

struct tx_rate_setting tx_rate_ctr_mprot_bw20
			
			Field only valid when Mprot_required_bw20 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 20 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0

struct tx_rate_setting tx_rate_ctr_mprot_bw40
			
			Field only valid when Mprot_required_bw40 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 40 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0

struct tx_rate_setting tx_rate_ctr_mprot_bw80
			
			Field only valid when Mprot_required_bw80 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 80 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0

struct tx_rate_setting response_rate_mprot_bw20
			
			Field only valid when Mprot_required_bw20 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 20 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0

struct tx_rate_setting response_rate_mprot_bw40
			
			Field only valid when Mprot_required_bw40 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 40 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0

struct tx_rate_setting response_rate_mprot_bw80
			
			Field only valid when Mprot_required_bw80 is set.
			
			Structure containing all the rate information for
			transmitting a medium protection frame at 80 MHz.
			
			In case of MU transmissions, all the medium protection
			settings are coming from user0
*/


/* Description		PDG_FES_SETUP_0_TRANSMIT_FES_TYPE
			
			<enum 0 self_gen_bar> A self-generated BAR frame is
			transmitted. 
			
			SU transmission only.
			
			<enum 1 self_gen_data_null> A self-generated Data null
			frame is transmitted. SU transmission only.
			
			<enum 2 self_gen_qos_null> A self-generated QoS null
			frame is transmitted. SU transmission only.
			
			<enum 3 self_gen_cf_end> A self-generated CF-end frame
			is transmitted. SU transmission only
			
			<enum 4 regular_transmission>  A Scheduled SU
			transmission
			
			
			
			15-5 Reserved
*/
#define PDG_FES_SETUP_0_TRANSMIT_FES_TYPE_OFFSET                     0x00000000
#define PDG_FES_SETUP_0_TRANSMIT_FES_TYPE_LSB                        0
#define PDG_FES_SETUP_0_TRANSMIT_FES_TYPE_MASK                       0x0000000f

/* Description		PDG_FES_SETUP_0_MEDIUM_PROT_TYPE
			
			Self Gen Medium Protection type used
			
			0: No protection
			
			1: RTS (legacy)
			
			2: RTS (11ac static bandwidth)
			
			3: RTS (11ac dynamic bandwidth)
			
			4: CTS2Self
			
			5-7: Reserved
*/
#define PDG_FES_SETUP_0_MEDIUM_PROT_TYPE_OFFSET                      0x00000000
#define PDG_FES_SETUP_0_MEDIUM_PROT_TYPE_LSB                         4
#define PDG_FES_SETUP_0_MEDIUM_PROT_TYPE_MASK                        0x00000070

/* Description		PDG_FES_SETUP_0_SU_RESPONSE_TYPE
			
			PPDU transmission Response type expected in case of SU
			transmission
			
			0: No response expected
			
			1: ACK expected2: BA expected
			
			3: Action No Ack frame expected (after NDP)
			
			7-4: Reserved
*/
#define PDG_FES_SETUP_0_SU_RESPONSE_TYPE_OFFSET                      0x00000000
#define PDG_FES_SETUP_0_SU_RESPONSE_TYPE_LSB                         7
#define PDG_FES_SETUP_0_SU_RESPONSE_TYPE_MASK                        0x00000380

/* Description		PDG_FES_SETUP_0_RESERVED_0_A
			
*/
#define PDG_FES_SETUP_0_RESERVED_0_A_OFFSET                          0x00000000
#define PDG_FES_SETUP_0_RESERVED_0_A_LSB                             10
#define PDG_FES_SETUP_0_RESERVED_0_A_MASK                            0x0003fc00

/* Description		PDG_FES_SETUP_0_MPROT_REQUIRED_BW20
			
			Field only valid when ppdu_allowed_bw20 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 20 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0. <legal all>
*/
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW20_OFFSET                   0x00000000
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW20_LSB                      18
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW20_MASK                     0x00040000

/* Description		PDG_FES_SETUP_0_MPROT_REQUIRED_BW40
			
			Field only valid when ppdu_allowed_bw40 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 40 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0<legal all>
*/
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW40_OFFSET                   0x00000000
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW40_LSB                      19
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW40_MASK                     0x00080000

/* Description		PDG_FES_SETUP_0_MPROT_REQUIRED_BW80
			
			Field only valid when ppdu_allowed_bw80 is set.
			
			
			
			When set, Medium protection transmission is required for
			a 80 MHz bandwidth PPDU transmission. In case of MU
			transmissions, all the medium protection settings are coming
			from user0. <legal all>
*/
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW80_OFFSET                   0x00000000
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW80_LSB                      20
#define PDG_FES_SETUP_0_MPROT_REQUIRED_BW80_MASK                     0x00100000

/* Description		PDG_FES_SETUP_0_PPDU_ALLOWED_BW20
			
			When set, allow PPDU transmission with 20 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0. <legal all>
*/
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW20_OFFSET                     0x00000000
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW20_LSB                        21
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW20_MASK                       0x00200000

/* Description		PDG_FES_SETUP_0_PPDU_ALLOWED_BW40
			
			When set, allow PPDU transmission with 40 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0. <legal all>
*/
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW40_OFFSET                     0x00000000
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW40_LSB                        22
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW40_MASK                       0x00400000

/* Description		PDG_FES_SETUP_0_PPDU_ALLOWED_BW80
			
			When set, allow PPDU transmission with 80 MHz bandwidth.
			In case of MU transmissions, all the ppdu allowed bw
			settings are coming from user0 <legal all>
*/
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW80_OFFSET                     0x00000000
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW80_LSB                        23
#define PDG_FES_SETUP_0_PPDU_ALLOWED_BW80_MASK                       0x00800000

/* Description		PDG_FES_SETUP_0_OTHER_QUEUES_MORE_DATA
			
			This setting is passed on to the PCU in the
			PCU_PPDU_SETUP TLV. It is used by the PCU TX to determine if
			it needs to set the More data bit in the FC field for the
			transmitted frames
*/
#define PDG_FES_SETUP_0_OTHER_QUEUES_MORE_DATA_OFFSET                0x00000000
#define PDG_FES_SETUP_0_OTHER_QUEUES_MORE_DATA_LSB                   24
#define PDG_FES_SETUP_0_OTHER_QUEUES_MORE_DATA_MASK                  0x01000000

/* Description		PDG_FES_SETUP_0_BW_INDICATION_ENABLE
			
			Indicates that the self gen frame requires bw indication
			in service and TA[0] set to 1.
*/
#define PDG_FES_SETUP_0_BW_INDICATION_ENABLE_OFFSET                  0x00000000
#define PDG_FES_SETUP_0_BW_INDICATION_ENABLE_LSB                     25
#define PDG_FES_SETUP_0_BW_INDICATION_ENABLE_MASK                    0x02000000

/* Description		PDG_FES_SETUP_0_SET_FC_PWR_MGT
			
			When set, the TX PCU will set the power management bit
			in the Frame Control field for the transmitted frames.
			
			This will only be set for the SW generated path.
			
			<legal all>
*/
#define PDG_FES_SETUP_0_SET_FC_PWR_MGT_OFFSET                        0x00000000
#define PDG_FES_SETUP_0_SET_FC_PWR_MGT_LSB                           26
#define PDG_FES_SETUP_0_SET_FC_PWR_MGT_MASK                          0x04000000

/* Description		PDG_FES_SETUP_0_RESERVED_0_B
			
			<legal 0>
*/
#define PDG_FES_SETUP_0_RESERVED_0_B_OFFSET                          0x00000000
#define PDG_FES_SETUP_0_RESERVED_0_B_LSB                             27
#define PDG_FES_SETUP_0_RESERVED_0_B_MASK                            0xf8000000

/* Description		PDG_FES_SETUP_1_LOCATION_REQ
			
			When set, a TX_LOCATION_REQ TLV should be generated by
			the PCU to the PHY TX  before this transmission starts.
*/
#define PDG_FES_SETUP_1_LOCATION_REQ_OFFSET                          0x00000004
#define PDG_FES_SETUP_1_LOCATION_REQ_LSB                             0
#define PDG_FES_SETUP_1_LOCATION_REQ_MASK                            0x00000001

/* Description		PDG_FES_SETUP_1_LOCATION_TYPE
			
			This field is only valid when Location_req is set.
			
			This field is used to define what kind of RTT response
			is required by the MAC and it is inserted into the
			TX_LOCATION_REQ TLV generated by the TX PCU
			
			<enum 0     ifft_response>   Indicates iFFT response
			format
			
			
			<legal 0-1>
*/
#define PDG_FES_SETUP_1_LOCATION_TYPE_OFFSET                         0x00000004
#define PDG_FES_SETUP_1_LOCATION_TYPE_LSB                            1
#define PDG_FES_SETUP_1_LOCATION_TYPE_MASK                           0x00000002

/* Description		PDG_FES_SETUP_1_EXPECT_NDP
			
			When set, a TX_EXPECT_NDP TLV should be generated by the
			TX PCU to the PHY.
			
			
			
			Used for debugging purposes and to allow alternative
			Frame eschange sequences
*/
#define PDG_FES_SETUP_1_EXPECT_NDP_OFFSET                            0x00000004
#define PDG_FES_SETUP_1_EXPECT_NDP_LSB                               2
#define PDG_FES_SETUP_1_EXPECT_NDP_MASK                              0x00000004

/* Description		PDG_FES_SETUP_1_NDP_FEEDBACK_TYPE
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			<enum 2     11ac_su>  Expect 11ac NDP and create SU
			feedback
			
			<enum 3     11ac_mu>  Expect 11ac NDP and create MU
			feedback
			
			<legal 2-3>
*/
#define PDG_FES_SETUP_1_NDP_FEEDBACK_TYPE_OFFSET                     0x00000004
#define PDG_FES_SETUP_1_NDP_FEEDBACK_TYPE_LSB                        3
#define PDG_FES_SETUP_1_NDP_FEEDBACK_TYPE_MASK                       0x00000008

/* Description		PDG_FES_SETUP_1_RESERVED_0A
			
			Reserved: Generator should set to 0 and consumer shall
			ignore. <legal 0>
*/
#define PDG_FES_SETUP_1_RESERVED_0A_OFFSET                           0x00000004
#define PDG_FES_SETUP_1_RESERVED_0A_LSB                              4
#define PDG_FES_SETUP_1_RESERVED_0A_MASK                             0x00000010

/* Description		PDG_FES_SETUP_1_NDP_NC_INDEX
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			Defines the dimension Nc for the beamforming feedback
			matrix. Nc_index values > 3 are not supported in Beeliner.
			
			<legal 0-3>
*/
#define PDG_FES_SETUP_1_NDP_NC_INDEX_OFFSET                          0x00000004
#define PDG_FES_SETUP_1_NDP_NC_INDEX_LSB                             5
#define PDG_FES_SETUP_1_NDP_NC_INDEX_MASK                            0x000000e0

/* Description		PDG_FES_SETUP_1_NDP_NC_OVERRIDE
			
			This field is only valid when expect_ndp is set.
			
			This field is inserted into the TX_EXPECT_NDP TLV
			generated by the TX PCU.
			
			
			
			This bit is set if the PHY is required to override its
			internally-calculated Nc value with the one provided by the
			MAC in this TLV.  <legal 0-1>
*/
#define PDG_FES_SETUP_1_NDP_NC_OVERRIDE_OFFSET                       0x00000004
#define PDG_FES_SETUP_1_NDP_NC_OVERRIDE_LSB                          8
#define PDG_FES_SETUP_1_NDP_NC_OVERRIDE_MASK                         0x00000100

/* Description		PDG_FES_SETUP_1_EXPECT_CBF
			
			When set, a TX_EXPECT_NDP TLV should be generated by the
			TX PCU to the PHY after the transmission of the PPDU.
*/
#define PDG_FES_SETUP_1_EXPECT_CBF_OFFSET                            0x00000004
#define PDG_FES_SETUP_1_EXPECT_CBF_LSB                               9
#define PDG_FES_SETUP_1_EXPECT_CBF_MASK                              0x00000200

/* Description		PDG_FES_SETUP_1_CBF_USER_NUMBER
			
			This field is only valid when expect_cbf is set.
			
			This field is inserted into the TX_EXPECT_CBF TLV
			generated by the TX PCU.
			
			
			
			Defines the source of the expected CBF.  
			
			<legal 0-3>
*/
#define PDG_FES_SETUP_1_CBF_USER_NUMBER_OFFSET                       0x00000004
#define PDG_FES_SETUP_1_CBF_USER_NUMBER_LSB                          10
#define PDG_FES_SETUP_1_CBF_USER_NUMBER_MASK                         0x00000c00

/* Description		PDG_FES_SETUP_1_UAPSD_REM_RESP_FRAME_CNT
			
			Field only valid in case of U-APSD response handling
			
			
			
			This field indicates the remaining  maximum number of
			frames to transmit for the uapsd response. If this number is
			reached, the PDG should indicate to the PCU to set the EOSP
			bit in the QoS control field.
			
			<legal all>
*/
#define PDG_FES_SETUP_1_UAPSD_REM_RESP_FRAME_CNT_OFFSET              0x00000004
#define PDG_FES_SETUP_1_UAPSD_REM_RESP_FRAME_CNT_LSB                 12
#define PDG_FES_SETUP_1_UAPSD_REM_RESP_FRAME_CNT_MASK                0x000ff000

/* Description		PDG_FES_SETUP_1_BF_TYPE
			
			<enum 0     NO_BF> Transmit a non-beamformed packet
			
			<enum 1     LEGACY_BF> Transmit a legacy beamformed
			packet.  This means beamforming starts at the L-STF.  The
			possible preamble formats are 11a, 11n mixed mode and 11ac. 
			This is used to support legacy implicit beamforming. 
			
			<enum 2     SU_BF> Transmit a single-user beamformed
			packet starting at the HT-STF or VHT-STF.
			
			<enum 3     MU_BF> Transmit a multi-user beamformed
			packet starting at the VHT-STF.
			
			<legal 0-3>
*/
#define PDG_FES_SETUP_1_BF_TYPE_OFFSET                               0x00000004
#define PDG_FES_SETUP_1_BF_TYPE_LSB                                  20
#define PDG_FES_SETUP_1_BF_TYPE_MASK                                 0x00300000

/* Description		PDG_FES_SETUP_1_BF_ENTIRE_PKT
			
			When this flag is set, the PHY TX shall begin applying
			beamforming weights at the start of the packet. If this flag
			is not set, the PHY TX shall begin applying weights at the
			start of the non-legacy portion of the packet. <legal 0-1>
*/
#define PDG_FES_SETUP_1_BF_ENTIRE_PKT_OFFSET                         0x00000004
#define PDG_FES_SETUP_1_BF_ENTIRE_PKT_LSB                            22
#define PDG_FES_SETUP_1_BF_ENTIRE_PKT_MASK                           0x00400000

/* Description		PDG_FES_SETUP_1_IMPLICIT_BF
			
			When this flag is set, the SVD module should perform
			implicit feedback computation on the next received packet.
			<legal 0-1>
*/
#define PDG_FES_SETUP_1_IMPLICIT_BF_OFFSET                           0x00000004
#define PDG_FES_SETUP_1_IMPLICIT_BF_LSB                              23
#define PDG_FES_SETUP_1_IMPLICIT_BF_MASK                             0x00800000

/* Description		PDG_FES_SETUP_1_RESERVED_1B
			
			<legal 0>
*/
#define PDG_FES_SETUP_1_RESERVED_1B_OFFSET                           0x00000004
#define PDG_FES_SETUP_1_RESERVED_1B_LSB                              24
#define PDG_FES_SETUP_1_RESERVED_1B_MASK                             0x0f000000

/* Description		PDG_FES_SETUP_1_CHANNEL_CAPTURE
			
			When set, indicates that the BB should be armed to
			capture the channel on the next received packet. This
			channel estimate is passed to the MAC if the packet is
			successfully received. 
			
			Copied by PDG into the channel_capture field in the
			PPDU_TX_PHY_DESC TLV
			
			<legal 0-1>
*/
#define PDG_FES_SETUP_1_CHANNEL_CAPTURE_OFFSET                       0x00000004
#define PDG_FES_SETUP_1_CHANNEL_CAPTURE_LSB                          28
#define PDG_FES_SETUP_1_CHANNEL_CAPTURE_MASK                         0x10000000

/* Description		PDG_FES_SETUP_1_RESERVED_1C
			
			<legal 0>
*/
#define PDG_FES_SETUP_1_RESERVED_1C_OFFSET                           0x00000004
#define PDG_FES_SETUP_1_RESERVED_1C_LSB                              29
#define PDG_FES_SETUP_1_RESERVED_1C_MASK                             0x20000000

/* Description		PDG_FES_SETUP_1_CLPC_EN
			
			This field enables closed-loop TPC operation by enabling
			CLPC adjustment of DAC gain for the next packet.
			
			<enum 0     clpc_off> TPC error update disabled
			
			<enum 1     clpc_on> TPC error will be applied to DAC
			gain setting for the next packet
			
			<legal 0-1>
*/
#define PDG_FES_SETUP_1_CLPC_EN_OFFSET                               0x00000004
#define PDG_FES_SETUP_1_CLPC_EN_LSB                                  30
#define PDG_FES_SETUP_1_CLPC_EN_MASK                                 0x40000000

/* Description		PDG_FES_SETUP_1_MEASURE_POWER
			
			This field enables the TPC to use power measurement for
			current packet in CLPC updates.
			
			<enum 0     measure_dis> TPC will not latch power
			measurement result for current packet
			
			<enum 1     measure_en> TPC will latch power measurement
			result for current packet
*/
#define PDG_FES_SETUP_1_MEASURE_POWER_OFFSET                         0x00000004
#define PDG_FES_SETUP_1_MEASURE_POWER_LSB                            31
#define PDG_FES_SETUP_1_MEASURE_POWER_MASK                           0x80000000

/* Description		PDG_FES_SETUP_2_MAX_FES_TIME
			
			The maximum medium time (in us) that the total Frame
			exchange sequence is allowed to take.  <legal all>
*/
#define PDG_FES_SETUP_2_MAX_FES_TIME_OFFSET                          0x00000008
#define PDG_FES_SETUP_2_MAX_FES_TIME_LSB                             0
#define PDG_FES_SETUP_2_MAX_FES_TIME_MASK                            0x0000ffff

/* Description		PDG_FES_SETUP_2_MAX_PPDU_TIME
			
			The maximum medium time (in us) that the PPDU Frame is
			allowed to take. <legal all>
*/
#define PDG_FES_SETUP_2_MAX_PPDU_TIME_OFFSET                         0x00000008
#define PDG_FES_SETUP_2_MAX_PPDU_TIME_LSB                            16
#define PDG_FES_SETUP_2_MAX_PPDU_TIME_MASK                           0xffff0000

/* Description		PDG_FES_SETUP_3_MAX_TXOP_TIME
			
			The maximum TXOP time (in us) that is remaining for the
			upcoming Frame Exchange Sequence (FES). The final maximum
			duration for the upcoming FES is the smallest of
			max_fes_time and max_TXOP_time.
			
			The max_TXOP_time field can also be used for determining
			the Duration value that should be inserted into the Frames.
			
			
			
			  <legal all>
*/
#define PDG_FES_SETUP_3_MAX_TXOP_TIME_OFFSET                         0x0000000c
#define PDG_FES_SETUP_3_MAX_TXOP_TIME_LSB                            0
#define PDG_FES_SETUP_3_MAX_TXOP_TIME_MASK                           0x0000ffff

/* Description		PDG_FES_SETUP_3_EXTEND_DURATION_VALUE
			
			Field only valid when Duration_extension is set.
			
			The amount of time (in us) added to the calculated
			duration value
*/
#define PDG_FES_SETUP_3_EXTEND_DURATION_VALUE_OFFSET                 0x0000000c
#define PDG_FES_SETUP_3_EXTEND_DURATION_VALUE_LSB                    16
#define PDG_FES_SETUP_3_EXTEND_DURATION_VALUE_MASK                   0xffff0000

/* Description		PDG_FES_SETUP_4_DURATION_FIELD_CTRL
			
			Duration field value generation control
			
			0: Set duration field to 0
			
			1: Protect entire FES
			
			2: protect entire TXOP
			
			<legal 0-2>
*/
#define PDG_FES_SETUP_4_DURATION_FIELD_CTRL_OFFSET                   0x00000010
#define PDG_FES_SETUP_4_DURATION_FIELD_CTRL_LSB                      0
#define PDG_FES_SETUP_4_DURATION_FIELD_CTRL_MASK                     0x00000003

/* Description		PDG_FES_SETUP_4_DURATION_EXTENSION
			
			Duration extension control
			
			0: No action
			
			1: Add the extra_duration_value to the calculated
			duration field.
*/
#define PDG_FES_SETUP_4_DURATION_EXTENSION_OFFSET                    0x00000010
#define PDG_FES_SETUP_4_DURATION_EXTENSION_LSB                       2
#define PDG_FES_SETUP_4_DURATION_EXTENSION_MASK                      0x00000004

/* Description		PDG_FES_SETUP_4_GROUP_ID
			
			Field only valid when Transmit_fes_type indicates a
			regular (non self generated) transmission
			
			
			
			When PDG detects that the transmission is at a VHT rate,
*/
#define PDG_FES_SETUP_4_GROUP_ID_OFFSET                              0x00000010
#define PDG_FES_SETUP_4_GROUP_ID_LSB                                 3
#define PDG_FES_SETUP_4_GROUP_ID_MASK                                0x000001f8

/* Description		PDG_FES_SETUP_4_RESERVED_4
			
			<legal 0>
*/
#define PDG_FES_SETUP_4_RESERVED_4_OFFSET                            0x00000010
#define PDG_FES_SETUP_4_RESERVED_4_LSB                               9
#define PDG_FES_SETUP_4_RESERVED_4_MASK                              0xfffffe00
#define PDG_FES_SETUP_5_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_OFFSET 0x00000014
#define PDG_FES_SETUP_5_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_LSB   9
#define PDG_FES_SETUP_5_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_MASK  0xffffffff
#define PDG_FES_SETUP_6_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_OFFSET 0x00000018
#define PDG_FES_SETUP_6_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_LSB   9
#define PDG_FES_SETUP_6_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW20_MASK  0xffffffff
#define PDG_FES_SETUP_7_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_OFFSET 0x0000001c
#define PDG_FES_SETUP_7_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_LSB   9
#define PDG_FES_SETUP_7_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_MASK  0xffffffff
#define PDG_FES_SETUP_8_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_OFFSET 0x00000020
#define PDG_FES_SETUP_8_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_LSB   9
#define PDG_FES_SETUP_8_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW40_MASK  0xffffffff
#define PDG_FES_SETUP_9_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_OFFSET 0x00000024
#define PDG_FES_SETUP_9_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_LSB   9
#define PDG_FES_SETUP_9_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_MASK  0xffffffff
#define PDG_FES_SETUP_10_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_OFFSET 0x00000028
#define PDG_FES_SETUP_10_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_LSB  9
#define PDG_FES_SETUP_10_TX_RATE_SETTING_TX_RATE_CTR_MPROT_BW80_MASK 0xffffffff
#define PDG_FES_SETUP_11_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_OFFSET 0x0000002c
#define PDG_FES_SETUP_11_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_LSB 9
#define PDG_FES_SETUP_11_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_MASK 0xffffffff
#define PDG_FES_SETUP_12_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_OFFSET 0x00000030
#define PDG_FES_SETUP_12_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_LSB 9
#define PDG_FES_SETUP_12_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW20_MASK 0xffffffff
#define PDG_FES_SETUP_13_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_OFFSET 0x00000034
#define PDG_FES_SETUP_13_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_LSB 9
#define PDG_FES_SETUP_13_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_MASK 0xffffffff
#define PDG_FES_SETUP_14_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_OFFSET 0x00000038
#define PDG_FES_SETUP_14_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_LSB 9
#define PDG_FES_SETUP_14_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW40_MASK 0xffffffff
#define PDG_FES_SETUP_15_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_OFFSET 0x0000003c
#define PDG_FES_SETUP_15_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_LSB 9
#define PDG_FES_SETUP_15_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_MASK 0xffffffff
#define PDG_FES_SETUP_16_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_OFFSET 0x00000040
#define PDG_FES_SETUP_16_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_LSB 9
#define PDG_FES_SETUP_16_TX_RATE_SETTING_RESPONSE_RATE_MPROT_BW80_MASK 0xffffffff


#endif // _PDG_FES_SETUP_H_
