// Copyright (c) 2012 Qualcomm Atheros, Inc.  All rights reserved.
// $ATH_LICENSE_HW_HDR_C$
//
// DO NOT EDIT!  This file is automatically generated
//               These definitions are tied to a particular hardware layout


#ifndef _SCHEDULER_TRANSMIT_STATUS_H_
#define _SCHEDULER_TRANSMIT_STATUS_H_
#if !defined(__ASSEMBLER__)
#endif

// ################ START SUMMARY #################
//
//	Dword	Fields
//	0	schedule_id[15:0], schedule_cmd_ring_id[20:16], fes_control_mode[22:21], number_of_users[24:23], cmd_ring_stall_status[25], data_underrun_warning[26], sch_cmd_result[29:27], reserved_0[31:30]
//	1	sch_eval_start_timestamp[31:0]
//	2	sch_eval_end_timestamp[31:0]
//	3	txop_time[15:0], fes_transmit_result[19:16], sifs_burst_scheduler_stopped[20], reserved_3[31:21]
//
// ################ END SUMMARY #################

#define NUM_OF_DWORDS_SCHEDULER_TRANSMIT_STATUS 4

struct scheduler_transmit_status {
    volatile uint32_t schedule_id                     : 16, //[15:0]
                      schedule_cmd_ring_id            :  5, //[20:16]
                      fes_control_mode                :  2, //[22:21]
                      number_of_users                 :  2, //[24:23]
                      cmd_ring_stall_status           :  1, //[25]
                      data_underrun_warning           :  1, //[26]
                      sch_cmd_result                  :  3, //[29:27]
                      reserved_0                      :  2; //[31:30]
    volatile uint32_t sch_eval_start_timestamp        : 32; //[31:0]
    volatile uint32_t sch_eval_end_timestamp          : 32; //[31:0]
    volatile uint32_t txop_time                       : 16, //[15:0]
                      fes_transmit_result             :  4, //[19:16]
                      sifs_burst_scheduler_stopped    :  1, //[20]
                      reserved_3                      : 11; //[31:21]
};

/*

schedule_id
			
			A field that SW can use to link this FES status to the
			schedule command that originated this transmission.

schedule_cmd_ring_id
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			 <legal 0-15>

fes_control_mode
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			
			
			<legal 0-1>

number_of_users
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users

cmd_ring_stall_status
			
			0: Scheduler command ring is NOT stalled
			
			1: Scheduler command ring is Stalled, due to
			unsuccessfull transmission (transmit result other then 0,
			and the scheduling command had the stall_schedule_enable
			field set)

data_underrun_warning
			
			0: No data under-run happened
			
			1: Data under-run happened

sch_cmd_result
			
			0: successfull
			
			1: Schedule command not executed due to lack of
			remaining TXOP time in the SIFS burst. 
			
			2: No successful transmission opportunity due to
			expiration of transmit window
			
			3: No successful transmission due to schedule lifespan
			expiration
			
			4: No successful transmission due to reaching maximum
			schedule retry count.
			
			5: No successful transmission due to the STA being in
			power save mode (as indicated in the peer entry)
			
			
			
			7-6: Reserved 

reserved_0
			
			0

sch_eval_start_timestamp
			
			The timestamp (based on always running system timer) at
			which the scheduler read the schedule command from the
			command ring (or response table)

sch_eval_end_timestamp
			
			The timestamp (based on always running system timer) at
			which the scheduler wrote this status report to the transmit
			status ring

txop_time
			
			Field NOT valid in case of pure SW transmit mode.
			
			 
			
			The maximum amount of TXOP time (in us) given to PDG
			based on scheduler transmit boundary checks.
			
			For each scheduler ring, SW can program which boundary
			input timers (like time remaining to TBTT, Coex, etc.) are
			evaluated together with this TXOP_time. The SCH will select
			the smallest value of all of them, and that is passed on to
			the PDG module.

fes_transmit_result
			
			Transmit result:
			
			0: Successful transmission of entire Frame exchange
			sequence
			
			1: No protection response frame received
			
			2: No PPDU response frame received. 
			
			In case of transmitting self generated BAR, DataNull or
			QoSDataNull frame and no BAR or ACK frame is received this
			indication is also set
			
			4: MAC HW error resulting in abort (details in the FES
			status report)
			
			5: PHY error resulting in abort (details in the FES
			status report)
			
			6: Coexistence early abort
			
			7: 15-10: Reserved

sifs_burst_scheduler_stopped
			
			0: No action
			
			1: The scheduler ring from which this status report
			originates has been halted.
			
			This is a result of the : Sifs_burst_abort_on_failure
			control set in the scheduling command

reserved_3
			
			0
*/


/* Description		SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_ID
			
			A field that SW can use to link this FES status to the
			schedule command that originated this transmission.
*/
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_ID_OFFSET               0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_ID_LSB                  0
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_ID_MASK                 0x0000ffff

/* Description		SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_CMD_RING_ID
			
			The schedule command ring  that originated this
			transmission
			
			<enum 0 sch_cmd_ring_number0>
			
			<enum 1 sch_cmd_ring_number1>
			
			<enum 2 sch_cmd_ring_number2>
			
			<enum 3 sch_cmd_ring_number3>
			
			<enum 4 sch_cmd_ring_number4>
			
			<enum 5 sch_cmd_ring_number5>
			
			<enum 6 sch_cmd_ring_number6>
			
			<enum 7 sch_cmd_ring_number7>
			
			<enum 8 sch_cmd_ring_number8>
			
			<enum 9 sch_cmd_ring_number9>
			
			<enum 10 sch_cmd_ring_number10>
			
			<enum 11 sch_cmd_ring_number11>
			
			<enum 12 sch_cmd_ring_number12>
			
			<enum 13 sch_cmd_ring_number13>
			
			<enum 14 sch_cmd_ring_number14>
			
			<enum 15 sch_cmd_ring_number15>
			
			
			
			 <legal 0-15>
*/
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_CMD_RING_ID_OFFSET      0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_CMD_RING_ID_LSB         16
#define SCHEDULER_TRANSMIT_STATUS_0_SCHEDULE_CMD_RING_ID_MASK        0x001f0000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_FES_CONTROL_MODE
			
			<enum 0  SW_transmit_mode>  No HW generated TLVs
			
			
			
			<enum 1 PDG_transmit_mode> PDG  is activated to generate
			TLVs
			
			
			
			Note: Final Bandwidth selection is always performed by
			TX PCU.
			
			
			
			<legal 0-1>
*/
#define SCHEDULER_TRANSMIT_STATUS_0_FES_CONTROL_MODE_OFFSET          0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_FES_CONTROL_MODE_LSB             21
#define SCHEDULER_TRANSMIT_STATUS_0_FES_CONTROL_MODE_MASK            0x00600000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_NUMBER_OF_USERS
			
			The number of users in this transmission.
			
			In case of multiple users, the PCU TX will generate a TX
			FES status for each of the users
*/
#define SCHEDULER_TRANSMIT_STATUS_0_NUMBER_OF_USERS_OFFSET           0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_NUMBER_OF_USERS_LSB              23
#define SCHEDULER_TRANSMIT_STATUS_0_NUMBER_OF_USERS_MASK             0x01800000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_CMD_RING_STALL_STATUS
			
			0: Scheduler command ring is NOT stalled
			
			1: Scheduler command ring is Stalled, due to
			unsuccessfull transmission (transmit result other then 0,
			and the scheduling command had the stall_schedule_enable
			field set)
*/
#define SCHEDULER_TRANSMIT_STATUS_0_CMD_RING_STALL_STATUS_OFFSET     0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_CMD_RING_STALL_STATUS_LSB        25
#define SCHEDULER_TRANSMIT_STATUS_0_CMD_RING_STALL_STATUS_MASK       0x02000000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_DATA_UNDERRUN_WARNING
			
			0: No data under-run happened
			
			1: Data under-run happened
*/
#define SCHEDULER_TRANSMIT_STATUS_0_DATA_UNDERRUN_WARNING_OFFSET     0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_DATA_UNDERRUN_WARNING_LSB        26
#define SCHEDULER_TRANSMIT_STATUS_0_DATA_UNDERRUN_WARNING_MASK       0x04000000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_SCH_CMD_RESULT
			
			0: successfull
			
			1: Schedule command not executed due to lack of
			remaining TXOP time in the SIFS burst. 
			
			2: No successful transmission opportunity due to
			expiration of transmit window
			
			3: No successful transmission due to schedule lifespan
			expiration
			
			4: No successful transmission due to reaching maximum
			schedule retry count.
			
			5: No successful transmission due to the STA being in
			power save mode (as indicated in the peer entry)
			
			
			
			7-6: Reserved 
*/
#define SCHEDULER_TRANSMIT_STATUS_0_SCH_CMD_RESULT_OFFSET            0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_SCH_CMD_RESULT_LSB               27
#define SCHEDULER_TRANSMIT_STATUS_0_SCH_CMD_RESULT_MASK              0x38000000

/* Description		SCHEDULER_TRANSMIT_STATUS_0_RESERVED_0
			
			0
*/
#define SCHEDULER_TRANSMIT_STATUS_0_RESERVED_0_OFFSET                0x00000000
#define SCHEDULER_TRANSMIT_STATUS_0_RESERVED_0_LSB                   30
#define SCHEDULER_TRANSMIT_STATUS_0_RESERVED_0_MASK                  0xc0000000

/* Description		SCHEDULER_TRANSMIT_STATUS_1_SCH_EVAL_START_TIMESTAMP
			
			The timestamp (based on always running system timer) at
			which the scheduler read the schedule command from the
			command ring (or response table)
*/
#define SCHEDULER_TRANSMIT_STATUS_1_SCH_EVAL_START_TIMESTAMP_OFFSET  0x00000004
#define SCHEDULER_TRANSMIT_STATUS_1_SCH_EVAL_START_TIMESTAMP_LSB     0
#define SCHEDULER_TRANSMIT_STATUS_1_SCH_EVAL_START_TIMESTAMP_MASK    0xffffffff

/* Description		SCHEDULER_TRANSMIT_STATUS_2_SCH_EVAL_END_TIMESTAMP
			
			The timestamp (based on always running system timer) at
			which the scheduler wrote this status report to the transmit
			status ring
*/
#define SCHEDULER_TRANSMIT_STATUS_2_SCH_EVAL_END_TIMESTAMP_OFFSET    0x00000008
#define SCHEDULER_TRANSMIT_STATUS_2_SCH_EVAL_END_TIMESTAMP_LSB       0
#define SCHEDULER_TRANSMIT_STATUS_2_SCH_EVAL_END_TIMESTAMP_MASK      0xffffffff

/* Description		SCHEDULER_TRANSMIT_STATUS_3_TXOP_TIME
			
			Field NOT valid in case of pure SW transmit mode.
			
			 
			
			The maximum amount of TXOP time (in us) given to PDG
			based on scheduler transmit boundary checks.
			
			For each scheduler ring, SW can program which boundary
			input timers (like time remaining to TBTT, Coex, etc.) are
			evaluated together with this TXOP_time. The SCH will select
			the smallest value of all of them, and that is passed on to
			the PDG module.
*/
#define SCHEDULER_TRANSMIT_STATUS_3_TXOP_TIME_OFFSET                 0x0000000c
#define SCHEDULER_TRANSMIT_STATUS_3_TXOP_TIME_LSB                    0
#define SCHEDULER_TRANSMIT_STATUS_3_TXOP_TIME_MASK                   0x0000ffff

/* Description		SCHEDULER_TRANSMIT_STATUS_3_FES_TRANSMIT_RESULT
			
			Transmit result:
			
			0: Successful transmission of entire Frame exchange
			sequence
			
			1: No protection response frame received
			
			2: No PPDU response frame received. 
			
			In case of transmitting self generated BAR, DataNull or
			QoSDataNull frame and no BAR or ACK frame is received this
			indication is also set
			
			4: MAC HW error resulting in abort (details in the FES
			status report)
			
			5: PHY error resulting in abort (details in the FES
			status report)
			
			6: Coexistence early abort
			
			7: 15-10: Reserved
*/
#define SCHEDULER_TRANSMIT_STATUS_3_FES_TRANSMIT_RESULT_OFFSET       0x0000000c
#define SCHEDULER_TRANSMIT_STATUS_3_FES_TRANSMIT_RESULT_LSB          16
#define SCHEDULER_TRANSMIT_STATUS_3_FES_TRANSMIT_RESULT_MASK         0x000f0000

/* Description		SCHEDULER_TRANSMIT_STATUS_3_SIFS_BURST_SCHEDULER_STOPPED
			
			0: No action
			
			1: The scheduler ring from which this status report
			originates has been halted.
			
			This is a result of the : Sifs_burst_abort_on_failure
			control set in the scheduling command
*/
#define SCHEDULER_TRANSMIT_STATUS_3_SIFS_BURST_SCHEDULER_STOPPED_OFFSET 0x0000000c
#define SCHEDULER_TRANSMIT_STATUS_3_SIFS_BURST_SCHEDULER_STOPPED_LSB 20
#define SCHEDULER_TRANSMIT_STATUS_3_SIFS_BURST_SCHEDULER_STOPPED_MASK 0x00100000

/* Description		SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3
			
			0
*/
#define SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3_OFFSET                0x0000000c
#define SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3_LSB                   21
#define SCHEDULER_TRANSMIT_STATUS_3_RESERVED_3_MASK                  0xffe00000


#endif // _SCHEDULER_TRANSMIT_STATUS_H_
