/*
 * Copyright (c) 2010, Atheros Communications Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/*
 * Copyright (c) 2013 Qualcomm Atheros, Inc.
 * All Rights Reserved.
 * Qualcomm Atheros Confidential and Proprietary.
 */
 
#ifndef _DEV_ATH_PCI_H_
#define _DEV_ATH_PCI_H_

#include <linux/pci.h>
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,9)
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,28)
#define ath_dma_sync_single	pci_dma_sync_single_for_device
#else
#define ath_dma_sync_single pci_dma_sync_single_for_cpu
#endif
#define	PCI_SAVE_STATE(a,b)	pci_save_state(a)
#define	PCI_RESTORE_STATE(a,b)	pci_restore_state(a)
#else
#define ath_dma_sync_single	pci_dma_sync_single
#define	PCI_SAVE_STATE(a,b)	pci_save_state(a,b)
#define	PCI_RESTORE_STATE(a,b)	pci_restore_state(a,b)
#endif
#include <if_bus.h>
#ifdef ATH_SUPPORT_MSI
extern unsigned int msi_enable;
int pci_msi_is_enabled(osdev_t osdev);
#endif
#endif   /* _DEV_ATH_PCI_H_ */
