<html>
<head>
<META HTTP-EQUIV="expires" CONTENT="0">
<META HTTP-EQUIV="pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache, must-revalidate">
<%languagechar_show();%>

<title>Wireless Advanced Setting</title>
<link rel="stylesheet" href="./stylesheets/nb.css" type="text/css">
<script type="text/javascript" src="./javascripts/common.js"> </script>
<% language=javascript %>

<SCRIPT>
function updateBwState()
{
	mode = Number(<%writeValue("networkMode");%>);
	if ( mode == 0) 
	{	
		disableTextField(document.advanceSetup.bwEnabled);
		disableTextField(document.advanceSetup.bwDownStream);
		disableTextField(document.advanceSetup.bwDownBurst);
		disableTextField(document.advanceSetup.bwUpStream);
		disableTextField(document.advanceSetup.bwUpBurst);
	}
	else if (document.advanceSetup.bwEnabled.checked)
	{
		enableTextField(document.advanceSetup.bwDownStream);
		enableTextField(document.advanceSetup.bwDownBurst);
		enableTextField(document.advanceSetup.bwUpStream);
		enableTextField(document.advanceSetup.bwUpBurst);
	}
	else
	{
		disableTextField(document.advanceSetup.bwDownStream);
		disableTextField(document.advanceSetup.bwDownBurst);
		disableTextField(document.advanceSetup.bwUpStream);
		disableTextField(document.advanceSetup.bwUpBurst);
	}
}

function saveChanges()
{
	var form = document.advanceSetup;
	var netMode = Number(<%writeValue("networkMode");%>);
	var chanMode = <%writeValue("wlChanMode");%>;
	var bcnMin = (chanMode==3 || chanMode==4) ? 100 : 20;

	if (parseInt(document.advanceSetup.fragThreshold.value) % 2)
	{
		alert("<%getlanguage("Invalid value of Fragment Threshold. Input value should be even.");%>");
		return false;
	}
	if (!ValidateNum(form.fragThreshold, 256, 2346)
	 || !ValidateNum(form.rtsThreshold, 1, 2347)
	 || !ValidateNum(form.beaconInterval, bcnMin, 1024)
	 || !ValidateNum(form.DTIMInterval, 1, 255)
	 //|| !ValidateNum(form.chan_thres, 0, 100)
	 //|| !ValidateNum(form.staNum, 0, 128)
	 || !ValidateNum(form.coverage, 0, 15000)
	 )
	{
		return false;
	}
	if (netMode!=0 && form.bwEnabled.checked)
	{
		if (!ValidateNum(form.bwDownStream, 0, 100*1024)
		|| !ValidateNum(form.bwDownBurst, 0, 100*1024)
		|| !ValidateNum(form.bwUpStream, 0, 100*1024)
		|| !ValidateNum(form.bwUpBurst, 0, 100*1024))
		{
			return false;
		}
	}
  return true;
}

function initpage() {
	var specWirMode = <%writeValue("specWirMode");%>;
	var wlanMode = <%writeValue("wlOpMode");%>;
	var bandMode = <%writeValue("wlWirMode");%>;
	var chanMode = <%writeValue("wlChanMode");%>;
	var is11n = (bandMode==7 || bandMode==8 || bandMode==19 || bandMode==20);
	var bSupport2G = specWirMode & ((1<<0)|(1<<2)|(1<<3));

	show_div(wlanMode!=2, "bcn_div");
	enableField(document.advanceSetup.wlWmm[0], wlanMode!=1 && !is11n);
	enableField(document.advanceSetup.wlWmm[1], wlanMode!=1 && !is11n);
	enableField(document.advanceSetup.AMPDUenable[0], is11n);
	enableField(document.advanceSetup.AMPDUenable[1], is11n);
	enableField(document.advanceSetup.AMSDUenable[0], is11n);
	enableField(document.advanceSetup.AMSDUenable[1], is11n);
	enableField(document.advanceSetup.ShortGIenable[0], is11n && (chanMode==1||chanMode==2));
	enableField(document.advanceSetup.ShortGIenable[1], is11n && (chanMode==1||chanMode==2));
	enableField(document.advanceSetup.RIFSenable[0], wlanMode!=1 && is11n);
	enableField(document.advanceSetup.RIFSenable[1], wlanMode!=1 && is11n);
	enableField(document.advanceSetup.beaconInterval, wlanMode!=1);
	enableField(document.advanceSetup.DTIMInterval, wlanMode!=1);
	enableField(document.advanceSetup.wlIsolation[0], wlanMode==0 || wlanMode==3);
	enableField(document.advanceSetup.wlIsolation[1], wlanMode==0 || wlanMode==3);
	enableField(document.advanceSetup.Enablesnoping[0], wlanMode==0);
	enableField(document.advanceSetup.Enablesnoping[1], wlanMode==0);

//	show_div(wlanMode==0 || wlanMode==3, "staNum_div");
	show_div(wlanMode==0 || wlanMode==1, "link_div");
	show_div(wlanMode==1, "cpeMode_div");
	show_div(wlanMode==0, "stdm_id");
	show_div(bSupport2G, "preamble_div");

	updateBwState();
	if (!<%writeValue("wlWlanEnalbe");%>)
		disableAll();
}

</SCRIPT>
<BODY onload="initpage();" class="bodyContainer">
<div class="boxHeader">
	<h2><%getlanguage("Wireless Advanced Settings"); %></h2>
	<span class="note">
		<%getlanguage("These settings are only for more technically advanced users who have a sufficient knowledge about wireless LAN. These settings should not be changed unless you know what effect the changes will take."); %>
	</span>
</div>

<form action=/goform/formAdvanceSetup method=POST name="advanceSetup">
<div class="box">
	<table class="text">
	<tr style="display:none">
	      <td width="33%"><%getlanguage("WMM Support"); %>:</td>
	      <td width="66%">
	      <input type="radio" name="wlWmm" value="yes"<% if (getValue("wlWmm")==1) write("checked"); %>><%getlanguage("Enabled"); %>&nbsp;&nbsp;
	      <input type="radio" name="wlWmm" value="no"<% if (getValue("wlWmm")==0) write("checked"); %>><%getlanguage("Disabled"); %></td>
    </tr>
	<tr>
		<td width="33%"><%getlanguage("A-MPDU aggregation"); %>:</td>
		<td width="66%">
		<input type="radio" name="AMPDUenable" value="yes"<% if (getValue("AMPDUenable")==1) write("checked"); %>><%getlanguage("Enabled"); %>&nbsp;&nbsp;
		<input type="radio" name="AMPDUenable" value="no"<% if (getValue("AMPDUenable")==0) write("checked"); %>><%getlanguage("Disabled"); %></td>
	</tr>   
 	<tr>
		<td width="33%"><%getlanguage("A-MSDU aggregation"); %>:</td>
		<td width="66%">
		<input type="radio" name="AMSDUenable" value="yes"<% if (getValue("AMSDUenable")==1) write("checked"); %>><%getlanguage("Enabled"); %>&nbsp;&nbsp;
		<input type="radio" name="AMSDUenable" value="no"<% if (getValue("AMSDUenable")==0) write("checked"); %>><%getlanguage("Disabled"); %></td>
	</tr>
	<tr>   
	<tr>
		<td width="33%"><%getlanguage("Short GI"); %>:</td>
		<td width="66%">
		<input type="radio" name="ShortGIenable" value="yes"<% if (getValue("ShortGIenable")==1) write("checked"); %>><%getlanguage("Enabled"); %>&nbsp;&nbsp;
		<input type="radio" name="ShortGIenable" value="no"<% if (getValue("ShortGIenable")==0) write("checked"); %>><%getlanguage("Disabled"); %></td>
	</tr>
	<tr>
		<td width="33%"><%getlanguage("RTS Threshold"); %>:</td>
		<td width="66%"><input type="text" name="rtsThreshold" size="10" maxlength="4" value=<% writeValue("rtsThreshold"); %>>&nbsp;&nbsp;<%getlanguage("(1-2347)"); %></td>
	</tr>
	<tr>
		<td width="33%"><%getlanguage("Fragment Threshold"); %>:</td>
		<td width="66%"><input type="text" name="fragThreshold" size="10" maxlength="4" value=<% writeValue("fragThreshold"); %>>&nbsp;&nbsp;<%getlanguage("(256-2346)"); %></td>
	</tr>
	<tr id="bcn_div">
		<td width="33%"><%getlanguage("Beacon Interval"); %>:</td>
		<td width="66%"><input type="text" name="beaconInterval" size="10" maxlength="4" value=<% writeValue("beaconInterval"); %>>&nbsp;&nbsp;<%if (getValue("wlChanMode")==3 || getValue("wlChanMode")==4) getlanguage("(100-1024 ms)") ; else getlanguage("(20-1024 ms)"); %></td>
	</tr>
	<tr>
		<td width="33%"><%getlanguage("DTIM Interval"); %>:</td>
		<td width="66%"><input type="text" name="DTIMInterval" size="10" maxlength="4" value=<% writeValue("dtimInterval"); %>>&nbsp;&nbsp;<%getlanguage("(1-255)"); %></td>
	</tr>
	<tr id="preamble_div">
		<td width="33%"><%getlanguage("Preamble Type"); %>:</td>
		<td width="66%">
		<input type="radio" name="preamble" value="0"<% if (getValue("preamble")==0) write("checked"); %>><%getlanguage("Long"); %>&nbsp;&nbsp;
		<input type="radio" name="preamble" value="1"<% if (getValue("preamble")==1) write("checked"); %>><%getlanguage("Auto"); %></td>
	</tr>
	<tr>
		<td width="33%"><%getlanguage("IGMP Snooping"); %>:</td>
		<td width="66%">
		<input type="radio" name="Enablesnoping" value="yes" <% if (getValue("enablesnoping")==1) write("checked"); %>><%getlanguage("Enabled"); %>&nbsp;&nbsp;
		<input type="radio" name="Enablesnoping" value="no"<% if (getValue("enablesnoping")==0) write("checked"); %>><%getlanguage("Disabled"); %></td>
	</tr>
    <tr style="display:none">
      <td width="33%"><%getlanguage("Wireless Separation"); %>:</td>
      <td width="66%">
      <input type="radio" name="wlIsolation" value="yes"<% if (getValue("wlIsolation")==1) write("checked"); %>><%getlanguage("Enabled"); %>&nbsp;&nbsp;
      <input type="radio" name="wlIsolation" value="no"<% if (getValue("wlIsolation")==0) write("checked"); %>><%getlanguage("Disabled"); %>
      </td>
  	</tr>
	<tr>
		<td><%getlanguage("RIFS"); %>:</td>
		<td>
			<input type="radio" name="RIFSenable" value="yes" <% if (getValue("RIFSenable")==1) write("checked"); %>><%getlanguage("Enabled"); %>&nbsp;&nbsp;
			<input type="radio" name="RIFSenable" value="no" <% if (getValue("RIFSenable")==0) write("checked"); %>><%getlanguage("Disabled"); %>
		</td>
	</tr> 
	<tr id = "link_div">
		<td><%getlanguage("Link Integration"); %>:</td>
		<td>
			<input type="radio" name="linkenable" value="yes" <% if (getValue("linkenable")==1) write("checked"); %>><%getlanguage("Enabled"); %>&nbsp;&nbsp;
			<input type="radio" name="linkenable" value="no" <% if (getValue("linkenable")==0) write("checked"); %>><%getlanguage("Disabled"); %>
		</td>
	</tr>
	<tr id = "stdm_id">
		<td><%getlanguage("TDM Coordination"); %>:</td>
		<td>
			<input type="radio" name="stdmenable" value="yes" <% if (getValue("stdmenable")==1) write("checked"); %>><%getlanguage("Enabled"); %>&nbsp;&nbsp;
			<input type="radio" name="stdmenable" value="no" <% if (getValue("stdmenable")==0) write("checked"); %>><%getlanguage("Disabled"); %>
		</td>
	</tr>
	<tr id = "cpeMode_div">
		<td><%getlanguage("CPE Type"); %>:</td>
		<td>
			<input type="radio" name="cpeType" value="0" <% if (getValue("cpeType")==0) write("checked"); %>><%getlanguage("Multi-Client"); %>&nbsp;&nbsp;
			<input type="radio" name="cpeType" value="1" <% if (getValue("cpeType")==1) write("checked"); %>><%getlanguage("Lan-to-Lan"); %>
		</td>
	</tr>

	<!--tr id="staNum_div">
		<td width="33%"><%getlanguage("Max. Station Num"); %>:</td>
		<td width="66%"><input type="text" name="staNum" size="10" maxlength="4" value=<% writeValue("staNum"); %>>&nbsp;&nbsp;<%getlanguage("(0-128)"); %></td>
	</tr-->
	<tr>
		<td width="33%"><%getlanguage("Space In Meter"); %>:</td>
		<td width="66%"><input type="text" name="coverage" size="10" maxlength="5" value=<% writeValue("coverage"); %>>&nbsp;&nbsp;<%getlanguage("(0-15000 m)"); %></td>
	</tr>
	</table>
	<h3>
      <input type="checkbox" name="bwEnabled" value="ON" <% if (getValue("bwEnabled")==1) write("checked"); %> ONCLICK=updateBwState()><%getlanguage("Enable Traffic Shaping"); %>
    </h3> 
	<table class="text">
      <tr>
        <td width="33%"><%getlanguage("Incoming Traffic Limit"); %>:</td>
        <td width="66%"><input type="text" name="bwDownStream" size="10" maxlength="6" value="<% writeValue("bwDownStream"); %>">
          &nbsp;
          <%getlanguage("kbit/s"); %></td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("Incoming Traffic Burst"); %>:</td>
        <td width="66%"><input type="text" name="bwDownBurst" size="10" maxlength="6" value="<% writeValue("bwDownBurst"); %>">
          &nbsp;
          <%getlanguage("kBytes"); %></td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("Outgoing Traffic Limit"); %>:</td>
        <td width="66%"><input type="text" name="bwUpStream" size="10" maxlength="6" value="<% writeValue("bwUpStream"); %>">
          &nbsp;
          <%getlanguage("kbit/s"); %></td>
      </tr>
      <tr>
        <td width="33%"><%getlanguage("Outgoing Traffic Burst"); %>:</td>
        <td width="66%"><input type="text" name="bwUpBurst" size="10" maxlength="6" value="<% writeValue("bwUpBurst"); %>">
          &nbsp;
          <%getlanguage("kBytes"); %></td>
      </tr>
  </table>
</div>
<p align="center">
  <input type="submit" value="<%getlanguage("Apply"); %>" name="save" onClick="return saveChanges()">&nbsp;&nbsp;
  <input type="button" value="<%getlanguage("Cancel"); %>" name="reset" onClick="Refreshweb()">
  <input type="hidden" value="/wladvanced.asp" name="submit-url">
</p>
</form>
</body>

</html>

