<html>
<head>
<META HTTP-EQUIV="expires" CONTENT="0">
<META HTTP-EQUIV="pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache, must-revalidate">
<%languagechar_show();%>

<title>Speed Test</title>
<link rel="stylesheet" href="/stylesheets/nb.css">
<script type="text/javascript" src="/javascripts/common.js"></script>
<!--script type="text/javascript" src="spdtest.js"></script-->
<script type="text/javascript">
var xhrAuth;
var xhrStart;
var xhrResult;
var duplex, ip, user, password;
var rqstTimeout;
	
function initVars()
{
	if (document.getElementById("direction").value == 0)
		duplex = "true";
	else 
		duplex = "false";
	
	ip = document.getElementById("destip").value;
	user = document.getElementById("user").value;
	password = document.getElementById("password").value;
	return;
}

function checkInput()
{
	var warn = "";

	document.getElementById("div_status").style.display = "";
	if (document.getElementById("destip").value == "<% writeValue("ip-rom"); %>")
	{
		document.getElementById("status").innerHTML = "Don't input the Local IP to the Destination IP box."; 
		return false;
	}
	warn = checkIpAddr(document.getElementById("destip"));
	if (warn != "")
	{
		document.getElementById("status").innerHTML = warn;
		return false;
	}	
	if (document.getElementById("user").value.length == 0 || document.getElementById("password").value.length == 0)
	{
		document.getElementById("status").innerHTML = "User Name or Password cannot be empty.";
		return false;
	}
	return true;
}

function handleTimeout()
{
	xhrAuth.abort();
	return handleError("Error! Request timeout, please check the IP address.");
}

function handleError(warn)
{
	document.getElementById("status").innerHTML = warn;
	document.getElementById("runtest").disabled = false;
	document.getElementById("direction").disabled = false;
	document.getElementById("img").style.display = "none";
	return false;
}

function runtest()
{
	var url;
	
	document.getElementById("rx").innerHTML = "N/A";
	document.getElementById("tx").innerHTML = "N/A";

	if (!checkInput())
		return false;
	
	initVars();
	document.getElementById("runtest").disabled = true;
	document.getElementById("direction").disabled = true;
	document.getElementById("status").innerHTML = "Starting...";

	if (window.XDomainRequest)
	{
		document.getElementById("status").innerHTML = "If your browser is IE7 or lower verion, enable \"Access data sources across domains\" at Internet Options/Security/Custom Level";
		xhrAuth = new XDomainRequest();
		xhrAuth.onload = handleAuthOnload;
		xhrAuth.onerror = function(){handleError("Error! Unkown.")};
	}
	else 
	{
		if (window.XMLHttpRequest)
		{
			document.getElementById("status").innerHTML = "If your browser is IE7 or lower verion, enable \"Access data sources across domains\" at Internet Options/Security/Custom Level";
			xhrAuth = new XMLHttpRequest();
			if(xhrAuth.overrideMimeType)
				xhrAuth.overrideMimeType("text/html");
		}
		else if(window.ActiveXObject){
			document.getElementById("status").innerHTML = "If your browser is IE7 or lower verion, enable \"Access data sources across domains\" at Internet Options/Security/Custom Level";
			try{
				xhrAuth = new ActiveXObject("Xsxml2.XMLHTTP");
			}
			catch(e){
				try{
					xhrAuth = new ActiveXObject("Microsoft.XMLHTTP");
				}
				catch(e){
				}
			}
		}
		xhrAuth.onreadystatechange = handleAuth;
	} 
	url = "http://"+ip+"/goform/formSpeedTest?purpose=auth&user="+user+"&password="+password+"&sid="+Math.random();
	xhrAuth.open("GET", url, true);
	if (window.XDomainRequest)
		;
	else
		rqstTimeout = setTimeout(handleTimeout, 5000);
	xhrAuth.send(null);
}

function handleAuthOnload()
{
	if (xhrAuth.responseText == "00")
	{
		return handleError("Error! Bad User Name or Password.");
	}
	else if (xhrAuth.responseText == "10")
	{
		return handleError("Error! Remote speed test server closed.");
	}
	else if (xhrAuth.responseText == "")
	{
		return handleError("Error! Please update the firmware of the remote device to the lastest version or run this tool with IE8 or firefox.");
	}

	document.getElementById("status").innerHTML = "";
	document.getElementById("img").style.display = "";

	xhrStart = createAjax();
	xhrStart.onreadystatechange = handleStart;
	var url = "/goform/formSpeedTest?purpose=start&duplex="+duplex+"&ip="+ip+"&sid="+Math.random();
	xhrStart.open("GET", url, true);
	xhrStart.send(null);
}

function handleAuth()
{
	if (xhrAuth.readyState == 4)
	{
		clearTimeout(rqstTimeout);
		handleAuthOnload();
	}
}

function handleStart()
{
	if (xhrStart.readyState == 4)
	{
		if (xhrStart.responseText != "1")
		{
			return handleError("Error! Unknown error occurred while starting local speed test process.");
		}

		setTimeout(function(){
			xhrResult = createAjax();
			xhrResult.onreadystatechange = handleResult;
			xhrResult.open("GET", "/goform/formSpeedTest?purpose=result&duplex="+duplex+"&sid="+Math.random(), true);
			xhrResult.send(null);
		}, 12000);
	}
}

function handleResult()
{
	if (xhrResult.readyState == 4)
	{
		if (xhrResult.responseText == "")
		{
			return handleError("Error! Result is null.");
		}

		if (duplex == "true")
		{
			var rx, tx;

			rx = xhrResult.responseText.split(",")[0];
			tx = xhrResult.responseText.split(",")[1];
			document.getElementById("rx").innerHTML = rx;
			document.getElementById("tx").innerHTML = tx;
		}
		else if (document.getElementById("direction").value == 1)
		{
			document.getElementById("rx").innerHTML = xhrResult.responseText;
		}
		else if (document.getElementById("direction").value == 2)
		{
			document.getElementById("tx").innerHTML = xhrResult.responseText;
		}

		document.getElementById("img").style.display = "none";
		document.getElementById("result").style.display = "";
		document.getElementById("status").innerHTML = "Test complete.";
		document.getElementById("runtest").disabled = false;
		document.getElementById("direction").disabled = false;

		return;
	}
}

</script>
</head>

<body class="bodyContainer">
<div class="boxHeader">
	<h2><%getlanguage("Speed Test"); %></h2>
	<span class="note">
	<%getlanguage("This page allows you test the network speed between this device and another terminal."); %>
	</span>
</div>
    <h3>
      <%getlanguage(" ");%>
    </h3>
	<div class="box">
		<table class="text">
			<tr> 
				<td width="33%"><%getlanguage("Destination IP");%>:</td>
				<td width="60%">
					<input type="text" id="destip" size="18" maxlength="15" value="">
					<input type="hidden" value=<% writeValue("ip-rom"); %> id="srcIp">
				</td>
			</tr>
			<tr> 
				<td width="33%"><%getlanguage("User Name");%>:</td>
				<td width="60%"><input type="text" id="user" size="18" maxlength="19" value=""></td>
			</tr>
			<tr> 
				<td width="33%"><%getlanguage("Password");%>:</td>
				<td width="60%"><input type="password" id="password" size="18" maxlength="19" value=""></td>
			</tr>
			<tr> 
				<td width="33%"><%getlanguage("Direction");%>:</td>
				<td width="60%">
					<select id="direction" >
						<option value=2>
						<%getlanguage("Transmit");%>
						</option>
						<option value=1>
						<%getlanguage("Receive");%>
						</option>
						<option value=0>
						<%getlanguage("Duplex");%>
						</option>
					</select>
				</td>
			</tr>
		</table>
	</div>
	<p align="center">
		<input type="button" value="<%getlanguage("Test"); %>" id="runtest" onClick="runtest()">
	</p>
	<div class="box" id="div_status" style="display:none">
		<span><b><%getlanguage("STATUS");%>:&nbsp;&nbsp;</b></span>
		<span id="status"></span>
		<span id="img" style="display:none"><%getlanguage("Test is Running");%>&nbsp;&nbsp;<img src="/images/speedtest.gif" /></br></span>
	</div>
	<div class="box" id="result" style="display:none"></br>
	<table>
		<tr><td colspan="2"><b><%getlanguage("TEST RESULT");%></b></td></tr>
		<tr><td><%getlanguage("RX");%>:</td><td id="rx"><%getlanguage("N/A");%></td></tr>
		<tr><td><%getlanguage("TX");%>:</td><td id="tx"><%getlanguage("N/A");%></td></tr>
	</table>
	</div>
</body>
</html>
