<html>
<head>
<META HTTP-EQUIV="expires" CONTENT="0">
<META HTTP-EQUIV="pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache, must-revalidate">
<%languagechar_show();%>

<title>Time Zone Setting</title>
<link rel="stylesheet" href="./stylesheets/nb.css" type="text/css">
<script type="text/javascript" src="./javascripts/common.js"> </script>
<script>
var ArrayTimeZone =
[
		{name:"(GMT-12:00)Eniwetok, Kwajalein",					value:"12 1"},
		{name:"(GMT-11:00)Midway Island, Samoa",				value:"11 1"},
		{name:"(GMT-10:00)Hawaii", 								value:"10 1"},
		{name:"(GMT-09:00)Alaska", 								value:"9 1"},
		{name:"(GMT-08:00)Pacific Time (US & Canada); Tijuana", value:"8 1"},
		{name:"(GMT-07:00)Arizona", 							value:"7 1"},
		{name:"(GMT-07:00)Mountain Time (US & Canada)", 		value:"7 2"},
		{name:"(GMT-06:00)Central Time (US & Canada)", 			value:"6 1"},
		{name:"(GMT-06:00)Mexico City, Tegucigalpa", 			value:"6 2"},
		{name:"(GMT-06:00)Saskatchewan", 						value:"6 3"},
		{name:"(GMT-05:00)Bogota, Lima, Quito", 				value:"5 1"},
		{name:"(GMT-05:00)Eastern Time (US & Canada)", 			value:"5 2"},
		{name:"(GMT-05:00)Indiana (East)", 						value:"5 3"},
		{name:"(GMT-04:00)Atlantic Time (Canada)", 				value:"4 1"},
		{name:"(GMT-04:00)Caracas, La Paz", 					value:"4 2"},
		{name:"(GMT-04:00)Santiago", 							value:"4 3"},
		{name:"(GMT-03:30)Newfoundland", 						value:"3:30 1"},
		{name:"(GMT-03:00)Brasilia", 							value:"3 2"},
		{name:"(GMT-03:00)Buenos Aires, Georgetown", 			value:"3 3"},
		{name:"(GMT-02:00)Mid-Atlantic", 						value:"2 1"},
		{name:"(GMT-01:00)Azores, Cape Verde Is.", 				value:"1 1"},
		{name:"(GMT)Casablanca, Monrovia", 						value:"0 1"},
		{name:"(GMT)Greenwich Mean Time: Dublin, Edinburgh, Lisbon, London", 	value:"0 2"},
		{name:"(GMT+01:00)Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna", 	value:"-1 1"},
		{name:"(GMT+01:00)Belgrade, Bratislava, Budapest, Ljubljana, Prague", 	value:"-1 2"},
		{name:"(GMT+01:00)Barcelona, Madrid", 									value:"-1 3"},
		{name:"(GMT+01:00)Brussels, Copenhagen, Madrid, Paris, Vilnius", 		value:"-1 4"},
		{name:"(GMT+01:00)Paris", 												value:"-1 5"},
		{name:"(GMT+01:00)Sarajevo, Skopje, Sofia, Warsaw, Zagreb", 			value:"-1 6"},
		{name:"(GMT+02:00)Athens, Istanbul, Minsk", 			value:"-2 1"},
		{name:"(GMT+02:00)Bucharest", 							value:"-2 2"},
		{name:"(GMT+02:00)Cairo", 								value:"-2 3"},
		{name:"(GMT+02:00)Harare, Pretoria", 					value:"-2 4"},
		{name:"(GMT+02:00)Helsinki, Riga, Tallinn", 			value:"-2 5"},
		{name:"(GMT+02:00)Jerusalem", 							value:"-2 6"},
		{name:"(GMT+03:00)Baghdad, Kuwait, Riyadh", 			value:"-3 1"},
		{name:"(GMT+03:00)Moscow, St. Petersburg, Volgograd", 	value:"-3 2"},
		{name:"(GMT+03:00)Nairobi", 							value:"-3 3"},
		{name:"(GMT+03:30)Tehran", 								value:"-3:30 4"},
		{name:"(GMT+04:00)Abu Dhabi, Muscat", 					value:"-4 1"},
		{name:"(GMT+04:00)Baku, Tbilisi", 						value:"-4 2"},
		{name:"(GMT+04:30)Kabul", 								value:"-4:30 3"},
		{name:"(GMT+05:00)Ekaterinburg", 						value:"-5 1"},
		{name:"(GMT+05:00)Islamabad, Karachi, Tashkent", 		value:"-5 2"},
		{name:"(GMT+05:30)Bombay, Calcutta, Madras, New Delhi", value:"-5:30 3"},
		{name:"(GMT+06:00)Astana, Almaty, Dhaka", 				value:"-6 1"},
		{name:"(GMT+06:00)Colombo", 							value:"-6 2"},
		{name:"(GMT+07:00)Bangkok, Hanoi, Jakarta", 			value:"-7 1"},
		{name:"(GMT+08:00)Beijing, Chongqing, Hong Kong, Urumchi", value:"-8 1"},
		{name:"(GMT+08:00)Perth", 								value:"-8 2"},
		{name:"(GMT+08:00)Singapore", 							value:"-8 3"},
		{name:"(GMT+08:00)Taipei", 								value:"-8 4"},
		{name:"(GMT+09:00)Osaka, Sapporo, Tokyo", 				value:"-9 1"},
		{name:"(GMT+09:00)Seoul", 								value:"-9 2"},
		{name:"(GMT+09:00)Yakutsk", 							value:"-9 3"},
		{name:"(GMT+09:30)Adelaide", 							value:"-9:30 4"},
		{name:"(GMT+09:30)Darwin", 								value:"-9:30 5"},
		{name:"(GMT+10:00)Brisbane", 							value:"-10 1"},
		{name:"(GMT+10:00)Canberra, Melbourne, Sydney", 		value:"-10 2"},
		{name:"(GMT+10:00)Guam, Port Moresby", 					value:"-10 3"},
		{name:"(GMT+10:00)Hobart", 								value:"-10 4"},
		{name:"(GMT+10:00)Vladivostok", 						value:"-10 5"},
		{name:"(GMT+11:00)Magana, Solomon Is., New Caledonia", 	value:"-11 1"},
		{name:"(GMT+12:00)Auckland, Wellington", 				value:"-12 1"},
		{name:"(GMT+12:00)Fiji, Kamchatka, Marshall Is.", 		value:"-12 2"}
];

function saveChanges(form){

	if (!ValidateNum(form.year, 2010, 2050)
	 || !ValidateNum(form.month, 1, 12)
	 || !ValidateNum(form.day, 1, 31)
	 || !ValidateNum(form.hour, 0, 23)
	 || !ValidateNum(form.minute, 0, 59)
	 || !ValidateNum(form.second, 0, 59))
	{
		return false;
	}
	if (form.NTPenabled.checked
	 && form.ntpServerId[1].checked
	 && !ValidateIP(form.ntpServerIp2, false))
	{
		return false;
	}
	return true;
}

function updateState(form)
{
	var bEnable = form.NTPenabled.checked;
	var bManual = form.ntpServerId[1].checked;

	enableField(form.ntpServerId[0], bEnable);
	enableField(form.ntpServerId[1], bEnable);
	enableField(form.ntpServerIp1, bEnable && !bManual);
	enableField(form.ntpServerIp2, bEnable && bManual);
}

function initpage()
{
	var form = document.time;

	// init value
	form.ntpServerIp1.value = "<%writeValue("ntpServerIp1");%>";
	if (form.ntpServerIp1.selectedIndex == -1)
		form.ntpServerIp1.selectedIndex = 0;
	// show them
	updateState(document.time);
}

</script>
</head>
<body class="bodyContainer" onload="initpage();">
<form action=/goform/formNtp method=POST name="time">
	<div class="boxHeader">
		<h2><%getlanguage("Time Settings"); %></h2>
		<span class="note">
			<%getlanguage("You can synchronize System Log's time stamp with a public time server over the Internet."); %>
		</span>
	</div>
	<div class="box">
		<table class="text">
			<tr>
				<td width ="33%"><%getlanguage("Current Time"); %>:</td>
				<td nowarp>
					<%getlanguage("Yr"); %> <input type="text" name="year" value="<% writeValue("year"); %>" disabled size="4" maxlength="4">
					<%getlanguage("Mon"); %> <input type="text" name="month" value="<% writeValue("month"); %>" disabled size="2" maxlength="2">
					<%getlanguage("Day"); %> <input type="text" name="day" value="<% writeValue("day"); %>" disabled size="2" maxlength="2">
					<%getlanguage("Hr"); %> <input type="text" name="hour" value="<% writeValue("hour"); %>" disabled size="2" maxlength="2">
					<%getlanguage("Mn"); %> <input type="text" name="minute" value="<% writeValue("minute"); %>" disabled size="2" maxlength="2">
					<%getlanguage("Sec"); %> <input type="text" name="second" value="<% writeValue("second"); %>" disabled size="2" maxlength="2">
				</td>
			</tr>
			<tr>
				<td width="33%"><%getlanguage("Time Zone Select"); %>:</td>
			    <td>
		        	<select name="timeZone">
		        		<script>WriteList(ArrayTimeZone, "<% writeValue("ntpTimeZone"); %>");</script>
		        	</select>
			    </td>
			</tr>
			<tr><td colspan="2">
				<input type="checkbox" name="NTPenabled" value="ON" 
				<% if (getValue("ntpEnabled")) write("checked"); %>
				ONCLICK=updateState(document.time)>&nbsp;&nbsp;<%getlanguage("Enable NTP client update"); %><br>
			    </td>
			</tr>
			<tr>
				<td nowrap>
					<input type="radio" value="0" name="ntpServerId"
					<% if (getValue("ntpServerId")==0) write("checked"); %>
					ONCLICK=updateState(document.time)>
					<%getlanguage("NTP server"); %>:
				</td>
				<td>
					<select name="ntpServerIp1">
						<option value="192.5.41.41"><%getlanguage("192.5.41.41    - North America"); %></option>
						<option value="192.5.41.209"><%getlanguage("192.5.41.209   - North America"); %></option>
						<option value="208.184.49.9"><%getlanguage("208.184.49.9   - North America"); %></option>
						<option value="131.188.3.220"><%getlanguage("131.188.3.220  - Europe"); %></option>
						<option value="130.149.17.8"><%getlanguage("130.149.17.8   - Europe"); %></option>
						<option value="203.60.1.2"> <%getlanguage("203.60.1.2  - Australia"); %></option>
						<option value="203.117.180.36"> <%getlanguage("203.117.180.36 - Asia Pacific"); %></option>
					</select>
				</td>
			</tr>
			<tr>
				<td nowrap>
					<input type="radio" value="1" name="ntpServerId" 
					<% if (getValue("ntpServerId")==1) write("checked"); %>
					ONCLICK=updateState(document.time)>
					 <%getlanguage("Manual IP"); %>:
				</td>
				<td>
					<input type="text" name="ntpServerIp2" size="15" maxlength="15" value=<% writeValue("ntpServerIp2"); %>>
				</td>
			</tr>
		</table>
	</div>
	<p align="center">
		<input type="hidden" value="/sysntp.asp" name="submit-url">
		<input type="submit" value="<%getlanguage("Apply"); %>" name="save" onClick="return saveChanges(document.time)">
		&nbsp;&nbsp;
		<input type="button" value="<%getlanguage("Cancel"); %>" name="refresh" onClick="Refreshweb();">
	</p>
</form>
</body>
</html>
