#ifdef ZCOM_TDM_COORDINATION
#ifndef _ZCOM_TDM_COORDINATION_H_
#define _ZCOM_TDM_COORDINATION_H_
#include <linux/list.h>

//#define ZCOM_TDM_COORDINATION

#define VQOS_TYPE_ID 0x38
#define VQOS_UNIQUE_STRING "VQOS"
#define VQOS_SUB_TYPE_ID 0x01
#define VQOS_RETAIN 0x24
#define VQOS_ELEMENT_ID 0x55

#define VQOS_ELEMENT_RSSI_LENGTH 1
#define VQOS_ELEMENT_TS_LENGTH 1
#define VQOS_ELEMENT_TS_ID_LENGTH 2

#define STDM_ASSOC_REQ_LENGTH 1

#define IEEE80211_STDM_ENABLE	1
#define IEEE80211_STDM_DISABLE  0
#define TIME_SLICE_MAX 1024000 //us
#define TIME_SLICE_MIN 20000     //us
#define VQOS_MAX_LENGTH 350
#define STDM_ASSOC_REQ_MAX_LENGTH 3

#define BEACON_SYN_ALL_STA_TICK 10

#define	ADDSHORT(frm, v) do {	\
	frm[0] = (v) & 0xff;			\
	frm[1] = (v) >> 8;			\
	frm += 2;					\
} while (0)

struct stdm_sta{													//use kernel list
	u_int8_t			sta_mac[IEEE80211_ADDR_LEN];				//station mac info
	int8_t				sta_rssi;									//station rssi info
	u_int8_t			sta_timeslice;								//num of station time slices
	u_int16_t			sta_timeoffs;								//each have 1 slice in FIFO
};

struct elem_info {
	u_int8_t			sta_num;				//num of associated stations
	u_int16_t			timeslice_num;			//num of total time slices
	struct stdm_sta		*tdm_sta_info;			//information of station
};

struct elem_list {
	u_int8_t			elem_flag;				//element flag
	struct elem_info	elem_info_list;			//element information
};

/*
 * generic definitions for tdm parameters by cx add
 */
 
struct vqos_param {
	u_int8_t			tdm_type;
	u_int16_t			tdm_length;
	u_int8_t			tdm_flag[4];			//frame flag(default : VQOS)
	u_int8_t			tdm_subtype;			//frame sub type(default : 0x0001)
	u_int8_t			tdm_id;					//beacon id
	u_int16_t			tdm_timeslice;			//total slices time
	u_int8_t			tdm_retain;				//retain for extra
	struct elem_list	tdm_element;			//element list
};

#define ath_hal_pauseTx(_ah, _mask, _pause) \
	((*(_ah)->ah_pauseTx)((_ah), (_mask), (_pause)))
    
u_int8_t *ieee80211_add_vqos(u_int8_t *frm);
void ieee80211_parser_vqos(struct ieee80211_node *ni, struct ieee80211_beacon_offsets *bo, struct sk_buff *skb);

#ifdef _ZCOM_TDM_WDS_
#define WDS_STDM_TYPE           0x38
#define WDS_STDM_VERSION        0x01
#define WDS_STDM_UNIQUE_STRING  "WDS.STDM"

struct ieee80211_wds_stdm_ie {
    u_int8_t    type;
    u_int8_t    length;
    u_int8_t    identifier_string[8];
    u_int8_t    version;
    u_int8_t    sequence_number;
    u_int16_t   total_slices_time;
    u_int8_t    time_slices_count;
    u_int8_t    slave_clients_count;
    u_int8_t	master_mac[6];
//    struct wds_stdm_slave_client slave_clients_list[slave_clients_count];
} __packed;

struct wds_stdm_slave_client {
    u_int8_t    number;
    u_int8_t    time_slices_count;
    u_int8_t    mac[6];
} __packed;

u_int8_t *ieee80211_add_wds_stdm(u_int8_t *frame);
int ieee80211_parser_wds_stdm(struct ieee80211_node *ni, struct ieee80211_beacon_offsets *bo, struct sk_buff *skb);
#endif

void stdm_txq_sch(void);
void StartPlatformTimer(u_long start_time);
void StopPlatformTimer(void);
void ResetPlatformTimer(u_long resetTimer);
#endif
#endif
