/*
 * if_zcom_wds_private.h
 */
#ifdef _ZCOM_FOR_WDS_
#ifndef __ZCOM_WLAN_WDSPRIVATE_H__
#define __ZCOM_WLAN_WDSPRIVATE_H__
////////////////////////////////////////////////////////////////////
// OS about operations defines
// Note: Please implement those according to your target platform
////////////////////////////////////////////////////////////////////

#include <linux/slab.h>
#include <asm/hardirq.h>
#include <linux/spinlock.h>
#include <linux/sched.h>

#define WDS_ASSERT(x) BUG_ON(!(x))

#define WDS_MEM_MALLOC(size)	kmalloc(size, in_interrupt()?GFP_ATOMIC:GFP_KERNEL)
#define WDS_MEM_FREE(addr)	kfree(addr)
#define WDS_MEM_CPY(to, from, len)	memcpy((void*)to, (void*)from, (unsigned long)len)
#define WDS_MEM_SET(addr, value, len)	memset((void*)addr, (unsigned long)value, (unsigned long)len)
#define WDS_MEM_CMP(addrs, addrt, len)	memcmp((void*)addrs, (void*)addrt, (unsigned long)len)

typedef spinlock_t	WDS_SPIN_LOCK;
#define WDS_SPIN_LOCK_INIT(lock)	spin_lock_init(&lock)
#define WDS_SPIN_LOCK_SAVE(lock, flags)	spin_lock_irqsave(&lock, flags)
#define WDS_SPIN_LOCK_RESTORE(lock, flags)	spin_unlock_irqrestore(&lock, flags)
#define WDS_SPIN_LOCK_RELEASE(lock)
#define WDS_GET_CURRENT_MS()	(jiffies*(1000/HZ))

////////////////////////////////////////////////////////////////////
// WDS module private data defines
////////////////////////////////////////////////////////////////////
#define WDS_NODE_TIME_TO_LIFE		120000	// in millisecond
#define WDS_NODE_MAX_HASH_INDEX		255
#define WDS_NODE_MAX_NUM			384
#define WDS_NODE_KEEPING_INTERVAL	100000
#define MAX_LOCAL_PC_COUNT			128

typedef struct	WDS_HASH_NODE WDS_HASH_NODE, *PWDS_HASH_NODE;
typedef struct	DESTINATION_NODE DESTINATION_NODE, *PDESTINATION_NODE;

struct	DESTINATION_NODE
{
	PDESTINATION_NODE			pNext;
	PWDS_HASH_NODE				pDestHashNode;
};

struct	WDS_HASH_NODE 
{
	PWDS_HASH_NODE			pNext;				// List in same hash index
	WDS_NODE				WdsNode;			// Store public attributes of WDS node (public attributes)
	union
	{
		PWDS_NODE				pAssocNode;		// Assocication node pointer for destination node
												// NULL means ETH forwarding
												// (private attributes)
		PDESTINATION_NODE		pDestNodeList;	// Store all destination node for this association node
	};
	unsigned long			ulTimeToLife;		// in millisecond (private attributes)
};

typedef	struct LocalPCEntry{
	struct LocalPCEntry*	pNextEntry;
	WDS_MAC_ADDR			localApPC;
	u_int8_t				pad[2];
#define	MAX_LOCAL_PC_LIFE_TICKS	30000			// in millisecond
	u_int32_t				ulLastActiveTicks;	// ticks in millisecond, record last time receive frame from it.
} LocalPCEntry;

struct WDS_CONTEXT
{
	WDS_SPIN_LOCK			WdsSpinLock;
	PWDS_HASH_NODE			pWdsHashList[WDS_NODE_MAX_HASH_INDEX];
	PWDS_HASH_NODE			pWdsHashFreeList;
	WDS_HASH_NODE			WdsHashNodePool[WDS_NODE_MAX_NUM];
	unsigned long			ulLastTimeNodeKeeping; // in millisecond, record last time for node keeping
	LocalPCEntry			*localPCEntry;
	unsigned int			iLocalPCEntryCount;
	unsigned int			wdsTimerFlag;
	unsigned int			wdsLocalPcEntryFlag;
	WDS_ASSOC_NODE_LIST		AssocNodeList;
};
#endif//__ZCOM_WLAN_WDSPRIVATE_H__
#endif
