#ifndef __IEEE80211_DEV_CONFIG__
#define __IEEE80211_DEV_CONFIG__
#include <linux/kernel.h>

#define atoi(str) simple_strtoul(((str != NULL) ? str : ""), NULL, 0)
#define strtoul(str) simple_strtoul(((str != NULL) ? str : ""), NULL, 16)
#ifndef TABLE_SIZE
#define TABLE_SIZE(tbl)		(sizeof(tbl)/sizeof(tbl[0]))
#endif
#ifndef	FIELD_OFFSET
#define	FIELD_OFFSET(_struct_name_, _field_name_)			\
	( (uint32_t)&(((_struct_name_ *)0)->_field_name_) )
#endif
#ifndef	FIELD_SIZE
#define	FIELD_SIZE(_struct_name_, _field_name_)				\
	( sizeof((((_struct_name_ *)0)->_field_name_)) )
#endif
#ifndef FIELD_INFO
#define	FIELD_INFO(_struct_name_, _field_name_)				\
		FIELD_OFFSET(_struct_name_, _field_name_),		\
		FIELD_SIZE(_struct_name_, _field_name_)
#endif

int config_wir_freq(struct ieee80211vap *, struct ieee80211com *, int);
int config_wir_mode(struct ieee80211vap *, int);
int config_wep_encode(struct ieee80211vap *, struct iw_point *, char *);
int config_data_rate(struct net_device *, int, int);
struct ieee80211_channel *findchannel(struct ieee80211com *ic, int ieee, int mode);


#define IF_ZCOM_FILE			"/tmp/config.dat"
#define TAG_VAP_PREFIX			"ath"
#define TAG_VAP_START			"vap_cfg"
#define TAG_VAP_END				"vap_def_end"
#define TAG_WIFI_START			"wifi_cfg"
#define TAG_WIFI_END			"wifi_def_end"
#define TAG_EQ_CHR				'='
#define TAG_SECTION_START		'['
#define INVALID_VAP_INDEX 		-1
#define MAX_VAP_NUM				16
#define MAX_WDS_NUM				4
#define MAX_ACL_NUM				32
#define RATE_AUTO 				0xFF
#define VAP_NAME_LEN			16
#define SSID_LEN 				36
#define WEP_KEY_LEN 			36
#define AES_KEY_LEN				68
#define NULL_MAC 				"\x00\x00\x00\x00\x00\x00"

enum WlanIfUpdate_t
{
	IF_UPDATE_WIRELESS_SETTINGS	= 0,
	IF_UPDATE_ZCOM_INFO,
};

enum ZCOM_IFTYPE_t
{
	ZCOM_IFTYPE_NONE			= 0,
	ZCOM_IFTYPE_WIFI			= 0x10,
	ZCOM_IFTYPE_VAP				= 0x01,
	//ZCOM_IFTYPE_PUBLIC			= 0x02,
};

enum ZCOM_WIRMODE_t{
	ZCOM_WIRMODE_BG				= 0,
	ZCOM_WIRMODE_A 				= 1,
	ZCOM_WIRMODE_B				= 2,
	ZCOM_WIRMODE_G				= 3,
	ZCOM_WIRMODE_NA				= 7,
	ZCOM_WIRMODE_NG				= 8,
	ZCOM_WIRMODE_NA_ONLYN		= 19,
	ZCOM_WIRMODE_NG_ONLYN		= 20,
	ZCOM_WIRMODE_INIT			= 200
};
enum zcom_opmode {
	ZCOM_OPMODE_AP 					= 0,
	ZCOM_OPMODE_CLIENT,
	ZCOM_OPMODE_P2P,
	ZCOM_OPMODE_P2P_AP,
	ZCOM_OPMODE_INIT				= 100,
};

enum zcom_chan_offset_t
{
	WIRELESS_CWM_OFFSET_NONE,
	WIRELESS_CWM_OFFSET_LOWER,
	WIRELESS_CWM_OFFSET_UPPER,
	WIRELESS_CWM_OFFSET_MAX,
};

typedef enum Authentication_t
{
	AUTH_OPEN_SYSTEM	= 0x00,
	AUTH_SHARED_KEY		= 0x01,
	AUTH_802_1X			= 0x02,
	AUTH_WPA_RADIUS		= 0x04,
	AUTH_WPA2_RADIUS	= 0x08,
	AUTH_WPA1_2_RADIUS	= (AUTH_WPA_RADIUS|AUTH_WPA2_RADIUS),
	AUTH_WPA_PSK		= 0x10,
	AUTH_WPA2_PSK		= 0x20,
	AUTH_WPA1_2_PSK		= (AUTH_WPA_PSK|AUTH_WPA2_PSK),
	AUTH_ALL			= (AUTH_OPEN_SYSTEM|AUTH_SHARED_KEY|AUTH_802_1X|AUTH_WPA1_2_RADIUS|AUTH_WPA1_2_PSK),
} Authentication_t;

typedef enum Encryption_t
{
	ENCRYPT_NONE		= 0x00,
	ENCRYPT_WEP			= 0x01,
	ENCRYPT_TKIP		= 0x02,
	ENCRYPT_AES			= 0x04,
	ENCRYPT_AES_TKIP	= (ENCRYPT_TKIP|ENCRYPT_AES),
} Encryption_t;

struct if_acl_cfg_t
{
	u_int8_t iu_acl_policy;
	u_int8_t iu_acl_addr[MAX_ACL_NUM][IEEE80211_ADDR_LEN];
};

typedef struct if_vap_cfg_t {
	u_int8_t	iu_vap_enable;					//enable or disable
	u_int8_t	iu_hidden_ssid;					//hidden ssid
	u_int8_t	iu_intra_bss_enable;			//intra-bss 
	u_int8_t	iu_auth_type;					//auth type
	u_int8_t	iu_encrypt;						//encryption
	u_int8_t	iu_privacy;	
	u_int8_t	iu_wep_def_no;					//privacy
	u_int8_t	iu_wmm_enable;					//wmm
	u_int8_t 	iu_ssid[SSID_LEN];				//ssid
	u_int8_t 	iu_vap_name[VAP_NAME_LEN];
	struct if_acl_cfg_t iu_acl_cfg;				//acl
	u_int16_t	iu_vlanid;
	u_int8_t 	iu_scan11n_enable;
	u_int8_t	iu_igmpsnooping;
#ifdef ZCOM_TDM_COORDINATION			// add for STDM
	u_int8_t		iu_stdm;			/*vap enable/disable stdm*/
#endif
	u_int16_t	iu_max_stanum;
	u_int8_t	iu_wds_isolation;
}if_vap_cfg_t;

struct if_wds_cfg_t
{
	u_int8_t	iu_wds_auth;
	u_int8_t 	iu_wds_key[AES_KEY_LEN];
	u_int8_t 	iu_wds_addr[MAX_WDS_NUM][IEEE80211_ADDR_LEN];
#ifdef _ZCOM_TDM_WDS_
	u_int8_t	iu_wds_stdm_mode;
#endif
};

#ifdef _ZCOM_INFO_
struct if_info_cfg_t
{
	u_int32_t	iu_ip;
	char		iu_name[17];
	char		iu_ver[40];
};
#endif

typedef struct if_user_cfg_t
{
	// wifi attributes, the int must be 32bits
	u_int32_t	iu_powerlevel;
	u_int32_t 	iu_distance;
	u_int32_t 	iu_antenna;
	u_int32_t	iu_ampdu_enable;
	u_int32_t	iu_ampdu_frames;
	u_int32_t	iu_ampdu_limit;

	u_int32_t	iu_domain;						//domain
	u_int8_t	iu_channel;						//channel
	u_int16_t	iu_txrate;						//data rate
	u_int8_t	iu_opmode;						//operation mode
	u_int8_t	iu_wir_mode;					//wireless mode
	u_int8_t	iu_preamble;					//preamble
	u_int16_t	iu_rts_thres;					//rts threshold
	u_int16_t	iu_frag_thres;					//fragment threshold
	u_int16_t	iu_bcn_intvl;					//beacon interval
	u_int16_t	iu_dtim_intvl;					//dtim interval
	
	//11n property
	u_int8_t	iu_amsdu_enable;
	u_int8_t	iu_shortgi_enable;
	u_int8_t	iu_cwm_mode;
	u_int8_t	iu_chan_offset;
	//u_int8_t	iu_cwm_chbwmode;				// for 5M/10M channel bandwidth
	u_int8_t	iu_rifs_enable;
	u_int8_t	iu_ext_protmode;
	u_int8_t	iu_htprot_enable;
	u_int8_t	iu_full_link;
	u_int8_t 	iu_ctl_enable;
	u_int8_t	iu_ignore11d;
	u_int8_t	iu_wep_key[4][WEP_KEY_LEN];
#ifdef _ZCOM_LAN2LAN_
	u_int8_t	iu_lan2lan;
#endif

	u_int8_t	iu_radiotest_enable; 
	u_int16_t	iu_radiotest_total; 
	u_int8_t	iu_radiotest_mac[IEEE80211_ADDR_LEN]; 

	struct if_wds_cfg_t iu_wds_cfg;				//wds config
	struct if_vap_cfg_t iu_vap_cfg[MAX_VAP_NUM];				//per vap config
#ifdef _ZCOM_INFO_
	struct if_info_cfg_t iu_info_cfg;
#endif
#ifdef _ZCOM_CHAN_HALF_
	u_int32_t	iu_chan_bandwidth;
#endif
} if_user_cfg_t;

enum WlanIfElemType_t
{
	IF_ELEM_NONE,
	IF_ELEM_INT,
	IF_ELEM_STR,
	IF_ELEM_MAC,
	IF_ELEM_MACS
};
typedef struct WlanIfElem_t
{
	int			type;
	char		*name;
	u_int32_t	offset;
	u_int16_t	len;
}WlanIfElem_t;


#endif

