#include <osdep.h>

/* set bus cachesize in 4B word units */
void bus_read_cachesize(osdev_t osdev, int *csz)
{
    /* XXX: get the appropriate value! PCI case reads from config space,
     *   and I think this is the data cache line-size. 
     */
    *csz = L1_CACHE_BYTES / sizeof(u_int32_t);
}

/* NOTE: returns uncached (kseg1) address. */
void *bus_alloc_consistent(void *hwdev, size_t size,
                            dma_addr_t * dma_handle)
 {
     void *ret;
     int gfp = GFP_ATOMIC;
     
     ret = (void *) __get_free_pages(gfp, get_order(size));
     
     if (ret != NULL) {
         memset(ret, 0, size);
         *dma_handle = __pa(ret);
         dma_cache_wback_inv((unsigned long) ret, size);
         ret = UNCAC_ADDR(ret);
     }
     
     return ret;
 }

void bus_free_consistent(void *hwdev, size_t size,
                         void *vaddr, dma_addr_t dma_handle)
{
    unsigned long addr = (unsigned long) vaddr;
    
    addr = CAC_ADDR(addr);
    free_pages(addr, get_order(size));
}
