<html>
<head>
<META HTTP-EQUIV="expires" CONTENT="0">
<META HTTP-EQUIV="pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache, must-revalidate">
<%languagechar_show();%>

<title>WLAN Basic Settings</title>
<link rel="stylesheet" href="./stylesheets/nb.css" type="text/css">
<link rel="stylesheet" href="./stylesheets/jslider.css" type="text/css">
<!--[if IE 6]>
	<link rel="stylesheet" href="./stylesheets/jslider.ie6.css" type="text/css" media="screen">
<![endif]-->

<script type="text/javascript" src="./javascripts/jquery.js"></script>
<script type="text/javascript" src="./javascripts/jquery.dependClass.js"></script>
<script type="text/javascript" src="./javascripts/jquery.slider.js"></script>
<script type="text/javascript" src="./javascripts/common.js"></script>
<script>

function FillList(list, array, len)
{
	if (len == 0)
		len = array.length;
	for(i=0; i<len; i++)
	{
		var oOption=new Option(array[i].name, array[i].value);
		list.options[list.length]=oOption;
	}
}

function SelectList(list, selectText)
{
	list.selectedIndex = 0;
	for (i=0; i<list.length; i++)
	{
		if (list.options[i].text == selectText)
		{
			list.value = list.options[i].value;
			break;
		}
	}
}

var Rate_auto = [
		{value:255,	name: "<%getlanguage("Auto");%>"	}
];
var Rate_11b = [
		{value:27,	name: "<%getlanguage("1M");%>"		},
		{value:26,	name: "<%getlanguage("2M");%>"		},
		{value:25,	name: "<%getlanguage("5.5M");%>"	},
		{value:24,	name: "<%getlanguage("11M");%>"		}
];
var Rate_11g = [
		{value:11,	name: "<%getlanguage("6M");%>"		},
		{value:15,	name: "<%getlanguage("9M");%>" 		},
		{value:10,	name: "<%getlanguage("12M");%>" 	},
		{value:14,	name: "<%getlanguage("18M");%>" 	},
		{value:9,	name: "<%getlanguage("24M");%>" 	},
		{value:13,	name: "<%getlanguage("36M");%>" 	},
		{value: 8,	name: "<%getlanguage("48M");%>" 	},
		{value:12,	name: "<%getlanguage("54M");%>" 	}
];
var Rate_11n = [
		{value:128,		name: "<%getlanguage("MCS0-6.5[13.5]");%>"	},
		{value:129,  	name: "<%getlanguage("MCS1-13[27]");%>"		},
		{value:130,  	name: "<%getlanguage("MCS2-19.5[40.5]");%>"	},
		{value:131,  	name: "<%getlanguage("MCS3-26[54]");%>"		},
		{value:132,  	name: "<%getlanguage("MCS4-39[81]");%>"		},
		{value:133,  	name: "<%getlanguage("MCS5-52[108]");%>"	},
		{value:134,  	name: "<%getlanguage("MCS6-58.5[121.5]");%>"},
		{value:135,  	name: "<%getlanguage("MCS7-65[135]");%>"	},
		{value:136,  	name: "<%getlanguage("MCS8-13[27]");%>"		},
		{value:137,  	name: "<%getlanguage("MCS9-26[54]");%>"		},
		{value:138,  	name: "<%getlanguage("MCS10-39[81]");%>"	},
		{value:139,  	name: "<%getlanguage("MCS11-52[108]");%>"	},
		{value:140,  	name: "<%getlanguage("MCS12-78[162]");%>"	},
		{value:141,  	name: "<%getlanguage("MCS13-104[216]");%>"	},
		{value:142,  	name: "<%getlanguage("MCS14-117[243]");%>"	},
		{value:143,  	name: "<%getlanguage("MCS15-130[270]");%>"	}
];
var Rate_11n_sgi = [
		{value:128,		name: "<%getlanguage("MCS0-6.5[15]");%>"	},
		{value:129,  	name: "<%getlanguage("MCS1-13[30]");%>"		},
		{value:130,  	name: "<%getlanguage("MCS2-19.5[45]");%>"	},
		{value:131,  	name: "<%getlanguage("MCS3-26[60]");%>"		},
		{value:132,  	name: "<%getlanguage("MCS4-39[90]");%>"		},
		{value:133,  	name: "<%getlanguage("MCS5-52[120]");%>"	},
		{value:134,  	name: "<%getlanguage("MCS6-58.5[135]");%>"	},
		{value:135,  	name: "<%getlanguage("MCS7-65[150]");%>"	},
		{value:136,  	name: "<%getlanguage("MCS8-13[30]");%>"		},
		{value:137,  	name: "<%getlanguage("MCS9-26[60]");%>"		},
		{value:138,  	name: "<%getlanguage("MCS10-39[90]");%>"	},
		{value:139,  	name: "<%getlanguage("MCS11-52[120]");%>"	},
		{value:140,  	name: "<%getlanguage("MCS12-78[180]");%>"	},
		{value:141,  	name: "<%getlanguage("MCS13-104[240]");%>"	},
		{value:142,  	name: "<%getlanguage("MCS14-117[270]");%>"	},
		{value:143,  	name: "<%getlanguage("MCS15-130[300]");%>"	}
];
var Rate_11a = Rate_11g;
function GenTransmitRate(form)
{
	var wirelessMode = Number(form.wlWirMode.value);
	var shortGI = <%writeValue("ShortGIenable");%>;
	var chainNum = <%writeValue("specChainNum");%>;
	var list = form.wlRate;
	var selectText = list.selectedIndex==-1 ? "<%writeValue("wlRateStr");%>" : list.options[list.selectedIndex].innerText;

	EmptyOptions(list);
	FillList(list, Rate_auto, 0);
	switch(wirelessMode)
	{
	case 0:	// b/g auto
		FillList(list, Rate_11b, 0);
		FillList(list, Rate_11g, 0);
		break;
	case 1:
		FillList(list, Rate_11a, 0);
		break;
	case 2:	// b only
		FillList(list, Rate_11b, 0);
		break;
	case 3:	// g only
		FillList(list, Rate_11g, 0);
		break;
	case 7:	// a/n
		FillList(list, Rate_11a, 0);
		if (shortGI)
			FillList(list, Rate_11n_sgi, 8 * chainNum);
		else
			FillList(list, Rate_11n, 8 * chainNum);
		break;
	case 8:	// b/g/n
		FillList(list, Rate_11b, 0);
		FillList(list, Rate_11g, 0);
		if (shortGI)
			FillList(list, Rate_11n_sgi, 8 * chainNum);
		else
			FillList(list, Rate_11n, 8 * chainNum);
		break;
	case 19:// an only
	case 20:// gn only
		if (shortGI)
			FillList(list, Rate_11n_sgi, 8 * chainNum);
		else
			FillList(list, Rate_11n, 8 * chainNum);
		break;
	}
	SelectList(list, selectText);
}

var ChanPowerTbl = [
<%wlChanPowerTbl();%>
];

function GetChannelNum(bandWidth)
{
	var list = form.wlChannel;
	var len = ChanPowerTbl.length;
	var num = 0;

	for(i=0; i<len; i++)
	{
		if (bandWidth==5 && ChanPowerTbl[i].quarter!=0)
			num++;
		else if (bandWidth==10 && ChanPowerTbl[i].half!=0)
			num++;
		else if (bandWidth==40 && ChanPowerTbl[i].ht40!=0)
			num++;
		else if (bandWidth==20 && (ChanPowerTbl[i].nonht!=0 || ChanPowerTbl[i].ht20!=0))
			num++;
	}
	return num;
}

function GenChannelList(form)
{
	var list = form.wlChannel;
	var selectValue = list.selectedIndex==-1 ? "<%writeValue("wlChannel");%>" : list.value;
	var channelMode = form.wlChanMode.value;
	var opMode = form.wlOpMode.value;
	var is11n = (form.wlWirMode.value==7 || form.wlWirMode.value==8
			 || form.wlWirMode.value==19 || form.wlWirMode.value==20);
	var len = ChanPowerTbl.length;

	EmptyOptions(list);
	for(i=0; i<len; i++)
	{
		if ((channelMode==3 && ChanPowerTbl[i].quarter>0)
		|| (channelMode==4 && ChanPowerTbl[i].half>0)
		|| (is11n && channelMode==0 && ChanPowerTbl[i].ht20>0)
		|| (is11n && (channelMode==1||channelMode==2) && ChanPowerTbl[i].ht40>0)
        || (!is11n && channelMode==3 && ChanPowerTbl[i].quarter>0 )
        || (!is11n && channelMode==4 && ChanPowerTbl[i].half>0 )
        || (!is11n && ChanPowerTbl[i].nonht>0 && channelMode==0))
		//|| (!is11n && ChanPowerTbl[i].nonht>0))
		{
			var oOption;
			if (ChanPowerTbl[i].freq==0)
				oOption=new Option("<%getlanguage("Auto");%>", ChanPowerTbl[i].freq);
			else
				oOption=new Option(ChanPowerTbl[i].freq + "MHz" + " (" + mhz2ieee(ChanPowerTbl[i].freq) + ")", ChanPowerTbl[i].freq);
			list.options[list.length]=oOption;
		}
	}
	if (opMode == 2)
		list.remove(0);
	list.value = selectValue;
	if (list.value == "" && list.length > 0)
		list.value = list.options[0].value;
}

var ChannelModeTbl = [
		{bandwidth:5,	value:3,	name: "<%getlanguage("5 MHz");%>"	},
		{bandwidth:10,	value:4,	name: "<%getlanguage("10 MHz");%>"	},
		{bandwidth:20,	value:0,	name: "<%getlanguage("20 MHz");%>"	},
		{bandwidth:40,	value:2,	name: "<%getlanguage("40 MHz");%>"	}
];
var ChanOffsetTbl = [
		{value:0,	name: "<%getlanguage("None");%>"			},
		{value:1,	name: "<%getlanguage("Lower Channel");%>"	},
		{value:2,	name: "<%getlanguage("Upper Channel");%>"	}
];

function GenChannelMode(form)
{
	var list = form.wlChanMode;
	var selectValue = list.selectedIndex==-1 ? "<%writeValue("wlChanMode");%>" : list.value;
	var is11n = (form.wlWirMode.value==7 || form.wlWirMode.value==8
			 || form.wlWirMode.value==19 || form.wlWirMode.value==20);

	EmptyOptions(list);
	for (var i=0; i<ChannelModeTbl.length; i++)
	{
		if (ChannelModeTbl[i].bandwidth == 40 && !is11n)
			continue;
		if (GetChannelNum(ChannelModeTbl[i].bandwidth) > 0)
		{
			var oOption=new Option(ChannelModeTbl[i].name, ChannelModeTbl[i].value);
			list.options[list.length]=oOption;
		}
	}

	list.value = selectValue;
	if (list.value == "" && list.length > 0)
		list.value = list.options[0].value;
}

function getMinPower(form)
{
	var min = 12;
	var channel = form.wlChannel.value;
	var opMode = form.wlOpMode.value;

	for (i=0; i<ChanPowerTbl.length; i++)
	{
		// client mode: power=min.of auto
		if (opMode == 1 || ChanPowerTbl[i].freq == channel)
		{
			min = ChanPowerTbl[i].min;
			break;
		}
	}
	return min;
}
function getMaxPower(form)
{
	var min = getMinPower(form);
	var max = 30;
	var channel = form.wlChannel.value;
	var is11n = (form.wlWirMode.value==7 || form.wlWirMode.value==8
			 || form.wlWirMode.value==19 || form.wlWirMode.value==20);
	var bandwidth = form.wlChanMode.value;
	var opMode = form.wlOpMode.value;

	for (i=0; i<ChanPowerTbl.length; i++)
	{
		// client mode: power=max.of auto
		if (opMode == 1 || ChanPowerTbl[i].freq == channel)
		{
			if (bandwidth == 3)
				max = ChanPowerTbl[i].quarter;
			else if (bandwidth == 4)
				max = ChanPowerTbl[i].half;
			else if (!is11n)
				max = ChanPowerTbl[i].nonht;
			else if (bandwidth == 1 || bandwidth == 2)
				max = ChanPowerTbl[i].ht40;
			else// if (bandwidth == 0)
				max = ChanPowerTbl[i].ht20;
			break;
		}
	}
	return max >= min ? max : min;
}

function updateAntennaGainLimit(form)
{
	var min = 0;
	var max = getMaxPower(form) - getMinPower(form);

	if (form.wlAntennaGain.value > max)
		form.wlAntennaGain.value = max;

	jQuery("#antennaGainSlider").slider({ from: min, to: max, step: 1, onstatechange: function(value) {form.wlAntennaGain.value=value;updatePowerLimit(form);}});
	jQuery("#antennaGainSlider").slider("to", max);
	updateAntennaGainValue(form);
}

function updateAntennaGainValue(form)
{
	jQuery("#antennaGainSlider").slider("value", form.wlAntennaGain.value);
}

function updatePowerLimit(form)
{
	var min = getMinPower(form);
	
	if(form.wlAntenna[0].checked)
		var max = getMaxPower(form);
	else
		var max = getMaxPower(form) - form.wlAntennaGain.value;
	
	if (form.wlPower.value < min)
		form.wlPower.value = min;
	else if (form.wlPower.value > max)
		form.wlPower.value = max;

	jQuery("#powerSlider").slider({ from: min, to: max, step: 1, onstatechange: function(value) {form.wlPower.value=value}});
	jQuery("#powerSlider").slider("from", min);
	jQuery("#powerSlider").slider("to", max);
	updatePowerValue(form);
}

function updatePowerValue(form)
{
	jQuery("#powerSlider").slider("value", form.wlPower.value);
}

var AntennaArray = [
		{value:1,	name: "<%getlanguage("Internal (8 dBi)");%>",	bwarning: false	},
		{value:2,	name: "<%getlanguage("Internal (16 dBi)");%>",	bwarning: false	},
		{value:3,	name: "<%getlanguage("SMA Connector");%>",		bwarning: true	},
		{value:4,	name: "<%getlanguage("External (N-Type)");%>",	bwarning: true	}
];
var g_remAntenna = null;

function GenAntennaList(form)
{
	var supportAntenna = <%writeValue("specAntenna");%>;
	var antennaValue = <%writeValue("wlAntenna");%>;
	var antennaNum = 0;

	for (i=0; i<AntennaArray.length; i++)
	{
		if (supportAntenna & (1<<AntennaArray[i].value))
		{
			var newRadio = createRadio("wlAntenna", AntennaArray[i].value, antennaValue == AntennaArray[i].value);
			document.getElementById("antenna_content").appendChild(newRadio);
			if (AntennaArray[i].bwarning)
			{
				newRadio.onclick = function()
				{
					if(confirm("<% getlanguage("Please DO connect the external antenna before switching to external antenna, otherwise damage might be caused to the CPE!");%>"))
						g_remAntenna = this;
					if (g_remAntenna != null)
						g_remAntenna.checked = true;
					show_div(true, "antennaGain_div");
					updatePowerLimit(form);
				};
			}
			else
			{
				newRadio.onclick = function()
				{
					show_div(false, "antennaGain_div");
					updatePowerLimit(form);
					g_remAntenna = this;
				};
			}
			if (antennaValue == AntennaArray[i].value)
				g_remAntenna = newRadio;

			var newText = document.createElement("span");
			newText.innerText = AntennaArray[i].name + "   ";
			document.getElementById("antenna_content").appendChild(newText);

			antennaNum++;
		}
	}
	show_div(antennaNum != 0, "antenna_div");
}

function updateChannelOffset(form)
{
	var opMode = form.wlOpMode.value;
	var channel = form.wlChannel.value;
	var chanMode = form.wlChanMode.value;
	var list = form.wlChanOffset;
	var selectValue = list.selectedIndex==-1 ? "<%writeValue("wlChanOffset");%>" : list.value;
	var is11n = (form.wlWirMode.value==7 || form.wlWirMode.value==8
			 || form.wlWirMode.value==19 || form.wlWirMode.value==20);
	var supportList = "";
	var currFreq = 0, extFreq = 0;

	if ((opMode!=1) && is11n && (chanMode==1||chanMode==2))
	{
		for (i=0; i<ChanPowerTbl.length; i++)
		{
			if (channel == ChanPowerTbl[i].freq)
			{
				supportList = ChanPowerTbl[i].offset.split(".");
				currFreq = ChanPowerTbl[i].freq;
				break;
			}
		}
	}
	EmptyOptions(list);
	if (supportList.length > 0)
	{
		for (j=0; j<supportList.length; j++)
		{
			extFreq = currFreq + Number(supportList[j]);
			if (extFreq != currFreq)
			{
				var oOption=new Option(ChanOffsetTbl[j+1].name, ChanOffsetTbl[j+1].value);
				list.options[list.length]=oOption;
			}
		}
	}
	if (list.length == 0)
	{
		var oOption=new Option(ChanOffsetTbl[0].name, ChanOffsetTbl[0].value);
		list.options[list.length]=oOption;
	}
	list.value = selectValue;
	if (list.value == "" && list.length > 0)
		list.value = list.options[0].value;
	enableField(list, list.length > 1);
}
function channelOffsetSelect(form)
{
	var channel = form.wlChannel.value;
	var offset = form.wlChanOffset.value;
	var extFreq = "", cenFreq = "";

	for (i=0; i<ChanPowerTbl.length; i++)
	{
		if (channel == ChanPowerTbl[i].freq)
			break;
	}
	if (offset > 0 && i < ChanPowerTbl.length)
	{
		extFreq = ChanPowerTbl[i].freq + Number(ChanPowerTbl[i].offset.split(".")[offset-1]);
		extFreq = extFreq + "MHz" + " (" + mhz2ieee(extFreq) + ")";
		cenFreq = ChanPowerTbl[i].freq + (Number(ChanPowerTbl[i].offset.split(".")[offset-1])/2);
		cenFreq = cenFreq + "MHz" + " (" + mhz2ieee(cenFreq) + ")";
	}
	document.getElementById("chanOffset_freq").innerText = extFreq;
	document.getElementById("chanCenter_freq").innerText = cenFreq;
}

function channelSelection(form)
{
	var bClient = (form.wlOpMode.value==1);
	var chanMode = form.wlChanMode.value;
	var is11n = (form.wlWirMode.value==7 || form.wlWirMode.value==8
			 || form.wlWirMode.value==19 || form.wlWirMode.value==20);

	updateAntennaGainLimit(form);
	updatePowerLimit(form);
	updateChannelOffset(form);
	channelOffsetSelect(form);
	show_div(!bClient, "chanOffset_div");
	show_div(!bClient && is11n && (chanMode==1||chanMode==2), "chanCenter_div");
}

function modeSelection(form)
{
	update11n(form);
	GenChannelMode(form);
	GenTransmitRate(form);
	GenChannelList(form);
	channelSelection(form);
}

function updateOperationMode(form)
{
	updateBasic(form);
 	GenChannelList(form);
	channelSelection(form);
}

function saveChanges(form)
{
	var netMode = Number(<%writeValue("networkMode");%>);
	var oldopMode = Number(<%writeValue("wlOpMode");%>);
	var curopMode = form.wlOpMode.value;

	if(curopMode==1 && form.wlCloneEnable.checked && !ValidateMAC(form.wlClonedMac))
	{
		return false;
	}

	var minpower = getMinPower(form);
	var maxpower = getMaxPower(form);
	var maxGain = maxpower - minpower;

	if(!form.wlAntenna[0].checked)
	{
		if (0 <= maxGain && !ValidateNum(form.wlAntennaGain, 0, maxGain))
		{
			return false;
		}
	}
	// check outpower value
	if (minpower <= maxpower && !ValidateNum(form.wlPower, minpower, maxpower))
	{
		return false;
	}
	if (form.wlSsid.value == "" && curopMode != 2)
	{
		alert("<%getlanguage("SSID cannot be empty!");%>");
		form.wlSsid.focus();
		return false;
	}

	if(netMode!=0 && oldopMode!=curopMode)
	{
		if (!confirm("The settings will take effect only if the device is rebooted. Are you sure to apply the settings and reboot now?"))
			return false;
	}

	return true;
}

function updateMacClone(form)
{
	var netMode = Number(<%writeValue("networkMode");%>);
	var cpeType = Number(<%writeValue("cpeType");%>);
	var bWlanEnable = !form.wlDisabled.checked;
	var bShowDiv = (netMode==0 && form.wlOpMode.value==1 && cpeType==0);

	show_div(bShowDiv, "macClone_div");
	enableField(form.wlCloneEnable, bShowDiv && bWlanEnable);
	enableField(form.wlClonedMac, bShowDiv && bWlanEnable && form.wlCloneEnable.checked);
}

function update11n(form)
{
	var bWlanEnable = !form.wlDisabled.checked;
	var bAPorRepeater = (form.wlOpMode.value==0 || form.wlOpMode.value==3);
	var bClient = (form.wlOpMode.value==1);
	var is11n = (form.wlWirMode.value==7 || form.wlWirMode.value==8
			 || form.wlWirMode.value==19 || form.wlWirMode.value==20);

	//show_div(is11n, "bandWidth_div");
	show_div(is11n && bAPorRepeater, "htProt_div");
	enableField(form.wlHTProt[0], bWlanEnable && is11n && bAPorRepeater);
	enableField(form.wlHTProt[1], bWlanEnable && is11n && bAPorRepeater);
	show_div(is11n, "extProt_div");
}

function updateBasic(form)
{
	var bWlanEnable = !form.wlDisabled.checked;
	var bAPorRepeater = (form.wlOpMode.value==0 || form.wlOpMode.value==3);
	var bClient = (form.wlOpMode.value==1);
	var bWds = (form.wlOpMode.value==2);

	show_div(!bWds, "ssid_div");
	show_div(bAPorRepeater, "mulitSsid_div");
	enableField(form.wlSsid, bWlanEnable && !bWds);
	show_div(bAPorRepeater, "hiddenSSID_div");
	enableField(form.wlHideSsid[0], bWlanEnable && bAPorRepeater);
	enableField(form.wlHideSsid[1], bWlanEnable && bAPorRepeater);
	//show_div(!bClient, "rate_div");
	enableField(form.wlRate, bWlanEnable);
	show_div(!bClient, "channel_div");
	enableField(form.site_survey, bWlanEnable && bClient);

	enableField(form.wlOpMode, bWlanEnable);
	enableField(form.wlWirMode, bWlanEnable);
	enableField(form.wlAntennaGain, bWlanEnable);
	enableField(form.wlPower, bWlanEnable);
	enableField(form.wlChanMode, bWlanEnable);
	enableField(form.wlChanProt, bWlanEnable);
	enableField(form.wlAntenna[0], bWlanEnable);
	enableField(form.wlAntenna[1], bWlanEnable);
	enableField(form.wlChannel, bWlanEnable);
	enableField(form.wlChanOffset, bWlanEnable && form.wlChanOffset.length > 1);

	update11n(form);
	updateMacClone(form);
}

function initpage()
{
	form = document.wlanSetup;

	// gen list
	GenAntennaList(form);
	GenResourceSupprotedOptions(opModeArray, form.wlOpMode, <%writeValue("specOpMode");%>);
	GenResourceSupprotedOptions(wirModeArray, form.wlWirMode, <%writeValue("specWirMode");%>);
	
	// init members' value
	form.wlDisabled.checked = !<%writeValue("wlWlanEnalbe");%>;
	form.wlOpMode.value = <%writeValue("wlOpMode");%>;
	form.wlWirMode.value = <%writeValue("wlWirMode");%>;
	form.wlSsid.value = form.text_ssid.value;
	form.wlHideSsid[0].checked = !<%writeValue("wlHideSsid0");%>;
	form.wlHideSsid[1].checked = !form.wlHideSsid[0].checked;
	form.wlHTProt[0].checked = <%writeValue("wlHTProt");%>;
	form.wlHTProt[1].checked = !form.wlHTProt[0].checked;
	form.wlAntennaGain.value = <%writeValue("wlAntennaGain");%>;
	form.antennaGainSlider.value = form.wlAntennaGain.value;
	form.wlPower.value = <%writeValue("wlPower");%>;
	form.powerSlider.value = form.wlPower.value;
	form.wlChanProt.value = <%writeValue("wlChanProt");%>;
	form.wlCloneEnable.checked = <%writeValue("wlCloneEnable");%>;
	form.wlClonedMac.value = "<%writeValue("wlClonedMac");%>";
	show_div(!form.wlAntenna[0].checked, "antennaGain_div");
	// update topology
	GenChannelMode(form);
 	GenChannelList(form);
	updateBasic(form);
	modeSelection(form);
}
</script>
</head>

<BODY onLoad="initpage();" class="bodyContainer">
<div class="boxHeader">
	<h2><%getlanguage("Wireless Basic Settings"); %></h2>
	<span class="note">
		<%getlanguage("Use this page to configure the parameters for wireless LAN clients which may connect to your Access Point. Here you may change wireless mode as well as wireless network parameters."); %>
	</span>
</div>
<form action=/goform/formWlanSetup method=POST name="wlanSetup">
<div class="box">
	<h3>
		<input type="checkbox" name="wlDisabled" value="ON" ONCLICK=updateBasic(document.wlanSetup)>
		<%getlanguage("Disable Wireless LAN Interface"); %>
	</h3>
	<table class="text">
		<tr>
			<td width="33%"><%getlanguage("Wireless Mode"); %>:</td>
			<td><select size="1" name="wlOpMode" onChange="updateOperationMode(document.wlanSetup);"></select>
				<input type="button" value="Site Survey" name="site_survey" onClick="window.open('wlsurvey.asp','','width=800,height=450,scrollbars=yes')" width="19" height="15" border="0" align="absmiddle">   
			</td>
		</tr>
		<tr id = "ssid_div">
			<textarea name="text_ssid" style="display:none" disabled><%writeValue("wlSsid0");%></textarea>
			<td><%getlanguage("Wireless Network Name(SSID)"); %>:</td>
			<td><input type="text" name="wlSsid" id="wlSsid" maxlength="32">&nbsp;&nbsp;
				<span id="mulitSsid_div">(<a href="wlprofiles.asp" style ="color: blue"><%getlanguage("more");%>...</a>)</span>
			</td>
		</tr>
		<tr id = "hiddenSSID_div">
			<td><%getlanguage("Broadcast SSID"); %>:</td>
			<td>
				<input type="radio" name="wlHideSsid" value="no"><%getlanguage("Enabled");%>&nbsp;&nbsp;
				<input type="radio" name="wlHideSsid" value="yes"><%getlanguage("Disabled");%>
			</td>
		</tr>
		<tr>
			<td><%getlanguage("802.11 Mode"); %>:</td>
			<td><select size="1" name="wlWirMode" onChange="modeSelection(document.wlanSetup)"></select></td>
		</tr>
		<tr id = "htProt_div" style="display:none">
			<td><%getlanguage("HT protect"); %>:</td>
			<td>
				<input type="radio" name="wlHTProt" value="yes"><%getlanguage("Enabled");%>&nbsp;&nbsp;
				<input type="radio" name="wlHTProt" value="no"><%getlanguage("Disabled");%>
			</td>
		</tr>
		<tr id="channel_div">
			<td><%getlanguage("Frequency/Channel"); %>:</td>
			<td><select name="wlChannel" onChange="channelSelection(document.wlanSetup)"></select>
			</td> 
		</tr>
		<tr id="chanOffset_div">
			<td><%getlanguage("Extension Channel"); %>:</td>
			<td><select size=1 name="wlChanOffset" onChange="channelOffsetSelect(document.wlanSetup)"></select>&nbsp;&nbsp;
				<span id="chanOffset_freq"><span>
			</td>
		</tr>
		<tr id="chanCenter_div">
			<td><%getlanguage("40MHz Center Frequency"); %>:</td>
			<td><span id="chanCenter_freq"><span>
			</td>
		</tr>
		<tr id = "bandWidth_div">
			<td><%getlanguage("Channel Mode"); %>:</td>
			<td><select size=1 name="wlChanMode" onChange="modeSelection(document.wlanSetup);"></select></td>
		</tr>
		<tr id="antenna_div">
		<td><%getlanguage("Antenna"); %>:</td>
		<td id="antenna_content"></td>
		</tr>
		<tr id = "antennaGain_div">
			<td><%getlanguage("Antenna Gain");%>:</td>
			<td><table border=0 width=100%><tr width=100%>
				<td width=40%>
				<div style="width:90%">
					<input id="antennaGainSlider" name="antennaGainSlider" type="slider">&nbsp;
				</div>
				</td>
				<td>
					<input type="text" name="wlAntennaGain" id="wlAntennaGain" size="4" maxlength="4" onChange="updateAntennaGainLimit(document.wlanSetup);updatePowerLimit(document.wlanSetup);">&nbsp;dBi				</td>
			
				</tr></table>
		</tr>
		<tr rawspan=2>
			<td><%getlanguage("Maximum Output Power (per chain)"); %>:</td>
			<td><table border=0 width=100%><tr width=100%>
				<td width=40%>
				<div style="width:90%">
					<input id="powerSlider" name="powerSlider" type="slider"/>
				</div>
				</td>
				<td>
					<input type="text" name="wlPower" size="4" maxlength="4" onChange="updatePowerValue(document.wlanSetup)">&nbsp;dBm
				</td>
				</tr></table>
			</td>
		</tr>
		<tr id = "rate_div">
			<td><%getlanguage("Data Rate"); %>:</td>
			<td>
				<select name="wlRate"></select>
			</td>
		</tr>
		<tr id = "extProt_div" style="display:none">
			<td><%getlanguage("Extension Channel Protection"); %>:</td>
			<td><select size="1" name="wlChanProt">
				<option value=0><%getlanguage("None");%></option>
				<option value=1><%getlanguage("CTS to Self");%></option>
				<option value=2><%getlanguage("RTS-CTS");%></option>
				</select></td>
		</tr>
		<tr id="macClone_div" style="display:none">
			<td><input type="checkbox" name="wlCloneEnable" value="ON" ONCLICK="updateMacClone(document.wlanSetup)">
				<%getlanguage("Enable MAC Clone");%>:
			</td>
			<td><input type="text" name="wlClonedMac" size="20" maxlength="20">
			</td>
		</tr>
	</table>
</div>

<p align="center">
	<input type="hidden" value="/wlbasic.asp" name="submit-url">
	<input type="submit" value="<%getlanguage("Apply"); %>" name="save" onClick="return saveChanges(document.wlanSetup)">&nbsp;&nbsp;
	<input type="button" value="<%getlanguage("Cancel"); %>" name="reset" onClick="Refreshweb();">
</p>

</form>
</body>

</html>
