<html>
<head>
<META HTTP-EQUIV="expires" CONTENT="0">
<META HTTP-EQUIV="pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache, must-revalidate">
<%languagechar_show();%>

<title>Antenna Alignment</title>
<link rel="stylesheet" href="./stylesheets/nb.css" type="text/css">
<script type="text/javascript" src="./javascripts/common.js"> </script>
<script type="text/javascript" src="./javascripts/jquery.js"></script>
<script type="text/javascript" src="./javascripts/jquery.tablesorter.js"></script>
<% language=javascript %>
<SCRIPT>

$(function() {
	$("#myTable").tablesorter({headers: {0:{sorter:false}}});
});	

function initpage()
{
	var wlanEnable = <%writeValue("wlWlanEnalbe");%>;
	var wlanMode = <%writeValue("wlOpMode");%>;

	if (!wlanEnable || (wlanMode!=2 && wlanMode!=3))
		disableAll();
	setTimeout('getResult()', 200);
}

function selectMac(mac)
{
	document.frmalign.remotemac.value = mac;
	enableTextField(document.frmalign.btTest);
}

function setState(state)
{
	document.frmalign.state.value = state;
	if (state == "<%getlanguage("Start"); %>")
	{
		document.frmalign.btTest.value = "<%getlanguage("Stop"); %>";
	}
	else
		document.frmalign.btTest.value = "<%getlanguage("Start"); %>";
}

var timestep = 5;
function countDown()
{
	if (timestep <= 0)
	{
		enableTextField(document.frmalign.btTest);
		document.frmalign.btTest.value = "<%getlanguage("Stop"); %>";
	}
	else
	{
		disableTextField(document.frmalign.btTest);
		document.frmalign.btTest.value = "Wait..." + timestep;
		timestep--;
		setTimeout('countDown()', 1000);
	}
}

function getResult()
{
	var xmlHttp = createAjax();
	var bFound = 0;
	var rad = document.getElementsByName("rad");
	for (i=0; i<rad.length; i++)
	{
		if (rad[i].checked)
		{
			bFound = 1;
			break;
		}
	}
	if (!bFound)
	{
		disableTextField(document.frmalign.btTest);
		return;
	}
	if (document.frmalign.state.value != "<%getlanguage("Start"); %>")
		return;
	// get result
	xmlHttp.onreadystatechange = function ()
	{
		if ((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			document.getElementById('result_div').innerHTML = xmlHttp.responseText;
		}
	}
	var url = "toolantennaalign_ajax.asp" + "?sid=" + Math.random();
	xmlHttp.open("GET", url, true);
	xmlHttp.send(null);
	if (document.frmalign.state.value == "<%getlanguage("Start"); %>"
	 && document.frmalign.remotemac.value != "")
		setTimeout('getResult()', 1000);
}

function LinkTest()
{
	if (document.frmalign.state.value != "<%getlanguage("Start"); %>"
	 && document.frmalign.remotemac.value == "")
	{
		alert("<%getlanguage("Please select an MAC Address"); %>");
		return false;
	}
	document.frmalign.state.value = document.frmalign.btTest.value;
	return document.frmalign.submit();
}

</SCRIPT>
</head>

<BODY class="bodyContainer" onload="initpage();">
<div class="boxHeader">
	<h2><%getlanguage("Antenna Alignment");%></h2>
	<span class="note">
		<%getlanguage("Use this page to align the antenna by link quality."); %>
	</span>
</div>
<form action=/goform/formAntennaAlign method=POST name="frmalign">
	<input type="hidden" value="/toolantennaalign.asp" name="submit-url">
	<input type="hidden" value="" name="state">
	<input type="hidden" value="" name="remotemac">
	<div class="box" align="center">
		<table width="60%" cellspacing="1" id="myTable" class="tablesorter">
		<thead>
			<tr align="center">
		      <th width="15%">&nbsp;</th>
		      <th width="20%"><%getlanguage("Index");%></th>
		      <th width="65%"><%getlanguage("MAC Address");%></th>
		    </tr>
		</thead>
  		<tbody>
		    <%AntennaAlignMacTbl();%>
  		</tbody>
		</table>
	</div>
	<p align="center">
		<input type="button" value="<%getlanguage("Refresh"); %>" onClick="Refreshweb()">
		&nbsp;&nbsp;
		<input type="button" value="<%getlanguage("Start"); %>" name="btTest" onClick="LinkTest()">
	</p>
	<div id="result_div">
	</div>
</form>
</body>
</html>

