/************************************************************
 *
 * 			tx99_config.c
 * Copyright(c) Nanjing Z-Com, Inc
 * http://www.zcom.com.cn
 *
 * begin :Thu May 2010
 * Copyright	:(c)2010 by Z-Com
 * email	:jxq19881013@hotmail.com
 * **********************************************************/

#include "tx99_config.h"

static Tx99_para_t tx99_parament;

int file_is_null(char *filename)
{
	FILE *fp = NULL;
	char ch;

	if((fp = fopen(filename, "r")) == NULL)
	{
		perror("Open file failed");
	}

	ch = fgetc(fp);
	if(ch == EOF)
	{
		fclose(fp);
		return 1;
	}
	else
	{
		fclose(fp);
		return 0;
	}
}


int file_lines_num(char *filename)
{
	FILE *fp = NULL;
	char *line = NULL;
	size_t len = 0;
	ssize_t read;
	int lines_num = 0;

	fp = fopen(filename,"r");
	if(fp == NULL)
	{
		perror("Open file failed");
	}

	while((read = getline(&line, &len, fp)) != -1)
	{
		lines_num++;	
	}
	
	if(line)
	{
		free(line);
	}

	return lines_num;

}

int check_module_status(char *module_name)
{
	/*use the lsmod command to check*/
	char cmd[MAX_COMMAND_LINE_SIZE] = "lsmod | grep ";
	int result;

	strcat(cmd, module_name);
	strcat(cmd, "> temp.txt");
	printf("cmd:%s--%d\n",cmd,__LINE__);
	system(cmd);
	result=file_is_null("temp.txt");

	/*result is 1 stands for module has not been loaded*/
	if(result == 1)
	{
		printf("Necessary module %s has not been loaded\n");
		return 1;
	}
	return 0;
}


int check_exist_wifi(void)
{
	/*use the ifconfig -a command to check the exist wifi interface*/
	int lines_num;
	char cmd[MAX_COMMAND_LINE_SIZE] = "ifconfig -a | grep wifi > temp.txt";

	printf("cmd:%s--%d\n",cmd,__LINE__);
	system(cmd);
	lines_num = file_lines_num("temp.txt");
	
	if(lines_num != 0)
	{
		/*wifi interface exist*/	
		return 1;
	}
	else
	{
		return 0;
	}


}


int check_wlan_interface_num(void)
{
	/*use the ifconfig -a command to check the exist and number of interface*/
	int lines_num;
	char cmd[MAX_COMMAND_LINE_SIZE] = "ifconfig -a | grep ath > temp.txt";

	printf("cmd:%s--%d\n",cmd,__LINE__);
	system(cmd);

	lines_num = file_lines_num("temp.txt");

	return lines_num;

}

int check_wlan_interface_status(void)
{
	/*use the ifconfig command to check the status of wlan interface*/
	int lines_num;
	char cmd[MAX_COMMAND_LINE_SIZE] = "ifconfig | grep ath > temp.txt";

	printf("cmd:%s--%d\n",cmd,__LINE__);
	system(cmd);
	lines_num = file_lines_num("temp.txt");

	return lines_num;
}

int stop_wlan_interface(int wlan_num)
{
	int i = 0;
	char cmd[MAX_COMMAND_LINE_SIZE] = {};

	for(i = 0; i < wlan_num; i++)
	{
		sprintf(cmd,"ifconfig ath%d down",i);
		printf("cmd:%s--%d\n",cmd,__LINE__);
		system(cmd);
	}

	return 0;
	
}

int check_current_env(void)
{
	int module_status;
	int wlan_interface_num = 0;
	int exist_wifi = 0;
	/*?May be we should adjust the order of module?*/
	/*check the necessary module whether have been loaded*/

	/*check the ath_hal module*/
	module_status = check_module_status("ath_hal");

	if(module_status == 1)
	{
		printf("This is something wrong with ath ath_hal module\n");
		return 1;
	}
	/*check the ath_dev module*/
	module_status = check_module_status("ath_dev");

	if(module_status == 1)
	{
		printf("This is something wrong with ath ath_dev module\n");
		return 1;
	}
	/*check the ath_pci module*/
	module_status = check_module_status("ath_pci");

	if(module_status == 1)
	{
		printf("This is something wrong with ath ath_pci module\n");
		return 1;
	}
	/*check the wlan module*/
	module_status = check_module_status("wlan");

	if(module_status == 1)
	{
		printf("This is something wrong with ath wlan module\n");
		return 1;
	}

	/*check the exist of wifi interface*/
	exist_wifi = check_exist_wifi();
	
	if(exist_wifi == 0)
	{
		printf("This is something wrong with wifi interface \n");
		return 1;
	}
	
	/*check the num of wlan inteface,0 stands for not exist*/
	wlan_interface_num = check_wlan_interface_num();
	if(wlan_interface_num != 0)
	{
		/*stop wlan interface*/
		stop_wlan_interface(wlan_interface_num);	
	}

	return 0;
}

int input_tx99_type(void)
{
	int choice = 0;  
	char stdinBuff[1024];

input_type_again:
	printf("Please select the Tx99 Type:\n");
	printf("1:FRAME_DATA \t 2:SINGLE_CARRIER\n");
	scanf("%d",&choice);
	if(choice == 1)
	{
		tx99_parament.type = FRAME_DATA;
	}
	else if(choice == 2)
	{
		tx99_parament.type = SINGLE_CARRIER;
	}
	else
	{
		printf("you have enter a wrong choice!!!\n");
		fgets(stdinBuff, 1024, stdin);
		goto input_type_again;
	}
	
	return 0;
}

int input_tx99_txmode(void)
{
	int choice = 0;
	char stdinBuff[1024];

input_txmode_again:
	printf("Please select the Tx99 tx channel mode:\n");
	printf("1:MODE_11A \n 2:MODE_11NA_HT20 \n 3:MODE_11NA_HT40PLUS \n 4:MODE_11NA_HT40MINUS\n");
	scanf("%d",&choice);
	if(choice == 1)
	{
		tx99_parament.txmode = MODE_11A;
	}
	else if(choice == 2)
	{
		tx99_parament.txmode = MODE_11NA_HT20;
		tx99_parament.htmode = HT20;
	}
	else if(choice == 3)
	{
		tx99_parament.txmode = MODE_11NA_HT40PLUS;
		tx99_parament.htmode = HT40;
		tx99_parament.htext = HTEXTPLUS;
	}
	else if(choice == 4)
	{
		tx99_parament.txmode = MODE_11NA_HT40MINUS;
		tx99_parament.htmode = HT40;
		tx99_parament.htext = HTEXTMINUS;
	}
	else
	{
		printf("you have enter a wrong choice!!!\n");
		fgets(stdinBuff, 1024, stdin);
		goto input_txmode_again;
	}

	return 0;
}


int input_tx99_txpower(void)
{
	int value = 0;
	char stdinBuff[1024];

input_txpower_again:
	printf("Please enter the value of txpower(1-60):\n");
	scanf("%d",&value);
	if(value < 1 || value > 60)
	{
		printf("you have input a wrong value for txpower\n");
		fgets(stdinBuff, 1024, stdin);
		goto input_txpower_again;
	}
	else
	{
		tx99_parament.txpower = value;
	}

	return 0;
}

void txmode_11a_freq_printer(void)
{
	int i = 0;
	int freq_count = 11; 
	int freq = 2412;

	printf("Please select the 11a freqency(HZ)\n");\
	for(i = 1; i <= freq_count; i++)
	{
		printf("(%d):%d\n",i,(freq+(i-1)*5));
	}

}

void txmode_11na_ht20_freq_printer(void)
{
	int i = 0;
	int freq_count = 4;
	int freq = 5180;

	printf("Please select the 11na ht20 freqency(HZ)\n");\
	for(i = 1 ; i <= freq_count; i++)
	{
		printf("(%d):%d\n",i,(freq+(i-1)*20));
	}

	freq_count += 5;
	freq = 5745;
	for( ; i <= freq_count; i++)
	{
		printf("(%d):%d\n",i,(freq+(i-1)*20));
	}
}

void txmode_11na_ht40plus_freq_printer(void)
{
	int i = 0;
	int freq_count = 2;
	int freq = 5180;

	printf("Please select the 11na ht40 plus freqency(HZ)\n");\
	for(i = 1 ; i <= freq_count; i++)
	{
		printf("(%d):%d\n",i,(freq+(i-1)*40));
	}

	freq_count += 2;
	freq = 5745;
	for( ; i <= freq_count; i++)
	{
		printf("(%d):%d\n",i,(freq+(i-1)*40));
	}

}

void txmode_11na_ht40minus_freq_printer(void)
{	
	int i = 0;
	int freq_count = 2;
	int freq = 5220;

	printf("Please select the 11na ht40 minus freqency(HZ)\n");\
	for(i = 1 ; i <= freq_count; i++)
	{
		printf("(%d):%d\n",i,(freq+(i-1)*40));
	}

	freq_count += 2;
	freq = 5765;
	for( ; i <= freq_count; i++)
	{
		printf("(%d):%d\n",i,(freq+(i-1)*40));
	}
		
}

static void channel_list(unsigned int  *pChannelsNum,unsigned int *pChannels)
{
	FILE *pp = NULL;
	char *szLine = NULL;
	int  size = 0;
	
	szLine = malloc(256 * sizeof(char));
	if (szLine == NULL)
		goto _end;
	pp = popen("iwlist ath0 channel", "r");
	if (pp == NULL)
		goto _end;

	pChannels[0] == 0; //for debug_country	
	*pChannelsNum = 0;			

	getline(&szLine, &size, pp);		// skip first line
	while(-1 != getline(&szLine, &size, pp))
	{
		unsigned int ulChann = 0;
		char *p = strstr(szLine, "Channel");
		if (p != NULL && strstr(p, ":") != NULL)
		{
			ulChann = atoi(p + strlen("Channel"));

			switch(tx99_parament.txmode)
			{
				case MODE_11A:
				case MODE_11NA_HT20:
				break;
				case MODE_11NA_HT40PLUS:
				case MODE_11NA_HT40MINUS:
				{
					if(pChannels[0] == 5180) //for debug_country
						break;
					switch(ulChann)
					{
						case 116:
						case 140:
						case 165:
						case 147:
						case 151:
						case 155:
						case 163:
						case 167:
						case 171:
							continue;
						default:
							break;
					}
				}
				break;
			}

			ulChann = 5000 + ulChann*5;
			{		
					pChannels[(*pChannelsNum)++] = ulChann;	
					printf("(%d):%d\n",*pChannelsNum,ulChann);
			}
		}
	}
_end:
	if (szLine != NULL)
		free(szLine);
	if (pp != NULL)
		pclose(pp);
}


int input_tx99_txfreq(void)
{
	/*Mayby we should consider the country code refelect*/
	int choice = 0;
	unsigned int freq_num = 0;
	unsigned int channels[64];
	char stdinBuff[1024];
	
input_txfreq_again:
	printf("Please select the value of txfreq:\n");

	channel_list(&freq_num,channels);
	scanf("%d",&choice);
	if((choice>freq_num)||(choice==0))
	{
		printf("You have enter a wrong choice!!!\n");
		fgets(stdinBuff, 1024, stdin);
		goto input_txfreq_again;
	}
	else
	{
		tx99_parament.txfreq = channels[choice-1];
	}

	return 0;
}


unsigned int txmode_txrate_printer(void)
{
	unsigned char rate_index = 0,ratel_count =0;
	switch(tx99_parament.txmode)
	{
		case MODE_11A:
			ratel_count = sizeof(s_11a_Rates)/sizeof(ExchangeEnumInfo_t);
			printf("Please select the value of tx rate for 11a(KB):\n");
			for(rate_index = 0;rate_index< ratel_count;rate_index++)
			{
				printf("%d:%s \n",rate_index + 1,s_11a_Rates[rate_index].szName);
			}
		break;
		case MODE_11NA_HT20:
			ratel_count = sizeof(s_11n_Rates_noGI)/sizeof(ExchangeEnumInfo_t);
			printf("Please select the value of tx rate for ht20 11na(M):\n");
			for(rate_index = 0;rate_index< ratel_count;rate_index++)
			{
				printf("%d:%s \n",rate_index + 1,s_11n_Rates_noGI[rate_index].szName);
			}
		break;
		case MODE_11NA_HT40PLUS:
		case MODE_11NA_HT40MINUS:
			ratel_count = sizeof(s_11n_Rates_noGI)/sizeof(ExchangeEnumInfo_t);
			printf("Please select the value of tx rate for ht40 mode(M):\n");
			for(rate_index = 0;rate_index< ratel_count;rate_index++)
			{
				printf("%d:%s \n",rate_index + 1,s_11n_Rates_noGI[rate_index].szName);
			}
		break;
	}
	return ratel_count;

}

int input_tx99_txrate(void)
{
	int choice = 0;
	char stdinBuff[1024];
	unsigned int rate_count;

	printf("Please select the value of txrate:\n");
input_txrate_again:
	rate_count = txmode_txrate_printer();
	if(tx99_parament.txmode == MODE_11A)
	{
		scanf("%d",&choice);
		if((choice>rate_count)||(choice==0))
		{
			printf("You have enter a wrong number,do it again!\n");
				fgets(stdinBuff, 1024, stdin);
				goto input_txrate_again;
		}
		else
		{
			tx99_parament.txrate = s_11a_Rates[choice - 1].ulValue;
		}	
	}
	else if(tx99_parament.txmode == MODE_11NA_HT20)
	{
		scanf("%d",&choice);

		if((choice>rate_count)||(choice==0))
		{
			printf("You have enter a wrong number,do it again!\n");
				fgets(stdinBuff, 1024, stdin);
				goto input_txrate_again;
		}
		else
		{
			tx99_parament.txrate = s_11n_Rates_noGI[choice - 1].ulValue;
		}	
	}
	else if(tx99_parament.txmode == MODE_11NA_HT40PLUS || 
		tx99_parament.txmode == MODE_11NA_HT40MINUS )
	{
		scanf("%d",&choice);

		if((choice>rate_count)||(choice==0))
		{
			printf("You have enter a wrong number,do it again!\n");
				fgets(stdinBuff, 1024, stdin);
				goto input_txrate_again;
		}
		else
		{
			tx99_parament.txrate = s_11n_Rates_noGI[choice - 1].ulValue;
		}	
	}
	else
	{
		perror("It is wrong tx mode");
		exit(1);
	}

}

int user_input(void)
{
	input_tx99_type();
	input_tx99_txmode();
	input_tx99_txpower();
	input_tx99_txfreq();
	input_tx99_txrate();
	return 0;
}

int tx99_setup(void)
{
	char cmd[MAX_COMMAND_LINE_SIZE];

	/*load the tx99 module*/
	system("insmod /lib/modules/2.6.15/net/ath_tx99.ko device=wifi0");

	/*tx99 type setup*/	
	memset(cmd,0,MAX_COMMAND_LINE_SIZE);
	//sprintf(cmd,"echo %d > %s",tx99_parament.type,PROC_TX99_TYPE_PATH);
	sprintf(cmd,"echo %d",tx99_parament.type);
	strcat(cmd," > /proc/sys/dev/wifi0/tx99type");
	//printf("cmd:%s--%d\n",cmd,__LINE__);
	system(cmd);

	/*tx99 txmode setup*/	
	memset(cmd,0,MAX_COMMAND_LINE_SIZE);	
	sprintf(cmd,"echo %d",tx99_parament.txmode);
	strcat(cmd," > /proc/sys/dev/wifi0/tx99txmode");
	printf("cmd:%s--%d\n",cmd,__LINE__);
	system(cmd);

	/*tx99 txrate setup*/	
	memset(cmd,0,MAX_COMMAND_LINE_SIZE);
	sprintf(cmd,"echo %d",tx99_parament.txrate);
	strcat(cmd, " > /proc/sys/dev/wifi0/tx99rate");
	printf("cmd:%s--%d\n",cmd,__LINE__);
	system(cmd);

	/*tx99 txfreq setup*/	
	memset(cmd,0,MAX_COMMAND_LINE_SIZE);
	sprintf(cmd,"echo %d",tx99_parament.txfreq);
	strcat(cmd, " > /proc/sys/dev/wifi0/tx99freq");
	printf("cmd:%s--%d\n",cmd,__LINE__);
	system(cmd);

	/*tx99 txpower setup*/	
	memset(cmd,0,MAX_COMMAND_LINE_SIZE);
	sprintf(cmd,"echo %d",tx99_parament.txpower);
	strcat(cmd, " > /proc/sys/dev/wifi0/tx99power");
	printf("cmd:%s--%d\n",cmd,__LINE__);
	system(cmd);

	/*tx99 recv setup*/	
	memset(cmd,0,MAX_COMMAND_LINE_SIZE);
	sprintf(cmd,"echo %d",tx99_parament.recv);
	strcat(cmd, " > /proc/sys/dev/wifi0/tx99recv");
	printf("cmd:%s--%d\n",cmd,__LINE__);
	system(cmd);

	return 0;
}

int tx99_start(void)
{
	/*start the tx99 by active the wifi interface*/	
	system("ifconfig wifi0 up");
 	return 0;
}

int tx99_stop(void)
{

	system("rmmod /lib/modules/2.6.15/net/ath_tx99.ko");
	system("ifconfig wifi0 down");
	return 0;
}
void banner_printer(void)
{
	printf("*******************************************************\n");
	printf("      welcome to use the tx99 testing \n");
	printf("The process is checking the running enviroment,\n \
		then accepting the user's input and setup the tx99,\n \
		finally,start tx99 and stop it when you need \n");
	printf("*******************************************************\n");
}



int main(int argc, char **argv)
{
	int choice = 1;
	char cmd[MAX_COMMAND_LINE_SIZE];
	char stdinBuff[1024];

	memset(cmd,0,MAX_COMMAND_LINE_SIZE);
	banner_printer();
	if(check_current_env() == 0)
	{
		printf("Check the enviroment success!!!\n");	
	}
	else
	{
		printf("Check the enviroment failed!!!\n");	
		/*Maybe we should do something to meet the need of tx99*/
		return;
	}

	tx99_stop(); //initial
	user_input();
	tx99_setup();
	tx99_start();

input_choice_again:
		printf("Please select:\n");
		printf("1:Active the RX99\n");
		printf("2:Dective the RX99\n");
		printf("3:Stop the Tx99\n");
		scanf("%d",&choice);
		
		if(choice == 1)
		{
			if(tx99_parament.recv == 1)
			{
				printf("The RX99 has been actived \n");
			}
			else
			{
				printf("Start to active the RX99\n");
				tx99_parament.recv = 1;
				memset(cmd,0,MAX_COMMAND_LINE_SIZE);
				sprintf(cmd,"echo %d",tx99_parament.recv);
				strcat(cmd, " > /proc/sys/dev/wifi0/tx99recv");
				printf("cmd:%s--%d\n",cmd,__LINE__);
				system(cmd);

			}
			goto input_choice_again;
		}
		else if(choice == 2)
		{
			if(tx99_parament.recv == 0)
			{
				printf("The RX99 has been stop \n");
			}
			else
			{
				printf("Start to stop the RX99\n");
				tx99_parament.recv = 0;
				memset(cmd,0,MAX_COMMAND_LINE_SIZE);
				sprintf(cmd,"echo %d",tx99_parament.recv);
				strcat(cmd, " > /proc/sys/dev/wifi0/tx99recv");
				printf("cmd:%s--%d\n",cmd,__LINE__);
				system(cmd);
			}
			goto input_choice_again;

		}
		else if(choice == 3)
		{
			tx99_stop();
			system("ifconfig wifi0 up");
		}
		else
		{
			printf("You have enter a wrong choice\n");
			fgets(stdinBuff, 1024, stdin);
			goto input_choice_again;
		}

	return 0;
}

