#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include "wag302client.h"

//#define SYSLOG_PORT_NUM		514
#define SYSLOG_FILE_PATH	"/proc/syslog"
//#define SYSLOG_SERVER_IP	"192.168.230.52"
#define SYSLOG_PERIOD		20

static int Daemon_Init(void)
{
	int devnullfd;
	chdir ("/");
	switch (fork() )
	{
	case -1:
		printf("Daemon_Init: error in fork\r\n");
		exit(1);
	case 0: /** Child **/
		break;
	default:
		/** Parent **/
		exit(0);
	}
	if ( setsid() == -1 )
	{
		printf("Daemon_Init: setsid error\r\n");
		exit(1);
	}
	
	devnullfd = open("/dev/null", O_RDWR);
	if ( devnullfd == -1 )
	{
		printf("Null device open failed\r\n");
		return 1;
	}
	close(0);
	close(1);
	close(2);
	
	dup2(devnullfd, 0);
	dup2(devnullfd, 1);
	dup2(devnullfd, 2);
	close(devnullfd);
	return 0;
}

static void watchdog_SigHandler(int lSigNum)
{
	switch(lSigNum)
	{
	case SIGHUP:
	case SIGINT:
	case SIGTERM:
	case SIGPIPE:
		return; /* Ignore */
		
	case SIGBUS:
	case SIGQUIT:
	case SIGABRT:
	case SIGSEGV:
		sleep(1);
		return ;
	}
}


static void watchdog_RegSigHandler(void)
{
	signal(SIGBUS , watchdog_SigHandler);
	signal(SIGINT , watchdog_SigHandler);
	signal(SIGQUIT, watchdog_SigHandler);
	signal(SIGILL , watchdog_SigHandler);
	signal(SIGABRT, watchdog_SigHandler);
	signal(SIGSEGV, watchdog_SigHandler);
	signal(SIGCHLD, watchdog_SigHandler);
	signal(SIGHUP , watchdog_SigHandler);
	signal(SIGTERM, watchdog_SigHandler);
	signal(SIGPIPE, watchdog_SigHandler);
}

int main(int argc, char *argv[])
{
	FILE *fd;
	int sockfd,newLine=0;
	char line[255],pivot[255];
	struct sockaddr_in remote;
	
	Daemon_Init();
	
	watchdog_RegSigHandler();
	
	memset(pivot,0,sizeof(pivot));
	while(1)
	{
		if ((fd=fopen(SYSLOG_FILE_PATH,"rb")) != NULL)
		{
			if ((sockfd = socket (AF_INET, SOCK_DGRAM, 0)) != -1) 
			{
				char szIP[20];
				uint32_t ulPort;

				remote.sin_family = AF_INET;
				CONF_READ_STRING0(MIB_SYSLOG_SERVER_IP, szIP);
				remote.sin_addr.s_addr = inet_addr(szIP);
				ConfigReadInteger(0, MIB_SYSLOG_SERVER_PORT, &ulPort);
				remote.sin_port = htons(ulPort);
				
				newLine=0;
				while (fgets(line,sizeof(line),fd)!= NULL)
				{
					if (newLine || !strlen(pivot))
					{
						sendto(sockfd, line, strlen(line), 0,
							(struct sockaddr *) &remote, sizeof(remote));
						strcpy(pivot,line);
					}
					
					if (!strcmp(line,pivot))
						newLine=1;
				}
				close(sockfd);
				
				//Cannot find the last record sent to remote server at last time.
				//Next time, we will begin in the front of log file.
				if (newLine == 0)
					memset(pivot,0,sizeof(pivot));
			}
			else
				printf("socket can not be opened!\n");
			
			fclose(fd);
		}
		else
			printf("file can not be opened!\n");
		
		sleep(SYSLOG_PERIOD);
	}
	
	return 0;
}

