// zcom_snmp.h
//

//#define	_DEBUG

#ifndef	__ZCOM_SNMP_H__
#define	__ZCOM_SNMP_H__

#include <stdint.h>

//#include "config.h"
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/library/callback.h>
#include <net-snmp/agent/snmp_agent.h>

#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_WINSOCK_H
#include <winsock.h>
#endif

#include "mibincl.h"

#include "wag302client.h"
#include "wag302def.h"
#define	TABLE_COUNT(TABLE)	(sizeof(TABLE)/sizeof(TABLE[0]))

///////////////////////////////////////////////////////////////////////////////
// debug routines
///////////////////////////////////////////////////////////////////////////////
#ifdef	_DEBUG
static const char *s_cszWriteAction[] =
{
	"RESERVE1", "RESERVE2", "ACTION", "COMMIT", "FREE", "UNDO",
	"Unknown6", "Unknown7", "Unknown8",
	"FINISHED_SUCCESS", "FINISHED_FAILURE"
};

static void OidTrace(const char *cszPrefix, oid *name, size_t length)
{
	size_t	i = 0;
	if (NULL!=cszPrefix)
	{
		printf(cszPrefix);
	}
	printf("%ld", name[6]);
	for (i=7; i<length; i++)
	{
		printf(".%ld", name[i]);
	}
	printf(" \n");
}

static void HexTrace(const char *cszPrefix, uint8_t *pData, size_t length)
{
	size_t	i = 0;
	if (NULL!=cszPrefix)
	{
		printf(cszPrefix);
	}
	printf("@%p(%dbytes):", pData, length);
	for (i=0; i<length; i++)
	{
		printf("%02x ", pData[i]);
	}
}
#endif//_DEBUG
extern int current_vap_index;

typedef struct acl_entry 
{	
	MacAddr_t macFilter;	
	uint32_t selectid;
} ACL_t, *ACL_tp;

///////////////////////////////////////////////////////////////////////////////
// Z-Com Converter routines
///////////////////////////////////////////////////////////////////////////////
in_addr_t StrSwitchIP(const char *cszIP);
bool_t checkIPSubnet(in_addr_t srcip, in_addr_t srcmask, in_addr_t desip,in_addr_t desmask);
void InitNBZCN1523(void);
void init_ieee802dot11(void);
///////////////////////////////////////////////////////////////////////////////
// Z-Com Oid Info definition
///////////////////////////////////////////////////////////////////////////////

typedef	struct	ZComOidInfo_t
{
	// ucd-snmp common info
	uint8_t			uchMagic;	// passed to function as a hint
	const char		type;		// type of variable, See important comment
								// in snmp_vars.c relating to acl
	const uint16_t	acl;		// access control list for variable
	FindVarMethod	*findVar;	// function that finds variable
	uint8_t			namelen;	// length of below
#define	ZCOM_OID_LEN_MAX	8
	oid				name[ZCOM_OID_LEN_MAX];	
								// object identifier of variable

	// Z-Com private Info
	int				(*ZComOidAccess)(
						struct ZComOidInfo_t	*pOidInfo,
						void		**ppVar,	//Read:NULL==*ppVar
						size_t		*pVarLen,
						oid			*pOid,		// table index
						size_t		OidLen		// table index len
						);
	const uint32_t	ulMIB;
	uint8_t	uchIndex;		// Fixed Index
	const uint8_t	uchSubOidLen;	// Default 0,
	ExchangeFieldType_t	FieldType;	// Auto update by ZComOidAccess
} ZComOidInfo_t;

typedef	enum ZComOidTreeInfo_t
{
	ZCOM_OID_NODE_FIXED =0,
	ZCOM_OID_NODE_CONTINUE,
	ZCOM_OID_NODE_SKIP,
	ZCOM_OID_SUB_BEGIN,
	ZCOM_OID_SUB_END
} ZComOidTreeInfo_t;

bool_t	ZComOidInfoInit(
	ZComOidInfo_t	*pOidInfo,
	uint32_t		ulCount,
	FindVarMethod	*FindMethod
	);

#define	ZCOM_OID_INFO(INDEX, MIB, TYPE, ACL, TAB_SUB, ACCESS, TREE, OIDS...)	\
	{0, TYPE, ACL, NULL, TREE, {OIDS}, ACCESS, MIB, INDEX, TAB_SUB}

#define	ZCOM_OID_FIX_INFO(INDEX, MIB, TYPE, ACL, TAB_SUB, ACCESS, OIDS...)	\
	{0, TYPE, ACL, NULL, ZCOM_OID_NODE_FIXED, {OIDS}, \
		ACCESS, MIB, INDEX, TAB_SUB}

#define	ZCOM_OID_CONTINUE_INFO(INDEX, MIB, TYPE, ACL, TAB_SUB, ACCESS)	\
	{0, TYPE, ACL, NULL, ZCOM_OID_NODE_CONTINUE, {0}, \
		ACCESS, MIB, INDEX, TAB_SUB}

#define	ZCOM_OID_SKIP_INFO(INDEX, MIB, TYPE, ACL, TAB_SUB, ACCESS, OIDS...)	\
	{0, TYPE, ACL, NULL, ZCOM_OID_NODE_SKIP, {OIDS}, \
		ACCESS, MIB, INDEX, TAB_SUB}

#define	ZCOM_OID_SUB_BEGIN_INFO(INDEX, MIB, TYPE, ACL, TAB_SUB, ACCESS, SUBOIDS...)	\
	{0, TYPE, ACL, NULL, ZCOM_OID_SUB_BEGIN, {SUBOIDS}, \
		ACCESS, MIB, INDEX, TAB_SUB}

#define	ZCOM_OID_SUB_END_INFO(INDEX, MIB, TYPE, ACL, TAB_SUB, ACCESS, DEC_DEPTH)	\
	{0, TYPE, ACL, NULL, ZCOM_OID_SUB_END, {DEC_DEPTH}, \
		ACCESS, MIB, INDEX, TAB_SUB}

///////////////////////////////////////////////////////////////////////////////
// Z-Com Oid Access routines
///////////////////////////////////////////////////////////////////////////////

#define	ZCOM_OID_ACCESS_DEFINE(_OID_ACCESS_)	\
int	_OID_ACCESS_(								\
	ZComOidInfo_t	*pOidInfo,					\
	void			**ppVar,					\
	size_t			*pVarLen,					\
	oid				*pOid,						\
	size_t			OidLen						\
	)

#define	ZCOM_OID_ACCESS_PARAM		pOidInfo, ppVar, pVarLen, pOid, OidLen

typedef	ZCOM_OID_ACCESS_DEFINE(ZComOidAccess_t);
ZComOidAccess_t ZComOidAccessKeyType;
ZComOidAccess_t ZComOidAccessVapIndex;
ZComOidAccess_t ZComOidAccessVlanID;
ZComOidAccess_t	ZComOidAccessResetAP;
ZComOidAccess_t	ZComOidAccessACL;
ZComOidAccess_t	ZComOidAccessGeneric;
ZComOidAccess_t	ZComOidAccessBoolean;
ZComOidAccess_t	ZComOidAccessIPAddress;
ZComOidAccess_t	ZComOidAccessMacAddress;

ZComOidAccess_t	ZComOidAccessMultiGeneric;
ZComOidAccess_t	ZComOidAccessMultiBoolean;
ZComOidAccess_t	ZComOidAccessMultiIPAddress;
ZComOidAccess_t	ZComOidAccessMultiMacAddress;

#endif//!__ZCOM_SNMP_H__
