// zcom_snmp.c
//

#include "zcom_snmp.h"
#include "netinet/in.h"

///////////////////////////////////////////////////////////////////////////////
// Z-Com Converter routines
///////////////////////////////////////////////////////////////////////////////
static int ISMultiVapMIB(int mib) 
{
	if (mib == MIB_WLAN_VAP_ENABLE || mib == MIB_WLAN_PRONAME || \
	    mib == MIB_WLAN_SSID || mib == MIB_WLAN_SSID_SUPPRESS ||	\
	    mib == MIB_WLAN_VAP_VLAN_PARAM || mib == MIB_WLAN_WIRELESS_ISOLATION || \
	    mib == MIB_WLAN_WMM || mib == MIB_WLAN_AUTHENTICATION  || \
	    mib == MIB_WLAN_ENCRYPTION || mib == MIB_WPA_PSK || \
	    mib == MIB_WLAN_MAX_STATION_NUM || mib == MIB_WLAN_STA_NUM_LMT) {
		return 1;
	} else {
		return 0;
	}
}
in_addr_t StrSwitchIP(const char *cszIP)
{
	in_addr_t ulIP;
	int SLen = strlen(cszIP);

	ulIP = INADDR_NONE;
	if ( 15 >= SLen && 7 <= SLen ) {
		ulIP = inet_addr(cszIP);
	}

	return ulIP;
}

bool_t checkIPSubnet(in_addr_t srcip, in_addr_t srcmask, in_addr_t desip,in_addr_t desmask)
{
	if ((srcip & srcmask) != (desip & desmask))
		return TRUE;
	else
	{
			//console_printf("Warn:LAN(Bridge) and WAN can not in same subnet.Please modify LAN(Bridge) IP.\n");
		return FALSE;
	}
}

typedef struct wdsfilter_entry 
{	
	MacAddr_t macFilter;	
	uint32_t mode;
} WDS_T, *WDS_Tp;

///////////////////////////////////////////////////////////////////////////////
// Z-Com SNMP register routines
///////////////////////////////////////////////////////////////////////////////
void	InitZComSnmp(void)
{	
	InitNBZCN1523();
	init_ieee802dot11();
}

static uint8_t	ZComOidLen(oid *pOid)
{
	int	iLen = 0;
	for (iLen=ZCOM_OID_LEN_MAX-1; iLen>=0; iLen--)
	{
		if (0!=pOid[iLen])
		{
			return iLen+1;
		}
	}
	return 0;
}

static void ZComOidCopy(oid *pDest, oid *pSrc)
{
	memcpy(pDest, pSrc, sizeof(oid)*ZCOM_OID_LEN_MAX);
}

bool_t	ZComOidInfoInit(
	ZComOidInfo_t	*pOidInfo,
	uint32_t		ulCount,
	FindVarMethod	*FindMethod
	)
{
	uint8_t	uchMagic = 0;
	oid		Oids[ZCOM_OID_LEN_MAX] = {0};
	uint8_t	uchOidLen = 0;
	uint8_t	uchOidIndex = 0;
	uint8_t	uchSkipOidLen = 0;
	uint8_t	uchSubOidLen = 0;

	if (NULL==pOidInfo || 0==ulCount)
	{
		return FALSE;
	}
	while (ulCount-->0)
	{
		if (0==uchOidLen && ZCOM_OID_NODE_FIXED!=pOidInfo->namelen)
		{
			return FALSE;
		}
		switch(pOidInfo->namelen)	//ZComOidTreeInfo_t
		{
		case ZCOM_OID_NODE_FIXED:
			uchOidLen = ZComOidLen(pOidInfo->name);
			if (0==uchOidLen)
			{
				return FALSE;
			}
			ZComOidCopy(Oids, pOidInfo->name);
			pOidInfo->namelen = uchOidLen;
			break;
		case ZCOM_OID_NODE_CONTINUE:
			Oids[uchOidLen-1]++;
			ZComOidCopy(pOidInfo->name, Oids);
			pOidInfo->namelen = uchOidLen;
			break;
		case ZCOM_OID_NODE_SKIP:
			uchSkipOidLen = ZComOidLen(pOidInfo->name);
			if (uchSkipOidLen>uchOidLen)
			{
				return FALSE;
			}
			for (uchOidIndex=0; uchOidIndex<uchSkipOidLen; uchOidIndex++)
			{
				Oids[uchOidLen-uchSkipOidLen+uchOidIndex] 
					+= pOidInfo->name[uchOidIndex];
			}
			ZComOidCopy(pOidInfo->name, Oids);
			pOidInfo->namelen = uchOidLen;
			break;
		case ZCOM_OID_SUB_BEGIN:
			Oids[uchOidLen-1]++;
			uchSubOidLen = ZComOidLen(pOidInfo->name);
			if (0==uchSubOidLen || uchSubOidLen+uchOidLen>=ZCOM_OID_LEN_MAX)
			{
				return FALSE;
			}
			for (uchOidIndex=0; uchOidIndex<uchSubOidLen; uchOidIndex++)
			{
				Oids[uchOidLen+uchOidIndex] = pOidInfo->name[uchOidIndex];
			}
			uchOidLen += uchSubOidLen;
			ZComOidCopy(pOidInfo->name, Oids);
			pOidInfo->namelen = uchOidLen;
			break;
		case ZCOM_OID_SUB_END:
			uchSubOidLen = pOidInfo->name[0];
			if (0==uchSubOidLen || uchSubOidLen>=uchOidLen)
			{
				return FALSE;
			}			
			Oids[uchOidLen-1]++;
			ZComOidCopy(pOidInfo->name, Oids);
			pOidInfo->namelen = uchOidLen;
			uchOidLen -= uchSubOidLen;
			break;
		default:
			return FALSE;
		}
		pOidInfo->uchMagic = ++uchMagic;
		pOidInfo->findVar = FindMethod;
		pOidInfo++;
	}
	return TRUE;
}

///////////////////////////////////////////////////////////////////////////////
// Z-Com Oid Access routines
///////////////////////////////////////////////////////////////////////////////
static const ExchangeFieldInfo_t* GetFieldInfo(
	const uint8_t	uchIndex,
	const uint32_t	ulMIB
	)
{
	static uint32_t Buf[MAX_EXCHANGE_SIZE/sizeof(uint32_t)];
	static ExchangeFieldInfo_t *pFieldInfo = (ExchangeFieldInfo_t *)Buf;
	if (CONF_RESULT_OK!=ConfigRequestFieldInfo(uchIndex, ulMIB, (uint8_t*)pFieldInfo, sizeof(Buf)))
	{
		printf("%s: GetFieldInfo Fail idx=%d, MIB=%d  (MIB_FIRMWARE_VERSION=%d)!\n", __FUNCTION__, uchIndex, ulMIB, MIB_FIRMWARE_VERSION);
		pFieldInfo->ulFieldType = CONF_FIELD_UNKNOWN;
	}
	return pFieldInfo;
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessGeneric)
{
	static char	szOidVar[MAX_EXCHANGE_SIZE] = {0};
	int32_t 		iRet = 0;
	static uint32_t	scan_tablen = 0;
	static uint8_t	scan_buff[MAX_EXCHANGE_SIZE] = {0};
	ExchangeResult_t result;
	uint8_t		uchIndex = pOidInfo->uchIndex;
	if (ISMultiVapMIB(pOidInfo->ulMIB)) {    //MIB is a MULTI VAP option
		uchIndex = current_vap_index - 1;
	}
	if ( MIB_WLAN_REMOTE_AP == pOidInfo->ulMIB){
		pOidInfo->FieldType = CONF_FIELD_STRING;
	}
	
	if (CONF_FIELD_UNKNOWN==pOidInfo->FieldType)
	{
		const ExchangeFieldInfo_t	*pFieldInfo
			= GetFieldInfo(uchIndex, pOidInfo->ulMIB);
		if (NULL!=pFieldInfo)
		{
			pOidInfo->FieldType = pFieldInfo->ulFieldType;
		}
	}

	if (CONF_FIELD_UNKNOWN==pOidInfo->FieldType)
	{		
		return SNMP_ERR_COMMITFAILED;
	}
	//Oid Read

	if (NULL==*ppVar)
	{
		if (pOidInfo->ulMIB == MIB_WLAN_AP_LIST)
		{
			uint32_t ulOpMode = 0;
			ConfigReadInteger(0, MIB_WLAN_OPERATION_MODE, &ulOpMode);
			if (ulOpMode != 1) goto do_error_process;
			
			if ((pOidInfo->name[3] == 1) && (pOid[0] == 1))
			{
				goto do_normal_process;
			}
			else if (!scan_tablen)
			{
				do_error_process:
				
				return SNMP_ERR_NOERROR;
			}
			else if (scan_tablen)
			{
				memcpy(szOidVar, scan_buff, scan_tablen*sizeof(ApScanList_t));
				*pVarLen = scan_tablen * sizeof(ApScanList_t);
				*ppVar = szOidVar;

				return SNMP_ERR_NOERROR;
			}
		}
		else if(MIB_TIME == pOidInfo->ulMIB){
			struct tm * tm_time;
			time_t current_secs;
			uint32_t val = 0;
			char timebuff[32]={0};

			time(&current_secs);
			tm_time = localtime(&current_secs);
			sprintf(timebuff,"%d-%d-%d-%d:%d:%d",tm_time->tm_year + 1900,
				tm_time->tm_mon + 1,tm_time->tm_mday,tm_time->tm_hour,
				tm_time->tm_min, tm_time->tm_sec);
			
			memcpy(szOidVar, timebuff, strlen(timebuff));
			*pVarLen = strlen(timebuff);
			*ppVar = szOidVar;
			
			return SNMP_ERR_NOERROR;
			
		}
		/*#8422*/
		else if (MIB_WLAN_CHANNEL  == pOidInfo->ulMIB){			
			uint32_t curchan=0,stachan=0;
			ConfigReadInteger(0, MIB_WLAN_CHANNEL, &curchan);
			ConfigReadInteger(0, MIB_WLAN_CHANNEL_STATUS, &stachan);
			if (curchan != stachan){	//auto channel
				(*pVarLen) = sizeof(uint32_t);
				uint32_t tmp = 0;
				*ppVar = &tmp;							
				return SNMP_ERR_NOERROR;
			}
			else
				goto do_normal_process;				
		}
		else	{
			do_normal_process:
			memset(szOidVar, 0, MAX_EXCHANGE_SIZE);
			if (MIB_WLAN_REMOTE_AP == pOidInfo->ulMIB){
				WDS_T wdsEntry;
				iRet = ConfigExchange(CONF_REQUEST_READ, uchIndex, pOidInfo->ulMIB, (uint8_t *)&wdsEntry, 0, sizeof(wdsEntry));
				sprintf(szOidVar, "%02x:%02x:%02x:%02x:%02x:%02x", 
					(wdsEntry.macFilter[0]&0x000000ff), (wdsEntry.macFilter[1]&0x000000ff), (wdsEntry.macFilter[2]&0x000000ff),
					(wdsEntry.macFilter[3]&0x000000ff), (wdsEntry.macFilter[4]&0x000000ff), (wdsEntry.macFilter[5]&0x000000ff));
			}else{			
				iRet = ConfigExchange(CONF_REQUEST_READ, uchIndex, pOidInfo->ulMIB, szOidVar, 0, sizeof(szOidVar));
			}
			if (CONF_RESULT_OK==iRet)
			{
				*pVarLen = GetLastExchangeResponse(pOidInfo->ulMIB, NULL, 0, 0);
				if (CONF_FIELD_STRING==pOidInfo->FieldType)
				{
					if (MIB_WLAN_REMOTE_AP == pOidInfo->ulMIB)
						(*pVarLen)= strlen(szOidVar)-1;
					else
						(*pVarLen)--;
				}
				*ppVar = szOidVar;
				return SNMP_ERR_NOERROR;
			}			
			return SNMP_ERR_GENERR;
		}
	}
	// Oid Write	
	if ((current_vap_index == 1)&&(pOidInfo->ulMIB == MIB_WLAN_VAP_ENABLE))
		return SNMP_ERR_READONLY;
	
	if ((MIB_IPFILTER_CLI_SNMP_DEL == pOidInfo->ulMIB)||(MIB_DSTIPFILTER_CLI_SNMP_DEL == pOidInfo->ulMIB)||(MIB_SRC_PORTFILTER_CLI_SNMP_DEL == pOidInfo->ulMIB)
		||(MIB_PORTFILTER_CLI_SNMP_DEL == pOidInfo->ulMIB)||(MIB_PORTFW_CLI_SNMP_DEL == pOidInfo->ulMIB)){
		int32_t ulRuleNum;
		switch (pOidInfo->ulMIB){
		case MIB_IPFILTER_CLI_SNMP_DEL:
			ConfigReadInteger(0, MIB_IPFILTER_NUM, &ulRuleNum);
			break;
		case MIB_DSTIPFILTER_CLI_SNMP_DEL:
			ConfigReadInteger(0, MIB_DSTIPFILTER_NUM, &ulRuleNum);
			break;
		case MIB_SRC_PORTFILTER_CLI_SNMP_DEL:
			ConfigReadInteger(0, MIB_SRC_PORTFILTER_NUM, &ulRuleNum);
			break;
		case MIB_PORTFILTER_CLI_SNMP_DEL:
			ConfigReadInteger(0, MIB_PORTFILTER_NUM, &ulRuleNum);
			break;
		case MIB_PORTFW_CLI_SNMP_DEL:
			ConfigReadInteger(0, MIB_PORTFW_NUM, &ulRuleNum);
			break;
		default:
			return SNMP_ERR_GENERR;
		}		
		if (*((int32_t*)*ppVar)>ulRuleNum)
			return SNMP_ERR_BADVALUE;
	}

	if ((pOidInfo->ulMIB == MIB_WLAN_PRONAME)&&(*pVarLen > 32))	return SNMP_ERR_BADVALUE;	//#8741			
	if ((pOidInfo->ulMIB == MIB_CHANNEL_MODE)&&(*((int32_t*)*ppVar)==2)){		//#8743
		uint32_t ulWirelessMode;
		ConfigReadInteger(0, MIB_WLAN_WIRELESS_MODE, &ulWirelessMode);
		if ((ulWirelessMode == WIRELESS_MODE_AUTO)||(ulWirelessMode == WIRELESS_MODE_11A)) return SNMP_ERR_BADVALUE;
	}
	if ((pOidInfo->ulMIB == MIB_ROUTE_MODE)&&(*((int32_t*)*ppVar)==2)){		//#8748
		uint32_t opmode;
		ConfigReadInteger(0, MIB_WLAN_OPERATION_MODE, &opmode);
		if (opmode == WLAN_OPERATION_AP)	return SNMP_ERR_BADVALUE;
	}	
#ifdef _ZCOM_DHCP_RELAY_
	if (pOidInfo->ulMIB == MIB_DHCP_RELAY_DAEMON){								//#8744
		int dhcpd_enabled;
		ConfigReadInteger(0, MIB_DHCPS_DAEMON, &dhcpd_enabled);
		if ((dhcpd_enabled)&&(*((int32_t*)*ppVar)))	return SNMP_ERR_BADVALUE;
	}
#endif
	
	if (CONF_FIELD_STRING==pOidInfo->FieldType)
	{
		((uint8_t*)(*ppVar))[*pVarLen] = 0;
		(*pVarLen)++;
	} 	
	if (MIB_WLAN_REMOTE_AP == pOidInfo->ulMIB){
		WDS_T wdsEntry;
		
		*pVarLen = sizeof(WDS_T);
		ConfigReadStruct(uchIndex, MIB_WLAN_REMOTE_AP, (uint8_t *)&wdsEntry,sizeof(wdsEntry));
		Str2Mac(wdsEntry.macFilter, *ppVar);
		result = ConfigExchange(CONF_REQUEST_WRITE, uchIndex,
			pOidInfo->ulMIB, (uint8_t *)&wdsEntry, *pVarLen, 0);
	}else{
		result = ConfigExchange(CONF_REQUEST_WRITE, uchIndex,
			pOidInfo->ulMIB, *ppVar, *pVarLen, 0);
	}	
	if (MIB_WEP_KEY_TYPE == pOidInfo->ulMIB){
		if(NULL!=*ppVar)
			ConfigWriteInteger(0, MIB_WLAN_ENCRYPTION, 1);
		else
			ConfigWriteInteger(0, MIB_WLAN_ENCRYPTION, 0);
	}
	switch(result){
	case CONF_RESULT_OK:
		return SNMP_ERR_NOERROR;
	case CONF_RESULT_IPC_ERROR:
	case CONF_RESULT_VERSION_MISMATCH:
	case CONF_RESULT_MIB_UNKNOWN:
		break;
	case CONF_RESULT_REQUEST_DENY:
		return SNMP_ERR_NOTWRITABLE;
	case CONF_RESULT_REQUEST_NOT_HANDLE:
	case CONF_RESULT_INDEX_OUT_OF_RANGE:
		break;
	case CONF_RESULT_DATA_TOO_SHORT:
	case CONF_RESULT_DATA_TOO_LONG:
		return SNMP_ERR_WRONGLENGTH;
	case CONF_RESULT_DATA_INVALID:
		return SNMP_ERR_WRONGVALUE;
	case CONF_RESULT_UNKNOWN:
		return SNMP_ERR_GENERR;
	default:
		break;
	}
	return SNMP_ERR_COMMITFAILED;
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessMultiGeneric)
{
	static char		szOidVar[MAX_EXCHANGE_SIZE] = {0};
	uint8_t			uchIndex = pOidInfo->uchIndex;
	
	int32_t 		iRet = 0;
	static uint32_t	scan_tablen = 0;
	static uint8_t	scan_buff[MAX_EXCHANGE_SIZE] = {0};

	uchIndex = (uint8_t)((*pOid)-1);

	if (ISMultiVapMIB(pOidInfo->ulMIB)) {    //MIB is a MULTI VAP option
		uchIndex = current_vap_index-1;
	}

	if (CONF_FIELD_UNKNOWN==pOidInfo->FieldType)
	{
		const ExchangeFieldInfo_t	*pFieldInfo
			= GetFieldInfo(uchIndex, pOidInfo->ulMIB);
		if (NULL!=pFieldInfo)
		{
			pOidInfo->FieldType = pFieldInfo->ulFieldType;
		}
	}

	if (CONF_FIELD_UNKNOWN==pOidInfo->FieldType)
	{
		return SNMP_ERR_COMMITFAILED;
	}

	//Oid Read
	if (NULL==*ppVar)
	{
		if (pOidInfo->ulMIB == MIB_WLAN_AP_LIST)
		{
			uint32_t ulOpMode = 0;
			ConfigReadInteger(0, MIB_WLAN_OPERATION_MODE, &ulOpMode);
			if (ulOpMode != 1) goto do_error_process;
			
			if ((pOidInfo->name[3] == 1) && (pOid[0] == 1))
			{
				goto do_normal_process;
			}
			else if (!scan_tablen)
			{
				do_error_process:
				
				return SNMP_ERR_NOERROR;
			}
			else if (scan_tablen)
			{
				memcpy(szOidVar, scan_buff, scan_tablen*sizeof(ApScanList_t));
				*pVarLen = scan_tablen * sizeof(ApScanList_t);
				*ppVar = szOidVar;

				return SNMP_ERR_NOERROR;
			}
		}
		else
		{
			do_normal_process:	
			iRet = ConfigExchange(CONF_REQUEST_READ, uchIndex, pOidInfo->ulMIB, szOidVar, 0, sizeof(szOidVar));
			if (CONF_RESULT_OK==iRet)
			{
				*pVarLen = GetLastExchangeResponse(pOidInfo->ulMIB, NULL, 0, 0);
				if (CONF_FIELD_STRING==pOidInfo->FieldType)
				{
					(*pVarLen)--;
				}
				*ppVar = szOidVar;

				if (pOidInfo->ulMIB == MIB_WLAN_AP_LIST)
				{
					scan_tablen = (*pVarLen)/(sizeof(ApScanList_t));
					memcpy(scan_buff, *ppVar, *pVarLen);
				}

				return SNMP_ERR_NOERROR;
			}
		}

		return SNMP_ERR_GENERR;
	}

	// Oid Write	
	if (CONF_FIELD_STRING==pOidInfo->FieldType)
	{
		((uint8_t*)(*ppVar))[*pVarLen] = 0;
		(*pVarLen)++;
	} 			
	switch (ConfigExchange(CONF_REQUEST_WRITE, uchIndex,
			pOidInfo->ulMIB, *ppVar, *pVarLen, 0))
	{
	case CONF_RESULT_OK:
#ifdef	_DEBUG
		printf("COMMIT successfully!\r\n");
#endif//_DEBUG
		return SNMP_ERR_NOERROR;
	case CONF_RESULT_IPC_ERROR:
	case CONF_RESULT_VERSION_MISMATCH:
	case CONF_RESULT_MIB_UNKNOWN:
		break;
	case CONF_RESULT_REQUEST_DENY:
#ifdef	_DEBUG
		printf("CONF_RESULT_REQUEST_DENY!\r\n");
#endif//_DEBUG
		return SNMP_ERR_NOTWRITABLE;
	case CONF_RESULT_REQUEST_NOT_HANDLE:
	case CONF_RESULT_INDEX_OUT_OF_RANGE:
		break;
	case CONF_RESULT_DATA_TOO_SHORT:
	case CONF_RESULT_DATA_TOO_LONG:
#ifdef	_DEBUG
		printf("CONF_RESULT_DATA_TOO_SHORT or CONF_RESULT_DATA_TOO_LONG!\r\n");
#endif//_DEBUG
		return SNMP_ERR_WRONGLENGTH;
	case CONF_RESULT_DATA_INVALID:
#ifdef	_DEBUG
		printf("CONF_RESULT_DATA_INVALID!\r\n");
#endif//_DEBUG
		return SNMP_ERR_WRONGVALUE;
	case CONF_RESULT_UNKNOWN:
	default:
		break;
	}

#ifdef	_DEBUG
	printf("COMMIT fail!\r\n");
#endif//_DEBUG
	return SNMP_ERR_COMMITFAILED;
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessBoolean)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			uint32_t	*pulBoolean = (uint32_t*)*ppVar;
			if (NULL!=*ppVar && sizeof(uint32_t)==*pVarLen)
			{
				pulBoolean = (uint32_t*)*ppVar;
				*pulBoolean = (1==*pulBoolean)?1:0;
				return SNMP_ERR_NOERROR;
			}
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		uint32_t	*pulBoolean = (uint32_t*)*ppVar;
		pulBoolean = (uint32_t*)*ppVar;
		switch(*pulBoolean)
		{
		case 0:
			break;
		case 1:
			break;
		default:
			return SNMP_ERR_GENERR;			
		}
		return ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM);
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessMultiBoolean)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			uint32_t	*pulBoolean = (uint32_t*)*ppVar;
			if (NULL!=*ppVar && sizeof(uint32_t)==*pVarLen)
			{
				pulBoolean = (uint32_t*)*ppVar;
				*pulBoolean = (1==*pulBoolean)?1:2;
				return SNMP_ERR_NOERROR;
			}
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		uint32_t	*pulBoolean = (uint32_t*)*ppVar;
		pulBoolean = (uint32_t*)*ppVar;
		switch(*pulBoolean)
		{
		case 1:
			break;
		case 2:
			*pulBoolean = 0;
			break;
		default:
			return SNMP_ERR_GENERR;			
		}
		return ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM);
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessIPAddress)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			char		*szIP = *ppVar;
			uint32_t	ulIP = 0;
			if (NULL!=*ppVar && Str2IP(&ulIP, szIP))
			{
				*pVarLen = sizeof(uint32_t);
				*((uint32_t*)szIP) = ulIP;
				return SNMP_ERR_NOERROR;
			}
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		char szIP[20];
		if (4 != *pVarLen)
			return SNMP_ERR_GENERR;
		IP2Str(szIP, *((uint32_t*)*ppVar));
		*ppVar = szIP;
		*pVarLen = strlen(szIP);
		return ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM);
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessMultiIPAddress)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			char		*szIP = *ppVar;
			uint32_t	ulIP = 0;
			if (NULL!=*ppVar && Str2IP(&ulIP, szIP))
			{
				*pVarLen = sizeof(uint32_t);
				*((uint32_t*)szIP) = ulIP;
				return SNMP_ERR_NOERROR;
			}
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		char szIP[20];
		if (4 != *pVarLen)
			return SNMP_ERR_GENERR;
		IP2Str(szIP, *((uint32_t*)*ppVar));
		*ppVar = szIP;
		*pVarLen = strlen(szIP);
		return ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM);
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessMacAddress)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			char	*szMacAddress = *ppVar;
			if (NULL!=*ppVar)
			{
				if (!Str2Mac(szMacAddress, szMacAddress))
				{
					memset(szMacAddress, 0, sizeof(MacAddr_t));
				}
				*pVarLen = sizeof(MacAddr_t);
				return SNMP_ERR_NOERROR;
			}
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		char	szMacAddress[20];

		if (6 != *pVarLen)
		{
			//return SNMP_ERR_GENERR;
		}
		Mac2Str(szMacAddress, *((MacAddr_t*)*ppVar));
		//#8749
		int i=0,j=0;
		for (;i<17;i++){
			if ((i+1)%3 == 0) continue;
			if ((szMacAddress[i]>='0')&&(szMacAddress[i]<='9')||(szMacAddress[i]>='a')&&(szMacAddress[i]<='f')||(szMacAddress[i]>='A')&&(szMacAddress[i]<='F')){
				if (szMacAddress[i]=='0') j++;
				if (i != 1) continue;
				if ((szMacAddress[i]<='9')&&(szMacAddress[i]%2 == 0)||(szMacAddress[i]>='65')&&(szMacAddress[i]%2 == 1)) continue;
				printf("The first byte must be even!\n");
				return SNMP_ERR_GENERR;
			}
			else{
				printf("Invalid parameter[0-9,a-f]:%s.\n", szMacAddress);
				return SNMP_ERR_GENERR;
			}
		}
		if (j>=12) return SNMP_ERR_GENERR;
		*ppVar = szMacAddress;
		*pVarLen = strlen(szMacAddress);
		return ZComOidAccessGeneric(ZCOM_OID_ACCESS_PARAM);
	}
}

ZCOM_OID_ACCESS_DEFINE(ZComOidAccessMultiMacAddress)
{
	if (NULL==*ppVar)
	{
		if (SNMP_ERR_NOERROR==ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM))
		{
			char	*szMacAddress = *ppVar;
			if (NULL!=*ppVar)
			{
				if (!Str2Mac(szMacAddress, szMacAddress))
				{
					memset(szMacAddress, 0, sizeof(MacAddr_t));
				}
				*pVarLen = sizeof(MacAddr_t);
				return SNMP_ERR_NOERROR;
			}
		}
		return SNMP_ERR_GENERR;
	}
	else
	{
		char	szMacAddress[20];

		if (6 != *pVarLen)
		{
			return SNMP_ERR_GENERR;
		}
		Mac2Str(szMacAddress, *((MacAddr_t*)*ppVar));
		*ppVar = szMacAddress;
		*pVarLen = strlen(szMacAddress);
		return ZComOidAccessMultiGeneric(ZCOM_OID_ACCESS_PARAM);
	}
}

int current_vap_index = 1; //add by jxq to support multi vap
ZCOM_OID_ACCESS_DEFINE(ZComOidAccessMultiVapIndex)
{

	if (NULL==*ppVar)
	{	
		*ppVar = &current_vap_index;
		*pVarLen = sizeof(current_vap_index);
	}
	else
	{
		if ((*((int32_t*)*ppVar)>16)||(*((int32_t*)*ppVar)<1))		//#8742
			return SNMP_ERR_BADVALUE;
		memcpy(&current_vap_index,*ppVar,sizeof(int));
	}
	return SNMP_ERR_NOERROR;
}

