//added for firewall by huang 2010-01-27
#ifndef _ZCOM_FIREWALL_H_
#define _ZCOM_FIREWALL_H_

#define IP_STR_LEN_MAX 15
#define IP_STR_LEN_MIN 7
#define PORT_STR_LEN_MAX 5
#define PORT_STR_LEN_MIN 1
#define PROTOCOL_STR_LEN_MAX 4
#define PROTOCOL_STR_LEN_MIN 3

#define PORTFORWARD_MAX_NUM	20
#define IPFILTER_MAX_NUM		20
#define PORTFILTER_MAX_NUM	20
#define DB_STR32				32

typedef struct ipfilter_entry {
	in_addr_t	inIpFilter;
	uint32_t	ucProtocolType;
	char		szComment[DB_STR32];
} IpFilter_t;

typedef struct ipfilter_access {
	 in_addr_t inIpFilter;
	 uint32_t ucProtocolType;
	 char szComment[DB_STR32];
	 uint32_t selectid;
} IpFilterAccess_t ;

typedef struct portfilter_entry {
	uint32_t	usFromPort;
	uint32_t	usToPort;
	uint32_t	ucProtocolType;
	char		szComment[DB_STR32];
} PortFilter_t;

typedef struct portfilter_access {
	 uint32_t usFromPort;
	 uint32_t usToPort;
	 uint32_t ucProtocolType;
	 char szComment[DB_STR32];
	 uint32_t selectid;
} PortFilterAccess_t;

typedef struct portforward_entry {
	in_addr_t	inPortForwareIp;
	uint32_t	usFromPort;
	uint32_t	usToPort;
	uint32_t	ucProtocolType;
	char		szComment[DB_STR32];
} PortForward_t;

typedef struct portforward_access {
	 in_addr_t inPortForwareIp;
	 uint32_t usFromPort;
	 uint32_t usToPort;
	 uint32_t  ucProtocolType;
	 char szComment[DB_STR32];
	 uint32_t selectid;
} PortForwardAccess_t;

#endif
