#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <mtd/mtd-user.h>
#include <getopt.h>

#define BUFSIZE 			0x1000
#define KB(x) 				((x) / 1024)
#define PERCENTAGE(x,total) (((x) * 100) / (total))

/*****************************************************
 * get size                                          *
 *****************************************************/
unsigned int flash_size(int mtdFd)
{
	unsigned int ulSize = -1;
	struct mtd_info_user mtd;

	if (mtdFd < 0 || ioctl (mtdFd,MEMGETINFO,&mtd) < 0)
	{
		printf("Fail to access the MTD flash!\n");
		goto _end;
	}
	ulSize = mtd.size;
_end:
	return ulSize;
}

/*****************************************************
 * erase enough blocks so that we can write the file *
 *****************************************************/
int flash_erase(int mtdFd, unsigned int ulSize)
{
	struct erase_info_user erase;
	struct mtd_info_user mtd;
	int i, blocks;

	if (mtdFd < 0 || ioctl (mtdFd,MEMGETINFO,&mtd) < 0)
	{
		printf("Fail to access the MTD flash!\n");
		goto _err;
	}
	if (ulSize > mtd.size)
	{
		printf("MTD size was too few!\n");
		goto _err;
	}
	// 0: erase all the data of mtd
	if (ulSize == 0)
		ulSize = mtd.size;

	erase.start = 0;
	erase.length = ulSize & ~(mtd.erasesize - 1);
	if (ulSize % mtd.erasesize)
		erase.length += mtd.erasesize;
	blocks = erase.length / mtd.erasesize;
	erase.length = mtd.erasesize;
	printf ("Erasing blocks: 0/%d (0%%)",blocks);
	for (i = 1; i <= blocks; i++)
	{
		printf ("\rErasing blocks: %d/%d (%d%%)",i,blocks,PERCENTAGE (i,blocks));
		if (ioctl (mtdFd,MEMERASE,&erase) < 0)
		{
			printf ("\nWhile erasing blocks 0x%.8x-0x%.8x: %m\n",
					(unsigned int) erase.start,(unsigned int) (erase.start + erase.length));
			goto _err;
		}
		erase.start += mtd.erasesize;
	}
	printf ("\rErasing blocks: %d/%d (100%%)\n",blocks,blocks);
	return 0;

_err:
	//if (mtdFd != -1)
	//	close(mtdFd);
	return -1;
}

int flash_erase_offset(int mtdFd, unsigned int ulOffset, unsigned int ulSize)
{
	struct erase_info_user erase;
	struct mtd_info_user mtd;
	int i, blocks;

	if (mtdFd < 0 || ioctl (mtdFd,MEMGETINFO,&mtd) < 0)
	{
		printf("Fail to access the MTD flash!\n");
		goto _err;
	}
	if (ulSize > mtd.size || ulOffset > mtd.size - mtd.erasesize)
	{
		printf("MTD size was too few!\n");
		goto _err;
	}
	// 0: erase all the data of mtd
	if (ulSize == 0)
		ulSize = mtd.size;

	erase.start = ulOffset & ~(mtd.erasesize - 1);
	if (ulOffset % mtd.erasesize)
		erase.start += mtd.erasesize;

	erase.length = ulSize & ~(mtd.erasesize - 1);
	if (ulSize % mtd.erasesize)
		erase.length += mtd.erasesize;
	blocks = erase.length / mtd.erasesize;
	erase.length = mtd.erasesize;
	printf ("Erasing blocks: 0/%d (0%%)",blocks);
	for (i = 1; i <= blocks; i++)
	{
		printf ("\rErasing blocks: %d/%d (%d%%)",i,blocks,PERCENTAGE (i,blocks));
		if (ioctl (mtdFd,MEMERASE,&erase) < 0)
		{
			printf ("\nWhile erasing blocks 0x%.8x-0x%.8x: %m\n",
					(unsigned int) erase.start,(unsigned int) (erase.start + erase.length));
			goto _err;
		}
		erase.start += mtd.erasesize;
	}
	printf ("\rErasing blocks: %d/%d (100%%)\n",blocks,blocks);
	return 0;

_err:
	return -1;
}

/*****************************************************
 * read to buf                                       *
 *****************************************************/
int flash_read(int mtdFd, unsigned char *szBuf, unsigned int ulSize)
{
	return read(mtdFd, szBuf, ulSize);
}

/*****************************************************
 * write the buf                                     *
 *****************************************************/
int flash_write(int mtdFd, const unsigned char *szBuf, unsigned int ulSize)
{
	return write(mtdFd, szBuf, ulSize);
}

/***********************************
 * write the file content to flash *
 **********************************/
int flash_write_file(int mtdFd, int fwFd, unsigned int ulLen)
{
	unsigned int reading = BUFSIZE, written = 0, remain = ulLen;
	unsigned char buf[BUFSIZE];

	if (mtdFd < 0 || fwFd < 0 || ulLen <= 0)
	{
		goto _err;
	}

	printf ("Writing data: 0k/%dk (0%%)",KB (ulLen));
	for(remain=ulLen, written=0; remain > 0; remain -= reading, written += reading)
	{
		if (remain < BUFSIZE)
			reading = remain;
		printf("\rWriting data: %dk/%dk (%d%%)",
				KB (written + reading),
				KB (ulLen),
				PERCENTAGE (written + reading,ulLen));

		/* read from filename */
		if (reading != read (fwFd, buf, reading))
			goto _err;

		/* write to device */
		if (reading != write (mtdFd, buf, reading))
		{
			printf("\nWhile writing data to 0x%.8x-0x%.8x: %m\n", written,written + reading);
			goto _err;
		}
	}
	printf("\rWriting data: %dk/%dk (100%%)\n", KB(ulLen), KB(ulLen));
	return 0;

_err:
	return -1;
}

