
#ifndef	__CFG_ZCOM_UTI_H__
#define	__CFG_ZCOM_UTI_H__

#include <stdio.h>
#include "os_type.h"

#define	INVALID_SOCKET_HANDLE	-1
#define MIN_RX_DBM 				-100
#define MAX_RX_DBM 				10
#define RSS2DBM_MIN				(-96)


int console_printf(const char *format, ...);
int systemf(const char *format, ...);
__inline__ unsigned long GetUptime(void);
int FileSize(const char *filepath);
uint16_t CheckSum(uint16_t *szBUF, int32_t iSize);
__inline__ bool_t IsBigEndian(void);
__inline__ unsigned short EndianAdjust16(unsigned short num);
__inline__ unsigned int EndianAdjust32(unsigned int num);
int getline(char **lineptr, size_t *n, FILE *stream);

// flash operation
unsigned int flash_size(int mtdFd);
int flash_erase(int mtdFd, unsigned int ulSize);
int flash_erase_offset(int mtdFd, unsigned int ulOffset, unsigned int ulSize);
int flash_read(int mtdFd, unsigned char *szBuf, unsigned int ulSize);
int flash_write(int mtdFd, const unsigned char *szBuf, unsigned int ulSize);
int flash_write_file(int mtdFd, int fwFd, unsigned int ulLen);

// convert operation
void IP2Str(char *szIP, in_addr_t ulIP);
bool_t Str2IP(in_addr_t *pulIP, const char *cszIP);
void Mac2Str(char *szMacAddress, MacAddr_t MacAddr);
bool_t Str2Mac(MacAddr_t MacAddr, const char *szMacAddress);
uint32_t Str2Hex(uint8_t *pHex, const char *cszString);
void Hex2Str(char *szString, uint8_t *pHex, uint32_t ulHexLen);
unsigned char mhz2ieee(unsigned int freq);
int  RSSI2dBm(int iRSSI);

// validation
bool_t IsValidIP(in_addr_t ulIP);
bool_t IsValidNetmask(in_addr_t ulIP, in_addr_t ulIPMask);

// ioctrl
int ZComIOControl(int request, void* pData);
int WlanAccess(int iIfIndex, int fIsRead, uint32_t ulMIB, void* pData, uint32_t ulSize);
void ZComLogAddAuthorization(unsigned short	usIdentification, unsigned char	puchFromIPv4[4], unsigned char	*szUserName);

#endif	//__CFG_ZCOM_UTI_H__
