//
//	zcomlog.h
//		Copyright (c) 2003, Z-Com, Inc.	
//		Forrest	<Team@zcom.com.cn>
//				<HappyDogs@zcom.unimis.com>
//

#ifndef	_ZCOM_LOG_H_
#define	_ZCOM_LOG_H_

#ifndef	__KERNEL__
#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#endif

#define	ZCOM_PROC_LOG_NAME			"syslog"
#define ZCOM_PROC_LOG_FULLNAME		"/proc/"ZCOM_PROC_LOG_NAME
#define	ZCOM_LOG_NAME				"zcomlog"
#define	ZCOM_LOG_FULLNAME			"/dev/"ZCOM_LOG_NAME

typedef	enum ZComLogID_t
{
	// padding log
	ZCOM_LOG_PADDING,	// don't use this ID.
	// generic log,	ZComLogRecord.u.szGeneric
	ZCOM_LOG_GENERIC,
	// system log
	ZCOM_LOG_SYS_BOOT_UP,
	ZCOM_LOG_SYS_SHUT_DOWN,
	// wlan log, ZComLogRecord.u.WlanLog
	ZCOM_LOG_WLAN_UP,
	ZCOM_LOG_WLAN_DOWN,
	ZCOM_LOG_WLAN_INTERFERENCE,
	ZCOM_LOG_WLAN_ANTENNA_SWITCHED,
	ZCOM_LOG_WLAN_MIC_FAILED,
	ZCOM_LOG_WLAN_MIC_ATTACKED,
	ZCOM_LOG_WLAN_AUTHENTICATED,
	ZCOM_LOG_WLAN_AUTHENTICATION_FAIL,
	ZCOM_LOG_WLAN_DEAUTHENTICATED,
	ZCOM_LOG_WLAN_KEY_MISMATCHED,
	ZCOM_LOG_WLAN_ASSOCIATED,
	ZCOM_LOG_WLAN_REASSOCIATED,
	ZCOM_LOG_WLAN_ASSOCIATION_FAIL,
	ZCOM_LOG_WLAN_DISASSOCIATED,
	ZCOM_LOG_WLAN_ACL_REFUSE,
	ZCOM_LOG_WLAN_REMOTE_AP_JOINED,
	ZCOM_LOG_WLAN_REMOTE_AP_DELETED,
	// cli log, ZComLogRecord.u.AuthorizationLog
	ZCOM_LOG_CLI_AUTHORIZED,
	ZCOM_LOG_CLI_UNAUTHORIZED,
	ZCOM_LOG_CLI_LOGOUT,
	// ftp log, ZComLogRecord.u.AuthorizationLog
	ZCOM_LOG_FTP_AUTHORIZED,
	ZCOM_LOG_FTP_UNAUTHORIZED,
	ZCOM_LOG_FTP_LOGOUT,
	// telnet log, ZComLogRecord.u.AuthorizationLog
	ZCOM_LOG_TELNET_AUTHORIZED,
	ZCOM_LOG_TELNET_UNAUTHORIZED,
	ZCOM_LOG_TELNET_LOGOUT,
	// web log, ZComLogRecord.u.AuthorizationLog
	ZCOM_LOG_WEB_AUTHORIZED,
	ZCOM_LOG_WEB_UNAUTHORIZED,
	ZCOM_LOG_WEB_LOGOUT,
	// snmp log, ZComLogRecord.u.AuthorizationLog
	ZCOM_LOG_SNMP_BAD_COMMUNITY	//???
} ZComLogID_t;

typedef	enum ZComLogIDRange{
	ZCOM_LOG_FIRST_ID				= ZCOM_LOG_GENERIC,
	ZCOM_LOG_LAST_ID				= ZCOM_LOG_SNMP_BAD_COMMUNITY,

	ZCOM_LOG_WLAN_FIRST_ID			= ZCOM_LOG_WLAN_UP,
	ZCOM_LOG_WLAN_LAST_ID			= ZCOM_LOG_WLAN_REMOTE_AP_JOINED,

	ZCOM_LOG_AUTHORIZATION_FIRST_ID	= ZCOM_LOG_CLI_AUTHORIZED,
	ZCOM_LOG_AUTHORIZATION_LAST_ID	= ZCOM_LOG_WEB_LOGOUT,
} ZComLogIDRange;

void ZComLogAppendGeneric(char *szGeneric);

void 
ZComLogAppendAuthorization(
	unsigned short	usIdentification,	// refer to ZComLogID
	unsigned char	puchFromIPv4[4],	// IP Address
	unsigned char	*szUserName			// Authorization User name
	);

#ifdef	__KERNEL__// kernel space
void
ZComLogAppendWlan(
	unsigned short	usIdentification,	// refer to ZComLogID
	unsigned char	puchMacAddress[6]
	);
#endif//__KERNEL__

// User Space Functions

typedef	enum ZComLogIOC_t
{
	ZCOM_LOG_IOC_GENERIC,
	ZCOM_LOG_IOC_AUTH,
} ZComLogIOC_t;

typedef	struct ZComLogAuthReq_t
{
	unsigned short	usIdentification;
	unsigned char	puchFromIPv4[4];
	unsigned char	szUserName[36];
} ZComLogAuthReq_t;


#endif//_ZCOM_LOG_H_
