/*
 *	wag302server.h
 */
#ifndef	__WAG302SERVER_H__
#define	__WAG302SERVER_H__

#include "wag302mib.h"
#include "wag302type.h"

// Last octet is version: 0x01
#define	CONFIG_VERSION	0x00, 0x60, 0xb3, 0x01

typedef	struct
{
	uint8_t		ubh4VAPIndex	:4,
				ubl4CardIndex	:4;
} IndexByteField_t;

typedef struct ExchangeHdr_t
{
	uint8_t		uchVersion[4];
	uint32_t	ulMIB;
	uint16_t	usDataLength;
	union
	{
		struct
		{
			uint8_t		ubl4CardIndex	:4;
			uint8_t		ubh4VAPIndex	:4;
		}IndexByteField_t;
		uint8_t		uchIndex;
	};
	uint8_t		uchRequest;
	uint8_t		uchResult;
	uint8_t		uchReserved[3];
} ExchangeHdr_t;

typedef	int (*ServerExchangeHook_t)(
	ExchangeHdr_t	*pReqHdr, 
	uint32_t		ulReqDataLen,	// exclude header len
	ExchangeHdr_t	*pRespHdr
	);

ExchangeResult_t ServerStartup(ServerExchangeHook_t ServerExchangeHook);
void ServerMonitor(void);
void ServerCleanup(void);

#endif//!__WAG302SERVER_H__
