//
// Copyright (c) 2002 Z-Com	Nanjing, Inc. China
//
// Module Name:
//
// Globals Accessed:
//
// Callers:
//
// Called routines:
//
// Functional Description:
//
// Comments:
//
// Diagnostics:
//

//////////////////////////////////////////////////////////////////////////////
//																			//
//	 This program is free software;	you	can	redistribute it	and/or modify	//
//	 it	under the terms	of the GNU General Public License as published by	//
//	 the Free Software Foundation; either version 2	of the License,	or		//
//	 (at your option) any later	version.									//
//																			//
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
//		|---|---|---|---|---|---|---|---|									//
//		32	28	24	20	16	12	8	4	0									//
//		|---|---|---|---|---|---|---|---|									//
//		  1	  2	  3	  4	  5	  6	  7	  8										//
//																			//
//		bit	0 -	7	End	Node												//
//		bit	8 -	15	4th	Subtree												//
//		bit	16-	19	3rd	Subtree												//
//		bit	20-	23	2nd	Subtree												//
//		bit	24-	27	1st	Subtree												//
//		bit	28-	31	Reserved												//
//////////////////////////////////////////////////////////////////////////////
#ifndef	_DOT11_MIB_H_
#define	_DOT11_MIB_H_

#define IFNAMSIZ 16
#define SIOCDEVPRIVATE 0x89F0
#define IW_SCAN_ZCOM_START	0x1000
typedef unsigned char WLAN_MACADDR[6];
#define __ATTRIB_PACK	__attribute__ ((packed))

/*
 *		MIB	NAME								MIB ID		// ASN ID	Size(byte) implement range default access	memo
 */
/*
 * Child IO_CONTROL	Command	define
 */

// 1.0.0.0.0: dot11smt
// 1.1.0.0.0: dot11StationConfigTable
// 1.1.1.0.0: dot11StationConfigEntry
#define	DOT11_STATION_ID						0x01110100	// 1.1.1.1.0  6	  *					  R		=according the card's HW mac address
#define	DOT11_MEDIUM_OCCUPANCY_LIMIT			0x01110200	// 1.1.1.2.0  2
#define	DOT11_CF_POLLABLE						0x01110300	// 1.1.1.3.0  1
#define	DOT11_CFP_PERIOD						0x01110400	// 1.1.1.4.0  1
#define	DOT11_CFP_MAX_DURATION					0x01110500	// 1.1.1.5.0  2
#define	DOT11_AUTHERNTICATION_RESPONSE_TIMEOUT	0x01110600	// 1.1.1.6.0  4
#define	DOT11_PRIVACY_OPTION_IMPLEMENTED		0x01110700	// 1.1.1.7.0  1	  *	(0..1)		1	  R		=1 TRUE
#define	DOT11_POWER_MANAGEMENT_MODE				0x01110800	// 1.1.1.8.0  1
#define	DOT11_DESIRED_SSID						0x01110900	// 1.1.1.9.0  32  *	Zero-terminal string
#define	DOT11_DESIRED_BSS_TYPE					0x01110a00	// 1.1.1.10.0 1	  *	(1..3)		1	  R		=1 INFRASTRUCTURE_BSS
#define	DOT11_OPERATIONAL_RATE_SET				0x01110b00	// 1.1.1.11.0 9	  *	see	the	following comment
//
//Mbps		  6		9	  12	18	  24	36	  48	54
//default	  0x8C,	0x12, 0x98,	0x24, 0xB0,	0x48, 0x60,	0x6C
//IsBasicRate Yes	No	  Yes	No	  Yes	No	  No	No
//each octet= (rate(in Mbps)*2)	| ((IsBasicRate)?0x80:0x00)
//
#define	DOT11_BEACON_PERIOD						0x01110c00	// 1.1.1.12.0 2	  *	(1..65535)	100	  RW	(20..1000)
#define	DOT11_DTIM_PERIOD						0x01110d00	// 1.1.1.13.0 1	  *	(1..255)	1	  RW
#define	DOT11_ASSOCIATION_RESPONSE_TIMEOUT		0x01110e00	// 1.1.1.14.0 4

// 1.2.0.0.0: dot11AuthenticationAlgorithmsTable
// 1.2.1.0.0: dot11AuthenticationAlgorithmsEntry
#define	DOT11_AUTHENTICATION_ALGORITHMS_INDEX	0x01210100	// 1.2.1.1.0  1
#define	DOT11_AUTHENTICATION_ALGORITHMS			0x01210200	// 1.2.1.2.0  1
#define	DOT11_AUTHENTICATION_ALGORITHMS_ENABLE	0x01210300	// 1.2.1.3.0  1

// 1.3.0.0.0: dot11WEPDefaultKeysTable
// 1.3.1.0.0: dot11WEPDefaultKeysEntry
#define	DOT11_WEP_DEFAULT_KEY_INDEX				0x01310100	// 1.3.1.1.0  1
#define	DOT11_WEP_DEFAULT_KEY_VALUE				0x01310200	// 1.3.1.2.0  5

// 1.4.0.0.0: dot11WEPKeyMappingsTable
#define	DOT11_WEP_KEY_MAPPINGS_ENTRY			0x01410000	// 1.4.1.0.0  28  *	see	the	sample,	different with 802.11b
//#define DOT11_WEP_KEY_MAPPING_INDEX			0x01410100	// 1.4.1.1.0  1
#define	DOT11_WEP_KEY_MAPPING_ADDRESS			0x01410200	// 1.4.1.2.0  6
#define	DOT11_WEP_KEY_MAPPING_WEP_ON			0x01410300	// 1.4.1.3.0  1
#define	DOT11_WEP_KEY_MAPPING_VALUE				0x01410400	// 1.4.1.4.0  5
#define	DOT11_WEP_KEY_MAPPING_STATUS			0x01410500	// 1.4.1.5.0  1

// 1.5.0.0.0: dot11PrivacyTable
// 1.5.1.0.0: dot11PrivacyEntry
#define	DOT11_PRIVACY_INVOKED					0x01510100	// 1.5.1.1.0  1	  *	(0..1)		0	  RW  0=false
#define	DOT11_WEP_DEFAULT_KEY_ID				0x01510200	// 1.5.1.2.0  1	  *	(1..4)		0	  RW
#define	DOT11_WEP_KEY_MAPPING_LENGTH			0x01510300	// 1.5.1.3.0  1
#define	DOT11_EXCLUDE_UNENCRYPTED				0x01510400	// 1.5.1.4.0  1
#define	DOT11_WEP_ICV_ERROR_COUNT				0x01510500	// 1.5.1.5.0  4
#define	DOT11_WEP_EXCLUDED_COUNT				0x01510600	// 1.5.1.6.0  4

// 1.6.0.0.0: dot11SMTnotification
// 1.6.1.0.0: dot11Disassociate
// 1.6.2.0.0: dot11Deauthenticate
// 1.6.3.0.0: dot11AuthenticateFail

// 2.0.0.0.0: dot11mac
// 2.1.0.0.0: dot11OperationTable
// 2.1.1.0.0: dot11OperationEntry
//#define DOT11_MAC_ADDRESS						0x02110100	// 2.1.1.1.0
#define	DOT11_RTS_THRESHOLD						0x02110200	// 2.1.1.2.0  2	  *	(0..2347)	2347  RW
#define	DOT11_SHORT_RETRY_LIMIT					0x02110300	// 2.1.1.3.0  1
#define	DOT11_LONG_RETRY_LIMIT					0x02110400	// 2.1.1.4.0  1
#define	DOT11_FRAGMENTATION_THRESHOLD			0x02110500	// 2.1.1.5.0  2	  *	(256..2346 even	only) 2346	RW
#define	DOT11_MAX_TRANSMIT_MSDU_LIFE_TIME		0x02110600	// 2.1.1.6.0  4
#define	DOT11_MAX_RECEIVE_LIFE_TIME				0x02110700	// 2.1.1.7.0  4
#define	DOT11_MANUFACTURER_ID					0x02110800	// 2.1.1.8.0  129
#define	DOT11_PRODUCT_ID						0x02110900	// 2.1.1.9.0  129


// 2.2.0.0.0: dot11CountersTable
// 2.2.1.0.0: dot11CountersEntry
#define	DOT11_TRANSMITTED_FRAGMENT_COUNT		0x02210100	// 2.2.1.1.0  4
#define	DOT11_MULTICAST_TRANSMITTED_FRAME_COUNT	0x02210200	// 2.2.1.2.0  4
#define	DOT11_FAILED_COUNT						0x02210300	// 2.2.1.3.0  4
#define	DOT11_RETRY_COUNT						0x02210400	// 2.2.1.4.0  4
#define	DOT11_MULTIPLE_RETRY_COUNT				0x02210500	// 2.2.1.5.0  4
#define	DOT11_FRAME_DUPLICATE_COUNT				0x02210600	// 2.2.1.6.0  4
#define	DOT11_RTS_SUCCESS_COUNT					0x02210700	// 2.2.1.7.0  4

#define	DOT11_RTS_FAILURE_COUNT					0x02210800	// 2.2.1.8.0  4
#define	DOT11_ACK_FAILURE_COUNT					0x02210900	// 2.2.1.9.0  4
#define	DOT11_RECEIVED_FRAGMENT_COUNT			0x02210a00	// 2.2.1.10.0 4
#define	DOT11_MULTICAST_RECEIVED_FRAME_COUNT	0x02210b00	// 2.2.1.11.0 4
#define	DOT11_FCS_ERROR_COUNT					0x02210c00	// 2.2.1.12.0 4
#define	DOT11_TRANSMITTED_FRAME_COUNT			0x02210d00	// 2.2.1.13.0 4
#define	DOT11_WEP_UNDECRYPTABLE_COUNT			0x02210e00	// 2.2.1.14.0 4

// 2.3.0.0.0: dot11GroupAddressesTable
// 2.3.1.0.0: dot11GroupAddressesEntry
#define	DOT11_GROUP_ADDRESSES_INDEX				0x02310100	// 2.3.1.1.0  1
#define	DOT11_ADDRESS							0x02310200	// 2.3.1.2.0  6
#define	DOT11_GROUP_ADDRESSES_STATUS			0x02310300	// 2.3.1.3.0  1

// 3.0.0.0.0: dot11res
// 3.1.0.0.0: dot11resAttribute
// 3.1.1.0.0: dot11ResourceTypeIDName
// 3.1.2.0.0: dot11ResourceInfoTable
// 3.1.2.1.0: dot11ResourceInfoEntry
#define	DOT11_MANUFACTURER_OUI					0x03120101	// 3.1.2.1.1  3
#define	DOT11_MANUFACTURER_NAME					0x03120102	// 3.1.2.1.2  129
#define	DOT11_MANUFACTURER_PRODUCT_NAME			0x03120103	// 3.1.2.1.3  129 *	string	  R
#define	DOT11_MANUFACTURER_PRODUCT_VERSION		0x03120104	// 3.1.2.1.4  129

// 4.0.0.0.0: dot11phy
// 4.1.0.0.0: dot11PhyOperationTable
// 4.1.1.0.0: dot11phyOperationEntry
#define	DOT11_PHY_TYPE							0x04110100	// 4.1.1.1.0  1
#define	DOT11_CURRENT_REG_DOMAIN				0x04110200	// 4.1.1.2.0  1
#define	DOT11_TEMP_TYPE							0x04110300	// 4.1.1.3.0  1

// 4.2.0.0.0: dot11PhyAntennaTable
// 4.2.1.0.0: dot11PhyAntennaEntry

// 4.3.0.0.0: dot11PhyTxPowerTable
// 4.3.1.0.0: dot11PhyTxPowerEntry

// 4.4.0.0.0: dot11PhyFHSSTable
// 4.4.1.0.0: dot11PhyFHSSEntry

// 4.5.0.0.0: dot11PhyDSSSSTable
// 4.5.1.0.0: dot11PhyDSSSEntry
#define	DOT11_CURRENT_CHANNEL					0x04510100	// 4.5.1.1.0  1	  *	(34|38|42|46 for MKK) 1	RW	=34
#define	DOT11_CCA_MODE_SUPPORTED				0x04510200	// 4.5.1.2.0  1
#define	DOT11_CURRENT_CCA_MODE					0x04510300	// 4.5.1.3.0  1
#define	DOT11_ED_THRESHOLD						0x04510400	// 4.5.1.4.0  4

// 4.6.0.0.0: dot11PhyIRTable
// 4.6.1.0.0: dot11PhyIREntry

// 4.7.0.0.0: dot11RegDomainsSupportedTable
// 4.7.1.0.0: dot11RegDomainsSupportEntry
#define	DOT11_REG_DOMAINS_SUPPORT_INDEX			0x04710100	// 4.7.1.1.0  1
#define	DOT11_REG_DOMAINS_SUPPORT_VALUE			0x04710200	// 4.7.1.2.0  1

// 4.8.0.0.0: dot11AntennasListTable
// 4.8.1.0.0: dot11AntennasListEntry

// 4.9.0.0.0: dot11SupportedDataRatesTxTable
// 4.9.1.0.0: dot11SupportedDataRatesTxEntry
#define	DOT11_SUPPORTED_DATA_RATES_TX_INDEX		0x04910100	// 4.9.1.1.0  1
#define	DOT11_SUPPORTED_DATA_RATES_TX_VALUE		0x04910200	// 4.9.1.2.0  1

// 4.10.0.0.0:	dot11SupportedDataRatesRxTable
// 4.10.1.0.0:	dot11SupportedDataRatesRxEntry
#define	DOT11_SUPPORTED_DATA_RATES_RX_INDEX		0x04a10100	// 4.10.1.1.0 1
#define	DOT11_SUPPORTED_DATA_RATES_RX_VALUE		0x04a10200	// 4.10.1.2.0 1

//
// the following are the Z-Com defined IDs
//
#define DOT11_ZCOM_11GMODE						0x00100000
#define DOT11_ZCOM_ABOLT						0x00100001
#define DOT11_ZCOM_ACCESS_CONTROL_ENTRY			0x00100002	//AccessControlEntry_t RW
#define DOT11_ZCOM_ACCESS_CONTROL_MODE			0x00100003	//1	* (0..2)  1		RW	=enabled
															//0= ACL disabled
															//1= ACL enabled
															//2= ACL strict
#define DOT11_ZCOM_AES_DEFAULT_KEY_ID			0x00100004	//1	* (1..4)  0		RW	1-4
#define DOT11_ZCOM_ANTENNA						0x00100005	//4
#define DOT11_ZCOM_AP_MODE						0x00100006	//1 *(0..5)	0		RW
																// 0= AP
																// 1= AP Client
																// 2= Bridge
																// 3= Bridge Enhanced
																// 4= Repeat
																// 5= Repeat Enhanced
																// 6= Promiscuous
#define DOT11_ZCOM_SCAN_RESULT					0x00100007
#define DOT11_ZCOM_ASSOC_STA_ENTRY				0x00100008	//AssocStaEntry_t	**	R
#define DOT11_ZCOM_AUTH_TYPE					0x00100009	//1	* (0..1)  0		RW
																//0= Open-System
																//1= Shared-Key
#define DOT11_ZCOM_AUTO_CHANNEL					0x0010000a
#define DOT11_ZCOM_BRIDGE						0x0010000b
		
#define DOT11_ZCOM_CIPHER_MODE					0x0010000c	//1	* (0..2)  0		RW	=WEP
																//0= WEP 
																//1= AES 
																//2= AUTO
#define DOT11_ZCOM_COUNTRY_CODE					0x0010000d	//2	* enum	  ?		RW	default	defined	by card
																// detail see programer's guide
#define DOT11_ZCOM_DYNAMIC_KEY					0x0010000e
#define DOT11_ZCOM_ECM							0x0010000f
#define DOT11_ZCOM_FORBID_W2W					0x00100010	//1	**(0..1)  0		RW	false
#define DOT11_ZCOM_HARDWARE_CAPABILITY			0x00100011
#define DOT11_ZCOM_HARDWARE_RETRY				0x00100012	//1	* (0..1)  1		RW	true
#define DOT11_ZCOM_HIDE_AP						0x00100013	//1	* (0..1)  0		RW	false
#define DOT11_ZCOM_KEY_SOURCE					0x00100014
#define DOT11_ZCOM_KICK_OUT_STA					0x00100015	//6	** macaddress	W
#define DOT11_ZCOM_MAX_STA_NUM					0x00100016
#define DOT11_ZCOM_OVERLAPPING_BSS				0x00100017
#define DOT11_ZCOM_PREAMBLE						0x00100018
#ifdef	_ZCOM_RADIO_TEST_
#define DOT11_ZCOM_RADIO_TEST					0x00100019
#endif//_ZCOM_RADIO_TEST_
#define DOT11_ZCOM_RATE_CONTROL					0x0010001a	//1	* (0..1)  1		RW	true
#define DOT11_ZCOM_SCAN_ACTION					0x0010001b
#define DOT11_ZCOM_SHORT_SLOT_TIME				0x0010001c
#define DOT11_ZCOM_SOFTWARE_RETRY				0x0010001d	//1	* (0..1)  1		RW	true
#define DOT11_ZCOM_STATISTIC					0x0010001e
#define DOT11_ZCOM_SUPER_G_OPTION				0x0010001f
#define DOT11_ZCOM_SWRETRY_MODE					0x00100020
#define DOT11_ZCOM_TX_POWER						0x00100021	//1	* (0..4)  0		RW	0=max
																//0= full power
																//1= -3	dB(50%)
																//2= -6	dB(25%)
																//3= -9	dB(12.5%)
																//4= min power
#define DOT11_ZCOM_TX_RATE						0x00100022	//1	* see DOT11_RATE_TABLE
#define DOT11_ZCOM_VALID_CHANNEL_LIST			0x00100023	//24	* bytes	array	R
#define DOT11_ZCOM_WDS_ENTRY					0x00100024
#define DOT11_ZCOM_WIRELESS_MODE				0x00100025
#define DOT11_ZCOM_PRIVATE_IE					0x00100026	// MgtPrivateIEs_t
#define DOT11_ZCOM_TX_POWER_DEFAULT				0x00100027
#define DOT11_ZCOM_TX_POWER_OVERRIDE			0x00100028	// 4	overRideTxPower

//Windy: define the following for AP-Client mode.
#define DOT11_ZCOM_NETWORK_STATUS				0x00100029
#define DOT11_ZCOM_CLIENT_BSSID					0x0010002a
#define DOT11_ZCOM_CLIENT_WMODE_RANGE			0x0010002b

//Define for power backoff
#define DOT11_ZCOM_XPD_INFO						0x0010002c	// 4bytes (uint32_t) Readonly
#define DOT11_ZCOM_RX_RSSI						0x0010002d	// 1bytes (uchar_t)  Readonly
#define NOISE_FLOOR_INVALID						0xffff
#define DOT11_ZCOM_NOISE_FLOOR					0x0010002e	// 4bytes (uint32_t)  Readonly 
															//Mask: 0x000001ff

#define DOT11_ZCOM_ISOLATION_WDS				0x0010002f
#define DOT11_ZCOM_DFS							0x00100100
#define DOT11_ZCOM_NOISE_THRESHOLD				0x00100110
#define DOT11_ZCOM_WME							0x00100120
#define DOT11_ZCOM_WMM_SET						0x00100121
#define DOT11_ZCOM_RATETOSIGNAL					0x00100122   //add by jxq
// new added
#define DOT11_ZCOM_CHAN_POWER_INFO				0x00100200	//

#define DOT11_ZCOM_PROBE						0x00100300

#define DOT11_ZCOM_PRIVACY_WDS_ENHANCE			0x00200004
#define DOT11_ZCOM_CTSMODE						0x00200005	// 4bytes (uint32_t) RWrite
#define DOT11_ZCOMCAP							0x00200006
#define DOT11_ZCOM_LONG_DETECT					0x00200007	// 4byte (uint32_t) read only
#define DOT11_ZCOM_RADIO						0x00200008	// Radio on/off, 4byte bool, R/W

/*
 * the following are the Z-Com defined DEBUG IDs
 */
#define DOT11_ZCOM_DRIFT_FREQUENCY				0x00300100
#define DOT11_APCLIENT_GATEWAY					0x00300101
#define DOT11_APCLIENT_GATEWAYMASK				0x00300102

#define DOT11_ZCOM_EXCLUDE						0x00300103

#define DOT11_ZCOM_REBOOT						0x00300104
#define DOT11_ZCOM_FACTORY_RESTORE				0x00300105

#define DOT11_ZCOM_VAP_INDEX					0x00300106
#define DOT11_ZCOM_VAP_ACTIVE					0x00300107
#define DOT11_ZCOM_VAP_MACADDRESS				0x00300108

// define  for 11n
#define DOT11_ZCOM_CWM_MODE						0x00300201
#define DOT11_ZCOM_CWM_EXTOFFSET				0x00300202
#define DOT11_ZCOM_CWM_EXTPROTMODE				0x00300203
#define DOT11_ZCOM_CWM_EXTPROTSPACING			0x00300204
#define DOT11_ZCOM_CWM_ENABLE					0x00300205
#define DOT11_ZCOM_CWM_EXTBUSYTHRESHOLD			0x00300206
#define DOT11_ZCOM_CWM_CHWIDTH					0x00300207


/*
 * The MIB interface structure used between the application and the driver
 * to get/set 802.11 MIBs
 */
#define	WLAN_IO_MIB_GET	0x0001
#define	WLAN_IO_MIB_SET	0x0002

typedef	enum MIB_STATUS
{
	MIB_ACCESS_ERROR=0,
}MIB_STATUS;

/* 802.11b 2312 ~ 2500 MHz, -19 ~ -7, 1 ~ 14  */
/* 802.11b 2312 ~ 2500 MHz, -19 ~ -7, 1 ~ 13  */
/* 802.11a 5120 ~ 5825 MHz, 24 ~ 165   */
#define CHANNEL_INDEX_MAX	230

#define BASIC11G_DOT11		0		/* 1,2 */
#define BASIC11G_DOT11B		1		/* 1,2,5.5,11 */
#define BASIC11G_DOT11G		2		/* 1,2,5.5,11,6,12,24 */
#define BASIC11G_OFDM		3		/* 6,12,24 */
#define BASIC11G_MIN		0
#define BASIC11G_MAX		BASIC11G_OFDM

typedef	struct
{
	A_INT32		lDot11WEPKeyIndex;	// 1-4 is DefaultKey else for Key Mapping
	UINT16		usKeyBitSize;
	UCHAR		puchKey[128/8];
}WEPKeyEntry_t;

typedef	struct
{
	A_INT32			lIndex;
	WLAN_MACADDR	Station;
	A_UINT32		ulIpAddr;
	A_UINT32		ulLastUpdateTime;
#define	DUT_STATUS_UNKNOWN	0
#define	DUT_STATUS_INACTIVE	1
#define	DUT_STATUS_ACTIVE	2
	A_UINT32		ulDutStatus;
	A_INT32			lRssi;
	UINT32			ulAssocTime;
#define STA_MODE_A		0			/* STA operates in 11a mode */
#define STA_MODE_G		1			/* STA operates in 11g mode */
#define STA_MODE_B		2			/* STA operates in 11b mode */
#define STA_MODE_108G	3			/* STA operates in 11g turbo mode */
	A_INT32			lWirelessMode;
} AssocStaEntry_t;

#define XPD_GAIN0	0x00000001
#define XPD_GAIN6	0x00000002
#define XPD_GAIN12	0x00000004
#define XPD_GAIN18	0x00000008

typedef	struct 
{
	A_INT32			lAclIndex;		//  index	of ACL (1..4096)
	WLAN_MACADDR	Station;		//  macaddress of	the	access controled station
#define MACACL_NONE				0x0000
#define MACACL_PRIVACYINVOKED	0x0001
#define MACACL_DENY				0x0002
#define MACACL_DEFAULT			0x0004
#define MACACL_KEY				0x0008
#define MACACL_DEL				0x0010
#define MACACL_SELFUP			0x0020
	A_UINT32		ulACLType;
	A_INT32			lKeyIndex;	//  index	of key(1..2048)								//  valid	only ulACLType = ACLACTION_KEYMAP							
} AccessControlEntry_t;

typedef	struct
{
	A_INT32			lIndex;
	WLAN_MACADDR	BridgeMac;
	// Action
#define	BRIDGE_ACTION_APPEND		0x40000000L
#define	BRIDGE_ACTION_REMOVE_ONE	0x80000000L
#define	BRIDGE_ACTION_REMOVE_ALL	0xF0000000L
	// Status
#define	BRIDGE_STATUS_UNKNOWN	0
#define	BRIDGE_STATUS_INACTIVE	1
#define	BRIDGE_STATUS_ACTIVE	2
	A_UINT32		ulStatusOrAction;
} BridgeEntry_t;

typedef	struct
{
	A_INT32			lIndex;
	WLAN_MACADDR	RemoteAP;
	WLAN_MACADDR	RemoteHost;
} WDSEntry_t;

typedef	struct 
{
	A_INT32			lindex;
	A_UINT32		rssi;
	A_UINT32		channel;
	A_UINT32		wirelessmode;
	A_UINT8			ssid[36];//Max string length is 32
	A_UINT32		isWEP;
	A_UINT8			bssid[6];
	A_UINT32		isWPA;
	A_UINT32		isWPA_PSK;
	A_UINT32		isWPA2;
	A_UINT32		isWPA2_PSK;
}ApScan_t;

typedef	struct
{
#define SCAN_CANCEL		0x0
#define SCAN_START		0x1

#define SCAN_11B		0x01
#define SCAN_11G		0x02
#define SCAN_11A		0x04
#define SCAN_11ATURBO	0x08
#define SCAN_11APRIME	0x10
#define SCAN_11GTURBO	0x20
#define SCAN_ALL		0x3f
	A_UINT32			ScanAction;
#define ACTIVE			0x00
#define PASSIVE			0x01
	A_UINT32			ScanType;
	A_UINT8				wirelessmode;
	A_UINT32			channel;
}ApScanAction_t;

typedef	struct
{
	A_UINT8			ulIndex;
#define	VLAN_DEL	0x01
#define VLAN_UPD	0x02
#define VLAN_ADD	0x04
#define VLAN_NON	0X08
	A_UINT8			uchVlanAction;
	A_UINT16		uchusrp;
	A_UINT16		uspriv;
	A_UINT16		ouspriv;
}VlanEntry_t;

typedef	enum
{
	KEY_SOURCE_LOCAL = 0,
	KEY_SOURCE_SERVER,
	KEY_SOURCE_MIXED
} KeySource_e;

typedef struct
{
	WLAN_MACADDR	Station;
	A_UINT16		usKeyBitSize;
	A_UINT8			puchKey[256/8];
} DynamicKey_t;

typedef struct
{
	A_UINT16		cmd;
	A_UINT16		item;
	A_UINT16		data;
} Zcomcap_t;

typedef	struct
{
	A_UINT32	ulRequestType;
	A_UINT32	ulParam;
	A_UINT32	ulReturn;
} HardwareCapability_t;

typedef struct
{
#define	PRIVATE_IE_REMOVE_ALL		0x00000000
#define	PRIVATE_IE_FOR_BEACON		0x00000001
#define	PRIVATE_IE_FOR_PROBE_RESP	0x00000002
#define	PRIVATE_IE_FOR_BOTH			(PRIVATE_IE_FOR_BEACON|PRIVATE_IE_FOR_PROBE_RESP)
	A_UINT32		ulValidFrameBitmap;	// Valid for Beacon or/and Probe Response.
										// 0 remove all Private IEs
	A_UINT32		ulLength;			// 0 remove, otherwise update or append.
} MgtPrivateIEsHdr_t;

typedef	struct
{
	MgtPrivateIEsHdr_t	Hdr;
	A_UINT8				IEs[3];			// byte-align, actual buffer length depends on ulLength.
} MgtPrivateIEs_t;

typedef struct
{
	// OFDM rates power
	A_UINT8	uchPwr6;
	A_UINT8	uchPwr9;
	A_UINT8	uchPwr12;
	A_UINT8	uchPwr18;
	A_UINT8	uchPwr24;
	A_UINT8	uchPwr36;
	A_UINT8	uchPwr48;
	A_UINT8	uchPwr54;
	// CCK rates power
	A_UINT8	uchPwr1L;
	A_UINT8	uchPwr2L;
	A_UINT8	uchPwr2S;
	A_UINT8	uchPwr5_5L;
	A_UINT8	uchPwr5_5S;
	A_UINT8	uchPwr11L;
	A_UINT8	uchPwr11S;
	// XR's power power
	A_UINT8	uchPwrXR;
} TargetPower_t;

typedef struct
{
#ifdef BIG_ENDIAN
	A_UINT8		rsrv		: 1,
				aci			: 2,
				acm			: 1,
				aifs		: 4;
	A_UINT8		logCwMax	: 4,
				logCwMin	: 4;
#else
	A_UINT8		aifs		: 4,
				acm			: 1,
				aci			: 2,
				rsrv		: 1;
	A_UINT8		logCwMin	: 4,
				logCwMax	: 4;
#endif
	A_UINT16	txOpLimit;
} __ATTRIB_PACK WME_PARAM;

typedef struct {
	A_UINT32		ulMode;
	A_UINT32		ulQueue;
	A_UINT32		ulParamType;
	WME_PARAM		ulParamData;
} WMM_Param_t;

typedef	struct wlanStats_t
{
	struct wlanNetStats_t
	{
		UINT64	ullBytes;

		UINT64	ullPacketsTotal;
		UINT64	ullPacketsUnicast;
		UINT64	ullPacketsMulticast;
		UINT64	ullPacketsBroadcast;

		UINT64	ulPacketsError;
		UINT64	ulPacketsDropped;
	} Rx, Tx;
} wlanStats_t;

#define SIOCGATHSETCOUNTRY					(SIOCDEVPRIVATE + 5)
#define	IEEE80211_IOCTL_STA_INFO			(SIOCDEVPRIVATE + 6)
#define IEEE80211_IOCTL_SCAN_RESULTS		(SIOCDEVPRIVATE + 9)
#define SIOCSIWREQ							(SIOCDEVPRIVATE + 12)
#define SIOCGIWREQ							(SIOCDEVPRIVATE + 13)
#define SIOCGIW_NAME						(SIOCDEVPRIVATE + 14)
#define	IEEE80211_IOCTL_GETCHANINFO			(SIOCIWFIRSTPRIV + 7)
#define SIOCSIWSCAN 						0x8B18
#define	CORRECT_NAME						"ZCom.Madwifi"

#define	IEEE80211_CAPINFO_ESS				0x0001
#define	IEEE80211_CAPINFO_IBSS				0x0002
#define	IEEE80211_CAPINFO_CF_POLLABLE		0x0004
#define	IEEE80211_CAPINFO_CF_POLLREQ		0x0008
#define	IEEE80211_CAPINFO_PRIVACY			0x0010
#define	IEEE80211_CAPINFO_SHORT_PREAMBLE	0x0020
#define	IEEE80211_CAPINFO_PBCC				0x0040
#define	IEEE80211_CAPINFO_CHNL_AGILITY		0x0080
/* bits 8-9 are reserved (8 now for specturm management) */
#define IEEE80211_CAPINFO_SPECTRUM_MGMT		0x0100
#define	IEEE80211_CAPINFO_SHORT_SLOTTIME	0x0400
#define	IEEE80211_CAPINFO_RSN				0x0800
/* bit 12 is reserved */
#define	IEEE80211_CAPINFO_DSSSOFDM			0x2000
/* bits 14-15 are reserved */

#define LE_READ_4(p)							\
	((u_int32_t)								\
	 ((((const u_int8_t *)(p))[0]      ) |		\
	  (((const u_int8_t *)(p))[1] <<  8) |		\
	  (((const u_int8_t *)(p))[2] << 16) |		\
	  (((const u_int8_t *)(p))[3] << 24)))
#define WPA_OUI		0xf25000
#define WPA_OUI_TYPE	0x01
#define	WPA_VERSION	1


/*
 * Management information element payloads.
 */

enum {
	IEEE80211_ELEMID_SSID		= 0,
	IEEE80211_ELEMID_RATES		= 1,
	IEEE80211_ELEMID_FHPARMS	= 2,
	IEEE80211_ELEMID_DSPARMS	= 3,
	IEEE80211_ELEMID_CFPARMS	= 4,
	IEEE80211_ELEMID_TIM		= 5,
	IEEE80211_ELEMID_IBSSPARMS	= 6,
	IEEE80211_ELEMID_COUNTRY	= 7,
	IEEE80211_ELEMID_REQINFO	= 10,
	IEEE80211_ELEMID_CHALLENGE	= 16,
	/* 17-31 reserved for challenge text extension */
	IEEE80211_ELEMID_PWRCNSTR	= 32,
	IEEE80211_ELEMID_PWRCAP		= 33,
	IEEE80211_ELEMID_TPCREQ		= 34,
	IEEE80211_ELEMID_TPCREP		= 35,
	IEEE80211_ELEMID_SUPPCHAN	= 36,
	IEEE80211_ELEMID_CHANSWITCHANN	= 37,
	IEEE80211_ELEMID_MEASREQ	= 38,
	IEEE80211_ELEMID_MEASREP	= 39,
	IEEE80211_ELEMID_QUIET		= 40,
	IEEE80211_ELEMID_IBSSDFS	= 41,
	IEEE80211_ELEMID_ERP		= 42,
	IEEE80211_ELEMID_HTCAP_ANA	= 45,
	IEEE80211_ELEMID_RSN		= 48,
	IEEE80211_ELEMID_XRATES		= 50,
	IEEE80211_ELEMID_HTCAP		= 51,
	IEEE80211_ELEMID_HTINFO		= 52,
	IEEE80211_ELEMID_EXTCHANSWITCHANN = 60,	/* Fix this later as per ANA definition */
	IEEE80211_ELEMID_HTINFO_ANA	= 61,
	IEEE80211_ELEMID_2040_COEXT      = 72,
	IEEE80211_ELEMID_2040_INTOL      = 73,
	IEEE80211_ELEMID_OBSS_SCAN      = 74,
	IEEE80211_ELEMID_EXTCAP		= 127,
	IEEE80211_ELEMID_TPC		= 150,
	IEEE80211_ELEMID_CCKM		= 156,
	IEEE80211_ELEMID_VENDOR		= 221,	/* vendor private */
};

typedef struct zcomioreq
{
	union
	{
		char ifname[IFNAMSIZ];
	}sDevice;
	union
	{
		char	name[IFNAMSIZ];
		struct
		{
			UINT32		MIBCommand;
			UINT32		dataLength;
			INT32		IOReturn;
			void*		data;	//= &IOReqData
		}info;
	}u;
}zcomioreq_t;

#define	IEEE80211_ADDR_LEN	6		/* size of 802.11 address */
#define	IEEE80211_RATE_MAXSIZE	30		/* max rates we'll handle */

struct ieee80211req_sta_info {
	u_int16_t	isi_len;		/* length (mult of 4) */
	u_int16_t	isi_freq;		/* MHz */
	u_int32_t	isi_flags;		/* channel flags */
	u_int16_t	isi_state;		/* state flags */
	u_int8_t	isi_authmode;	/* authentication algorithm */
	int8_t		isi_rssi;
	u_int16_t	isi_capinfo;	/* capabilities */
	u_int8_t	isi_athflags;	/* Atheros capabilities */
	u_int8_t	isi_erp;		/* ERP element */
	u_int8_t	isi_macaddr[IEEE80211_ADDR_LEN];
	u_int8_t	isi_nrates;		/* negotiated rates */
	u_int8_t	isi_rates[IEEE80211_RATE_MAXSIZE];
	u_int8_t	isi_txrate;		/* index to isi_rates[] */
	u_int32_t	isi_txratekbps;         /* tx rate in kbps */
	u_int32_t	isi_rxratekbps;         /* rx rate in kbps */
	u_int16_t	isi_ie_len;		/* IE length */
	u_int16_t	isi_associd;	/* assoc response */
	u_int16_t	isi_txpower;	/* current tx power */
	u_int16_t	isi_vlan;		/* vlan tag */
	u_int16_t	isi_txseqs[17];	/* seq to be transmitted */
	u_int16_t	isi_rxseqs[17];	/* seq previous for qos frames*/
	u_int16_t	isi_inact;		/* inactivity timer */
	u_int8_t	isi_uapsd;		/* UAPSD queues */
	u_int8_t	isi_opmode;		/* sta operating mode */
	u_int8_t	isi_cipher;
	u_int32_t	isi_assoc_time;	/* sta association time */

	u_int16_t	isi_htcap;		/* HT capabilities */
	/* XXX frag state? */
	/* variable length IE data */
	u_int32_t	isi_ipaddr;
#ifdef _ZCOM_INFO_
	char		isi_devname[17];
#endif
	/*add by jxq for more station information start*/
	u_int32_t	isi_acktimeout;
	u_int32_t	isi_CCQ;
	int 		isi_signal;
	int 		isi_noise;
	u_int32_t	isi_rx_frames;
	u_int64_t	isi_rx_bytes;
	u_int32_t	isi_tx_frames;
	u_int64_t	isi_tx_bytes;
	u_int8_t 	isi_tx_retries;
	u_int8_t 	isi_tx_maxretries;
	u_int32_t 	isi_maxtxrate;

/*add by jxq for more station information end*/


};

/*add by jxq for supporting map last rx signal to  rx rate start */
#define MAXRATENUM 30
struct ratemapsignal{
	u_int32_t rateKbps[MAXRATENUM];
	int8_t signal[MAXRATENUM];
	u_int8_t rateNum;
};

struct noderatemapsignal {
	u_int8_t        mac[6];
	struct ratemapsignal rms;
};
/*add by jxq for supporting map last rx signal to  rx rate end */

/*
 *  * Scan result data returned for IEEE80211_IOC_SCAN_RESULTS.
 *   */
struct ieee80211req_scan_result {
	        u_int16_t       isr_len;                /* length (mult of 4) */
	        u_int16_t       isr_freq;               /* MHz */
	        u_int32_t       isr_flags;              /* channel flags */
	        u_int8_t        isr_noise;
	        u_int8_t        isr_rssi;
	        u_int8_t        isr_intval;             /* beacon interval */
	        u_int16_t       isr_capinfo;            /* capabilities */
	        u_int8_t        isr_erp;                /* ERP element */
	        u_int8_t        isr_bssid[IEEE80211_ADDR_LEN];
	        u_int8_t        isr_nrates;
	        u_int8_t        isr_rates[IEEE80211_RATE_MAXSIZE];
	        u_int8_t        isr_ssid_len;           /* SSID length */
	        u_int8_t        isr_ie_len;             /* IE length */
	        u_int8_t        isr_pad[5];
	        /* variable length SSID followed by IE data */
};

struct ieee80211_channel {
	u_int16_t	ic_freq;	/* setting in Mhz */
	u_int32_t	ic_flags;	/* see below */
	u_int8_t	ic_flagext;	/* see below */
	u_int8_t	ic_ieee;	/* IEEE channel number */
	int8_t		ic_maxregpower;	/* maximum regulatory tx power in dBm */
	int8_t		ic_maxpower;	/* maximum tx power in dBm */
	int8_t		ic_minpower;	/* minimum tx power in dBm */
};

#define	IEEE80211_RADAR_11HCOUNT	5
#define	IEEE80211_RADAR_TEST_MUTE_CHAN	36 /* Move to channel 36 for mute test */

/* bits 0-3 are for private use by drivers */
/* channel attributes */
#define IEEE80211_CHAN_RADAR	0x0001	/* Radar found on channel */
#define	IEEE80211_CHAN_TURBO	0x0010	/* Turbo channel */
#define	IEEE80211_CHAN_CCK	0x0020	/* CCK channel */
#define	IEEE80211_CHAN_OFDM	0x0040	/* OFDM channel */
#define	IEEE80211_CHAN_2GHZ	0x0080	/* 2 GHz spectrum channel. */
#define	IEEE80211_CHAN_5GHZ	0x0100	/* 5 GHz spectrum channel */
#define	IEEE80211_CHAN_PASSIVE	0x0200	/* Only passive scan allowed */
#define	IEEE80211_CHAN_DYN	0x0400	/* Dynamic CCK-OFDM channel */
#define	IEEE80211_CHAN_GFSK	0x0800	/* GFSK channel (FHSS PHY) */
#define	IEEE80211_CHAN_DFS  0x1000	/* Radar found on channel */
#define	IEEE80211_CHAN_STURBO	0x2000	/* 11a static turbo channel only */
#define	IEEE80211_CHAN_HALF	0x4000	/* Half rate channel */
#define	IEEE80211_CHAN_QUARTER	0x8000	/* Quarter rate channel */
#define	IEEE80211_CHAN_HT20	0x10000
#define IEEE80211_CHAN_HT40PLUS  0x20000        /* HT 40 with extension channel above */
#define IEEE80211_CHAN_HT40MINUS 0x40000        /* HT 40 with extension channel below */
#define IEEE80211_CHAN_HT40INTOL 0x80000        /* HT 40 Intolerant */

/* flagext */
#define	IEEE80211_CHAN_DFS_CLEAR	0x0008	/* if channel has been checked for DFS */
#define	IEEE80211_CHAN_11D_EXCLUDED     0x0010	/* excluded in 11D */
#define IEEE80211_CHAN_DISALLOW_ADHOC   0x0040  /* ad-hoc is not allowed */
#define IEEE80211_CHAN_EDGE_CH          0x0080  /* Edge Channel */

/*
 * Useful combinations of channel characteristics.
 */
#define	IEEE80211_CHAN_FHSS \
	(IEEE80211_CHAN_2GHZ | IEEE80211_CHAN_GFSK)
#define	IEEE80211_CHAN_A \
	(IEEE80211_CHAN_5GHZ | IEEE80211_CHAN_OFDM)
#define	IEEE80211_CHAN_B \
	(IEEE80211_CHAN_2GHZ | IEEE80211_CHAN_CCK)
#define	IEEE80211_CHAN_PUREG \
	(IEEE80211_CHAN_2GHZ | IEEE80211_CHAN_OFDM)
#define	IEEE80211_CHAN_G \
	(IEEE80211_CHAN_2GHZ | IEEE80211_CHAN_DYN)
#define IEEE80211_CHAN_108A \
	(IEEE80211_CHAN_5GHZ | IEEE80211_CHAN_OFDM | IEEE80211_CHAN_TURBO)
#define	IEEE80211_CHAN_108G \
	(IEEE80211_CHAN_2GHZ | IEEE80211_CHAN_OFDM | IEEE80211_CHAN_TURBO)
#define	IEEE80211_CHAN_ST \
	(IEEE80211_CHAN_108A | IEEE80211_CHAN_STURBO)

#define IEEE80211_CHAN_11NG_HT20 \
        (IEEE80211_CHAN_2GHZ | IEEE80211_CHAN_HT20)
#define IEEE80211_CHAN_11NA_HT20 \
        (IEEE80211_CHAN_5GHZ | IEEE80211_CHAN_HT20)
#define IEEE80211_CHAN_11NG_HT40PLUS \
        (IEEE80211_CHAN_2GHZ | IEEE80211_CHAN_HT40PLUS)
#define IEEE80211_CHAN_11NG_HT40MINUS \
        (IEEE80211_CHAN_2GHZ | IEEE80211_CHAN_HT40MINUS)
#define IEEE80211_CHAN_11NA_HT40PLUS \
        (IEEE80211_CHAN_5GHZ | IEEE80211_CHAN_HT40PLUS)
#define IEEE80211_CHAN_11NA_HT40MINUS \
        (IEEE80211_CHAN_5GHZ | IEEE80211_CHAN_HT40MINUS)
#define IEEE80211_CHAN_11NG_HT40 \
        (IEEE80211_CHAN_11NG_HT40PLUS | IEEE80211_CHAN_11NG_HT40MINUS)
#define IEEE80211_CHAN_11NA_HT40 \
        (IEEE80211_CHAN_11NA_HT40PLUS | IEEE80211_CHAN_11NA_HT40MINUS)

#define	IEEE80211_CHAN_ALL \
	(IEEE80211_CHAN_2GHZ | IEEE80211_CHAN_5GHZ | IEEE80211_CHAN_HT20 | IEEE80211_CHAN_GFSK | \
	 IEEE80211_CHAN_CCK | IEEE80211_CHAN_OFDM | IEEE80211_CHAN_DYN | IEEE80211_CHAN_HT40PLUS |IEEE80211_CHAN_HT40MINUS)
#define	IEEE80211_CHAN_ALLTURBO \
	(IEEE80211_CHAN_ALL | IEEE80211_CHAN_TURBO | IEEE80211_CHAN_STURBO)

#define	IEEE80211_IS_CHAN_FHSS(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_FHSS) == IEEE80211_CHAN_FHSS)
#define	IEEE80211_IS_CHAN_A(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_A) == IEEE80211_CHAN_A)
#define	IEEE80211_IS_CHAN_B(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_B) == IEEE80211_CHAN_B)
#define	IEEE80211_IS_CHAN_PUREG(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_PUREG) == IEEE80211_CHAN_PUREG)
#define	IEEE80211_IS_CHAN_G(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_G) == IEEE80211_CHAN_G)
#define	IEEE80211_IS_CHAN_ANYG(_c) \
	(IEEE80211_IS_CHAN_PUREG(_c) || IEEE80211_IS_CHAN_G(_c))
#define	IEEE80211_IS_CHAN_ST(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_ST) == IEEE80211_CHAN_ST)
#define	IEEE80211_IS_CHAN_108A(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_108A) == IEEE80211_CHAN_108A)
#define	IEEE80211_IS_CHAN_108G(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_108G) == IEEE80211_CHAN_108G)

#define	IEEE80211_IS_CHAN_2GHZ(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_2GHZ) != 0)
#define	IEEE80211_IS_CHAN_5GHZ(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_5GHZ) != 0)
#define	IEEE80211_IS_CHAN_OFDM(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_OFDM) != 0)
#define	IEEE80211_IS_CHAN_CCK(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_CCK) != 0)
#define	IEEE80211_IS_CHAN_GFSK(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_GFSK) != 0)
#define	IEEE80211_IS_CHAN_TURBO(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_TURBO) != 0)
#define	IEEE80211_IS_CHAN_STURBO(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_STURBO) != 0)
#define	IEEE80211_IS_CHAN_DTURBO(_c) \
	(((_c)->ic_flags & \
	(IEEE80211_CHAN_TURBO | IEEE80211_CHAN_STURBO)) == IEEE80211_CHAN_TURBO)
#define	IEEE80211_IS_CHAN_HALF(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_HALF) != 0)
#define	IEEE80211_IS_CHAN_QUARTER(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_QUARTER) != 0)
#define	IEEE80211_IS_CHAN_RADAR(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_RADAR) != 0)
#define IEEE80211_IS_CHAN_11D_EXCLUDED(_c) \
        (((_c)->ic_flagext & IEEE80211_CHAN_11D_EXCLUDED) != 0)

#define	IEEE80211_IS_CHAN_11NG_HT20(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_11NG_HT20) == IEEE80211_CHAN_11NG_HT20 && ((_c)->ic_flags & (IEEE80211_CHAN_HALF | IEEE80211_CHAN_QUARTER)) == 0)
#define	IEEE80211_IS_CHAN_11NA_HT20(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_11NA_HT20) == IEEE80211_CHAN_11NA_HT20 && ((_c)->ic_flags & (IEEE80211_CHAN_HALF | IEEE80211_CHAN_QUARTER)) == 0)
#define	IEEE80211_IS_CHAN_11NG_HT40PLUS(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_11NG_HT40PLUS) == IEEE80211_CHAN_11NG_HT40PLUS && ((_c)->ic_flags & (IEEE80211_CHAN_HALF | IEEE80211_CHAN_QUARTER)) == 0)
#define	IEEE80211_IS_CHAN_11NG_HT40MINUS(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_11NG_HT40MINUS) == IEEE80211_CHAN_11NG_HT40MINUS && ((_c)->ic_flags & (IEEE80211_CHAN_HALF | IEEE80211_CHAN_QUARTER)) == 0)
#define	IEEE80211_IS_CHAN_11NA_HT40PLUS(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_11NA_HT40PLUS) == IEEE80211_CHAN_11NA_HT40PLUS && ((_c)->ic_flags & (IEEE80211_CHAN_HALF | IEEE80211_CHAN_QUARTER)) == 0)
#define	IEEE80211_IS_CHAN_11NA_HT40MINUS(_c) \
	(((_c)->ic_flags & IEEE80211_CHAN_11NA_HT40MINUS) == IEEE80211_CHAN_11NA_HT40MINUS && ((_c)->ic_flags & (IEEE80211_CHAN_HALF | IEEE80211_CHAN_QUARTER)) == 0)

#define	IEEE80211_IS_CHAN_11N(_c) \
	(((_c)->ic_flags & (IEEE80211_CHAN_HT20 | IEEE80211_CHAN_HT40PLUS | IEEE80211_CHAN_HT40MINUS)) != 0 && ((_c)->ic_flags & (IEEE80211_CHAN_HALF | IEEE80211_CHAN_QUARTER)) == 0)
#define	IEEE80211_IS_CHAN_11N_HT20(_c) \
	(((_c)->ic_flags & (IEEE80211_CHAN_HT20)) != 0 && ((_c)->ic_flags & (IEEE80211_CHAN_HALF | IEEE80211_CHAN_QUARTER)) == 0)
#define	IEEE80211_IS_CHAN_11N_HT40(_c) \
	(((_c)->ic_flags & (IEEE80211_CHAN_HT40PLUS | IEEE80211_CHAN_HT40MINUS)) != 0 && ((_c)->ic_flags & (IEEE80211_CHAN_HALF | IEEE80211_CHAN_QUARTER)) == 0)
#define	IEEE80211_IS_CHAN_11NG(_c) \
	(IEEE80211_IS_CHAN_2GHZ((_c)) && IEEE80211_IS_CHAN_11N((_c)))
#define	IEEE80211_IS_CHAN_11NA(_c) \
	(IEEE80211_IS_CHAN_5GHZ((_c)) && IEEE80211_IS_CHAN_11N((_c)))

#define IEEE80211_IS_CHAN_HT20_CAPABLE(_c) \
     ( ((_c)->ic_flags & IEEE80211_CHAN_HT20) == IEEE80211_CHAN_HT20 )
#define IEEE80211_IS_CHAN_HT40PLUS_CAPABLE(_c) \
     ( ((_c)->ic_flags & IEEE80211_CHAN_HT40PLUS) == IEEE80211_CHAN_HT40PLUS )
#define IEEE80211_IS_CHAN_HT40MINUS_CAPABLE(_c) \
     ( ((_c)->ic_flags & IEEE80211_CHAN_HT40MINUS) == IEEE80211_CHAN_HT40MINUS )
#define IEEE80211_IS_CHAN_HT40_CAPABLE(_c) \
     ( IEEE80211_IS_CHAN_HT40PLUS_CAPABLE(_c) || IEEE80211_IS_CHAN_HT40MINUS_CAPABLE(_c) )
#define IEEE80211_IS_CHAN_HT_CAPABLE(_c) \
     ( IEEE80211_IS_CHAN_HT20_CAPABLE(_c) || IEEE80211_IS_CHAN_HT40_CAPABLE(_c) )
#define IEEE80211_IS_CHAN_11N_CTL_CAPABLE(_c)  IEEE80211_IS_CHAN_HT20_CAPABLE(_c)
#define IEEE80211_IS_CHAN_11N_CTL_U_CAPABLE(_c) \
     ( ((_c)->ic_flags & IEEE80211_CHAN_HT40PLUS) == IEEE80211_CHAN_HT40PLUS )
#define IEEE80211_IS_CHAN_11N_CTL_L_CAPABLE(_c) \
     ( ((_c)->ic_flags & IEEE80211_CHAN_HT40MINUS) == IEEE80211_CHAN_HT40MINUS )
#define IEEE80211_IS_CHAN_11N_CTL_40_CAPABLE(_c) \
     ( IEEE80211_IS_CHAN_11N_CTL_U_CAPABLE((_c)) || IEEE80211_IS_CHAN_11N_CTL_L_CAPABLE((_c)) )
#define IEEE80211_IS_CHAN_DFS_REQUIRED(_c) \
     ( ((_c)->ic_flags & IEEE80211_CHAN_DFS) == IEEE80211_CHAN_DFS )
#define IEEE80211_GET_BCAST_ADDR(_c)  ((_c)->ic_dev->broadcast)

/* mode specific macros */


#define IEEE80211_IS_11NG_MODE(_mode) \
                (((_mode) == IEEE80211_MODE_11NG_HT20) ||  \
                ((_mode) == IEEE80211_MODE_11NG_HT40PLUS) || ((_mode) == IEEE80211_MODE_11NG_HT40MINUS))

#define IEEE80211_IS_11NA_MODE(_mode) \
                (((_mode) == IEEE80211_MODE_11NA_HT20) ||  \
                ((_mode) == IEEE80211_MODE_11NA_HT40PLUS) || ((_mode) == IEEE80211_MODE_11NA_HT40MINUS))

#define IEEE80211_IS_11N_MODE(_mode) \
                (IEEE80211_IS_11NA_MODE((_mode)) || IEEE80211_IS_11NG_MODE((_mode)))

struct chanpower_info_t{
	u_int32_t freq;	// channel freq
	u_int32_t flags;// channel flags
	u_int8_t min;	// min power of this channel
	u_int8_t nonht;	// power of non-HT
	u_int8_t ht20;	// power of HT20 mode
	u_int8_t ht40;	// power of HT40 mode, if == 0,means not exist ht40 mode
	u_int8_t quarter;//
	u_int8_t half;	//
};
struct ieee80211req_chanpowers_t{
	u_int	ic_nchanpowers;
	struct chanpower_info_t ic_chanpowers[255];
};

#define	MAX_DATA_LEN	64
typedef	union IOReqData
{
	A_UINT8					a_uchar;
	UINT16					a_uint16;
	UINT32					a_uint32;
	WLAN_MACADDR			Station;
	VlanEntry_t				VlanEntry;
	BridgeEntry_t			BridgeEntry;
	WEPKeyEntry_t			WEPKeyEntry;
	DynamicKey_t			DynamicKey;
	Zcomcap_t				Zcomcap;
	AssocStaEntry_t			AssocStaEntry;
	AccessControlEntry_t	AccessControlEntry;
	WDSEntry_t				WDSEntry;
	ApScan_t				ApScanEntry;
	ApScanAction_t			ApScanAtion;
	WMM_Param_t				WMP;
	wlanStats_t				wlanStats;
	HardwareCapability_t	HwCapability;
	MgtPrivateIEs_t			MgtPrivateIEs;
	TargetPower_t			TargetPower;
	A_UINT8					puchData[MAX_DATA_LEN];
	A_UINT16				pusData[MAX_DATA_LEN/sizeof(A_UINT16)];
	struct ieee80211req_chanpowers_t	chanPowerInfo;
}IOReqData;

#endif//_DOT11_MIB_H_
