/*
 *	DhcpcMsg.h
 */
#ifndef	__DHCPCMSG_H__
#define	__DHCPCMSG_H__

#include <stdint.h>

// UDP loop back port number
#define	DHCPC_LOOPBACK_PORT		9000	// TBD

typedef enum DhcpcMsgType_t
{
	DHCPC_MSG_INVALID = 0,
	DHCPC_MSG_INTERFACE_CONFIG,
	DHCPC_MSG_INTERFACE_STATUS,
	DHCPC_MSG_INTERFACE_LIST,
} DhcpcMsgType_t;

typedef enum DhcpcConfigStatus_t
{
	DHCPC_CONFIG_DISABLE = 0,	// Manual IP setting
	DHCPC_CONFIG_ENABLE,		// Default IP setting
	DHCPC_CONFIG_REMOVE,		// Ignore followed IP setting

	DHCPC_STATUS_DISABLE = 0,	// Manual IP setting
	DHCPC_STATUS_LINKING,		// Default IP setting 
	DHCPC_STATUS_OBTAINED,		// IP setting from DHCP server
								// obtained the IP Setting from DHCP server
	DHCPC_STATUS_IF_OVERFLOW,	// Max interface number reached.
	DHCPC_STATUS_IF_MISSED = 0x80000000,	// Interface not found.
} DhcpcConfigStatus_t;

typedef	uint32_t IPAddr_t;
#define	DHCPC_EMPTY_IP		((IPAddr_t)0)

typedef	char DhcpcIfName_t[16];

typedef	struct DhcpcIPSetting_t
{
	IPAddr_t	ulIP;
	IPAddr_t	ulNetmask;
	IPAddr_t	ulGateway;
#define	DHCP_CLIENT_MAX_DNS_NUM		2
	IPAddr_t	ulDNS[DHCP_CLIENT_MAX_DNS_NUM];
} DhcpcIPSetting_t;

// Config Message and Status Message
typedef struct DhcpcMsgConfigStatus_t
{
	uint32_t			ulMsgType;		// refer to DhcpcMsgType_t
	DhcpcIfName_t		szIfName;
	uint32_t			ulConfigStatus;	// refer to DhcpcConfigStatus_t
	DhcpcIPSetting_t	IPSetting;
} DhcpcMsgConfigStatus_t;

// Interface List
typedef struct DhcpcMsgInterfaceList_t
{
	uint32_t			ulMsgType;
	uint32_t			ulIfCount;
#define	DHCPC_MAX_INTERFACE_NUM		16
	DhcpcIfName_t		szIfName[DHCPC_MAX_INTERFACE_NUM];
} DhcpcMsgInterfaceList_t;

#endif//!__DHCPCMSG_H__
