#ifndef _DHCLIGDF_H_
#define _DHCLIGDF_H_

#define    MAX_DHCP_OPTIONS	              256
#define    MAX_BIT_POS                        8
#define    MAX_OPTION_BYTES                   32
#define    MAX_DHCPC_STATE_LEN                28 
#define    DHCPC_TIMEBUF_LEN                  40



#define   SUBNET_MASK                        1
#define   TIME_OFFSET                        2  
#define   DEFAULT_ROUTER_IP                  3
#define   DHCPC_TIME_SERVER_IP               4
#define   DHCPC_LOG_SERVER_IP                7
#define   DHCPC_DEFAULT_TTL                  23
#define   DHCPC_INTERFACE_MTU                26
#define   DHCPC_REQ_IP_ADDRESS               50
#define   DHCPC_IP_LEASE                     51
#define   DHCPC_SERVER_ID                    54
#define   DHCPC_OPT_177                      177
                 


 
#define   MAX_DEFAULT_ROUTERS                4
#define   MAX_TIME_SERVER_IPADDR             4
#define   MAX_LOG_SERVER_IPADDR              4
#define   DHCPC_DOMAIN_NAME                  15
#define   DNS_SERVER_IP                      6  
#define   MAX_DNS_SERVER_IPADDR              2
#define   BROADCAST_ADDRESS                  28
#define   IPADDR_LEASED_TIME                 51  
#define   WIN_SERVER_IPADDR                  44
#define   REQUESTED_IPADDR_OPCODE            50 
#define   END_OPTION                         255
#define   PADDING_OPTION                     0
#define   TotArpUpCheckTime                  3
#define   MAX_DHCP_HOST_NAME                 128
#define   BOOTP_PORT                         67
#define   DHCPC_MANAGER_ID                   0



typedef struct DHCPClientGlbFds_s
{
  T_INT32 iKickEventSockFd;
  T_INT32 iSocketFd; 
}DHCPClientGlbFds_t;

/* Added  by Gopi 0n May 24 */
typedef struct DHCPClientGlobCtrlCb_s
{
   T_UINT32 ulSockAddr;
   T_UINT16 usSockPort;
}DHCPClientGlobCtrlCb_t;


/* Added  by Gopi 0n May 24 */
typedef struct DHCPCIpAddressInfo_s
{
   ipaddr    ulClientIpAddress;
   ipaddr    ulServerIpAddress;
   T_UINT16  usClientPort;
   T_UINT16  usServerPort;
}DHCPCIpAddressInfo_t;

#define   MAX_VALID_MAC_ADDR_LEN   6

typedef struct DHCPCIntfInfo_s
{
  #define SERV_PORT 9000
  #define SERV_ADDR "127.0.0.1"
  T_UINT8  ucType;
     #define DHCP_CLIENT_KICK_UP                0x1
     #define DHCP_CLIENT_KICK_DOWN              0x2 
     #define DHCP_CLIENT_KICK_RELEASE           0x04 
     
  T_UCHAR8 ucInfName[MAX_INTERFACE_NAMELEN+1];   
  T_UINT32 uiOpaqueId;
}DHCPCIntfInfo_t;


/*** Padmalatha ---- moved here from IGW_IFACE  ****/
typedef struct  DHCPGlobalFields_s
{ 
  T_BOOL8           bObtainDynamic;
  ipaddr            DnsIpAddrs[MAX_DNS_SERVER_IPADDR];
  ipaddr            DefaultGwIps[MAX_DEFAULT_ROUTERS];
  ipaddr            WinServerIpAddr;
  T_UCHAR8          ucOptions[MAX_OPTION_BYTES];
  T_BOOL8           bOptionsInUse;
}DHCPGlobalFields_t;

typedef struct  DHCPClientRecordInfo_s
{
  T_CHAR8    InterfaceName[MAX_INTERFACE_NAMELEN +1];
  T_UCHAR8   ucCurrentState[MAX_DHCPC_STATE_LEN + 1];
  ipaddr     DHCPServerIpAddr;
  ipaddr     ulIpAddr;
  ipaddr     ulMask;
  ipaddr     ulBcast;
  ipaddr     ulGwIp[MAX_DEFAULT_ROUTERS];
  ipaddr     ulDnsIp[MAX_DNS_SERVER_IPADDR];
  T_UINT32   ulLeasedTime;
  T_CHAR8    ucTimeBuf[DHCPC_TIMEBUF_LEN+1];
  T_INT32    iContextId;
  T_UINT32   uiOpaqueId;

}DHCPClientRecordInfo_t;

/*DHCP CLIENT STATES*/
typedef enum DHCPClientStates_s
{
  DHCP_CLIENT_INITIALIZED,            
  DHCP_CLIENT_SELECT,                 
  DHCP_CLIENT_REQUEST,                
  DHCP_CLIENT_ARP_AWAIT,              
  DHCP_CLIENT_BOUND,                 
  DHCP_CLIENT_RENEW,                  
  DHCP_CLIENT_REBIND,
  DHCP_CLIENT_RELEASE,
  DHCP_CLIENT_TIMEOUT
}DHCPClientStates_t;

typedef struct DHCPClientFunctionInfo_s
{
  T_INT32 (*InfLookUp)(T_CHAR8* pIfaceName,
                       T_UINT32 uiOpaqueId);

  T_VOID (*GetHwaddr)(T_UCHAR8 *hw,
                      T_CHAR8 *pIfaceName,
                      T_UINT32 uiOpaqueId);

  T_INT32 (*GetArp)(T_CHAR8 *iface,
                    T_UINT32 ip, 
                    T_UINT32 uiOpaqueId);

  T_INT32 (*SendArp)(T_CHAR8 *ifname,
                     T_UCHAR8 *haddr,
					 T_UINT32 source,
					 T_UINT32 dest,
					 T_UINT32 uiOpaqueId);

  T_INT32 (*SetInfParams)(T_CHAR8 *IfaceName, 
                          DHCPGlobalFields_t *pDHCPClientGlobFd, 
                          T_UINT32  ip, 
                          T_UINT32 net, 
                          T_UINT32 broad, 
                          T_UINT32 uiOpaqueId);

  T_INT32 (*GetInfParams)(T_CHAR8* InterfaceName,
                          T_UINT32 uiOpaqueId,
                          ipaddr*  ulIpAddr,
                          ipaddr*  ulMask,
                          ipaddr*  ulBcast,
                          ipaddr*  ulGwIp, 
                          ipaddr*  ulDnsIp);   

  T_INT32 (*SetOptions)(T_CHAR8 *IfaceName, 
                        T_UCHAR8 *ReplyBuf, 
                        T_CHAR8  MsgType,
                        T_UINT32   ulTotOpBufLen,
						DHCPGlobalFields_t *pDhcpGlbFld,
                        T_UINT32 TftpIp,
                        T_UCHAR8 *pFileName,
                        T_UINT32 uiOpaqueId);

  T_INT32 (*SendPacket)(T_CHAR8 *pIfaceName,
                        T_UCHAR8 *data,
						T_UINT32 len,
						ipaddr source, 
                        ipaddr dest);

  T_INT32  (*UpdateInfo)(T_CHAR8*  pIfaceName,
                         T_UINT32 uiOpaqueId);

  T_VOID (*DeleteIfaceParams)(T_CHAR8 *pIfaceName,
                              T_UINT32 uiOpaqueId,
                              DHCPGlobalFields_t *DhcpGlbFld);

  T_VOID (*StateChangeEvent)(T_CHAR8 *pIfaceName,
                             T_UINT32 uiOpaqueId,
			     T_UCHAR8 ucOldState,
			     T_UCHAR8 ucNewState);

  T_VOID (*FillOptions)(T_CHAR8 *pIfaceName,
                        T_UINT32 uiOpaqueId,
                        T_UCHAR8 *pData,
                        T_UINT32 *uiDataLen,
                        T_UCHAR8 ucDHCPMsgType);

  T_INT32 (*SelectOffer)(T_CHAR8 *pIfaceName,
                         T_UINT32 uiOpaqueId,
                         T_UCHAR8 *pData,
                         T_INT32 iDataLen);
  
}DHCPClientFunctionInfo_t;


#endif
