// os_string.c
//

#include <string.h>

#include "os_type.h"

#include "os_string.h"

///////////////////////////////////////////////////////////////////////////////
// Token routines
///////////////////////////////////////////////////////////////////////////////
#define	CHARS_MAP_BYTES	(1<<5)	//(1<<8)/8

static const char s_cszWhiteSpace[] = " \t\r\n";

static __inline void CharsIntoMap(const uint8_t *cszChars, uint8_t *pCharsMap)
{
	if (NULL==cszChars)
	{
		cszChars = s_cszWhiteSpace;
	}

	while ('\0'!=*cszChars)
	{
		pCharsMap[*cszChars >> 3] |= (1<<(*cszChars & 7));
		cszChars++;
	}
}

static __inline bool_t IsCharInMap(uint8_t uchChar, const uint8_t *cpCharsMap)
{
	return 0!=(cpCharsMap[uchChar>>3]&(1<<(uchChar & 7)));
}

char*	OsStrFindChars(const char *cszString, const char *cszChars)
{
	uint8_t	CharsMap[CHARS_MAP_BYTES] = {0};

	CharsIntoMap(cszChars, CharsMap);
	while ('\0'!=*cszString)
	{
		if (IsCharInMap(*cszString, CharsMap))
		{
			return (char*)cszString;
		}
		cszString++;
	}
	return NULL;
}

char*	OsStrTrimLeft(const char *cszString, const char *cszTrimChars)
{
	uint8_t	CharsMap[CHARS_MAP_BYTES] = {0};

	CharsIntoMap(cszTrimChars, CharsMap);
	while ('\0'!=*cszString && IsCharInMap(*cszString, CharsMap))
	{
		cszString++;
	}
	return (char*)cszString;
}

char*	OsStrtoken(char *cszString, const char *cszDelimit, char **pszNext)
{
	uint8_t	CharsMap[CHARS_MAP_BYTES] = {0};
	char	*szToken = NULL;

	if (NULL==cszString)
	{
		return NULL;
	}

	CharsIntoMap(cszDelimit, CharsMap);
	// Trim Left
	while ('\0'!=*cszString && IsCharInMap(*cszString, CharsMap))
	{
		cszString++;
	}

	if ('\0'==*(szToken=cszString))
	{
		return NULL;
	}

	while ('\0'!=*cszString && !IsCharInMap(*cszString, CharsMap))
	{
		cszString++;
	}

	if (NULL!=pszNext)
	{
		*pszNext = ('\0'!=*cszString)?(cszString+1):cszString;
	}
	*cszString = '\0';
	return szToken;
}
