// os_network.h
//

#ifndef	__OS_NETWORK_H__
#define	__OS_NETWORK_H__

#ifdef	WIN32
#define WIN32_LEAN_AND_MEAN
#include <winsock2.h>
#else//Linux
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>

#include <features.h>    /* for the glibc version number */
#if __GLIBC__ >= 2 && __GLIBC_MINOR >= 1
#include <netpacket/packet.h>
#include <net/ethernet.h>     /* the L2 protocols */
#else
#include <asm/types.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>   /* The L2 protocols */
#include <linux/if.h>
#endif

#endif//!WIN32

#include "os_type.h"

///////////////////////////////////////////////////////////////////////////////
// basic network routines
///////////////////////////////////////////////////////////////////////////////
#ifdef	WIN32
typedef	SOCKET	OsSocket_t;
#else
typedef	int	OsSocket_t;
#endif//!WIN32

#define	OS_INVALID_SOCKET		((OsSocket_t)(-1))
#define	OS_SOCKET_RETRY_TIMES	5

OsSocket_t	OsSocketOpen(int iAddrFamily, int iType, int iProtocol);
bool_t	OsSocketClose(OsSocket_t Socket);

bool_t OsConnect(OsSocket_t Socket, const struct sockaddr *pRemoteAddr, int	iAddrLen, int* iErrNo);
bool_t OsConnectInternet(OsSocket_t Socket, uint32_t ulRemoteIP, uint16_t usPort);

bool_t	OsBind(OsSocket_t Socket, const struct sockaddr *pAddr, int iAddrLen);
bool_t	OsBindInternet(OsSocket_t Socket, uint32_t ulIP, uint16_t usPort);
bool_t	OsGetIfInfoByName(const char* cszIfName, int32_t* piIfIndex, MacAddr_t MacAddr);
bool_t	OsBindIfNameOnRAWPkt(OsSocket_t Socket, const char* cszIfName);

bool_t	OsListen(OsSocket_t Socket, int iBacklog);

OsSocket_t	OsAccept(OsSocket_t Socket, struct sockaddr *pAddr, int *pAddrLen);
OsSocket_t	OsAcceptInternet(OsSocket_t Socket, uint32_t *pulIP, uint16_t *pusPort);

int32_t	OsRecv(OsSocket_t Socket, void *pBuf, int32_t iLen, int iFlags);
int32_t	OsSend(OsSocket_t Socket, const void *pBuf, int32_t iLen, int iFlags);

int32_t	OsRecvFrom(OsSocket_t Socket, void *pBuf, int32_t iLen, int iFlags, 
				   struct sockaddr *From, int32_t *iFromLen);
int32_t OsSendTo(OsSocket_t Socket, const void *pBuf, int32_t iLen,
				 int iFlags, uint32_t ulRemoteIP, uint16_t usPort);
///////////////////////////////////////////////////////////////////////////////
// socket test routines
///////////////////////////////////////////////////////////////////////////////

bool_t	OsIsPacketIncoming(OsSocket_t Socket, uint32_t ulTimeout/*in ms*/);

#endif//!__OS_NETWORK_H__
