// os_mem.h
//

#ifndef	__OS_MEM_H__
#define	__OS_MEM_H__

#include "os_type.h"

void *OsMemNew(uint32_t ulSize, bool_t fZero);
void OsMemFree(void *pMem);
void OsListFree(void *pList, void (*NodeClean)(void *pList));
void OsTreeFree(void *pTree, void (*NodeClean)(void *pTree));

char *OsStrdup(const char *cszStr, int32_t lLen);

int32_t	OsStrcasecmp(const char *cszStr1, const char *cszStr2);
int32_t	OsStrncasecmp(const char *cszStr1, const char *cszStr2, uint32_t ulSize);

int32_t		OsStrToInt32(const char *cszString);
uint32_t	OsStrToUint32(const char *cszString);

#endif//!__OS_MEM_H__
