// os_file.h
//

#ifndef	__OS_FILE_H__
#define	__OS_FILE_H__

#include "os_type.h"

typedef	void*	OsFile_t;

const char*	OsFileName(const char *cszFullFileName);

OsFile_t	OsFileOpen(const char *cszFileName, const char *cszOpenMode);
void		OsFileClose(OsFile_t FileHandle);

uint32_t	OsGetFileSize(const char *cszFile, bool_t fIsText);
uint8_t*	OsGetFileContent(const char *cszFile, bool_t fIsText);

char*	OsGetCurrentDirectory(void);
bool_t	OsSetCurrentDirectory(const char *cszPath);

typedef	struct OsFileEntry_t
{
	struct OsFileEntry_t	*pNext;
	struct OsFileEntry_t	*pChild;
	char					szFileName[4]; // or directory name
} OsFileEntry_t;

// cszPath=NULL, list current directory
// szFileName=NULL, list all files and subdir
// lDepth<0, List subdir
// lDepth=0, only current directory
// lDepth=1, ...
OsFileEntry_t*	OsGetFileList(
	const char	*cszPath,
	const char	*szFileName,
	int32_t		lDepth
	);

void OsFileEntryFree(OsFileEntry_t *pEntry);

#endif//!__OS_FILE_H__
