/*
 *  SystemManage MIB group implementation - systemManage.c
 *
 */

#include <config.h>
#include <sys/reboot.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <sys/reboot.h>
#include <unistd.h>

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#if HAVE_WINSOCK_H
#include <winsock.h>
#endif

# if HAVE_SYS_TIME_H
#  include <sys/time.h>
#endif

#include <ctype.h>
#if HAVE_UTSNAME_H
#include <utsname.h>
#else
#if HAVE_SYS_UTSNAME_H
#include <sys/utsname.h>
#endif
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_DMALLOC_H
#include <dmalloc.h>
#endif


/* mibincl.h contains all the snmp specific headers to define the
   return types and various defines and structures. */
#include "mibincl.h"

/* header_generic() comes from here */
#include "util_funcs.h"

#include "agent_read_config.h"

#include "read_config.h"

/* include our .h file */
#include "systemManage.h"

//////////////////////Yichun Dec 14 2005////////////////////////////////////////////

#include "../../../../goahead-2.1.1/LINUX/apmib.h"
#include "../../../../goahead-2.1.1/LINUX/mibtbl.h"

/////////////////////////////////////////////////////////////

 /*********************
         *
         *  Kernel & interface information,
         *   and internal forward declarations
         *
         *********************/



	/*********************
	 *
	 *  Initialisation & common implementation functions
	 *
	 *********************/

/* define the structure we're going to ask the agent to register our
   information at */
struct variable2 systemManage_variables[] = {
    {sysConfigSave, ASN_INTEGER, RWRITE, var_systemManage, 1, {1}},
    {sysReboot, ASN_INTEGER , RWRITE,  var_systemManage, 1, {2}},
    {sysConfigApply, ASN_INTEGER, RWRITE, var_systemManage, 1, {3}},
    {resetToFactoryDefault, ASN_INTEGER, RWRITE,  var_systemManage , 1, {4}},
    {clearCounters, ASN_INTEGER, RWRITE, var_systemManage, 1, {5}},
};

/* Define the OID pointer to the top of the mib tree that we're
   registering underneath */
oid systemManage_variables_oid[] = { 1,3,6,1,4,1,14125,6 };


void init_systemManage(void)
{
/* register ourselves with the agent to handle our mib tree */
  REGISTER_MIB("senaoMIB/systemManage", systemManage_variables, variable2, systemManage_variables_oid);
}

        /*********************
         *
         *  System specific implementation functions
         *

         *********************/

//////////////////////////////////////////////////////

u_char  *
var_systemManage(struct variable *vp,
           oid *name,
           size_t *length,
           int exact,
           size_t *var_len,
           WriteMethod **write_method)
{
  
    if (header_generic(vp, name, length, exact, var_len, write_method) == MATCH_FAILED )
        return NULL;    

///////////////////YiChun Dec 13  2005/////////////////////////////////////////
    if ( !apmib_init()) {
                        printf("Initialize AP MIB failed!\n");
                        return 0;
                }   

//	printf("Initialize AP MIB success!\n");                                                                                            
///////////////////////////////////////////////////////////////////////////////
    switch (vp->magic){
        case sysConfigSave:
	     *write_method = write_systemManageint;
	     long_return = 0;
	     return(u_char*)&long_return;

	case sysReboot:
	     *write_method = write_systemManageint;
//             printf("get\n");
//             sleep(5);
  //           pthread_create(&tid, NULL, reboot_thread, arg);
	      //if( !reboot( RB_AUTOBOOT )){
//                            printf("reboot failed!\n");
//                            return 0;
                //        }

	     long_return = 0;
	     return(u_char*)&long_return;
	   
//	case sysConfigApply:

	case resetToFactoryDefault:
	     *write_method = write_systemManageint;
	     long_return = 0;
	     return(u_char*)&long_return;

//	case clearCounters:


	default:
            DEBUGMSGTL(("snmpd", "unknown sub-id %d in var_systemManage\n", vp->magic));
    }
    return NULL;
}

        /*********************
         *
         *  Writeable object SET handling routines
         *
         *********************/
int
write_systemManageint(int    action,
                 u_char *var_val,
                 u_char var_val_type,
                 size_t var_val_len,
                 u_char *statP,
                 oid    *name,
                 size_t name_len)
{
                                                                                
    static long intval;
    static long old_intval;
    int val;
    char *ptr=NULL;                                                                                
                                                                                
    switch ( action )
    {
        case RESERVE1:
                        /*
                         *  Check that the value being set is acceptable
                         */
          /*  printf("4444!\n");
            if (var_val_type != ASN_INTEGER ) {
                DEBUGMSGTL(("systemSet", "%x not integer type", var_val_type));
            printf("5555!\n");
                return SNMP_ERR_WRONGTYPE;
            }
                                                                                
            printf("6666!\n");
            if (var_val_len > sizeof(long)) {
                DEBUGMSGTL(("systemSet", "wrong length %x", var_val_len));
            printf("7777!\n");
                return SNMP_ERR_WRONGLENGTH;
            }
                                                                                
            intval = *((long *) var_val);
            if (intval > MAX_SYSTEMSET_INT) {
                DEBUGMSGTL(("systemSet", "wrong value %x", intval));
                return SNMP_ERR_WRONGVALUE;
                                                                                
            }  */
           break;
                                                                                
                                                                                
        case RESERVE2:
//             printf("RESERVE2!\n");
                                                                                
                        /*
                         *  This is conventially where any necesary
                         *   resources are allocated (e.g. calls to malloc)
                         *  Here, we are using static variables
                         *   so don't need to worry about this.
                         */
            break;
                                                                                
                                                                                
        case FREE:
//             printf("FREE!\n");
                        /*
                         *  This is where any of the above resources
                         *   are freed again (because one of the other
                         *   values being SET failed for some reason).
                         *  Again, since we are using static variables
                         *   we don't need to worry about this either.
                         */
                                                                                
            break;
                                                                                
        case ACTION:
//             printf("ACTION!!\n");
                        /*
                         *  Set the variable as requested.
                         *   Note that this may need to be reversed,
                         *   so save any information needed to do this.
                         */
//            old_intval  = val;
//            val = intval;
            break;
                                                                                
                                                                                
        case UNDO:
//             printf("UNDO!!\n");
                        /*
                         *  Something failed, so re-set the
                         *   variable to its previous value
                         *  (and free any allocated resources).
                         */
            val = old_intval;
            break;
                                                                                
                                                                                
        case COMMIT:
//             printf("COMMIT!!\n");
                        /*
                         *  Everything worked, so we can discard any
                         *   saved information, and make the change
                         *   permanent (e.g. write to the config file).
                         *  We also free any allocated resources.
                         *
                         *  In this case, there's nothing to do.
                         */
             ////////////////////////////////////////////////////
                switch (*(name+8))
                {
                    case 1: //sysConfigSave   
     
			 if( !system("init.sh gw all") ) {
			     printf("exit failed\n");
			     return 0;
			 }

//			 printf("success.\n");
			
                            break;

		    case 2:  //sysReboot
			 
			 system("./etc/coldstart");
			 if( !system("reboot") ){
			     printf("reboot failed!\n");
			     return 0; 
			 }  

			    break;

//		    case 3: //sysConfigApply
			
//			    break;

		    case 4: //resetToFactoryDefault

                        if ( !apmib_updateDef() ) {
                        	free(ptr);
                        	printf("Write default to current setting failed!\n");
                        	return 0;
                	}
            		if ( !apmib_reinit() ) {
                        	free(ptr);
                        	printf("Re-initialize AP MIB failed!\n");
                        	return 0;
                	}
			system("reboot");

			break;

//		    case 5: //clearCounters

//			break;

                }  //switch(*(name+8)) 
                                                            
            break;
                                                                                
    }  //switch(action)
    return SNMP_ERR_NOERROR;
                                                                                
}   //write_systemManageint()
                                                                                

   

