/*
 *  bridgeTable MIB group implementation - bridgeTable.c
 *
 */

#include <config.h>

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#if HAVE_WINSOCK_H
#include <winsock.h>
#endif

# if HAVE_SYS_TIME_H
#  include <sys/time.h>
#endif

#include <ctype.h>
#if HAVE_UTSNAME_H
#include <utsname.h>
#else
#if HAVE_SYS_UTSNAME_H
#include <sys/utsname.h>
#endif
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_DMALLOC_H
#include <dmalloc.h>
#endif

/* mibincl.h contains all the snmp specific headers to define the
   return types and various defines and structures. */
#include "mibincl.h"

/* header_generic() comes from here */
#include "util_funcs.h"

#include "agent_read_config.h"

#include "read_config.h"

/* include our .h file */
#include "bridgeTable.h"

#include <string.h>
//////////////////////Yichun Nov 17 2005////////////////////////////////////////////

#include "../../../../goahead-2.1.1/LINUX/apmib.h"
#include "../../../../goahead-2.1.1/LINUX/mibtbl.h"
#include "../../../../goahead-2.1.1/LINUX/utility.h"
/////////////////////////////////////////////////////////////

 /*********************
         *
         *  Kernel & interface information,
         *   and internal forward declarations
         *
         *********************/


	/*********************
	 *
	 *  Initialisation & common implementation functions
	 *
	 *********************/

/* define the structure we're going to ask the agent to register our
   information at */
struct variable2 bridgeTable_variables[] = {
    {bridgeMAC, ASN_OCTET_STR , RONLY,  var_bridgeTable, 1, {1}}
};

/* Define the OID pointer to the top of the mib tree that we're
   registering underneath */
oid bridgeTable_variables_oid[] = { 1,3,6,1,4,1,14125,7 };


void init_bridgeTable(void)
{
/* register ourselves with the agent to handle our mib tree */
  REGISTER_MIB("senaoMIB/bridgeTable", bridgeTable_variables, variable2, bridgeTable_variables_oid);
}

        /*********************
         *
         *  System specific implementation functions
         *

         *********************/
//////////////////////////////////////////////////////////////////////////////////////////////////
u_char  *
var_bridgeTable(struct variable *vp,
           oid *name,
           size_t *length,
           int exact,
           size_t *var_len,
           WriteMethod **write_method)
{

    WLAN_STA_INFO_Tp pInfo;
    int val,i,found=0;
    char *buff;
    char WLAN_IF[20];
    char mac_arr[1500],buffer[24];

    if (header_generic(vp, name, length, exact, var_len, write_method) == MATCH_FAILED )
        return NULL;
                                                                                

///////////////////YiChun Dec 14  2005/////////////////////////////////////////
    if ( !apmib_init()) {
                        printf("Initialize AP MIB failed!\n");
                        return 0;
                }
                                                                                                                             
//      printf("Initialize AP MIB success!\n");
                                                                                                                             
///////////////////////////////////////////////////////////////////////////////

    switch (vp->magic)
    {
	case bridgeMAC:
            apmib_get( MIB_WLAN_MODE, (void *)&val);
            if( val == CLIENT_MODE )
           	  return 0;
            else if(val == AP_MODE || val == AP_WDS_MODE)
	    {
	          buff = calloc(1, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM+1));	
	          if ( buff == 0 ) {
                       printf("Allocate buffer failed!\n");
                       return 0;
                  }
		  strcpy(WLAN_IF,"wlan0");
		  if ( getWlStaInfo(WLAN_IF,  (WLAN_STA_INFO_Tp)buff ) < 0 ) {
                       printf("Read wlan sta info failed!\n");
                       return 0;
                  }
	
		 
                  for (i=1; i<=MAX_STA_NUM; i++) 
		  {
                       pInfo = (WLAN_STA_INFO_Tp)&buff[i*sizeof(WLAN_STA_INFO_T)];
                       if (pInfo->aid && (pInfo->flag & STA_INFO_FLAG_ASOC)) 
		       {                          
		           sprintf(buffer,"%2d-[%02x:%02x:%02x:%02x:%02x:%02x]  ",i , pInfo->addr[0], 
					pInfo->addr[1], pInfo->addr[2], pInfo->addr[3], pInfo->addr[4], pInfo->addr[5]);

	//		   printf("buffer = %s\n",buffer);
			   *var_len = i * 24;    //*var_len = get CB MAC Address total length

                           found++; 
	//		   printf("found = %d\n",found);
			   strcpy(&mac_arr[(found-1) * 24], buffer);

	               } //if (pInfo->aid...)

		  } //for (i=1; i<=MAX_STA_NUM...)
		
        	  if (found == 0) 
		  {
			     mac_arr[i] == 0;
                	     *var_len = 0;
		  }
		
	//	  printf("var_len=%d\n",*var_len);
		  free(buff);

	    }  //else if (val == AP_MODE.....)

            return (u_char *) mac_arr;

	default:
            DEBUGMSGTL(("snmpd", "unknown sub-id %d in var_bridgeTableEntry\n", vp->magic));


    } //switch(magic)
    return NULL;
} //var_bridgeTable()

