/*
 *  webAdmin MIB group implementation - webAdmin.c
 *
 */

#include <config.h>
#include <sys/reboot.h>

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#if HAVE_WINSOCK_H
#include <winsock.h>
#endif

# if HAVE_SYS_TIME_H
#  include <sys/time.h>
#endif

#include <ctype.h>
#if HAVE_UTSNAME_H
#include <utsname.h>
#else
#if HAVE_SYS_UTSNAME_H
#include <sys/utsname.h>
#endif
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_DMALLOC_H
#include <dmalloc.h>
#endif

/* mibincl.h contains all the snmp specific headers to define the
   return types and various defines and structures. */
#include "mibincl.h"

/* header_generic() comes from here */
#include "util_funcs.h"

#include "agent_read_config.h"

#include "read_config.h"

/* include our .h file */
#include "webAdmin.h"

//////////////////////Yichun Nov 17 2005////////////////////////////////////////////

#include "../../../../goahead-2.1.1/LINUX/apmib.h"
#include "../../../../goahead-2.1.1/LINUX/mibtbl.h"

/////////////////////////////////////////////////////////////

 /*********************
         *
         *  Kernel & interface information,
         *   and internal forward declarations
         *
         *********************/



	/*********************
	 *
	 *  Initialisation & common implementation functions
	 *
	 *********************/

/* define the structure we're going to ask the agent to register our
   information at */
struct variable2 webAdmin_variables[] = {
    {username, ASN_OCTET_STR, RWRITE, var_webAdmin, 1, {1}},
    {password, ASN_OCTET_STR , RWRITE,  var_webAdmin, 1, {2}},
};

/* Define the OID pointer to the top of the mib tree that we're
   registering underneath */
oid webAdmin_variables_oid[] = { 1,3,6,1,4,1,14125,5 };


void init_webAdmin(void)
{
/* register ourselves with the agent to handle our mib tree */
  REGISTER_MIB("senaoMIB/webAdmin", webAdmin_variables, variable2, webAdmin_variables_oid);
}

        /*********************
         *
         *  System specific implementation functions
         *

         *********************/
                                                                                
//////////////////////////////////////////////////////////////////////////////////////////////////

u_char  *
var_webAdmin(struct variable *vp,
           oid *name,
           size_t *length,
           int exact,
           size_t *var_len,
           WriteMethod **write_method)
{
  
    unsigned char buffer[500];

    if (header_generic(vp, name, length, exact, var_len, write_method) == MATCH_FAILED )
        return NULL;    

///////////////////YiChun Dec 14  2005/////////////////////////////////////////
    if ( !apmib_init()) {
                        printf("Initialize AP MIB failed!\n");
                        return 0;
                }   

//	printf("Initialize AP MIB success!\n");                                                                                            
///////////////////////////////////////////////////////////////////////////////
    switch (vp->magic)
    {
        case username:
	     buffer[0]='\0';
                if ( !apmib_get(MIB_USER_NAME,  (void *)buffer) )
                        return 0;
//		printf("username = %s\n",buffer);
		*var_len = strlen(buffer);
		*write_method = write_webAdminint;
                return (u_char *) buffer;

	case password:
	     buffer[0]='\0';
                if ( !apmib_get( MIB_USER_PASSWORD,  (void *)buffer) )
                        return 0;

//		printf("password = %s\n",buffer);
		*var_len = strlen(buffer);
		*write_method = write_webAdminint;
                return (u_char *) buffer;

	default:
            DEBUGMSGTL(("snmpd", "unknown sub-id %d in var_webAdmin\n", vp->magic));

    } //switch(magic)
    return NULL;
} //var_webAdmin()


        /*********************
         *
         *  Writeable object SET handling routines
         *
         *********************/
int
write_webAdminint(int    action,
                 u_char *var_val,
                 u_char var_val_type,
                 size_t var_val_len,
                 u_char *statP,
                 oid    *name,
                 size_t name_len)
{

    static long intval;
    static long old_intval;
    int val,i;
//    char_t *userid;
	
  switch ( action )
    {
        case RESERVE1:
                        /*
                         *  Check that the value being set is acceptable
                         */
          /*  printf("4444!\n");
            if (var_val_type != ASN_INTEGER ) {
                DEBUGMSGTL(("systemSet", "%x not integer type", var_val_type));
            printf("5555!\n");
                return SNMP_ERR_WRONGTYPE;
            }
                                                                                
            printf("6666!\n");
            if (var_val_len > sizeof(long)) {
                DEBUGMSGTL(("systemSet", "wrong length %x", var_val_len));
            printf("7777!\n");
                return SNMP_ERR_WRONGLENGTH;
            }
                                                                                
            intval = *((long *) var_val);
            if (intval > MAX_SYSTEMSET_INT) {
                DEBUGMSGTL(("systemSet", "wrong value %x", intval));
                return SNMP_ERR_WRONGVALUE;
                                                                                
            }  */
           break;
                                                                                
                                                                                
        case RESERVE2:
//             printf("RESERVE2!\n");
                                                                                
                        /*
                         *  This is conventially where any necesary
                         *   resources are allocated (e.g. calls to malloc)
                         *  Here, we are using static variables
                         *   so don't need to worry about this.
                         */
            break;
                                                                                
        case FREE:
//             printf("FREE!\n");
                        /*
                         *  This is where any of the above resources
                         *   are freed again (because one of the other
                         *   values being SET failed for some reason).
                         *  Again, since we are using static variables
                         *   we don't need to worry about this either.
                         */
                                                                                   
            break;
                                                                                   
        case ACTION:
//             printf("ACTION!!\n");
                        /*
                         *  Set the variable as requested.
                         *   Note that this may need to be reversed,
                         *   so save any information needed to do this.
                         */
//            old_intval  = val;
//            val = intval;
            break;

        case UNDO:
//             printf("UNDO!!\n");
                        /*
                         *  Something failed, so re-set the
                         *   variable to its previous value
                         *  (and free any allocated resources).
                         */
            val = old_intval;
            break;
                                                                                   
                                                                                   
        case COMMIT:
//             printf("COMMIT!!\n");
                        /*
                         *  Everything worked, so we can discard any
                         *   saved information, and make the change
                         *   permanent (e.g. write to the config file).
                         *  We also free any allocated resources.
                         *
                         *  In this case, there's nothing to do.
                         */
             ////////////////////////////////////////////////////
                switch (*(name+8))
                {
                    case 1: //username
                         
			 /* Delete current user account */
                       /*   if(var_val_len >29)
			  {
                             printf("ERROR!! Name length can't be longer than 29 characters!! \n");
                             return 0;
                          }
                      */                                                              
                          for(i=var_val_len;i<30;i++)
                              var_val[i] = NULL;
          		
                    //      var_val[var_val_len-1] = '\n';
                          name_len = strlen(var_val); 

                	 /* Set user account to MIB */  
			// var_val[0]='\0';  
                         if( apmib_set( MIB_USER_NAME, (void *)var_val) == 0)
                         {
                              printf("Set user name to MIB database failed.\n");
                              return 0;
                         }

			 /* Retrieve next page URL */
			 apmib_update(CURRENT_SETTING);
			
                         break;
                                                                                                                                         
                    case 2: //password
	
			 /* Delete current password */
		/*	  if(var_val_len >29)
			  {
                             printf("ERROR!! Name length can't be longer than 29 characters!! \n");
                             return 0;
                          }
                */                                                                
                          for(i=var_val_len;i<30;i++)
                              var_val[i] = NULL;
		
                 	  name_len = strlen(var_val);

			 /* Set user account to MIB */
			 if( apmib_set( MIB_USER_PASSWORD, (void *)var_val) == 0)
                         {
                              printf("Set user password to MIB database failed.\n");
                              return 0;
                         }

			 /* Retrieve next page URL */
                         apmib_update(CURRENT_SETTING);	            		

                         break;
		}

            break;
                                                                                   
    }  //switch(action)
    return SNMP_ERR_NOERROR;
                                                                                   
}   //write_webAdminint()
                                                                                   





   

