/*
 *  SystemSet MIB group implementation - systemSet.c
 *
 */

#include <config.h>

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#if HAVE_WINSOCK_H
#include <winsock.h>
#endif

# if HAVE_SYS_TIME_H
#  include <sys/time.h>
#endif

#include <ctype.h>
#if HAVE_UTSNAME_H
#include <utsname.h>
#else
#if HAVE_SYS_UTSNAME_H
#include <sys/utsname.h>
#endif
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_DMALLOC_H
#include <dmalloc.h>
#endif

/* mibincl.h contains all the snmp specific headers to define the
   return types and various defines and structures. */
/* include our .h file */
#include "mibincl.h"

/* header_generic() comes from here */
#include "util_funcs.h"

#include "agent_read_config.h"

#include "read_config.h"

/* include our .h file */
#include "systemSet.h"

//////////////////////Yichun Dec 14 2005////////////////////////////////////////////

#include "../../../../goahead-2.1.1/LINUX/apmib.h"
#include "../../../../goahead-2.1.1/LINUX/mibtbl.h"
#define SSID_MAX_STR_SIZE 32
#define IP_ADDRESS_LEN 4
int ssidlength;

/////////////////////////////////////////////////////////////

 /*********************
         *
         *  Kernel & interface information,
         *   and internal forward declarations
         *
         *********************/



	/*********************
	 *
	 *  Initialisation & common implementation functions
	 *
	 *********************/

/* define the structure we're going to ask the agent to register our
   information at */
struct variable2 systemSet_variables[] = {
    {operationMode, ASN_INTEGER, RONLY, var_systemSet, 1, {1}},
    {ipAddress, ASN_IPADDRESS , RWRITE,  var_systemSet, 1, {2}},
    {subnetmask, ASN_IPADDRESS, RWRITE, var_systemSet, 1, {3}},
    {ipGateway, ASN_IPADDRESS, RWRITE,  var_systemSet , 1, {4}},
    {devicename, ASN_OCTET_STR, RWRITE, var_systemSet, 1, {5}},
    {desiredSSID, ASN_OCTET_STR, RWRITE,  var_systemSet, 1, {6}},
    {NetworkManagement, ASN_INTEGER, RWRITE, var_systemSet, 1, {7}},
    {SNMPLANside, ASN_INTEGER, RWRITE, var_systemSet, 1, {8}},
};

/* Define the OID pointer to the top of the mib tree that we're
   registering underneath */
oid systemSet_variables_oid[] = { 1,3,6,1,4,1,14125,4 };


void init_systemSet(void)
{
/* register ourselves with the agent to handle our mib tree */
  REGISTER_MIB("senaoMIB/systemSet", systemSet_variables, variable2, systemSet_variables_oid);
  printf("init_systemSet!!\n");
}

        /*********************
         *
         *  System specific implementation functions
         *

         *********************/
 
////////////////////////////////////////////////////////////////////////////////
static void translate_control_code(char *buffer)
{
        char tmpBuf[200], *p1 = buffer, *p2 = tmpBuf;
                                                                                
                                                                                
        while (*p1) {
                if (*p1 == '"') {
                        memcpy(p2, "&quot;", 6);
                        p2 += 6;
                }
                else
                        *p2++ = *p1;
                p1++;
        }
        *p2 = '\0';
                                                                                
                                                                                
        strcpy(buffer, tmpBuf);
}

////////////////////////////////////////////////////////////////////////////////

u_char  *
var_systemSet(struct variable *vp,
           oid *name,
           size_t *length,
           int exact,
           size_t *var_len,
           WriteMethod **write_method)
{
	printf("var_systemSet\n");

//    OPMODE_T opmode=-1;
//    OPMODE_T opmode;
//    WLAN_MODE_T wlanMode;
    DHCP_T dhcp;
    unsigned char buffer[500];
    int i,val,domain,found=0,opmode,wlanMode;

    if (header_generic(vp, name, length, exact, var_len, write_method) == MATCH_FAILED )
        return NULL;
    
///////////////////YiChun Dec 13  2005/////////////////////////////////////////
    if ( !apmib_init()) {
                          printf("Initialize AP MIB failed!\n");
                          return 0;
                        }   

//	printf("Initialize AP MIB success!\n");                                                                                            
///////////////////////////////////////////////////////////////////////////////

    switch (vp->magic)
    {
        case operationMode:

	     if( !apmib_get(MIB_WLAN_MODE, (void *)&wlanMode) ){ 
	             printf("WLAN MODE/// failed");
		     return 0;
	     }
	     if( wlanMode == 1 ) 
	     {
	        if( !apmib_get( MIB_DOMAIN_NAME, (void *)&buffer) ){
	             printf("domain name failed!!");
		     return 0;
		}
		domain = strlen(buffer);
//		printf("domain name = %d\n",domain);
		if( domain == 2 ){  // CB
		     long_return = 1;
//		     *write_method = write_systemSetint;
		}
		else if( domain == 6 ){  // CB-R
		     long_return = 2;
//		     *write_method = write_systemSetint;

		}
	     }
	     else if( wlanMode == 3 )  //AP_WDS
	     {
		     long_return = 3;
//		     *write_method = write_systemSetint;
	     }	 
	     else{
		      printf("failed\n");
		      long_return = 0;	  
//		      *write_method = write_systemSetint;
	     } 	
             return (u_char*)&long_return;

	case ipAddress:             
	     if ( !apmib_get( MIB_IP_ADDR,  (void *)buffer) ){
			printf("failed!!\n");
                        return 0;
	     }
	     *var_len = IP_ADDRESS_LEN;
	     *write_method = write_systemSetint;
             return (u_char *) buffer;

	case subnetmask:            
	     if ( !apmib_get( MIB_SUBNET_MASK,  (void *)buffer) ){
			printf("failed!!!\n");
                        return 0;
	     }
		*write_method = write_systemSetint;
                return (u_char *) buffer;

	case ipGateway:
	     if ( !apmib_get( MIB_DEFAULT_GATEWAY,  (void *)buffer) ){
//			printf("failed!!!!\n");
                        return 0;
	     }
         //       if (!memcmp(buffer, "\x0\x0\x0\x0", 4))
          //              return 0;

//		printf("subnetmask = %s\n",buffer);
		*write_method = write_systemSetint;
//		printf("gateway oid = %d\n",*(name+8));
                return (u_char *) buffer;

	case devicename:
		buffer[0]='\0';	     
                if ( !apmib_get(MIB_DEVICE_NAME,  (void *)buffer) ){
			printf("failed!!!!!\n");
                        return 0;
	        }
		*var_len = strlen(buffer);
		*write_method = write_systemSetint;
                return(u_char *) buffer;
		
	case desiredSSID:
		printf("get ssid\n");
		buffer[0]='\0';	     
 	        if( !apmib_get( MIB_WLAN_SSID,  (void *)buffer) ){
                    printf("apmib_get MIB_WLAN_SSID failed\n");
                    return 0;
        	}
//		ssidlength = strlen(buffer);
/*		while(1)
		{
			buffer[ssidlength] = 0;
			ssidlength--;
			if(!ssidlength)
			  break;
		}  */
//		printf("buffer str = %s\n", buffer);
//		(char *)buffer[5] = '\0';                                                                                
                translate_control_code(buffer);
                *var_len = strlen(buffer);
                *write_method = write_systemSetint;                                                                
                return(u_char *) buffer;

//	case NetworkManagemrnt:

//	case SNMPLANside:

	default:
            DEBUGMSGTL(("snmpd", "unknown sub-id %d in var_systemSet\n", vp->magic));

    } //switch(magic)

    return NULL;

} //var_systemSet()


        /*********************
         *
         *  Writeable object SET handling routines
         *
         *********************/
int
write_systemSetint(int    action,
                 u_char *var_val,
                 u_char var_val_type,
                 size_t var_val_len,
                 u_char *statP,
                 oid    *name,
                 size_t name_len)
{
    printf("write_systemSetint\n");
    static long intval;
    static long old_intval;
    int i,val,id,domain,number,wlanMode,opmode;
//    WLAN_MODE_T wlanMode;
//    OPMODE_T opmode;
    unsigned char *cp1, *cp2, buffer[10];
    cp1 = "ap";
    cp2 = "router";
                                                          
    switch ( action ) 
    {
        case RESERVE1:
                        /*
                         *  Check that the value being set is acceptable
                         */
	  /*  printf("4444!\n");
            if (var_val_type != ASN_INTEGER ) {
                DEBUGMSGTL(("systemSet", "%x not integer type", var_val_type));
	    printf("5555!\n");
                return SNMP_ERR_WRONGTYPE;
            }
	    
	    printf("6666!\n");
            if (var_val_len > sizeof(long)) {
                DEBUGMSGTL(("systemSet", "wrong length %x", var_val_len));
	    printf("7777!\n");
                return SNMP_ERR_WRONGLENGTH;
	    }

            intval = *((long *) var_val);
            if (intval > MAX_SYSTEMSET_INT) {
                DEBUGMSGTL(("systemSet", "wrong value %x", intval));
                return SNMP_ERR_WRONGVALUE;

            }  */
           break;


        case RESERVE2:
//             printf("RESERVE2!\n");

                        /*
                         *  This is conventially where any necesary
                         *   resources are allocated (e.g. calls to malloc)
                         *  Here, we are using static variables
                         *   so don't need to worry about this.
                         */
            break;
                                                                                                                             
        case FREE:
//	     printf("FREE!\n");
                        /*
                         *  This is where any of the above resources
                         *   are freed again (because one of the other
                         *   values being SET failed for some reason).
                         *  Again, since we are using static variables
                         *   we don't need to worry about this either.
                         */

            break;

        case ACTION:
//             printf("ACTION!!\n");
                        /*
                         *  Set the variable as requested.
                         *   Note that this may need to be reversed,
                         *   so save any information needed to do this.
                         */
//            old_intval  = val;
//            val = intval;
            break;
                                                                                                                             
        case UNDO:
//             printf("UNDO!!\n");
                        /*
                         *  Something failed, so re-set the
                         *   variable to its previous value
                         *  (and free any allocated resources).
                         */
            val = old_intval;
            break;
                                                                                                                             
        case COMMIT:
//             printf("COMMIT!!\n");
                        /*
                         *  Everything worked, so we can discard any
                         *   saved information, and make the change
                         *   permanent (e.g. write to the config file).
                         *  We also free any allocated resources.
                         *
                         *  In this case, there's nothing to do.
                         */
             ////////////////////////////////////////////////////
/*int i;
printf("13:name =");
for(i=0;i<9;i++)
              printf("%d.",*(name+i));  
printf("\n");
               
             i= *(name+8);
*/

          
/* if (var_val) {
	number = * (int *) var_val;
}
printf("number = %d\n", number); */

		switch (*(name+8))
		{
/*        	    case 1: //operationMode
			 
                         if( number == 1 ){
				wlanMode = number;
				apmib_set( MIB_WLAN_MODE, (void *)&wlanMode);
				strcpy( buffer, cp1);
				apmib_set( MIB_DOMAIN_NAME, (void *)&buffer);
                		domain = strlen(buffer);
				system("./etc/cb");
				printf("1\n");
			 }
                         else if( number == 2 ){
				wlanMode = number -1;
				apmib_set( MIB_WLAN_MODE, (void *)&wlanMode);
				strcpy( buffer, cp2);
				apmib_set( MIB_DOMAIN_NAME, (void *)&buffer);
                		domain = strlen(buffer);  
				system("./etc/router");  
				printf("2\n");
			 }
                         else if( number == 3 ){
				wlanMode = number;
				apmib_set( MIB_WLAN_MODE, (void *)&wlanMode);
				strcpy( buffer, cp1);
				apmib_set( MIB_DOMAIN_NAME, (void *)&buffer);
                		domain = strlen(buffer);
				system("./etc/ap");     
				printf("3\n");
			 }
			 else
				printf("set failed\n");
*/
			 /* Retrieve next page URL */
//                         apmib_update(CURRENT_SETTING);
			 
//                	 break;                                                                                                                                                                                          
        	    case 2: //ipAddress          
	
			 if( var_val_type != ASN_IPADDRESS ){
                             printf("write to ip not ASN_IPADDRESS\n");
                             return 0;
                         }
                         if( var_val_len != sizeof(u_long) ){
                             printf("write to ip: bad length\n");
                             return 0;
                         }
            	    	 if( apmib_set( MIB_IP_ADDR, (void *)var_val) == 0)
			 {
                              printf("Set IP-address error!\n");
                              return 0;
             	         }
			/* Retrieve next page URL */
                         apmib_update(CURRENT_SETTING);

	     	    	 break;

	     	    case 3: //subnetmask

	     	         if( apmib_set( MIB_SUBNET_MASK, (void *)var_val) == 0)
			 {
                              printf("Set subnet-mask error!\n");
                	      return 0;
	     	         }
			/* Retrieve next page URL */
                         apmib_update(CURRENT_SETTING);
	     
	            	 break;

        	    case 4: //ipGateway

             		 if( apmib_set( MIB_DEFAULT_GATEWAY, (void *)var_val) == 0)
			 {
                       	      printf("Set default-gateway error!\n");
                              return 0;
             	         }
			/* Retrieve next page URL */
                         apmib_update(CURRENT_SETTING);

             	    	 break;
                                                                                                             
  	            case 5: //devicename

			printf("var_val_len 1=%x\n",var_val_len);
                        for(i=var_val_len;i<34;i++)
                           var_val[i] = NULL;   
        		 name_len = strlen(var_val);                 
                         if( var_val_type != ASN_OCTET_STR){
                             printf("write to devicename not ASN_OCTET_STR\n");
                             return 0;
                         }
                         if( (var_val_len > sizeof(char) * SSID_MAX_STR_SIZE) || (var_val_len == 0) ){
                             printf("write to devicename: bad length\n");
                             return 0;
                         }
	     		 if( apmib_set(MIB_DEVICE_NAME,  (void *)var_val) == 0 )
			 {
	                      printf("Set devicename error!\n");
                              return 0;
             	         }

			 /* Retrieve next page URL */
                         apmib_update(CURRENT_SETTING);

		    	 break;


		    case 6: //desiredSSID
			printf("var_val_len 2=%x\n",var_val_len);
			printf("set ssid\n");
			printf("var_val = %s\n",(char *)var_val);
                    //    for(i=var_val_len;i<30;i++)
                    //       var_val[i] = ' ';  
                         if( var_val_type != ASN_OCTET_STR){
                             printf("write to ssid not ASN_OCTET_STR\n");
                             return 0;
                         }
                         if( (var_val_len > sizeof(char) * SSID_MAX_STR_SIZE) || (var_val_len == 0) ){
                             printf("write to ssid: bad length\n");
                             return 0;
                         }
	//		 unsigned char buff_clear[32];
         //              memset( buff_clear, 0, strlen(buff_clear) );	
          //    	 apmib_set(MIB_WLAN_SSID,  (void *)buff_clear);
			// ssidlength = 0;
			 ssidlength = strlen(var_val);
			 printf("ssidlength = %x\n", ssidlength);
			 printf("var_val = %s\n", (char *)var_val);
			 printf("ssid length=%x\n",ssidlength);
              	         if ( apmib_set(MIB_WLAN_SSID,  (void *)var_val) == 0 ){
	                      printf("Set devicename error!\n");
                              return 0;
                         }
	//		 while (ssidlength--)
	//		 {
	//			*(char *) var_val = 0;
	//		 }
	//		 name_len = var_val_len;
                         /* Retrieve next page URL */
                         apmib_update(CURRENT_SETTING);
                                                                                                                             
                         break;

		} //switch(*(name+8))

/*	case 7: //NetworkManagement

	     if ( apmib_set(MIB_DEVICE_NAME,  (void *)var_val) == 0 ){
	                      printf("Set devicename error!\n");
                              return 0;

	case 8: //SNMPLANside
  
	     if ( apmib_set(MIB_DEVICE_NAME,  (void *)var_val) == 0 ){
	                      printf("Set devicename error!\n");
                              return 0;
*/

        	  //  default:
		    
	     	      //   printf("unknown parameter in write_systemSet\n");

            //    }   //switch(*name)
  
            break;                                                                                                                    
    }  //switch(action)
    return SNMP_ERR_NOERROR;

}   //write_systemSetint()                                                                                                                          


   

