/*
 *  PrivacySet MIB group implementation - privacySet.c
 *
 */

/* include important headers */
#include <config.h>
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

/* needed by util_funcs.h */
#if TIME_WITH_SYS_TIME
# ifdef WIN32
#  include <sys/timeb.h>
# else
#  include <sys/time.h>
# endif
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_WINSOCK_H
#include <winsock.h>
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

/* mibincl.h contains all the snmp specific headers to define the
   return types and various defines and structures. */
#include "mibincl.h"

/* header_generic() comes from here */
#include "util_funcs.h"

#include "agent_read_config.h"

#include "read_config.h"

/* include our .h file */
#include "privacySet.h"


//////////////////////Yichun Nov 17 2005////////////////////////////////////////////
                                                                                
#include "../../../../goahead-2.1.1/LINUX/apmib.h"
#include "../../../../goahead-2.1.1/LINUX/mibtbl.h"
                                                                                
/////////////////////////////////////////////////////////////

        /*********************
         *
         *  Kernel & interface information,
         *   and internal forward declarations
         *
         *********************/


	 /*********************
         *
         *  Initialisation & common implementation functions
         *
         *********************/

/* define the structure we're going to ask the agent to register our
   information at */
struct variable2 privacySet_variables[] = {
    {wepEnabled, ASN_INTEGER, RWRITE, var_privacySet, 1, {1}},
    {wepKeyLength, ASN_INTEGER, RWRITE, var_privacySet, 1, {2}},
    {wepKeyNumber, ASN_INTEGER, RWRITE, var_privacySet, 1, {3}},
    {wepKey, ASN_OCTET_STR, RWRITE, var_privacySet, 1, {4}},
    {denyUnencryptedData, ASN_INTEGER, RWRITE, var_privacySet, 1, {5}}
};

/* Define the OID pointer to the top of the mib tree that we're
   registering underneath */
oid privacySet_variables_oid[] = { 1,3,6,1,4,1,14125,3 };


void init_privacySet(void)
{
  /* register ourselves with the agent to handle our mib tree */
REGISTER_MIB("senaoMIB/privacySet", privacySet_variables, variable2, privacySet_variables_oid);
}


        /*********************
         *
         *  System specific implementation functions
         *
         *********************/
/////////////////////////////////////////////////////////////////////////////////
static int string_to_hex(char *string, unsigned char *key, int len)
{
        char tmpBuf[4];
        int idx, ii=0;
        for (idx=0; idx<len; idx+=2) {
                tmpBuf[0] = string[idx];
                tmpBuf[1] = string[idx+1];
                tmpBuf[2] = 0;
             //   if ( !_is_hex(tmpBuf[0]) || !_is_hex(tmpBuf[1]))
               //         return 0;
                                                                                                                             
                key[ii++] = (unsigned char) strtol(tmpBuf, (char**)NULL, 16);
        }
        return 1;
}

//////////////////////////////////////////////////////////////////////////////////
u_char	*
var_privacySet(struct variable *vp,
	    oid *name,
	    size_t *length,
	    int exact,
	    size_t *var_len,
	    WriteMethod **write_method)
{

  unsigned char buffer[500];
  int val,encrypt,intVal;
  WEP_T wep;

  if (header_generic(vp, name, length, exact, var_len, write_method) == MATCH_FAILED)
    return NULL;

///////////////////YiChun Dec 13  2005/////////////////////////////////////////
    if ( !apmib_init()) {
                        printf("Initialize AP MIB failed!\n");
                        return 0;
                }
                                                                                
//      printf("Initialize AP MIB success!\n");
                                                                                
////////////////////////////////////////////////////////////////////////////

  switch (vp->magic)
  {

    case wepEnabled:
    if ( !apmib_get( MIB_WLAN_ENCRYPT,  (void *)&encrypt) )
                        return 0;
                if (encrypt == ENCRYPT_DISABLED || encrypt == ENCRYPT_WPA || encrypt == ENCRYPT_WPA2 || encrypt == ENCRYPT_WPA2_MIXED)
		{
                //        strcpy( buffer, T("Disabled") );
			long_return = 0;
			*write_method = write_privacySetint;
		}
              /*  else if (encrypt == ENCRYPT_WPA)
                        strcpy( buffer, T("WPA") );
                else if (encrypt == ENCRYPT_WPA2)
                        strcpy( buffer, T("WPA2") );
                else if (encrypt == (ENCRYPT_WPA | ENCRYPT_WPA2))
                        strcpy( buffer, T("WPA2 Mixed") );  */
                else{
                        long_return = 1;
                        *write_method = write_privacySetint;                                                                                 }
		return (u_char *)&long_return;

    case wepKeyLength:
	                 //ENCRYPT_T encrypt;
                if ( !apmib_get( MIB_WLAN_ENCRYPT,  (void *)&encrypt) )
                        return 0;
                if (encrypt == ENCRYPT_DISABLED)
                {
     //                   strcpy( buffer, "Disabled" );
                         long_return = 0;
			 *write_method = write_privacySetint;
                }
                else if (encrypt == ENCRYPT_WPA)
                     //   strcpy( buffer, T("WPA") );
                        return 0;
                else if (encrypt == ENCRYPT_WPA2)
                     //   strcpy( buffer, T("WPA2") );
                        return 0;
                else if (encrypt == (ENCRYPT_WPA | ENCRYPT_WPA2))
                     //   strcpy( buffer, T("WPA2 Mixed") );
                        return 0;
                                                                                                                             
                else {
                        WEP_T wep;
                        if ( !apmib_get( MIB_WLAN_WEP,  (void *)&wep) )
                                return 0;
                        if ( wep == WEP_DISABLED )
                        {
                       //         strcpy( buffer, "Disabled" );
                                long_return = 0;
			        *write_method = write_privacySetint;
                        }
                        else if ( wep == WEP64 )
                        {
                            //    strcpy( buffer, "WEP-64bits" );
                                long_return = 1;
			        *write_method = write_privacySetint;
                        }
                        else if ( wep == WEP128)
                        {
 //                               strcpy( buffer, "WEP-128bits" );
                                long_return = 2;
			        *write_method = write_privacySetint;
                        }
			else{
		//		printf("Have't correct key length.\n");
				long_return = 0;
			        *write_method = write_privacySetint;
                        }   

		}
		return (u_char *)&long_return;

    case wepKeyNumber:
	                  //ENCRYPT_T encrypt;
                if ( !apmib_get( MIB_WLAN_ENCRYPT,  (void *)&encrypt) )
                        return 0;
                if (encrypt == ENCRYPT_DISABLED)
		{
     //                   strcpy( buffer, "Disabled" );
                         long_return = 0;
			 *write_method = write_privacySetint;
                }
                else if (encrypt == ENCRYPT_WPA)
                     //   strcpy( buffer, T("WPA") );
                        return 0;
                else if (encrypt == ENCRYPT_WPA2)
                     //   strcpy( buffer, T("WPA2") );
                        return 0;
                else if (encrypt == (ENCRYPT_WPA | ENCRYPT_WPA2))
                     //   strcpy( buffer, T("WPA2 Mixed") );
                        return 0;

                else
		{ 
			WEP_T wep;
			if ( !apmib_get( MIB_WLAN_WEP,  (void *)&wep) )
                              return 0; 

                        if( wep == WEP_DISABLED )
	         	{
                     //           strcpy( buffer, "Disabled" );
                              long_return = 0;
			      *write_method = write_privacySetint;
                        }
                        else if ( wep == WEP64 )
		        {
			         if( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
                                     return 0;
                                                                                                                             
//                                 val++;
                  //               sprintf(buffer, "%d", (int)val);
                  //               printf("64keyNumber = %d\n",val );
                                 long_return = val;
                                 *write_method = write_privacySetint;
                        }
                        else if ( wep == WEP128)
			{
				 if( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
                                     return 0;
                                                                                                                             
                //                 val++;
                    //             sprintf(buffer, "%d", (int)val);
                    //             printf("128keyNumber = %d\n",val );
                                 long_return = val;
                                 *write_method = write_privacySetint;
                        }
			else
			{
				printf("Have't correct key number.\n");
				long_return = 0;
                                *write_method = write_privacySetint;
			}
		}
		return (u_char *)&long_return;

    case wepKey:

	        //ENCRYPT_T encrypt;
                if ( !apmib_get( MIB_WLAN_ENCRYPT,  (void *)&encrypt) )
                        return 0;
                if (encrypt == ENCRYPT_DISABLED)
                {
     //                   strcpy( buffer, "Disabled" );
                         long_return = 0;
                         *write_method = write_privacySetint;
                }
                else if (encrypt == ENCRYPT_WPA)
                     //   strcpy( buffer, T("WPA") );
                        return 0;
                else if (encrypt == ENCRYPT_WPA2)
                     //   strcpy( buffer, T("WPA2") );
                        return 0;
                else if (encrypt == (ENCRYPT_WPA | ENCRYPT_WPA2))
                     //   strcpy( buffer, T("WPA2 Mixed") );
                        return 0;
                                                                                                                             
                else
                {
                        WEP_T wep;
                        if ( !apmib_get( MIB_WLAN_WEP,  (void *)&wep) )
                              return 0;
                                                                                                                             
                        if( wep == WEP_DISABLED )
                        {
                     //           strcpy( buffer, "Disabled" );
                              long_return = 0;
                              *write_method = write_privacySetint;
                        }
                        else if ( wep == WEP64 )
                        {
			     if ( !apmib_get( MIB_WLAN_WEP_KEY_TYPE, (void *)&intVal) )
                                  return 0;
                             if( intVal == 0 ){  //ASCII

                                   if( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
                                       return 0;
					val++;
//					printf("val(64)=%d\n",val);

				        if(val == 1){
                                              if( !apmib_get( MIB_WLAN_WEP64_KEY1, (void *)buffer) )
						  return 0;
					      *var_len = 5;
//					      printf("WEP64-key 1 = %s\n",buffer);
                                              *write_method = write_privacySetint;
				        }
				        else if(val == 2){
					        if( !apmib_get( MIB_WLAN_WEP64_KEY2, (void *)buffer) )
							return 0;
					        *var_len = 5;
//					        printf("WEP64-key 2 = %s\n",buffer);
                                                *write_method = write_privacySetint;
				        }
				        else if(val == 3){
					        if( !apmib_get( MIB_WLAN_WEP64_KEY3, (void *)buffer) )
						    return 0;
					        *var_len = 5;
//					        printf("WEP64-key 3 = %s\n",buffer);
                                                *write_method = write_privacySetint;
				        }
				        else if(val == 4){
					        if( !apmib_get( MIB_WLAN_WEP64_KEY4, (void *)buffer) )
							return 0;
					        *var_len = 5;
//					        printf("WEP64-key 4 = %s\n",buffer);
                                                *write_method = write_privacySetint;
				        }
					else{
						printf("ASCII:WEP64 Have't correct key.\n");
						buffer[0] = 0;
                                                *write_method = write_privacySetint;
					}
			     } //ASCII

			     if( intVal == 1 ){  //hex
                                                                                                                             
                                   if( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
                                       return 0;
                                        val++;
//                                        printf("val(64)=%d\n",val);
                                                                                                                             
                                        if(val == 1){
                                              if( !apmib_get( MIB_WLAN_WEP64_KEY1, (void *)buffer) )
                                                        return 0;
                                              *var_len = 5;
//                                              printf("WEP64 key 1 = %x\n",buffer);
                                              *write_method = write_privacySetint;
                                        }
                                        else if(val == 2){
                                                if( !apmib_get( MIB_WLAN_WEP64_KEY2, (void *)buffer) )
                                                        return 0;
                                                *var_len = 5;
//                                                printf("WEP64 key 2 = %x\n",buffer);
                                                *write_method = write_privacySetint;
                                        }
                                        else if(val == 3){
                                                if( !apmib_get( MIB_WLAN_WEP64_KEY3, (void *)buffer) )
                                                        return 0;
                                                *var_len = 5;
//                                                printf("WEP64 key 3 = %x\n",buffer);
                                                *write_method = write_privacySetint;
                                        }
                                        else if(val == 4){
                                                if( !apmib_get( MIB_WLAN_WEP64_KEY4, (void *)buffer) )
                                                        return 0;
                                                *var_len = 5;
//                                                printf("WEP64 key 4 = %x\n",buffer);
                                                *write_method = write_privacySetint;
                                        }
					else{
						printf("hex:WEP64 Have't correct key.\n");
						buffer[0] = 0;
                                                *write_method = write_privacySetint;
					}
			     } //hex

                        }  //wep == WEP64
                        else if ( wep == WEP128)
                        {
			     if ( !apmib_get( MIB_WLAN_WEP_KEY_TYPE, (void *)&intVal) )
                                  return 0;
                             if( intVal == 0 ){  //ASCII
                                                                                                                             
                                    if( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
                                        return 0;      
                                        val++;
//					printf("val(128)=%d\n",val);

                                         if(val == 1){
                                               if( !apmib_get( MIB_WLAN_WEP128_KEY1, (void *)buffer) )
						   return 0;
					       *var_len = 13;
//					       printf("WEP128-key 1 = %s\n",buffer);
                                               *write_method = write_privacySetint;
                                         }
                                         else if(val == 2){
                                                 if( !apmib_get( MIB_WLAN_WEP128_KEY2, (void *)buffer) )
						     return 0;
					         *var_len = 13;
//					         printf("WEP128-key 2 = %s\n",buffer);
                                                 *write_method = write_privacySetint;
                                         }
                                         else if(val == 3){
                                                 if( !apmib_get( MIB_WLAN_WEP128_KEY3, (void *)buffer) )
						     return 0;
					         *var_len = 13;
//					         printf("WEP128-key 3 = %s\n",buffer);
                                                 *write_method = write_privacySetint;
                                         }
                                         else if(val == 4){
                                                 if( !apmib_get( MIB_WLAN_WEP128_KEY4, (void *)buffer) )
						     return 0;
					         *var_len = 13;
//					         printf("WEP128-key 4 = %s\n",buffer);
                                                 *write_method = write_privacySetint;
                                         } 
					 else{
						printf("ASCII:WEP128 Have't correct key.\n");
						buffer[0] = 0;
                                                *write_method = write_privacySetint;
					 }
                             } //ASCII
                             else if( intVal == 1 ){  //hex 
                                    if( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
                                        return 0;
                                        val++;
//                                        printf("val(128)=%d\n",val);
                                                                                                                             
                                         if(val == 1){
                                               if( !apmib_get( MIB_WLAN_WEP128_KEY1, (void *)buffer) )
                                                   return 0;
                                               *var_len = 13;
//                                               printf("WEP128 key 1 = %x\n",buffer);
                                               *write_method = write_privacySetint;
                                         }
                                         else if(val == 2){
                                                 if( !apmib_get( MIB_WLAN_WEP128_KEY2, (void *)buffer) )
                                                     return 0;
                                                 *var_len = 13;
//                                                 printf("WEP128 key 2 = %x\n",buffer);
                                                 *write_method = write_privacySetint;
                                         }
                                         else if(val == 3){
                                                 if( !apmib_get( MIB_WLAN_WEP128_KEY3, (void *)buffer) )
                                                     return 0;
                                                 *var_len = 13;
//                                                 printf("WEP128 key 3 = %x\n",buffer);
                                                 *write_method = write_privacySetint;
                                         }
					 else if(val == 4){
                                                 if( !apmib_get( MIB_WLAN_WEP128_KEY4, (void *)buffer) )
                                                     return 0;
                                                 *var_len = 13;
//                                                 printf("WEP128 key 4 = %x\n",buffer);
                                                 *write_method = write_privacySetint;
					 }
					 else{
						printf("hex:WEP128 Have't correct key.\n");
						buffer[0] = 0;
                                                *write_method = write_privacySetint;
					 }
			     } //hex
                                                                             
                        }
                }
		return (u_char *)buffer;

    case denyUnencryptedData:
        apmib_get( MIB_WLAN_MODE, (void *)&val);
        if (val == CLIENT_MODE)
	    return 0;

	else if(val == AP_MODE || val == AP_WDS_MODE)
	{
                if ( !apmib_get( MIB_WLAN_AC_ENABLED, (void *)&val) ){
		      printf("invalid val\n");
                      return 0;
	        }
     //        sprintf(buffer, "%d", val);
	       long_return = val;
               *write_method = write_privacySetint;
	}
	else{
		long_return = 0;
                *write_method = write_privacySetint;
	}
        return (u_char *) &long_return;
   
    default:
      DEBUGMSGTL(("snmpd", "unknown sub-id %d in senaoMIB/var_privacySet\n", vp->magic));

  } //switch(magic)
  return NULL;

} //var_privacySet()


        /*********************
         *
         *  Writeable object SET handling routines
         *
         *********************/
int
write_privacySetint(int    action,
                 u_char *var_val,
                 u_char var_val_type,
                 size_t var_val_len,
                 u_char *statP,
                 oid    *name,
                 size_t name_len)
{
                                                                                   
    static long intal;
    static long old_intval;
    unsigned char buffer[500];
    int val,encrypt,intVal,i;
    WEP_T wep;
    char key[30];

    switch ( action )
    {
        case RESERVE1:  
                        /*
                         *  Check that the value being set is acceptable
                         */
          /*  printf("4444!\n");
            if (var_val_type != ASN_INTEGER ) {
                DEBUGMSGTL(("systemSet", "%x not integer type", var_val_type));
            printf("5555!\n");
                return SNMP_ERR_WRONGTYPE;
            }
                                                                                   
            printf("6666!\n");
            if (var_val_len > sizeof(long)) {
                DEBUGMSGTL(("systemSet", "wrong length %x", var_val_len));
            printf("7777!\n");
                return SNMP_ERR_WRONGLENGTH;
            }
                                                                                   
            intval = *((long *) var_val);
            if (intval > MAX_SYSTEMSET_INT) {
                DEBUGMSGTL(("systemSet", "wrong value %x", intval));
                return SNMP_ERR_WRONGVALUE;
                                                                                   
            }  */
           break;
                                                                                   
                                                                                   
        case RESERVE2:
//             printf("RESERVE2!\n");
                                                                                   
                        /*
                         *  This is conventially where any necesary
                         *   resources are allocated (e.g. calls to malloc)
                         *  Here, we are using static variables
                         *   so don't need to worry about this.
                         */
            break;
                                                                                   
        case FREE:
//             printf("FREE!\n");   
                        /*
                         *  This is where any of the above resources
                         *   are freed again (because one of the other
                         *   values being SET failed for some reason).
                         *  Again, since we are using static variables
                         *   we don't need to worry about this either.
                         */
                                                                                   
            break;
                                                                                   
        case ACTION:
//             printf("ACTION!!\n");   
                        /*
                         *  Set the variable as requested.
                         *   Note that this may need to be reversed,
                         *   so save any information needed to do this.
                         */
//            old_intval  = val;
//            val = intval;
            break;
        case UNDO:
//             printf("UNDO!!\n");   
                        /*
                         *  Something failed, so re-set the
                         *   variable to its previous value
                         *  (and free any allocated resources).
                         */
            val = old_intval;
            break;
                                                                                   
                                                                                   
        case COMMIT:
//             printf("COMMIT!!\n");   
                        /*
                         *  Everything worked, so we can discard any
                         *   saved information, and make the change
                         *   permanent (e.g. write to the config file).
                         *  We also free any allocated resources.
                         *
                         *  In this case, there's nothing to do.
                         */
             ////////////////////////////////////////////////////
                switch (*(name+8))
                {
                    case 1: //wepEnabled
                                                                //&encrypt
			 if (apmib_set( MIB_WLAN_ENCRYPT, (void *)var_val) == 0) 
			 {
                             printf("Set MIB_WLAN_ENCRYPT mib error!\n");
                	     return 0;
        		 }
                                                          
			/* Retrieve next page URL */
                         apmib_update(CURRENT_SETTING);

                         break;
		                                                                                                         
                    case 2: //wepKeyLength

			 if( apmib_set( MIB_WLAN_WEP , (void *)var_val) == 0)
                         {
                             	printf("Set WEP MIB error!\n");
                             	return 0;
                         }

			 // Retrieve next page URL //
                         apmib_update(CURRENT_SETTING);

                         break;

		    case 3: //wepKeyNumber

			 if( apmib_set( MIB_WLAN_WEP_DEFAULT_KEY, (void *)var_val) == 0)
			 {
			     printf("Set default tx key id error!\n");
                             return 0;
			 }

                         // Retrieve next page URL //
                         apmib_update(CURRENT_SETTING);                                                                                                     
                         break;

		    case 4: //wepKey

                  	if ( !apmib_get( MIB_WLAN_ENCRYPT,  (void *)&encrypt) )
                       	     return 0;
                  	if (encrypt == ENCRYPT_DISABLED)
                  	{
     //                	    strcpy( buffer, "Disabled" );
                            return 0;
                  	}
                  	else if (encrypt == ENCRYPT_WPA)
                     //     strcpy( buffer, T("WPA") );
                                 return 0;
                  	else if (encrypt == ENCRYPT_WPA2)
                     //     strcpy( buffer, T("WPA2") );
                                return 0;
                  	else if (encrypt == (ENCRYPT_WPA | ENCRYPT_WPA2))
                     //     strcpy( buffer, T("WPA2 Mixed") );
                                return 0;                                                                                                            else
                        {
                       	    WEP_T wep;
                        	if ( !apmib_get( MIB_WLAN_WEP,  (void *)&wep) )
                              		 return 0;
                                if( wep == WEP_DISABLED )
                              	       	 return 0;
                        	else if ( wep == WEP64 ){
                                 	if ( !apmib_get( MIB_WLAN_WEP_KEY_TYPE, (void *)&intVal) )
                                      		return 0;
                                 	if( intVal == 0 ){  //ASCII
                                      		if ( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
                                           		return 0;
						val++;
                                           	 name_len = strlen(var_val);

				      		if( val == 1 ){
								
					  			if( apmib_set(MIB_WLAN_WEP64_KEY1, (void *)var_val) == 0)
					  			{
									printf("Set wep64-key1 error!\n");
									return 0;			
					  			}
				      		}
				      		else if( val == 2 ){
                                           			if( apmib_set(MIB_WLAN_WEP64_KEY2, (void *)var_val) == 0)
                                           			{
                                                			printf("Set wep64-key2 error!\n");
									return 0;
                                           			}
				      		}
                                      		else if( val == 3 ){
					   			if( apmib_set(MIB_WLAN_WEP64_KEY3, (void *)var_val) == 0)
                                           			{
                                              				printf("Set wep64-key3 error!\n");
                                                			return 0;
                                           			}
				      		}
				      		else if( val == 4 ){
                                          			if( apmib_set(MIB_WLAN_WEP64_KEY4, (void *)var_val) == 0)
                                          			{
                                                			printf("Set wep64-key4 error!\n");
                                                			return 0;
                                          			}
				      		}
						else{
							printf("invlid value\n");
							return 0;
						}
				 	}  //ASCII
				 	else if( intVal == 1 ){   //hex
					
                                      		if ( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
                                           			return 0;
						val++;
                                                name_len = strlen(var_val);
                                                string_to_hex(var_val,key,10);
                                  //              printf("%d\n",name_len);
                                      		if( val == 1 ){
                                          			if( apmib_set(MIB_WLAN_WEP64_KEY1, (void *)key) == 0)
                                          			{
                                                			printf("Set wep64 key1 error!\n");
                                                			return 0;
                                          			}
                                      		}
                                      		else if( val == 2 ){
                                           			if( apmib_set(MIB_WLAN_WEP64_KEY2, (void *)key) == 0)
                                           			{
                                                			printf("Set wep64 key2 error!\n");
                                                			return 0;
                                           			}
                                      		}
                                      		else if( val == 3 ){
                                           			if( apmib_set(MIB_WLAN_WEP64_KEY3, (void *)key) == 0)
                                           			{
                                                			printf("Set wep64 key3 error!\n");
                                                			return 0;
                                           			}
                                      		}
                                      		else if( val == 4 ){
                                          			if( apmib_set(MIB_WLAN_WEP64_KEY4, (void *)key) == 0)
                                          			{
                                                			printf("Set wep64 key4 error!\n");
                                                			return 0;
                                          			}
                                      		}
						else{
							printf("invlid value\n");
							return 0;
						}   
				 	}  //hex  
				}  //wep == WEP64
		        	else if( wep == WEP128 ){
                                 	if ( !apmib_get( MIB_WLAN_WEP_KEY_TYPE, (void *)&intVal) )
                                      		return 0;
                                 	if( intVal == 0 ){  //ASCII
                                      		if ( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
                                          		return 0;
						val++;
						for(i=var_val_len;i<13;i++)
                                                var_val[i] = NULL;
                                                name_len = strlen(var_val);
                                      		if( val == 1 ){
                                          			if( apmib_set(MIB_WLAN_WEP128_KEY1, (void *)var_val) == 0)
                                          			{
                                                			printf("Set wep128-key1 error!\n");
                                                			return 0;
                                          			}
                                      		}
                                      		else if( val == 2 ){
                                           			if( apmib_set(MIB_WLAN_WEP128_KEY2, (void *)var_val) == 0)
                                           			{
                                                			printf("Set wep128-key2 error!\n");
                                                			return 0;
                                           			}
                                      		}
                                      		else if( val == 3 ){
                                           			if( apmib_set(MIB_WLAN_WEP128_KEY3, (void *)var_val) == 0)
                                           			{
                                                			printf("Set wep128-key3 error!\n");
                                                			return 0;
                                           			}
                                      		}
                                      		else if( val == 4 ){
                                          			if( apmib_set(MIB_WLAN_WEP128_KEY4, (void *)var_val) == 0)
                                          			{
                                                			printf("Set wep128-key4 error!\n");
                                                			return 0;
					 			}
				      		}
					// Retrieve next page URL //
                                        apmib_update(CURRENT_SETTING);
					}  //ASCII
                                 	else if( intVal == 1 ){   //hex
					//	printf("15\n");
                                      		if ( !apmib_get( MIB_WLAN_WEP_DEFAULT_KEY, (void *)&val) )
                                           		return 0;
						val++;
					/*	for(i=var_val_len;i<26;i++)
                                                var_val[i] = NULL;  */
                                                name_len = strlen(var_val);
						string_to_hex(var_val,key,26);
                                      		if( val == 1 ){
								printf("16\n");
                                          			if( apmib_set(MIB_WLAN_WEP128_KEY1, (void *)key) == 0)
                                          			{
                                                			printf("Set wep128 key1 error!\n");
                                                			return 0;
                                          			}
                                      		}
                                      		else if( val == 2 ){
                                           			if( apmib_set(MIB_WLAN_WEP128_KEY2, (void *)key) == 0)
                                           			{
                                                			printf("Set wep128 key2 error!\n");
                                                			return 0;
                                           			}
                                      		}
                                      		else if( val == 3 ){
                                           			if( apmib_set(MIB_WLAN_WEP128_KEY3, (void *)key) == 0)
                                           			{
                                                			printf("Set wep128 key3 error!\n");
                                                			return 0;
                                           			}
                                      		}
                                      		else if( val == 4 ){
                                          			if( apmib_set(MIB_WLAN_WEP128_KEY4, (void *)key) == 0)
                                          			{
                                                			printf("Set wep128 key4 error!\n");
                                                			return 0;
                                          			}
                                      		}
						else{
							printf("invlid value\n");
							return 0;
						}
					// Retrieve next page URL //
                                        apmib_update(CURRENT_SETTING);
				 	}  //hex
				} //wep == WEP128
			}
                         // Retrieve next page URL //
                         apmib_update(CURRENT_SETTING);                                                                                                    
                         break;

		    case 5: //denyUnencryptedData

			 if ( apmib_set( MIB_WLAN_AC_ENABLED, (void *)var_val ) == 0 )
			 {
                 		printf("invalid val\n");
                 		return 0;
			 }
			 printf("set success!!");
			 
			 // Retrieve next page URL //
                         apmib_update(CURRENT_SETTING);                                                                                                    
                         break;

		}  //switch(*(name+8))

//    	    system("sh /bin/init.sh gw all");                                                          
            break;
                                                                                   
    }  //switch(action)
    return SNMP_ERR_NOERROR;
                                                                                   
}   //write_privacySetint()
                                                                                   

