/*
 *  counters MIB group implementation - counters.c
 *
 */

#include <config.h>

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif

#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

/* needed by util_funcs.h */
#if TIME_WITH_SYS_TIME
# ifdef WIN32
#  include <sys/timeb.h>
# else
#  include <sys/time.h>
# endif
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_WINSOCK_H
#include <winsock.h>
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

/* mibincl.h contains all the snmp specific headers to define the
   return types and various defines and structures. */
#include "mibincl.h"

/* header_generic() comes from here */
#include "util_funcs.h"

#include "agent_read_config.h"

/* include our .h file */
#include "counters.h"

//////////////////////Yichun Nov 17 2005////////////////////////////////////////////
                                                                                
#include "../../../../goahead-2.1.1/LINUX/apmib.h"
#include "../../../../goahead-2.1.1/LINUX/mibtbl.h"
#include "../../../../goahead-2.1.1/LINUX/utility.h"
//#include "../../../../goahead-2.1.1/uemf.h"
                                                                                
/////////////////////////////////////////////////////////////



	/*********************
	 *
	 *  Initialisation & common implementation functions
	 *
	 *********************/

/* define the structure we're going to ask the agent to register our
   information at */

struct variable2 counters_variables[] = {
    { receivedPacketsGoodCount, ASN_COUNTER, RONLY, var_counters, 1, {1}},
    { receivedPacketsBadCount, ASN_COUNTER, RONLY, var_counters, 1, {2}},
    { sendPacketsGoodCount, ASN_COUNTER, RONLY, var_counters, 1, {3}},
    { sendPacketsBadCount, ASN_COUNTER, RONLY, var_counters, 1, {4}},
    { bootCount, ASN_COUNTER, RONLY, var_counters, 1, {5}},
  };


/* Define the OID pointer to the top of the mib tree that we're
   registering underneath */
   oid counters_variables_oid[] = { 1,3,6,1,4,1,14125,2 };

void init_counters(void)
{
/* register ourselves with the agent to handle our mib tree */
  REGISTER_MIB("senaoMIB/counters", counters_variables, variable2, counters_variables_oid);
}

        /*********************
         *
         *  System specific implementation functions
         *                                                                       
         *********************/
///////////////////////////+Dec 14 2005////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////

u_char	*
var_counters(struct variable *vp,
	    oid *name,
	    size_t *length,
	    int exact,
	    size_t *var_len,
	    WriteMethod **write_method)
{

  struct user_net_device_stats stats;
  char WLAN_IF[20];

  if (header_generic(vp, name, length, exact, var_len, write_method) == MATCH_FAILED)
    return NULL;

///////////////////YiChun Dec 14 2005/////////////////////////////////////////////
    if ( !apmib_init()) {
                        printf("Initialize AP MIB failed!\n");
                        return 0;
                }
                                                                                
//      printf("Initialize AP MIB success!\n");

///////////////////////////////////////////////////////////////////////////////

  switch (vp->magic)
  {
    case receivedPacketsGoodCount:
	  strcpy(WLAN_IF,"wlan0");
	  if ( getStats(WLAN_IF, &stats) < 0)
	  {
               		stats.rx_packets = 0;
	//		printf("rx_packets = 0\n");			
			return 0;
	  }	
	//	printf("rx_packers = %d \n",(int)stats.rx_packets);
          //      sprintf(buffer, "%d", (int)stats.rx_packets);
		long_return = (int)stats.rx_packets;
                return (u_char*)&long_return;
                                       

    case receivedPacketsBadCount:
          strcpy(WLAN_IF,"wlan0");
          if ( getStats(WLAN_IF, &stats) < 0)
          {
                        stats.rx_errors = 0;
          //              printf("rx_error=0\n");
                        return 0;
          }
          //      printf("rx_errors packers = %d \n",(int)stats.rx_errors);
          //      sprintf(buffer, "%d", (int)stats.rx_errors);
                long_return = (int)stats.rx_errors;
                return (u_char*)&long_return;

    case sendPacketsGoodCount:
	  strcpy(WLAN_IF,"wlan0");
	  if ( getStats(WLAN_IF, &stats) < 0)
	  {
                        stats.tx_packets = 0;
	//		printf("tx_packets = 0 \n");		
			return 0;	
	  }		
          //      sprintf(buffer, "%d", (int)stats.tx_packets);
	//	printf("tx_packets = %d\n",(int)stats.tx_packets);
		long_return = (int)stats.tx_packets;
                return (u_char*)&long_return;
	  

    case sendPacketsBadCount:
 	  strcpy(WLAN_IF,"wlan0");
          if ( getStats(WLAN_IF, &stats) < 0)
          {
                        stats.tx_errors = 0;
          //              printf("tx_errors=0\n");
                        return 0;
          }
         //       printf("tx_error packets = %d \n",(int)stats.tx_errors);
          //      sprintf(buffer, "%d", (int)stats.rx_errors);
                long_return = (int)stats.tx_errors;
                return (u_char*)&long_return;

    case bootCount:

        default:
            DEBUGMSGTL(("snmpd", "unknown sub-id %d in var_systemSet\n", vp->magic));
                                                                                                                             
  } //switch(magic)
                                                                                                                             
    return NULL;
                                                                                                                             
} //var_counters()



