#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>


int main(int argc, char** argv)
{
  unsigned long start_addr, end_addr, len, i;
  unsigned char *wbuf, *rbuf;
  int fh;

 if ( argc!=3 ) {
	printf("Invalid argument!\n");
	exit(1);
  }
  sscanf(argv[1], "%x", (unsigned int *)&start_addr);
  sscanf(argv[2], "%x", (unsigned int *)&end_addr);

  if (  start_addr > 0x400000 ||
	end_addr > 0x400000 ||
	start_addr > end_addr ) {
	printf("Invalid argument!\n");
	exit(1);
  }

  // generate test pattern
  len = end_addr - start_addr;
  wbuf = malloc(len);
  if ( wbuf == NULL ) {
  	printf("allocate write buffer failed!\n");
	exit(1);
  }
  for (i=0; i<len; i++)
  	wbuf[i] = (unsigned char)i;

  // open device and write data
#ifdef __mips__
  fh = open("/dev/mtd", O_RDWR);
#else
  fh = open("test.bin", O_RDWR|O_CREAT);
#endif

  if ( fh == -1 ) {
  	printf("open file failed!\n");
 	exit(1);
  }

  lseek(fh, start_addr, SEEK_SET);

  if ( write(fh, wbuf, len) != len) {
	printf("write data failed!\n");
	close(fh);
	exit(1);
  }
  close(fh);
  sync();

#ifdef __mips__
  fh = open("/dev/mtd", O_RDWR);
#else
  fh = open("test.bin", O_RDWR|O_CREAT,S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH);
#endif

  if ( fh == -1 ) {
  	printf("open file failed!\n");
 	exit(1);
  }

  // read data and compare result
  rbuf = malloc(len);
  if ( rbuf == NULL ) {
  	printf("allocate read buffer failed!\n");
	close(fh);
	exit(1);
  }

  lseek(fh, start_addr, SEEK_SET);
  if ( read(fh, rbuf, len) != len) {
	printf("read data failed!\n");
	close(fh);
	exit(1);
  }

  close(fh);
  if ( memcmp(wbuf, rbuf, len) )
  	printf("compare data error!\n");
  else
	printf("compare data ok!\n");
  
  return 0;	
}
