/*
 *      Include file of form handler
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: apform.h,v 1.16 2005/11/04 07:05:19 davidhsu Exp $
 *
 */

#ifndef _INCLUDE_APFORM_H
#define _INCLUDE_APFORM_H

#if HAVE_STDBOOL_H
# include <stdbool.h>
#else
typedef enum {false = 0, true = 1} bool;
#endif

#ifdef __i386__
  #define _CONFIG_SCRIPT_PATH	T(".")
  #define _LITTLE_ENDIAN_
#else
  #define _CONFIG_SCRIPT_PATH	T("/bin")
#endif

#define _CONFIG_SCRIPT_PROG	T("init.sh")
#define _WLAN_SCRIPT_PROG	T("wlan.sh")
#define _PPPOE_SCRIPT_PROG	T("pppoe.sh")
#define _FIREWALL_SCRIPT_PROG	T("firewall.sh")
#define _ROUTE_SCRIPT_PROG	T("route.sh")
#define _PPPOE_DC_SCRIPT_PROG	T("disconnect.sh")
#define _IAPPAUTH_SCRIPT_PROG	T("iappauth.sh")
#define _NTP_SCRIPT_PROG	T("ntp.sh")
#ifdef HOME_GATEWAY
#ifdef VPN_SUPPORT
#define _VPN_SCRIPT_PROG	T("vpn.sh")
#endif
#endif
#define _WLAN_APP_SCRIPT_PROG	T("wlanapp.sh")

#ifdef WLAN_EASY_CONFIG
#define _AUTO_CONFIG_DAEMON_PROG T("autoconf")
#endif

///////////////////////////////////////////////////////////////////////////
static bool _is_hex(char c)
{
    return (((c >= '0') && (c <= '9')) ||
            ((c >= 'A') && (c <= 'F')) ||
            ((c >= 'a') && (c <= 'f')));
}

// Validate digit
static bool _isdigit(char c)
{
    return ((c >= '0') && (c <= '9'));
}

static int __inline__ string_to_hex(char_t *string, unsigned char *key, int len)
{
	char tmpBuf[4];
	int idx, ii=0;
	for (idx=0; idx<len; idx+=2) {
		tmpBuf[0] = string[idx];
		tmpBuf[1] = string[idx+1];
		tmpBuf[2] = 0;
		if ( !_is_hex(tmpBuf[0]) || !_is_hex(tmpBuf[1]))
			return 0;

		key[ii++] = (unsigned char) strtol(tmpBuf, (char**)NULL, 16);
	}
	return 1;
}

static int __inline__ string_to_dec(char_t *string, int *val)
{
	int idx;
	int len = strlen(string);

	for (idx=0; idx<len; idx++) {
		if ( !_isdigit(string[idx]))
			return 0;
	}

	*val = strtol(string, (char**)NULL, 10);
	return 1;
}

#define ERR_MSG(msg) { \
	websHeader(wp); \
   	websWrite(wp, T("<body><blockquote><h4>%s</h4>\n"), msg); \
	websWrite(wp, T("<form><input type=\"button\" onclick=\"history.go (-1)\" value=\"&nbsp;&nbsp;OK&nbsp;&nbsp\" name=\"OK\"></form></blockquote></body>")); \
   	websFooter(wp); \
	websDone(wp, 200); \
}
//gemhom 2005/10/19
#define ERR_MSG2(msg) { \
	websHeader(wp); \
   	websWrite(wp, T("<body><blockquote><h4>%s</h4>\n"), msg); \
	websWrite(wp, T("<form><input type=\"button\" onclick=\"history.go (-1);self.parent.menu.location.reload('../menu_reload.asp');\" value=\"&nbsp;&nbsp;OK&nbsp;&nbsp\" name=\"OK\"></form></blockquote></body>")); \
   	websFooter(wp); \
	websDone(wp, 200); \
}
//Jacy 2006/11/02
#define ERR_MSG3(msg) { \
	websHeader(wp); \
   	websWrite(wp, T("<body><blockquote><h4>%s</h4>\n"), msg); \
	websWrite(wp, T("<form><input type=\"button\" onclick=\"history.go (-1);self.location.reload('../wlwpa.asp');\" value=\"&nbsp;&nbsp;OK&nbsp;&nbsp\" name=\"OK\"></form></blockquote></body>")); \
   	websFooter(wp); \
	websDone(wp, 200); \
}

/* jacy added reload webpage */
#define RELOAD_MSG(msg, url) { \
	websHeader(wp); \
	websWrite(wp, T("<body><blockquote><form name=\"redirect\"><h2>Reloading</font></h2>\n")); \
	websWrite(wp, T("<h4>%s</h4>\n"), msg); \
	websWrite(wp, T("<p>wait <input type=\"text\" size=\"2\" name=\"redirect2\">Sec...</p><p></center><script>\n")); \
	websWrite(wp, T("<!-- \n")); \
	websWrite(wp, T("var targetURL=\"../status.asp\"\n")); \
	websWrite(wp, T("var countdownfrom=18\n")); \
	websWrite(wp, T("var currentsecond=document.redirect.redirect2.value=countdownfrom+1\n")); \
	websWrite(wp, T("function countredirect(){\n")); \
	websWrite(wp, T("if (currentsecond!=1){\n")); \
	websWrite(wp, T("currentsecond-=1\n")); \
	websWrite(wp, T("document.redirect.redirect2.value=currentsecond }\n")); \
	websWrite(wp, T("else{\n")); \
	websWrite(wp, T("window.location=targetURL\n")); \
	websWrite(wp, T("return }\n")); \
	websWrite(wp, T("setTimeout(\"countredirect()\",1000) }\n")); \
	websWrite(wp, T("countredirect()\n")); \
	websWrite(wp, T("//--> </script><tr>\n")); \
	websWrite(wp, T("Please change the IP address in your web browser to default IP address</div></td></td></tr></p>\n")); \
	websWrite(wp, T("<div id=\"outside\"></div><p></p></p></form></body>\n")); \
  websFooter(wp); \
	websDone(wp, 200); \
}

/* jacy added reboot webpage */
#define REBOOT_MSG(msg, url) { \
	websHeader(wp); \
	websWrite(wp, T("<body><blockquote><form name=\"redirect\"><h2>Rebooting</font></h2>\n")); \
	websWrite(wp, T("<h4>%s</h4>\n"), msg); \
	websWrite(wp, T("<p>wait <input type=\"text\" size=\"2\" name=\"redirect2\">Sec...</p><p></center><script>\n")); \
	websWrite(wp, T("<!-- \n")); \
	websWrite(wp, T("var targetURL=\"../status.asp\"\n")); \
	websWrite(wp, T("var countdownfrom=50\n")); \
	websWrite(wp, T("var currentsecond=document.redirect.redirect2.value=countdownfrom+1\n")); \
	websWrite(wp, T("function countredirect(){\n")); \
	websWrite(wp, T("if (currentsecond!=1){\n")); \
	websWrite(wp, T("currentsecond-=1\n")); \
	websWrite(wp, T("document.redirect.redirect2.value=currentsecond }\n")); \
	websWrite(wp, T("else{\n")); \
	websWrite(wp, T("window.location=targetURL\n")); \
	websWrite(wp, T("return }\n")); \
	websWrite(wp, T("setTimeout(\"countredirect()\",1000) }\n")); \
	websWrite(wp, T("countredirect()\n")); \
	websWrite(wp, T("//--> </script><tr>\n")); \
	websWrite(wp, T("If you changed the IP address of the device <br>\n")); \
	websWrite(wp, T("you will need to change the IP address in your <br>\n")); \
	websWrite(wp, T("browser before accessing the configuration Web site again.</div></td></td></tr></p>\n")); \
	websWrite(wp, T("<div id=\"outside\"></div><p></p></p></form></body>\n")); \
  websFooter(wp); \
	websDone(wp, 200); \
}

//gemhom 2005/10/19
#define OK_MSG(url) { \
	websHeader(wp); \
   	websWrite(wp, T("<body><blockquote><h4>Change setting successfully!</h4>\n")); \
	if (url[0]) websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\")></form></blockquote></body>"), url);\
	else websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=window.close()></form></blockquote></body>"));\
   	websFooter(wp); \
	websDone(wp, 200); \
}

#define OK_MSG1(msg, url) { \
	websHeader(wp); \
   	websWrite(wp, T("<body><blockquote><h4>%s</h4>\n"), msg); \
	if (url) websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=window.location.replace(\"%s\")></form></blockquote></body>"), url);\
	else websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=window.close()></form></blockquote></body>"));\
   	websFooter(wp); \
	websDone(wp, 200); \
}
//gemhom 2005/10/19
#define OK_MSG2(url) { \
	websHeader(wp); \
   	websWrite(wp, T("<body><blockquote><h4>Change setting successfully!</h4>\n")); \
	if (url[0]) websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=\"JavaScript:window.location.replace('%s');self.parent.menu.location.reload('../menu_reload.asp');\"></form></blockquote></body>"), url);\
	else websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=window.close()></form></blockquote></body>"));\
   	websFooter(wp); \
	websDone(wp, 200); \
}

#define OK_MSG3(url) { \
	websHeader(wp); \
   	websWrite(wp, T("<body><blockquote><h4>Change setting successfully!</h4>\n")); \
	if (url[0]) websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=\"JavaScript:window.location.replace('%s');self.parent.menu.location.reload('../menu_reload.asp');self.parent.title.location.reload();\"></form></blockquote></body>"), url);\
	else websWrite(wp, T("<form><input type=button value=\"  OK  \" OnClick=window.close()></form></blockquote></body>"));\
   	websFooter(wp); \
	websDone(wp, 200); \
}
//gemhom 2005/10/19
//////////////////////////////////////////////////////////////////////////

/* Routines exported in fmmgmt.c */
extern int sysLogList(int eid, webs_t wp, int argc, char_t **argv);
extern void formPasswordSetup(webs_t wp, char_t *path, char_t *query);
extern void formUpload(webs_t wp, char_t * path, char_t * query);
#ifdef TLS_CLIENT
extern void formCertUpload(webs_t wp, char_t * path, char_t * query);
#endif
extern void formSaveConfig(webs_t wp, char_t *path, char_t *query);
extern void set_user_profile();
extern void formStats(webs_t wp, char_t *path, char_t *query);
extern void formLogout(webs_t wp, char_t *path, char_t *query);
extern void formSysCmd(webs_t wp, char_t *path, char_t *query);
extern int sysCmdLog(int eid, webs_t wp, int argc, char_t **argv);
extern void formSysLog(webs_t wp, char_t *path, char_t *query);
#ifdef HOME_GATEWAY
#ifdef DOS_SUPPORT
extern void formDosCfg(webs_t wp, char_t *path, char_t *query);
#endif
// by sc_yang
extern void formNtp(webs_t wp, char_t *path, char_t *query);
#endif //gemhom 2005/10/20
extern void formOpMode(webs_t wp, char_t *path, char_t *query);
//#endif gemhom 2005/10/20
extern void formWizard(webs_t wp, char_t *path, char_t *query);

/* Routines exported in fmget.c */
extern int getIndex(int eid, webs_t wp, int argc, char_t **argv);
extern int getInfo(int eid, webs_t wp, int argc, char_t **argv);
extern int isConnectPPP();

/* Routines exported in fmwlan.c */
extern void formWlanSetup(webs_t wp, char_t *path, char_t *query);
extern void formWlanSetup1(webs_t wp, char_t *path, char_t *query);
extern int wlAcList(int eid, webs_t wp, int argc, char_t **argv);
extern void formWlAc(webs_t wp, char_t *path, char_t *query);
extern void formAdvanceSetup(webs_t wp, char_t *path, char_t *query);
extern int wirelessClientList(int eid, webs_t wp, int argc, char_t **argv);
extern void formWirelessTbl(webs_t wp, char_t *path, char_t *query);
extern void formWep(webs_t wp, char_t *path, char_t *query);
extern void formWlSiteSurvey(webs_t wp, char_t *path, char_t *query);
extern int wepHandler(webs_t wp, char *tmpBuf, int wlan_id);
extern int wlanHandler(webs_t wp, char *tmpBuf, int *mode, int wlan_id); 
extern int wpaHandler(webs_t wp, char *tmpBuf, int wlan_id);
extern void formWlanRedirect(webs_t wp, char_t *path, char_t *query);
#ifdef TLS_CLIENT
extern int certRootList(int eid, webs_t wp, int argc, char_t **argv);
extern int certUserList(int eid, webs_t wp, int argc, char_t **argv);
#endif

int wlSiteSurveyTbl(int eid, webs_t wp, int argc, char_t **argv);
extern void formWlEncrypt(webs_t wp, char_t *path, char_t *query);

extern void formWlWds(webs_t wp, char_t *path, char_t *query);
extern int wlWdsList(int eid, webs_t wp, int argc, char_t **argv);
extern void formWdsEncrypt(webs_t wp, char_t *path, char_t *query);
extern int wdsList(int eid, webs_t wp, int argc, char_t **argv);

#ifdef WLAN_EASY_CONFIG
extern void sigHandler_autoconf(int signo);
extern void formAutoCfg(webs_t wp, char_t *path, char_t *query);
#endif

#ifndef NO_ACTION
extern void run_init_script(char *arg);
#endif

/* Routines exported in fmtcpip.c */
extern void formTcpipSetup(webs_t wp, char_t *path, char_t *query);
extern void formSnmpSetup(webs_t wp, char_t *path, char_t *query);  //yichun + for SNMP
extern int isDhcpClientExist(char *name);
extern void formReflashClientTbl(webs_t wp, char_t *path, char_t *query);
extern int dhcpClientList(int eid, webs_t wp, int argc, char_t **argv);
extern int tcpipLanHandler(webs_t wp, char *tmpBuf);
extern int SnmpLanHandler(webs_t wp, char *tmpBuf);  //yichun + for SNMP

#ifdef HOME_GATEWAY
extern void formWanTcpipSetup(webs_t wp, char_t *path, char_t *query);

/* Routines exported in fmfwall.c */
extern void formPortFw(webs_t wp, char_t *path, char_t *query);
extern void formFilter(webs_t wp, char_t *path, char_t *query);
extern int portFwList(int eid, webs_t wp, int argc, char_t **argv);
extern int portFilterList(int eid, webs_t wp, int argc, char_t **argv);
extern int ipFilterList(int eid, webs_t wp, int argc, char_t **argv);
extern int macFilterList(int eid, webs_t wp, int argc, char_t **argv);
extern int urlFilterList(int eid, webs_t wp, int argc, char_t **argv);
extern void formDMZ(webs_t wp, char_t *path, char_t *query);
extern void formTriggerPort(webs_t wp, char_t *path, char_t *query);
extern int triggerPortList(int eid, webs_t wp, int argc, char_t **argv);
extern int tcpipWanHandler(webs_t wp, char * tmpBuf, int *dns_changed);
/* Routines exported in fmroute.c */
#ifdef ROUTE_SUPPORT
extern void formRoute(webs_t wp, char_t *path, char_t *query);
extern int staticRouteList(int eid, webs_t wp, int argc, char_t **argv);
extern int kernelRouteList(int eid, webs_t wp, int argc, char_t **argv);
#endif
#endif

#ifdef HOME_GATEWAY
/* Routine exported in fmddns.c */
extern void formDdns(webs_t wp, char_t *path, char_t *query);
#endif

#ifdef HOME_GATEWAY
#ifdef VPN_SUPPORT
/* Routines exported in fmvpn.c */
extern void formVpnSetup(webs_t wp, char_t *path, char_t *query);
extern void formVpnConn(webs_t wp, char_t *path, char_t *query);
//extern int vpnStatList(int eid, webs_t wp, int argc, char_t **argv);
extern int vpnConnList(int eid, webs_t wp, int argc, char_t **argv);
extern int vpnRsaList(int eid, webs_t wp, int argc, char_t **argv);
extern int vpnShowLog(int eid, webs_t wp, int argc, char_t **argv);
extern void formVpnLog(webs_t wp, char_t *path, char_t *query);
extern int getVpnTblIdx(void);
extern void len2Mask(int len, char * mask );
extern int mask2Len(char *buf);
extern int getVpnKeyMode(void);
extern int  getConnStat(char *in_connName);
#endif
#endif

/* variables exported in main.c */
#ifdef HOME_GATEWAY
extern char *WAN_IF;
extern char *BRIDGE_IF;
extern char *ELAN_IF;
extern char *PPPOE_IF;

#else
extern char *BRIDGE_IF;
extern char *ELAN_IF;
#endif
extern char WLAN_IF[];
extern int wlan_num;
#endif // _INCLUDE_APFORM_H
