/* vi: set sw=4 ts=4: */
/*
 * Copyright 1989 - 1991, Julianne Frances Haugh <jockgrrl@austin.rr.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Julianne F. Haugh nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY JULIE HAUGH AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JULIE HAUGH OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <syslog.h>
#include <ctype.h>
#include <crypt.h>

#include "libbb.h"

#include "busybox.h" //lingfeng +

/* Ask the user for a password.
   Return 1 if the user gives the correct password for entry PW,
   0 if not.  Return 1 without asking for a password if run by UID 0
   or if PW has an empty password.  */

int correct_password ( const struct passwd *pw )
{
	char *unencrypted, *encrypted, *correct;
	unsigned char buffer[32];
	
#ifdef CONFIG_FEATURE_SHADOWPASSWDS  //lingfeng + support shadowpasswords, I do not know 
                                     // should we support busybox shadow password in our product?

	if (( strcmp ( pw-> pw_passwd, "x" ) == 0 ) || ( strcmp ( pw-> pw_passwd, "*" ) == 0 )) {
		struct spwd *sp = getspnam ( pw-> pw_name );
		
		if ( !sp )
			bb_error_msg_and_die ( "no valid shadow password" );
		
		correct = sp-> sp_pwdp;
	}
	else
#endif
   
   #ifdef LingFengTelnetD
	    if ( !apmib_init()) {
                        printf("Initialize AP MIB failed!\n");
                        return 0;
        }
    	if ( !apmib_get(MIB_USER_PASSWORD,(void *)buffer)) {
			printf("get password failed\n");
        	return 0;
		}
   #else
 	 correct = pw-> pw_passwd;
     if ( correct == 0 || correct[0] == '\0' ) //lingfeng + if we allow password is NULL
        return 1;                          //and already store in system, then directly
                                          // Jump to busybox shell, the getpass prompt
                                          // will not pop out in telnet window. However
// 3220 series does not support Null password in WebPage, so we must disable this step
// in Telnet daemon.
   #endif 
   
repeat:
	unencrypted = getpass ( "Password: " );

	if ( !unencrypted )
	{
		fputs ( "getpass: cannot open /dev/tty\n", stderr );
		return 0;
	}
	#ifdef LingFengTelnetDdbg                                     
	//	printf("password is %s\n",unencrypted);
	#endif
	correct = buffer;
	#ifdef LingFengTelnetDdbg                                     
	//	printf("mib password is %s\n",correct);
	#endif
//	encrypted = crypt ( unencrypted, correct );
//	printf("encrypted = %s\n",encrypted);
//	char result; //Elain add for unencrypted password
	int password_len;
    password_len = strlen(unencrypted);
//    printf("1.password_len=%d\n",password_len);
	if (strcmp(unencrypted,correct) == 0) {
          printf("2.password_len=%d\n",password_len);
          printf("1.%s\n",correct);
		  memset ( unencrypted, 0, bb_strlen ( unencrypted ));
		  return 1;
    }
    else {
            if (password_len > 30 ) {
              printf("3.len=%d\n",password_len);
              printf("2.%s\n",correct);
			  puts("Input password only up to 30 character");
			  memset ( unencrypted, 0, bb_strlen ( unencrypted ));
              return 0;
            }
            else if (password_len <= 30) {
              printf("4.len=%d\n",password_len);
              printf("3.%s\n",correct);
			  puts("Incorrect password");
			  memset ( unencrypted, 0, bb_strlen ( unencrypted ));
              return 0;
            }
    }
//	result = ( strcmp ( unencrypted, correct ) == 0 ) ? 1 : 0;
//	memset ( unencrypted, 0, bb_strlen ( unencrypted ));
//	return result;
}
