/*
 * relay and default driver
 * version 0.1
 * yansl
 */

#include <linux/init.h>
#include <linux/fs.h>
#include <linux/major.h>
#include <linux/poll.h>
#include <linux/interrupt.h>
#include <asm/uaccess.h>
#include <asm/blackfin.h>
#include <linux/proc_fs.h>


#define RELAY_MAJOR 242
#define DEVICE_NAME "Relay"

int relay_major;

static int device_open = 0;

static int relay_open(struct inode *inode, struct file *filp);
static ssize_t relay_read(struct file *filp, char *buf, size_t size, loff_t *offp);
static ssize_t relay_write(struct file *filp, const char *buf, size_t size, loff_t *offp);
static int relay_ioctl(struct inode *inode, struct file *filp, uint cmd, unsigned long arg);
static int relay_release(struct inode *inode, struct file *filp);

static int
relay_open(struct inode *inode, struct file *filp)
{
	if (device_open)
		return -EBUSY;
	return 0;
}

static int
relay_release(struct inode *inode, struct file *filp)
{
	return 0;
}

static ssize_t
relay_read(struct file *filp, char *buf, size_t size, loff_t *offp)
{
	const char *bit;

	bit = ((bfin_read_FIO_FLAG_D() >> 1) & 0x01) ? "1" : "0";
	__builtin_bfin_ssync();

	return (copy_to_user(buf, bit, 2)) ? -EFAULT : 2;
}

static ssize_t
relay_write(struct file *filp, const char *buf, size_t size, loff_t *offp)
{

	if (buf[0] == '0')
		bfin_write_FIO_FLAG_C(PF2);
	else
		bfin_write_FIO_FLAG_S(PF2);
		
	return 0;

}

static int
relay_ioctl(struct inode *inode, struct file *filp, uint cmd, unsigned long arg)
{
	return 0;
}

static struct file_operations relay_fops = {
	open:relay_open,
	read:relay_read,
	write:relay_write,
	ioctl:relay_ioctl,
	release:relay_release
};

static int 
__init relay_init(void)
{
	relay_major = register_chrdev(RELAY_MAJOR, DEVICE_NAME, &relay_fops);
	if (relay_major < 0)
	{
		printk(KERN_INFO"Registering the device Relay failed with %d\n", relay_major);
		return relay_major;
	}
	else
		printk(KERN_INFO"Registering the device Relay ok!\n");
	
	return 0;
}

void
__exit relay_exit(void)
{
	int ret;
	ret = unregister_chrdev(RELAY_MAJOR, DEVICE_NAME);
	if (ret < 0)
		printk(KERN_INFO"Unregister device Relay err with %d\n", ret);
}

module_init(relay_init);
module_exit(relay_exit);
