/*
 * led driver
 */
#include<linux/module.h>
#include<linux/config.h>
#include<linux/init.h>
#include<linux/fs.h>
#include<asm/uaccess.h>
#include<asm/io.h>
#include<linux/delay.h>
#include<linux/sched.h>
#include"bf533_led.h"

#define WATCHDOG

int  __init led_init(void);
void __exit led_exit(void);

int led_open(struct inode *, struct file *);
int led_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg);
int led_release(struct inode *, struct file *);

static spinlock_t conf_spinlock = SPIN_LOCK_UNLOCKED;

static struct file_operations fops={
	open: led_open,
	ioctl: led_ioctl,
	release: led_release,
};

static void my_timer_func(unsigned long ptr)
{
	static unsigned long cycle_count = 0;
	unsigned long flags;

	spin_lock_irqsave(&conf_spinlock, flags);
	{
		#ifdef WATCHDOG
		if (bfin_read_WDOG_STAT() < 0xCCE924)
		{
			bfin_write_FIO_FLAG_C(PF0);
			barrier();
		}
		#endif	
        	if ( cycle_count%2 == 0 )
		{
                	*led_addr = led_val | led_status;
                	barrier();
        	}
        	else
        	{
               		*led_addr = led_val & ~led_status;
                	barrier();
        	}

        	cycle_count++;
		my_timer.expires = jiffies+BLINK_DELAY;
		add_timer(&my_timer);
	}
	spin_unlock_irqrestore(&conf_spinlock, flags);

}

int __init led_init(void)
{
	Major=register_chrdev(240, DEVICE_NAME, &fops);
	if(Major<0){
		printk(KERN_INFO"Registering the device YanSL_LED failed with %d\n",Major);
		return Major;
	}
	else
		printk(KERN_INFO"Registering the device YanSL_LED ok!\n");

	led_addr = (u16*)LED_ADDR;
	led_val = 0;
	led_status = 0;
	*led_addr = led_val;

	init_timer(&my_timer);
	my_timer.function = my_timer_func;
	my_timer.data = 0;
	my_timer.expires = jiffies+BLINK_DELAY;
	add_timer(&my_timer);

	return SUCCESS;
}

void __exit led_exit(void)
{
	int ret=unregister_chrdev(Major, DEVICE_NAME);
	if(ret<0)
		printk(KERN_INFO"Error in unregister device YanSL_LED with %d\n",ret);
}

int led_open(struct inode *inode, struct file *file)
{
	if(Device_Open) return -EBUSY;
	return SUCCESS;
}

int led_release(struct inode *inode, struct file *file)
{
	return SUCCESS;
}

int led_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg)
{
	void __user *argp = (void __user *)arg;
	int __user *p = argp;
	int new_arg = 0;
	
	get_user(new_arg, p);	
	dat = 1 << new_arg;

	switch(cmd)
	{
		case LED_START:
		{
			led_status = led_status & ~dat;
			barrier();
			bld_count[new_arg] = 0;
			barrier();
			led_val = led_val | dat;
			barrier();
			*led_addr = led_val;
			barrier();
			break;
		}
		case LED_STOP:
		{
			led_status = led_status & ~dat;
			barrier();
			bld_count[new_arg] = 0;
			barrier();
			led_val = led_val & ~dat;
			barrier();
			*led_addr = led_val;
			barrier();
			break;
		}
		case LED_BLINK:
		{
			bld_count[new_arg]++;
			barrier();
			led_status = led_status | dat;
			barrier();
			break;
		}
		case LED_N_BLINK:
		{
			bld_count[new_arg]--;
			barrier();
			if (bld_count[new_arg] == 0)
			{
				led_status = led_status & ~dat;
				barrier();
			}
			if (bld_count[new_arg] < 0)
			{
				bld_count[new_arg] = 0;
				barrier();
			}
			break;
		}
		default:
			break;
	}
	return SUCCESS;
}

module_init(led_init);
module_exit(led_exit);
