//*****************************************************************************
//*
//*
//*      System.h
//*
//*
//*****************************************************************************
#ifndef     __SYSTEM_H__
#define     __SYSTEM_H__


#ifdef      _DEBUG
    #define HEAP_DEBUG
#else
    #ifdef  HEAP_DEBUG
    #undef  HEAP_DEBUG
    #endif
#endif

#ifndef     SYS_USE_WDOGUTIL_H
#define 	SYS_USE_WDOGUTIL_H	0
#endif 	
#ifndef     SYS_USE_THREAD_H
#define 	SYS_USE_THREAD_H	0
#endif 	
#ifndef     SYS_HAS_SHORT_NAME
#define     SYS_HAS_SHORT_NAME	1
#endif
#ifndef     SYS_HAS_NAME_INFO
#define     SYS_HAS_NAME_INFO   0
#endif
#ifndef 	SYS_USE_WATCHDOG
#define 	SYS_USE_WATCHDOG	0
#endif

#ifdef  __cplusplus
extern "C"{
#endif

#ifdef  linux
#ifndef LINUX
#define LINUX
#endif
#endif


//*****************************************************************************
//*
//*		Windows
//*
//*****************************************************************************
#if (defined(WIN32) || defined(WIN64)) && !defined(RTTARGET)

    #ifndef WINBASEAPI
    #define WINBASEAPI __declspec(dllimport)
    #endif

    WINBASEAPI int      __stdcall HeapDestroy(void*  hHeap);
    WINBASEAPI void*    __stdcall HeapAlloc  (void*  hHeap,unsigned long dwFlags,unsigned long dwBytes);
    WINBASEAPI int      __stdcall HeapFree   (void*  hHeap,unsigned long dwFlags,void* lpMem);
    WINBASEAPI void*    __stdcall HeapReAlloc(void*  hHeap,unsigned long dwFlags,void *lpMem,unsigned long dwBytes);
    WINBASEAPI void*    __stdcall HeapCreate (unsigned long dwOptions,unsigned long dwInitialSize,unsigned long dwMaximumSize);

#endif


//*****************************************************************************
//*
//*		Rttarget
//*
//*****************************************************************************
#ifdef      RTTARGET

    #ifndef WINBASEAPI
    #define WINBASEAPI __declspec(dllimport)
    #endif

    WINBASEAPI int      __stdcall HeapDestroy(void*  hHeap);
    WINBASEAPI void*    __stdcall HeapAlloc  (void*  hHeap,unsigned long dwFlags,unsigned long dwBytes);
    WINBASEAPI int      __stdcall HeapFree   (void*  hHeap,unsigned long dwFlags,void* lpMem);
    WINBASEAPI void*    __stdcall HeapReAlloc(void*  hHeap,unsigned long dwFlags,void *lpMem,unsigned long dwBytes);
    WINBASEAPI void*    __stdcall HeapCreate (unsigned long dwOptions,unsigned long dwInitialSize,unsigned long dwMaximumSize);

#endif


//*****************************************************************************
//*
//*		Linux
//*
//*****************************************************************************
#ifdef      LINUX

    #ifndef _cdecl
    #define _cdecl
    #endif

    #ifndef __cdecl
    #define __cdecl
    #endif

    int     HeapDestroy(void*  hHeap);
    void*   HeapAlloc  (void*  hHeap,unsigned dwFlags,unsigned dwBytes);
    int     HeapFree   (void*  hHeap,unsigned dwFlags,void* lpMem);
    void*   HeapReAlloc(void*  hHeap,unsigned dwFlags,void *lpMem,unsigned dwBytes);
    void*   HeapCreate (unsigned dwOptions,unsigned dwInitialSize,unsigned dwMaximumSize);

#endif


//*****************************************************************************
//*
//*		System defines
//*
//*****************************************************************************

#ifndef     TRUE
#define     TRUE            1
#endif

#ifndef     FALSE
#define     FALSE           0
#endif

#ifndef     SEEK_SET
#define     SEEK_SET        0
#endif

#ifndef     SEEK_CUR
#define     SEEK_CUR        1
#endif

#ifndef     SEEK_END
#define     SEEK_END        2
#endif

#ifndef     MAX_PATH
#define     MAX_PATH        256
#endif


#define		SYS_ERR_NONE                 0
#define		SYS_ERR_PARAM               -1
#define		SYS_ERR_INVALID_FILENAME    -2
#define		SYS_ERR_FILE_NOT_FOUND      -3
#define		SYS_ERR_ACCESS_DENIED       -4
#define		SYS_ERR_NO_HANDLES          -5
#define		SYS_ERR_UNKNOWN             -6
#define		SYS_ERR_PATH_NOTFOUND       -7
#define		SYS_ERR_DISKFULL            -8
#define 	SYS_ERR_ALREADY_EXISTS		-9



#define     SYS_READ        0x0001                          // read access for files
#define     SYS_WRITE       0x0002                          // write access for files
#define     SYS_CREATE      0x0004                          // create the file if it didn't exist
#define     SYS_TRUNC       0x0008                          // set the file size to zero
#define     SYS_DIR         0x0010                          // the file is a directory
#define     SYS_HIDDEN      0x0020                          // the hidden flag for files
#define     SYS_ARCHIVE     0x0040                          // the archive flag for files (set at writes)
#define     SYS_SYSTEM      0x0080                          // the system flag for files
#define     SYS_VOLUME      0x0100                          // the volume flag for disknames
#define     SYS_EXEC	    0x0200                          // execute acces for the file
#define     SYS_SHARE_RD    0x0400                          // read access for more than one file
#define     SYS_SHARE_WR    0x0800                          // write access for more than one file
#define     SYS_HIGHMASK    0xFC00                          // mask  for the 64 bit size
#define     SYS_HIGHSHIFT   10                              // shift for the 64 bit size

#define     SYS_GLOBAL      0x80000000                      // absolute global priority for threads

typedef     unsigned        SysDW;
typedef     unsigned        SysTime;
typedef     unsigned       *SysFind;
typedef		unsigned	   *SysWdog;
typedef     unsigned char  *SysFile;
typedef     void           *SysHeap;
typedef     void           *SysThread;
typedef     void           *SysSemaphore;



typedef struct
    {
    SysDW   		dwAttr;                                // file attributes (see SYS_???)
    SysDW   		dwSize;                                // file size
    SysTime 		dwTimeCreate;                          // creation time of file
    SysTime 		dwTimeAccess;                          // last accestime of file
    SysTime 		dwTimeWrite;                           // last write time of file
    char    		cName[256];                            // file name
    #if SYS_HAS_SHORT_NAME								   
    char    		cShortName[16];                        // short file name (8.3)
    #endif
    }SysFindStruct;

typedef struct
    {
    unsigned short  usYear;                                 // year         (0..9999)
    unsigned char   ucMonth;                                // month        (1..12)
    unsigned char   ucDay;                                  // day of month (1..31)
    unsigned char   ucHour;                                 // hour         (0..23)
    unsigned char   ucMinute;                               // minute       (0..59)
    unsigned char   ucSecond;                               // secound      (0..59)
    unsigned char   ucIsDst;                                // daylight saving (0=no 1=yes)
    }SysTimeStruct;

typedef struct
    {
    SysDW			dwFreeUnits;
    SysDW   		dwTotalUnits;
    SysDW   		dwBytesPerSector;
    SysDW   		dwSectorsPerUnit;
    SysDW   		dwSerialNumber;
    char    		cName[16];
    char    		cFsType[16];
    }SysVolumeInfo;

    
//*****************************************************************************
//*
//*		file functions
//*
//*****************************************************************************

    #define         SysOpen(n,f)	SysOpenEx(n,f,0)
    SysFile         SysOpenEx       (const char *pFilename,unsigned uFlags,int *pError);
    int             SysClose        (SysFile hHandle);
    int             SysFlush        (SysFile hHandle);
    int             SysSeek         (SysFile hHandle,SysDW dwOffset,int iType);
    int             SysTell         (SysFile hHandle);
    int             SysRead         (SysFile hHandle,      void *pBuffer ,SysDW uSize);
    int             SysWrite        (SysFile hHandle,const void *pBuffer ,SysDW uSize);
    int             SysGetFileSize  (SysFile hHandle);
    int             SysGetFileInfo  (SysFile hHandle,SysFindStruct *pFind);

    int             SysMkdir        (const char *pFilename);
    int             SysRmdir        (const char *pFilename);
    int             SysDelete       (const char *pFilename);
    int             SysMove         (const char *pFilename,const char *pNewFilename);

    int             SysGetAttributes(const char *pFilename);
    int             SysSetAttributes(const char *pFilename,SysDW dwAttrib);

    int             SysGetFileTime  (SysFile hHandle,SysTime *dwWrite,SysTime *dwCreate,SysTime *dwAccess);
    int             SysSetFileTime  (SysFile hHandle,SysTime  dwWrite,SysTime  dwCreate,SysTime  dwAccess);
    int             SysSetFileSize  (SysFile hHandle,SysDW    ulSize);

    int             SysGetVolumeInfo(const char *pFilename,SysVolumeInfo *pInfo,int iCalcFree);
    int             SysGetFullPath  (const char *pFilename,char *pBuffer,int iMax);


    // Find Functions

    #define         SysFindFirst(pFilename,pFind)   SysFindFirstEx(pFilename,pFind,0)
    SysFind         SysFindFirstEx  (const char *pFilename,SysFindStruct *pFind,int *pError);
    int             SysFindNext     (SysFind hHandle      ,SysFindStruct *pFind);
	int 			SysFindClose	(SysFind hHandle);


//*****************************************************************************
//*
//*		thread functions
//*
//*****************************************************************************

#if SYS_USE_THREAD_H

	#include		"Thread.h"

    #define 	    SysSleep(t)					ThreadSleep(t)
    #define 	    SysTickCount()				ThreadTickCount()
    #define 	    SysSemaphoreCreate()		ThreadSemaphoreInit()
    #define 	    SysSemaphoreCreateEx(n)		ThreadSemaphoreInitEx(n)
    #define 	    SysSemaphoreDelete(s)		ThreadSemaphoreExit(s)
    #define 	    SysSemaphoreUnlock(s)		ThreadSemaphoreRelease(s)
    #define 	    SysSemaphoreLock			ThreadSemaphoreWait(s)
    #define 	    SysSemaphoreLockWait(s,t)	ThreadSemaphoreTimed(s,t)
    #define 	    SysThreadStart(f,s,a,p,n)	ThreadStartEx(f,s,a,p,n)

	#if				THREAD_CHECK
	extern void		SysThreadCheckSet(f,l)		ThreadCheckSet(f,l)
	extern int		SysThreadCheckGet(h,p,s,a)	ThreadCheckGet(h,p,s,a)
	#define			SysThreadCheck()			ThreadCheckSet(__FILE__,__LINE__)
	#else
	#define			SysThreadCheck()
	#endif

#else 

    void            SysSleep					(SysDW dwMillisec);
    SysDW           SysTickCount        		();
    SysSemaphore    SysSemaphoreCreate  		();
    SysSemaphore    SysSemaphoreCreateEx		(int iNumber);
    int             SysSemaphoreDelete  		(SysSemaphore hSema);
    int             SysSemaphoreUnlock  		(SysSemaphore hSema);
    int             SysSemaphoreLock    		(SysSemaphore hSema);
    int             SysSemaphoreLockWait		(SysSemaphore hSema,SysDW dwMillisec);
    SysThread       SysThreadStart				(void( _cdecl *pStartProc)(void*),SysDW uStackSize,void *pParam,int iPriority,const char *pName);
	#define			SysThreadCheck()

#endif 	

//*****************************************************************************
//*
//*		time functions
//*
//*****************************************************************************

    int             SysTimeConvertSD (SysTime              uSysTime ,SysDW   *pDosTime);
    int             SysTimeConvertSF (SysTime              uSysTime ,void    *pWftTime);
    int             SysTimeConvertSU (SysTime              uSysTime ,void    *pUtcTime);
    int             SysTimeConvertDS (SysDW                uDosTime ,SysTime *pSysTime);
    int             SysTimeConvertFS (const void          *pWftTime ,SysTime *pSysTime);
    int             SysTimeConvertUS (const void          *pUtcTime ,SysTime *pSysTime);
    void            SysTimeToStruct  (      SysTimeStruct *pData    ,SysTime  uSysTime,unsigned uMode);
    SysTime         SysTimeFromStruct(const SysTimeStruct *pData                      ,unsigned uMode);
    SysDW           SysTimeToWeekday (SysTime              uSysTime);
    SysDW           SysTimeGet       ();


//*****************************************************************************
//*
//*		heap functions
//*
//*****************************************************************************

#ifdef  HEAP_DEBUG

    void           *HeapReAllocD(void *hHeap,SysDW dwFlags,void *pMem,SysDW dwBytes,int iLine,const char *pFile);
    void           *HeapAllocD  (void *hHeap,SysDW dwFlags,           SysDW dwBytes,int iLine,const char *pFile);
    int             HeapFreeD   (void *hHeap,SysDW dwFlags,void *pMem              ,int iLine,const char *pFile);
    int             HeapPrint();

    #define         SysHeapCreate(s)        HeapCreate  (0,s,s)
    #define         SysHeapDestroy(h)       HeapDestroy (h)
    #define         SysHeapReAlloc(h,p,s)   HeapReAllocD(h,0,p,s,__LINE__,__FILE__)
    #define         SysHeapAlloc(h,s)       HeapAllocD  (h,0,  s,__LINE__,__FILE__)
    #define         SysHeapFree(h,p)        HeapFreeD   (h,0,p  ,__LINE__,__FILE__)

#else

    #define         SysHeapCreate(s)        HeapCreate (0,s,s)
    #define         SysHeapDestroy(h)       HeapDestroy(h)
    #define         SysHeapReAlloc(h,p,s)   HeapReAlloc(h,0,p,s)
    #define         SysHeapAlloc(h,s)       HeapAlloc  (h,0,s)
    #define         SysHeapFree(h,p)        HeapFree   (h,0,p)
    #define         HeapPrint()


#endif



//*****************************************************************************
//*
//*		Watchdog functions
//*
//*****************************************************************************

#if SYS_USE_WDOGUTIL_H

	#include				"WatchdogUtility.h"

	#define 				SysWatchdogExit	     	WatchdogExit
	#define 				SysWatchdogReset		WatchdogReset	 	
	#define 				SysWatchdogRunning	 	WatchdogRunning
	#define 				SysWatchdogInit		 	WatchdogInit
	#define 				SysWatchdogRegister		WatchdogRegister	
	#define 				SysWatchdogChangeTime	WatchdogChangeTime
	#define 				SysWatchdogUnregister	WatchdogUnregister
	#define 				SysWatchdogTrigger   	WatchdogTrigger
	
#elif SYS_USE_WATCHDOG

	void					SysWatchdogExit	     ();
	void					SysWatchdogReset	 ();
	int						SysWatchdogRunning	 ();
	void					SysWatchdogInit		 (unsigned uTime);
	SysWdog					SysWatchdogRegister  (unsigned uUpdateMaxTime,const char *pName=0);
	void					SysWatchdogChangeTime(SysWdog hWatchdog,unsigned uUpdateMaxTime,const char *pNewName=0);
	void					SysWatchdogUnregister(SysWdog hWatchdog);
	static inline void 		SysWatchdogTrigger   (SysWdog hWatchdog){if(hWatchdog)hWatchdog[0]++;}

#else

	static inline void		SysWatchdogExit      (){};
	static inline void		SysWatchdogReset     (){};
	static inline int 		SysWatchdogRunning   (){return 1;}
	static inline void		SysWatchdogInit      (unsigned uTime){};
	static inline SysWdog	SysWatchdogRegister  (unsigned uUpdateMaxTime,const char *pName){return (SysWdog)1;}
	static inline void		SysWatchdogChangeTime(SysWdog hWatchdog,unsigned uUpdateMaxTime,unsigned char *pNewName=0){};
	static inline void		SysWatchdogUnregister(SysWdog hWatchdog){};
	static inline void		SysWatchdogTrigger   (SysWdog hWatchdog){};

#endif



#ifdef  __cplusplus
}
#endif

#endif
