/*
 *  Boa, an http server.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define MAX_GROUPS 128

/*
 * User name, password, and the numerical group identifiers from the UNIX
 * files passswd and group.
 */
struct user {
     char *name;
     char *passwd;
     int no_groups;
     gid_t groups[MAX_GROUPS];
     char *realm_list;
#ifdef GROUP_POLICY
     int policy;
#endif
     struct user *next;
};

/*
 * List contains all defined users from UNIX files.
 */
extern struct user *users;

void init_users(void);
#ifndef DISABLE_DEBUG
void dump_users(void);
#endif
void parse_passwd(const char *path);
void parse_group(const char *path);
struct user *find_user(const char *user_name);
struct group *find_group_name(const char *path, const char *group_name);
