#! /bin/sh

if false; then
 echo "Not reached."
elif [ -f ./configure.in ]; then
        t=.
elif [ -f ../configure.in ]; then
        t=../
else
  echo "Not in right place, dying."
  exit 1;
fi

cd $t

libtoolize -c --force && aclocal && automake -a -c --force-missing && autoconf

# Fix automake...
rm -f COPYING
ln Documentation/COPYING.LIB COPYING

gen_prefix=include/internal_syms_generated/vstr

# BEG: Create linker file...
perl -pe 'BEGIN { print " VSTR_1.0 {\n  global:\n"; }
          END   { print " local:\n    vstr__*;\n};\n"; }
        s/^(.*)\((.*)\)\n$/vstr_$1;\n/ ||
        s/^([^#].*[^)])\n$/vstr_$1;\n/;' \
  include/vstr.exported_symbols > src/linker-script 
# END: Create linker file...

# BEG: Create alias files...
perl -pe 'BEGIN { print "/* DO NOT EDIT THIS FILE */\n"; }
        s/^(.*)\((.*)\)\n$/#ifdef $2\nVSTR__SYM($1)\n#endif\n\n/ ||
        s/^([^#].*[^)])\n$/VSTR__SYM($1)\n/;' \
  include/vstr.exported_symbols > $gen_prefix-alias-symbols.h
# END: Create alias files...

# BEG: Create cpp mapping to internal names
perl -pe 'BEGIN { print "/* DO NOT EDIT THIS FILE */\n"; }
        s/^(.*)\((.*)\)\n$/#ifdef $2\n#define vstr_$1 vstr_nx_$1\n#endif\n\n/ ||
        s/^([^#].*[^)])\n$/#define vstr_$1 vstr_nx_$1\n/;' \
  include/vstr.exported_symbols > $gen_prefix-cpp-symbols_fwd.h
perl -pe 'BEGIN { print "/* DO NOT EDIT THIS FILE */\n"; }
        s/^(.*)\((.*)\)\n$/#ifdef $2\n#undef vstr_$1\n#endif\n\n/ ||
        s/^([^#].*[^)])\n$/#undef vstr_$1\n/;' \
  include/vstr.exported_symbols > $gen_prefix-cpp-symbols_rev.h
# END: Create cpp mapping to internal names

