#!/bin/sh
##############################################################################
# Copyright (c) 1998-2001,2006 Free Software Foundation, Inc.                #
#                                                                            #
# Permission is hereby granted, free of charge, to any person obtaining a    #
# copy of this software and associated documentation files (the "Software"), #
# to deal in the Software without restriction, including without limitation  #
# the rights to use, copy, modify, merge, publish, distribute, distribute    #
# with modifications, sublicense, and/or sell copies of the Software, and to #
# permit persons to whom the Software is furnished to do so, subject to the  #
# following conditions:                                                      #
#                                                                            #
# The above copyright notice and this permission notice shall be included in #
# all copies or substantial portions of the Software.                        #
#                                                                            #
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR #
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,   #
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL    #
# THE ABOVE COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER      #
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING    #
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER        #
# DEALINGS IN THE SOFTWARE.                                                  #
#                                                                            #
# Except as contained in this notice, the name(s) of the above copyright     #
# holders shall not be used in advertising or otherwise to promote the sale, #
# use or other dealings in this Software without prior written               #
# authorization.                                                             #
##############################################################################
# $Id: MKfallback.sh,v 1.1 2009-05-21 08:33:45 steven Exp $
#
# MKfallback.sh -- create fallback table for entry reads
#
# This script generates source code for a custom version of read_entry.c
# that (instead of reading capabilities for an argument terminal type
# from an on-disk terminfo tree) tries to match the type with one of a
# specified list of types generated in.
#

terminfo_dir=$1
shift

terminfo_src=$1
shift

if test $# != 0 ; then
	tmp_info=tmp_info
	echo creating temporary terminfo directory... >&2

	TERMINFO=`pwd`/$tmp_info
	export TERMINFO

	TERMINFO_DIRS=$TERMINFO:$terminfo_dir
	export TERMINFO_DIRS

	tic -x $terminfo_src >&2
else
	tmp_info=
fi

cat <<EOF
/*
 * DO NOT EDIT THIS FILE BY HAND!  It is generated by MKfallback.sh.
 */

#include <curses.priv.h>
#include <term.h>

EOF

if [ "$*" ]
then
	cat <<EOF
#include <tic.h>

/* fallback entries for: $* */
EOF
	for x in $*
	do
		echo "/* $x */"
		infocmp -E $x
	done

	cat <<EOF
static const TERMTYPE fallbacks[$#] =
{
EOF
	comma=""
	for x in $*
	do
		echo "$comma /* $x */"
		infocmp -e $x
		comma=","
	done

	cat <<EOF
};

EOF
fi

cat <<EOF
NCURSES_EXPORT(const TERMTYPE *) _nc_fallback (const char *name GCC_UNUSED)
{
EOF

if [ "$*" ]
then
	cat <<EOF
    const TERMTYPE	*tp;

    for (tp = fallbacks;
	 	tp < fallbacks + sizeof(fallbacks)/sizeof(TERMTYPE);
	 	tp++)
	if (_nc_name_match(tp->term_names, name, "|"))
	    return(tp);
EOF
else
	echo "	/* the fallback list is empty */";
fi

cat <<EOF
	return((TERMTYPE *)0);
}
EOF

if test -n "$tmp_info" ; then
	echo removing temporary terminfo directory... >&2
	rm -rf $tmp_info
fi
