/******************************************************************************

  Copyright (C), 2014-2024, Hisilicon Tech. Co., Ltd.

 ******************************************************************************
  File Name     : drv_hdmi_edid_test.c
  Version       : Initial Draft
  Author        : Hisilicon multimedia software group
  Created       : 2014/12/10
  Description   :
  History       :
  Date          : 2014/12/10
  Author        : t00273561
  Modification  :
*******************************************************************************/
#include "drv_hdmi_common.h"
#include "drv_hdmi_platform.h"
#include "drv_hdmi_edid_test.h"

#if HDMI_EDID_RAW_TEST

                                                           


/**
\ 	sony hdmi2.0
*/
static HI_U8 s_g_au8EdidRawTest0[] = 
{
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x4d, 0xd9, 0x03, 0x42, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x18, 0x01, 0x03, 0x80, 0x7a, 0x44, 0x78, 0x0a, 0x0d, 0xc9, 0xa0, 0x57, 0x47, 0x98, 0x27, 
	0x12, 0x48, 0x4c, 0x21, 0x08, 0x00, 0x81, 0x80, 0xa9, 0xc0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3a, 0x80, 0x18, 0x71, 0x38, 0x2d, 0x40, 0x58, 0x2c, 
	0x45, 0x00, 0xc2, 0xad, 0x42, 0x00, 0x00, 0x1e, 0x01, 0x1d, 0x00, 0x72, 0x51, 0xd0, 0x1e, 0x20, 
	0x6e, 0x28, 0x55, 0x00, 0xc2, 0xad, 0x42, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x53, 
	0x4f, 0x4e, 0x59, 0x20, 0x54, 0x56, 0x20, 0x20, 0x2a, 0x30, 0x37, 0x0a, 0x00, 0x00, 0x00, 0xfd, 
	0x00, 0x30, 0x3e, 0x0e, 0x46, 0x0f, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0xf4, 

	0x02, 0x03, 0x4d, 0xf0, 0x57, 0x1f, 0x10, 0x14, 0x05, 0x13, 0x04, 0x20, 0x22, 0x3c, 0x3e, 0x12, 
	0x16, 0x03, 0x07, 0x11, 0x15, 0x02, 0x06, 0x01, 0x5d, 0x5e, 0x5f, 0x62, 0x26, 0x0d, 0x07, 0x07, 
	0x15, 0x07, 0x50, 0x83, 0x0f, 0x00, 0x00, 0x78, 0x03, 0x0c, 0x00, 0x20, 0x00, 0xb8, 0x3c, 0x2f, 
	0xd0, 0x8a, 0x01, 0x02, 0x03, 0x04, 0x01, 0x40, 0x00, 0x7f, 0x20, 0x30, 0x70, 0x80, 0x90, 0x76, 
	0xe2, 0x00, 0xfb, 0xe3, 0x05, 0xdf, 0x01, 0xe5, 0x0e, 0x60, 0x61, 0x65, 0x66, 0x02, 0x3a, 0x80, 
	0xd0, 0x72, 0x38, 0x2d, 0x40, 0x10, 0x2c, 0x45, 0x80, 0xc2, 0xad, 0x42, 0x00, 0x00, 0x1e, 0x01, 
	0x1d, 0x00, 0xbc, 0x52, 0xd0, 0x1e, 0x20, 0xb8, 0x28, 0x55, 0x40, 0xc2, 0xad, 0x42, 0x00, 0x00, 
	0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe7
};
/**
\ normal test
\ hdmi device
\ our expect : hdmi
*/
static HI_U8 s_g_au8EdidRawTest1[256] = 
{
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x4d, 0x79, 0x30, 0x00, 0x01, 0x00, 0x00, 0x00, 
    0x0a, 0x14, 0x01, 0x03, 0x80, 0x73, 0x41, 0x78, 0x0a, 0xcf, 0x74, 0xa3, 0x57, 0x4c, 0xb0, 0x23, 
    0x09, 0x48, 0x4c, 0x21, 0x08, 0x00, 0x81, 0x80, 0x45, 0x40, 0x61, 0x40, 0x95, 0x00, 0x01, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1d, 0x00, 0x72, 0x51, 0xd0, 0x1e, 0x20, 0x6e, 0x28,
    0x55, 0x00, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x1e, 0x01, 0x1d, 0x80, 0x18, 0x71, 0x1c, 0x16, 0x20,
    0x58, 0x2c, 0x25, 0x00, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x9e, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x53, 
    0x4b, 0x59, 0x57, 0x4f, 0x52, 0x54, 0x48, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfd,
    0x00, 0x32, 0x4b, 0x1e, 0x50, 0x12, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0xdd, 

    0x02, 0x03, 0x2e, 0xf2, 0x4d, 0x01, 0x03, 0x84, 0x05, 0x07, 0x10, 0x12, 0x93, 0x14, 0x16, 0x1f, 
    0x20, 0x22, 0x26, 0x09, 0x07, 0x07, 0x11, 0x17, 0x50, 0x83, 0x01, 0x00, 0x00, 0x70, 0x03, 0x0c, 
    0x00, 0x30, 0x00, 0xb8, 0x2d, 0x20, 0xa0, 0x06, 0x01, 0x41, 0x00, 0x00, 0x00, 0x00, 0x8c, 0x0a, 
    0xd0, 0x8a, 0x20, 0xe0, 0x2d, 0x10, 0x10, 0x3e, 0x96, 0x00, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x18, 
    0x02, 0x3a, 0x80, 0x18, 0x71, 0x38, 0x2d, 0x40, 0x58, 0x2c, 0x45, 0x00, 0xc4, 0x8e, 0x21, 0x00,
    0x00, 0x9e, 0x01, 0x1d, 0x00, 0xbc, 0x52, 0xd0, 0x1e, 0x20, 0xb8, 0x28, 0x55, 0x40, 0xc4, 0x8e, 
    0x21, 0x00, 0x00, 0x1e, 0x01, 0x1d, 0x80, 0xd0, 0x72, 0x1c, 0x16, 0x20, 0x10, 0x2c, 0x25, 0x80, 
    0xc4, 0x8e, 0x21, 0x00, 0x00, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
};

/*
\ for edid test block 4
\ hdmi device
\ our expect : hdmi
*/
static HI_U8 s_g_au8EdidRawTest2[512] =
{
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x4D, 0x29, 0x48, 0x44, 0x01, 0x00, 0x00, 0x00,	
    0x0A, 0x0D, 0x01, 0x03, 0x80, 0x50, 0x2D, 0x78, 0x0A, 0x0D, 0xC9, 0xA0, 0x57, 0x47, 0x98, 0x27, 0x12, 0x48, 0x4C, 0x20, 0x00,	
    0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1D, 0x80, 0x18,	
    0x71, 0x1C, 0x16, 0x20, 0x58, 0x2C, 0x25, 0x00, 0x20, 0xC2, 0x31, 0x00, 0x00, 0x9E, 0x8C, 0x0A, 0xD0, 0x8A, 0x20, 0xE0, 0x2D,	
    0x10, 0x10, 0x3E, 0x96, 0x00, 0x13, 0x8E, 0x21, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x48, 0x44, 0x4D, 0x49, 0x20,	
    0x54, 0x56, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xFD, 0x00, 0x3B, 0x3D, 0x0F, 0x2E, 0x08, 0x02, 0x00, 0x20,	
    0x20, 0x20, 0x20, 0x20, 0x20, 0x03,	0xF1,

	//back	0xF0, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    /*|*/  0x02, 0x03,/*|*/ 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0xed,	0x0C,

    0x02, 0x03, 0x1E, 0xF1, 0x4A, 0x85, 0x04, 0x10, 0x02, 0x01, 0x06, 0x14, 0x12, 0x16, 0x13, 0x23,	
    0x09, 0x07, 0x07, 0x83, 0x01, 0x00, 0x00, 0x66, 0x03, 0x0C, 0x00, 0x10, 0x00, 0x80, 0x01, 0x1D, 0x00, 0x72, 0x51, 0xD0, 0x1E,	
    0x20, 0x6E, 0x28, 0x55, 0x00, 0xC4, 0x8E, 0x21, 0x00, 0x00, 0x1E, 0xD6, 0x09, 0x80, 0xA0, 0x20, 0xE0, 0x2D, 0x10, 0x10, 0x60,	
    0x22, 0x00, 0x12, 0x8E, 0x21, 0x08, 0x08, 0x18, 0x8C, 0x0A, 0xD0, 0x90, 0x20, 0x40, 0x31, 0x20, 0x0C, 0x40, 0x55, 0x00, 0xC4,	
    0x8E, 0x21, 0x00, 0x00, 0x18, 0x01, 0x1D, 0x80, 0xD0, 0x72, 0x1C, 0x16, 0x20, 0x10, 0x2C, 0x25, 0x80, 0xC4, 0x8E, 0x21, 0x00,	
    0x00, 0x9E, 0x8C, 0x0A, 0xA0, 0x14, 0x51, 0xF0, 0x16, 0x00, 0x26, 0x7C, 0x43, 0x00, 0x13, 0x8E, 0x21, 0x00, 0x00, 0x98, 0x00,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	0xF5,

    0x02, 0x03, 0x04, 0xF1, 0xF3, 0x39, 0x80, 0x18, 0x71, 0x38, 0x2D, 0x40, 0x58, 0x2C, 0x45, 0x00,	
    0xC4, 0x8E, 0x21, 0x00, 0x00, 0x1E, 0x8C, 0x0A, 0xA0, 0x20, 0x51, 0x20, 0x18, 0x10, 0x18, 0x7E, 0x23, 0x00, 0xC4, 0x8E, 0x21,	
    0x00, 0x00, 0x98, 0x01, 0x1D, 0x00, 0xBC, 0x52, 0xD0, 0x1E, 0x20, 0xB8, 0x28, 0x55, 0x40, 0xC4, 0x8E, 0x21, 0x00, 0x00, 0x1E,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	0xDF,
};
 
/*
\ alter from edid test block 4,ext num err,and vsdb in block 3
\ hdmi device
\ our expect : hdmi (need or not force mode) 
*/ 
static HI_U8 s_g_au8EdidRawTest3[384] = 
{
    0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x4D,0x29,0x02,0x80,0x01,0x00,0x00,0x00,
    0x0F,0x10,0x01,0x03,0x80,0x50,0x2D,0x78,0x0A,0x0D,0xC9,0xA0,0x57,0x47,0x98,0x27,
    0x12,0x48,0x4C,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x1D,0x80,0x18,0x71,0x1C,0x16,0x20,0x58,0x2C,
    0x25,0x00,0xC4,0x8E,0x21,0x00,0x00,0x9E,0x8C,0x0A,0xD0,0x8A,0x20,0xE0,0x2D,0x10,
    0x10,0x3E,0x96,0x00,0xC4,0x8E,0x21,0x00,0x00,0x18,0x00,0x00,0x00,0xFC,0x00,0x34,
    0x20,0x62,0x6C,0x6F,0x63,0x6B,0x0A,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0xFD,
    0x00,0x32,0x3D,0x1C,0x22,0x08,0x00,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x02,0x90,

    0xF0,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,

    0x02,0x03,0x15,0x71,0x46,0x85,0x03,0x02,0x14,0x12,0x11,0x23,0x0D,0x7F,0x07,0x65,
    0x03,0x0C,0x00,0x8C,0x00,0x8C,0x0A,0xD0,0x8A,0x20,0xE0,0x2D,0x10,0x10,0x3E,0x96,
    0x00,0x13,0x8E,0x21,0x00,0x00,0x18,0x01,0x1D,0x80,0xD0,0x72,0x1C,0x16,0x20,0x10,
    0x2C,0x25,0x80,0xC4,0x8E,0x21,0x00,0x00,0x9E,0x8C,0x0A,0xD0,0x90,0x20,0x40,0x31,
    0x20,0x0C,0x40,0x55,0x00,0xC4,0x8E,0x21,0x00,0x00,0x18,0x8C,0x0A,0xD0,0x90,0x20,
    0x40,0x31,0x20,0x0C,0x40,0x55,0x00,0x13,0x8E,0x21,0x00,0x00,0x18,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB4,
};
/*
\ extend version too high
\ hdmi device
\ our expect : hdmi
*/
static HI_U8 s_g_au8EdidRawTest4[384] = 
{
    0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x4D,0x29,0x0C,0x80,0x01,0x00,0x00,0x00,
    0x0F,0x10,0x01,0x03,0x80,0x50,0x2D,0x78,0x0A,0x0D,0xC9,0xA0,0x57,0x47,0x98,0x27,
    0x12,0x48,0x4C,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x1D,0x80,0x18,0x71,0x1C,0x16,0x20,0x58,0x2C,
    0x25,0x00,0xC4,0x8E,0x21,0x00,0x00,0x9E,0x8C,0x0A,0xD0,0x8A,0x20,0xE0,0x2D,0x10,
    0x10,0x3E,0x96,0x00,0xC4,0x8E,0x21,0x00,0x00,0x18,0x00,0x00,0x00,0xFC,0x00,0x34,
    0x20,0x62,0x6C,0x6F,0x63,0x6B,0x23,0x32,0x0A,0x20,0x20,0x20,0x00,0x00,0x00,0xFD,
    0x00,0x32,0x3D,0x1C,0x22,0x08,0x00,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x02,0x71,

    0xF0,0x02,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,

    0x02,0x04,0x15,0x71,0x46,0x85,0x03,0x02,0x14,0x12,0x11,0x23,0x0D,0x7F,0x07,0x65,
    0x03,0x0C,0x00,0x8C,0x00,0x8C,0x0A,0xD0,0x8A,0x20,0xE0,0x2D,0x10,0x10,0x3E,0x96,
    0x00,0x13,0x8E,0x21,0x00,0x00,0x18,0x01,0x1D,0x80,0xD0,0x72,0x1C,0x16,0x20,0x10,
    0x2C,0x25,0x80,0xC4,0x8E,0x21,0x00,0x00,0x9E,0x8C,0x0A,0xD0,0x90,0x20,0x40,0x31,
    0x20,0x0C,0x40,0x55,0x00,0xC4,0x8E,0x21,0x00,0x00,0x18,0x8C,0x0A,0xD0,0x90,0x20,
    0x40,0x31,0x20,0x0C,0x40,0x55,0x00,0x13,0x8E,0x21,0x00,0x00,0x18,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xB3,
};
/**
\ maybe test parse edid some function
\ hdmi device
\ our expect : hdmi
*/
static HI_U8 s_g_au8EdidRawTest5[] = 
{
    0x00,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x0c,0x16,0x01,0x03,0x81,0x52,0x2e,0x78,0x0b,0xd9,0xb0,0xa3,0x57,0x49,0x9c,0x25,
    0x11,0x49,0x4b,0xa1,0x0c,0x00,0x95,0x00,0xb3,0x00,0x81,0xc0,0x81,0x00,0x81,0x40,
    0x81,0x80,0x81,0xc0,0xd1,0xc0,0x1b,0x21,0x50,0xa0,0x51,0x00,0x1e,0x30,0x48,0x88,
    0x35,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x1f,0x00,0x80,0x51,0x00,0x1e,0x30,
    0x40,0x80,0x37,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,
    0x00,0x4d,0x54,0x32,0x37,0x43,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x01,0x98,

    0x02,0x03,0x20,0xf1,0x4d,0x05,0x02,0x03,0x04,0x07,0x10,0x11,0x12,0x13,0x14,0x15,
    0x16,0x1f,0x23,0x09,0x57,0x07,0x83,0x01,0x00,0x00,0x65,0x03,0x0c,0x00,0x10,0x00,
    0x8c,0x0a,0xd0,0x8a,0x20,0xe0,0x2d,0x10,0x10,0x3e,0x96,0x00,0x65,0xcc,0x21,0x00,
    0x00,0x18,0x01,0x1d,0x00,0xbc,0x52,0xd0,0x1e,0x20,0xb8,0x28,0x55,0x40,0x32,0xcc,
    0x31,0x00,0x00,0x1e,0x01,0x1d,0x80,0xd0,0x72,0x1c,0x16,0x20,0x10,0x2c,0x25,0x80,
    0x32,0xcc,0x31,0x00,0x00,0x9e,0x8c,0x0a,0xd0,0x8a,0x20,0xe0,0x2d,0x10,0x10,0x3e,
    0x96,0x00,0x32,0xcc,0x31,0x00,0x00,0x18,0x8c,0x0a,0xd0,0x90,0x20,0x40,0x31,0x20,
    0x0c,0x40,0x55,0x00,0x32,0xcc,0x31,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x14,
};

/*
\#define Amplifier
\ hdmi device
\ our expect : hdmi
*/
static HI_U8 s_g_au8EdidRawTest6[] = 
{
    0x00,0xff,0xff,0xff,0xff, 0xff, 0xff,0x00,  0x65, 0xa8,  0x30, 0x31,  0x00,  0x00,  0x00, 0x00,        
    0x00,0x12,0x01,0x03,0x80, 0x00, 0x00,0x78,  0x0a, 0x0d,  0xc9, 0xa0,  0x57,  0x47,  0x98, 0x27,        
    0x12,0x48,0x4c,0x00,0x00, 0x00, 0x01,0x01,  0x01, 0x01,  0x01, 0x01,  0x01,  0x01,  0x01, 0x01,        
    0x01,0x01,0x01,0x01,0x01, 0x01, 0x01,0x1d,  0x80, 0x18,  0x71, 0x1c,  0x16,  0x20,  0x58, 0x2c,        
    0x25,0x00,0xc4,0x8e,0x21, 0x00, 0x00,0x9e,  0x01, 0x1d,  0x80, 0xd0,  0x72,  0x1c,  0x16, 0x20,        
    0x10,0x2c,0x25,0x80,0xc4, 0x8e, 0x21,0x00,  0x00, 0x9e,  0x00, 0x00,  0x00,  0xfc,  0x00, 0x52,        
    0x58,0x2d,0x56,0x33,0x39, 0x30, 0x30,0x0a,  0x20, 0x20,  0x20, 0x20,  0x00,  0x00,  0x00, 0xfd,        
    0x00,0x31,0x79,0x0f,0x5b, 0x0f, 0x00,0x0a,  0x20, 0x20,  0x20, 0x20,  0x20,  0x20,  0x01, 0x36, 

    0x02,0x03,0x45,0x74,0x5a, 0x85, 0x04,0x02,  0x03, 0x06,  0x07, 0x10,  0x0e,  0x0f,  0x0a, 0x0b,        
    0x23,0x24,0x14,0x13,0x11, 0x12, 0x15,0x16,  0x1f, 0x1d,  0x1e, 0x19,  0x1a,  0x25,  0x26, 0x38,        
    0x09,0x7f,0x07,0x0f,0x7f, 0x07, 0x15,0x07,  0x50, 0x3e,  0x1f, 0xc0,  0x4d,  0x02,  0x00, 0x57,        
    0x06,0x00,0x67,0x54,0x00, 0x5f, 0x54,0x01,  0x83, 0x5f,  0x00, 0x00,  0x68,  0x03,  0x0c, 0x00,        
    0x10,0x00,0x80,0x21,0x00, 0x01, 0x1d,0x00,  0x72, 0x51,  0xd0, 0x1e,  0x20,  0x6e,  0x28, 0x55,        
    0x00,0xc4,0x8e,0x21,0x00, 0x00, 0x1e,0x01,  0x1d, 0x00,  0xbc, 0x52,  0xd0,  0x1e,  0x20, 0xb8,        
    0x28,0x55,0x40,0xc4,0x8e, 0x21, 0x00,0x00,  0x1e, 0x00,  0x00, 0x00,  0x00,  0x00,  0x00, 0x00,        
    0x00,0x00,0x00,0x00,0x00, 0x00, 0x00,0x00,  0x00, 0x00,  0x00, 0x00,  0x00,  0x00,  0x00, 0xc2,        
};



/**
\CEA 861B is supported in Extend version Num >= 0x02 0x03
\extend version 2.1 whole detail timing 
\dvi device
\our expect : dvi
*/
static HI_U8 s_g_au8EdidRawTest7[] = 
{
    0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0x4D,0xD9,0x00,0x00,0x00,0x00,0x00,0x00,   
    0x00,0x11,0x01,0x03,0x80,0x00,0x00,0x78,0x0A,0x0D,0xC9,0xA0,0x57,0x47,0x98,0x27,   
    0x12,0x48,0x4C,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,   
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x1D,0x80,0xD0,0x72,0x1C,0x16,0x20,0x10,0x2C,   
    0x25,0x80,0xC4,0x8E,0x21,0x00,0x00,0x9E,0x01,0x1D,0x80,0x18,0x71,0x1C,0x16,0x20,   
    0x58,0x2C,0x25,0x00,0xC4,0x8E,0x21,0x00,0x00,0x9E,0x00,0x00,0x00,0xFC,0x00,0x48,   
    0x44,0x4D,0x49,0x20,0x4C,0x4C,0x43,0x0A,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0xFD,   
    0x00,0x3B,0x3D,0x0F,0x2D,0x08,0x00,0x0A,0x20,0x20,0x20,0x20,0x20,0x20,0x01,0xC2,   

    0x02,0x01,0x04,0x00,0x8C,0x0A,0xD0,0x90,0x20,0x40,0x31,0x20,0x0C,0x40,0x55,0x00,   
    0x13,0x8E,0x21,0x00,0x00,0x18,0x01,0x1D,0x00,0xBC,0x52,0xD0,0x1E,0x20,0xB8,0x28,   
    0x55,0x40,0xC4,0x8E,0x21,0x00,0x00,0x1E,0x8C,0x0A,0xD0,0x8A,0x20,0xE0,0x2D,0x10,   
    0x10,0x3E,0x96,0x00,0xC4,0x8E,0x21,0x00,0x00,0x18,0x01,0x1D,0x00,0x72,0x51,0xD0,   
    0x1E,0x20,0x6E,0x28,0x55,0x00,0xC4,0x8E,0x21,0x00,0x00,0x1E,0x8C,0x0A,0xD0,0x8A,   
    0x20,0xE0,0x2D,0x10,0x10,0x3E,0x96,0x00,0x13,0x8E,0x21,0x00,0x00,0x18,0x8C,0x0A,   
    0xD0,0x90,0x20,0x40,0x31,0x20,0x0C,0x40,0x55,0x00,0xC4,0x8E,0x21,0x00,0x00,0x18,   
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xD2,   
};

/*
\extend num && header err
\1.1	changhong TV LT22610 EDID read errTV in DVI mode, no audio
\ hdmi device
\ our expect : hdmi 
*/
static HI_U8 s_g_au8EdidRawTest8[] = 
{
    0xC4,0x60,0x00,0xFF,0xCC,0xAB,0x00,0x00,0x0D,0x04,0x21,0x90,0x01,0x00,0x00,0x00,
    0x20,0x12,0x01,0x03,0x80,0x73,0x41,0x78,0x0A,0xCF,0x74,0xA3,0x57,0x4C,0xB0,0x23,
    0x09,0x48,0x4C,0x21,0x08,0x00,0x01,0x01,0x81,0xC0,0x61,0x40,0x81,0x80,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x1D,0x80,0x18,0x71,0x1C,0x16,0x20,0x58,0x2C,
    0x25,0x00,0xC4,0x8E,0x21,0x00,0x00,0x9E,0x4C,0x1F,0x00,0x90,0x51,0x00,0x1B,0x30,
    0x40,0x86,0x13,0x00,0x58,0x54,0x21,0x00,0x00,0x1E,0x00,0x00,0x00,0xFC,0x00,0x4C,
    0x54,0x32,0x32,0x36,0x31,0x30,0x0A,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0xFD,
    0x00,0x2D,0x41,0x0F,0x45,0x06,0x00,0x0A,0x0C,0x0D,0x0E,0x0F,0x08,0x09,0x0A,0x0B,

    0x02,0x03,0x21,0xF3,0x4C,0x01,0x02,0x03,0x84,0x85,0x07,0x10,0x12,0x93,0x14,0x16,
    0x1F,0x23,0x09,0x17,0x07,0x83,0x01,0x00,0x00,0x67,0x03,0x0C,0x00,0x10,0x00,0x38,
    0x2D,0x8C,0x0A,0xD0,0x8A,0x20,0xE0,0x2D,0x10,0x10,0x3E,0x96,0x00,0xC4,0x8E,0x21,
    0x00,0x00,0x18,0x8C,0x0A,0xD0,0x90,0x20,0x40,0x31,0x20,0x0C,0x40,0x55,0x00,0xC4,
    0x8E,0x21,0x00,0x00,0x18,0x01,0x1D,0x00,0xBC,0x52,0xD0,0x1E,0x20,0xB8,0x28,0x55,
    0x40,0xC4,0x8E,0x21,0x00,0x00,0x1E,0x01,0x1D,0x80,0xD0,0x72,0x1C,0x16,0x20,0x10,
    0x2C,0x25,0x80,0xC4,0x8E,0x21,0x00,0x00,0x9E,0x8C,0x0A,0xD0,0x8A,0x20,0xE0,0x2D,
    0x10,0x10,0x3E,0x96,0x00,0x13,0x8E,0x21,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x10,   
};
/**
\ audio capabilty
\ hdmi device
\ our expect : hdmi
*/
static HI_U8 s_g_au8EdidRawTest9[] = 
{
    0x00 ,0xff ,0xff ,0xff ,0xff, 0xff ,0xff ,0x00 ,0x65 ,0xa8 ,0x2d ,0x31 ,0x00 ,0x00 ,0x00 ,0x00,
    0x00 ,0x12 ,0x01 ,0x03 ,0x80, 0x00 ,0x00 ,0x78 ,0x0a ,0x0d ,0xc9 ,0xa0 ,0x57 ,0x47 ,0x98 ,0x27,
    0x12 ,0x48 ,0x4c ,0x00 ,0x00, 0x00 ,0x01 ,0x01 ,0x01 ,0x01 ,0x01 ,0x01 ,0x01 ,0x01 ,0x01 ,0x01,
    0x01 ,0x01 ,0x01 ,0x01 ,0x01, 0x01 ,0x01 ,0x1d ,0x80 ,0x18 ,0x71 ,0x1c ,0x16 ,0x20 ,0x58 ,0x2c,
    0x25 ,0x00 ,0xc4 ,0x8e ,0x21, 0x00 ,0x00 ,0x9e ,0x01 ,0x1d ,0x80 ,0xd0 ,0x72 ,0x1c ,0x16 ,0x20,
    0x10 ,0x2c ,0x25 ,0x80 ,0xc4, 0x8e ,0x21 ,0x00 ,0x00 ,0x9e ,0x00 ,0x00 ,0x00 ,0xfc ,0x00 ,0x52,
    0x58 ,0x2d ,0x56 ,0x31 ,0x39, 0x30 ,0x30 ,0x0a ,0x20 ,0x20 ,0x20 ,0x20 ,0x00 ,0x00 ,0x00 ,0xfd,
    0x00 ,0x17 ,0x79 ,0x0f ,0x5b, 0x0f ,0x00 ,0x0a ,0x20 ,0x20 ,0x20 ,0x20 ,0x20 ,0x20 ,0x01 ,0x55,

    0x02 ,0x03 ,0x45 ,0x75 ,0x5a, 0x85 ,0x04 ,0x02 ,0x03 ,0x06 ,0x07 ,0x10 ,0x0e ,0x0f ,0x0a ,0x0b,
    0x23 ,0x24 ,0x14 ,0x13 ,0x11, 0x12 ,0x15 ,0x16 ,0x1f ,0x1d ,0x1e ,0x19 ,0x1a ,0x25 ,0x26 ,0x38,
    0x09 ,0x7f ,0x07 ,0x0f ,0x7f, 0x07 ,0x15 ,0x07 ,0x50 ,0x3e ,0x1f ,0xc0 ,0x4d ,0x02 ,0x00 ,0x57,
    0x06 ,0x00 ,0x67 ,0x54 ,0x00, 0x5f ,0x54 ,0x01 ,0x83 ,0x5f ,0x00 ,0x00 ,0x68 ,0x03 ,0x0c ,0x00,
    0x30 ,0x00 ,0x80 ,0x21 ,0x00, 0x8c ,0x0a ,0xd0 ,0x8a ,0x20 ,0xe0 ,0x2d ,0x10 ,0x10 ,0x3e ,0x96,
    0x00 ,0x13 ,0x8e ,0x21 ,0x00, 0x00 ,0x18 ,0x8c ,0x0a ,0xd0 ,0x90 ,0x20 ,0x40 ,0x31 ,0x20 ,0x0c,
    0x40 ,0x55 ,0x00 ,0x13 ,0x8e, 0x21 ,0x00 ,0x00 ,0x18 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00,
    0x00 ,0x00 ,0x00 ,0x00 ,0x00, 0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x3f,  
};

//audio Amplifier auido capability parse test 
/**
\audio code       ch                     fs                               bit
\ 1   PCM        2ch        all fs(32/441/48/88/96/176/192)      all bit 16/20/24bit
\ 1   PCM        8ch        all fs 				all bit                          
\ 2   AC3        6ch        32/44/48 				no bit msg                
\ 7   DTS        7ch        32/44/48/88/96                       no bit msg
\ 9   OneBitAudio 6ch	   44					no bit msg
\ 10  DD+        8ch 	   44/48				no bit msg
\ 12  MAT	8ch 	   48/96/192				no bit msg
\ 11  DTS_HD	8ch        48/96/192				16bit           
\
\ hdmi device
\ our expect : hdmi
*/
static HI_U8 s_g_au8EdidRawTest10[] = 
{
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x65, 0xa8, 0x30, 0x31, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x12, 0x01, 0x03, 0x80, 0x00, 0x00, 0x78, 0x0a, 0x0d, 0xc9, 0xa0, 0x57, 0x47, 0x98, 0x27, 
    0x12, 0x48, 0x4c, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1d, 0x80, 0x18, 0x71, 0x1c, 0x16, 0x20, 0x58, 0x2c, 
    0x25, 0x00, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x9e, 0x01, 0x1d, 0x80, 0xd0, 0x72, 0x1c, 0x16, 0x20, 
    0x10, 0x2c, 0x25, 0x80, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x9e, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x52, 
    0x58, 0x2d, 0x56, 0x33, 0x39, 0x30, 0x30, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfd, 
    0x00, 0x31, 0x79, 0x0f, 0x5b, 0x0f, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0x36, 
    
    0x02, 0x03, 0x45, 0x74, 0x5a, 0x85, 0x04, 0x02, 0x03, 0x06, 0x07, 0x10, 0x0e, 0x0f, 0x0a, 0x0b, 
    0x23, 0x24, 0x14, 0x13, 0x11, 0x12, 0x15, 0x16, 0x1f, 0x1d, 0x1e, 0x19, 0x1a, 0x25, 0x26, 0x38, 
    0x09, 0x7f, 0x07, 0x0f, 0x7f, 0x07, 0x15, 0x07, 0x50, 0x3e, 0x1f, 0xc0, 0x4d, 0x02, 0x00, 0x57, 
    0x06, 0x00, 0x67, 0x54, 0x00, 0x5f, 0x54, 0x01, 0x83, 0x5f, 0x00, 0x00, 0x68, 0x03, 0x0c, 0x00, 
    0x20, 0x00, 0x80, 0x21, 0x00, 0x01, 0x1d, 0x00, 0x72, 0x51, 0xd0, 0x1e, 0x20, 0x6e, 0x28, 0x55, 
    0x00, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x1e, 0x01, 0x1d, 0x00, 0xbc, 0x52, 0xd0, 0x1e, 0x20, 0xb8, 
    0x28, 0x55, 0x40, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2,  
};

/*
\ hdmi device
\ our expect : hdmi
*/
static HI_U8 s_g_au8EdidRawTest11[] = 
{
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x44, 0x89, 0x72, 0x03, 0x05, 0x00, 0x00, 0x00,
    0x2d, 0x0e, 0x01, 0x03, 0x80, 0x50, 0x2d, 0x78, 0x0a, 0x0d, 0xc9, 0xa0, 0x57, 0x47, 0x98, 0x27,
    0x12, 0x48, 0x4c, 0x20, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xd6, 0x09, 0x80, 0xa0, 0x20, 0xe0, 0x2d, 0x10, 0x10, 0x60,
    0xa2, 0x00, 0x80, 0xe0, 0x21, 0x00, 0x00, 0x18, 0x8c, 0x0a, 0xd0, 0x8a, 0x20, 0xe0, 0x2d, 0x10,
    0x10, 0x3e, 0x96, 0x00, 0x13, 0x8e, 0x21, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x48,
    0x44, 0x4d, 0x49, 0x20, 0x54, 0x56, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfd,
    0x00, 0x3b, 0x3d, 0x0f, 0x2e, 0x08, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0x6f,
    
    0x02, 0x03, 0x18, 0x41, 0x45, 0x83, 0x02, 0x01, 0x11, 0x12, 0x23, 0x09, 0x07, 0x07, 0x83, 0x01,
    0x00, 0x00, 0x65, 0x03, 0x0c, 0x00, 0x10, 0x00, 0x8c, 0x0a, 0xd0, 0x90, 0x20, 0x40, 0x31, 0x20,
    0x0c, 0x40, 0x55, 0x00, 0x13, 0x8e, 0x21, 0x00, 0x00, 0x18, 0x8c, 0x0a, 0xd0, 0x8a, 0x20, 0xe0,
    0x2d, 0x10, 0x10, 0x3e, 0x96, 0x00, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x18, 0x8c, 0x0a, 0xd0, 0x90, 
    0x20, 0x40, 0x31, 0x20, 0x0c, 0x40, 0x55, 0x00, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x18, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe1,
};
/*
\hdcp test not support hdmi
\quantum data 882EA when test DVI hdcp
\ dvi device
\ our expect : dvi
*/
static HI_U8 s_g_au8EdidRawTest12[] = 
{
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x44, 0x89, 0x72, 0x03, 0x05, 0x00, 0x00, 0x00, 
    0x2d, 0x0e, 0x01, 0x03, 0x80, 0x50, 0x2d, 0x78, 0x0a, 0x0d, 0xc9, 0xa0, 0x57, 0x47, 0x98, 0x27, 
    0x12, 0x48, 0x4c, 0x20, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xd6, 0x09, 0x80, 0xa0, 0x20, 0xe0, 0x2d, 0x10, 0x10, 0x60, 
    0xa2, 0x00, 0x80, 0xe0, 0x21, 0x00, 0x00, 0x18, 0x8c, 0x0a, 0xd0, 0x8a, 0x20, 0xe0, 0x2d, 0x10, 
    0x10, 0x3e, 0x96, 0x00, 0x13, 0x8e, 0x21, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x48, 
    0x44, 0x4d, 0x49, 0x20, 0x54, 0x56, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfd, 
    0x00, 0x3b, 0x3d, 0x0f, 0x2e, 0x08, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0x6f, 
    
    0x02, 0x01, 0x04, 0x00, 0x8c, 0x0a, 0xd0, 0x90, 0x20, 0x40, 0x31, 0x20, 0x0c, 0x40, 0x55, 0x00, 
    0x13, 0x8e, 0x21, 0x00, 0x00, 0x18, 0x8c, 0x0a, 0xd0, 0x8a, 0x20, 0xe0, 0x2d, 0x10, 0x10, 0x3e, 
    0x96, 0x00, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x18, 0x8c, 0x0a, 0xd0, 0x90, 0x20, 0x40, 0x31, 0x20, 
    0x0c, 0x40, 0x55, 0x00, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 
};
/**
\hitachi no vsdb(in some tv,some byte has broken) && block 2 crc err && support audio
\ hdmi device
\ our expect : force mode 
*/
static HI_U8 s_g_au8EdidRawTest13[] = 
{
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x22, 0x83, 0x99, 0x00, 0x01, 0x01, 0x01, 0x01, 
    0x00, 0x12, 0x01, 0x03, 0x80, 0x10, 0x09, 0x78, 0x0a, 0xaf, 0x83, 0xa6, 0x54, 0x4c, 0x9e, 0x26, 
    0x11, 0x45, 0x47, 0x20, 0x08, 0x00, 0x81, 0x80, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3a, 0x80, 0x18, 0x71, 0x38, 0x2d, 0x40, 0x58, 0x2c, 
    0x45, 0x00, 0x10, 0x09, 0x00, 0x00, 0x00, 0x1e, 0x02, 0x3a, 0x80, 0xd0, 0x72, 0x38, 0x2d, 0x40, 
    0x10, 0x2c, 0x45, 0x80, 0x10, 0x09, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x55, 
    0x4c, 0x43, 0x44, 0x20, 0x4d, 0x4f, 0x4e, 0x49, 0x54, 0x4f, 0x52, 0x0a, 0x00, 0x00, 0x00, 0xfd, 
    0x00, 0x17, 0x3d, 0x0f, 0x44, 0x0f, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0xca, 
    
    0x02, 0x03, 0x26, 0x71, 0x50, 0x90, 0x05, 0x04, 0x1f, 0x14, 0x13, 0x20, 0x02, 0x03, 0x11, 0x12, 
    0x01, 0x06, 0x07, 0x15, 0x16, 0x23, 0x09, 0x07, 0x07, 0x83, 0x01, 0x00, 0x00, 0xff, 0xff, 0x0c, 
    0x00, 0x10, 0x00, 0xb8, 0x2d, 0x00, 0x01, 0x1d, 0x80, 0x18, 0x71, 0x1c, 0x16, 0x20, 0x58, 0x2c, 
    0x25, 0x00, 0x10, 0x09, 0x00, 0x00, 0x00, 0x9e, 0x01, 0x1d, 0x00, 0x72, 0x51, 0xd0, 0x1e, 0x20, 
    0x6e, 0x28, 0x55, 0x00, 0x10, 0x09, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x1d, 0x80, 0xd0, 0x72, 0x1c, 
    0x16, 0x20, 0x10, 0x2c, 0x25, 0x80, 0x10, 0x09, 0x00, 0x00, 0x00, 0x9e, 0x01, 0x1d, 0x00, 0xbc, 
    0x52, 0xd0, 0x1e, 0x20, 0xb8, 0x28, 0x55, 0x40, 0x10, 0x09, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 
};

/**
\ all 0xff and 0x7f,err edid, can read 2 block
\ hdmi device
\ our expect : force mode 
*/
static HI_U8 s_g_au8EdidRawTest14[] = 
{
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 

    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 

};

/**
\all 0xff and 0x7f,err edid, can read 4 block
\ hdmi device
\ our expect : force mode 
*/
static HI_U8 s_g_au8EdidRawTest15[] = 
{
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 

    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 

    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 

    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
};

/**
\ 2block 1block ok,2block all 0xff(0x7f)
\ hdmi device
\ our expect : force mode 
*/
static HI_U8 s_g_au8EdidRawTest16[] = 
{
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x4c, 0x2d, 0xd0, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x2f, 0x14, 0x01, 0x03, 0x80, 0x10, 0x09, 0x8c, 0x0a, 0xee, 0x91, 0xa3, 0x54, 0x4c, 0x99, 0x26,
    0x0f, 0x50, 0x54, 0xbd, 0xee, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x66, 0x21, 0x50, 0xb0, 0x51, 0x00, 0x1b, 0x30, 0x40, 0x70,
    0x36, 0x00, 0xa0, 0x5a, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x1d, 0x00, 0x72, 0x51, 0xd0, 0x1e, 0x20,
    0x6e, 0x28, 0x55, 0x00, 0xa0, 0x5a, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x18,
    0x4b, 0x1a, 0x44, 0x17, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfc,
    0x00, 0x53, 0x41, 0x4d, 0x53, 0x55, 0x4e, 0x47, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0xda,

    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
};
/**
\4block 1block ok,2/3/4block all 0xff(0x7f)
\hdmi device
\our expect : force mode 
*/
static HI_U8 s_g_au8EdidRawTest17[] = 
{
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x4c, 0x2d, 0xd0, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x2f, 0x14, 0x01, 0x03, 0x80, 0x10, 0x09, 0x8c, 0x0a, 0xee, 0x91, 0xa3, 0x54, 0x4c, 0x99, 0x26,
    0x0f, 0x50, 0x54, 0xbd, 0xee, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x66, 0x21, 0x50, 0xb0, 0x51, 0x00, 0x1b, 0x30, 0x40, 0x70,
    0x36, 0x00, 0xa0, 0x5a, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x1d, 0x00, 0x72, 0x51, 0xd0, 0x1e, 0x20,
    0x6e, 0x28, 0x55, 0x00, 0xa0, 0x5a, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x18,
    0x4b, 0x1a, 0x44, 0x17, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfc,
    0x00, 0x53, 0x41, 0x4d, 0x53, 0x55, 0x4e, 0x47, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x03, 0xd8,

    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 

    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
};

/**
\ 2block and 1st block header all 0xff,crc ok
\ hdmi device
\ our expect : hdmi
*/
static HI_U8 s_g_au8EdidRawTest18[] = 
{
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x4c, 0x2d, 0xd0, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x2f, 0x14, 0x01, 0x03, 0x80, 0x10, 0x09, 0x8c, 0x0a, 0xee, 0x91, 0xa3, 0x54, 0x4c, 0x99, 0x26,
    0x0f, 0x50, 0x54, 0xbd, 0xee, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x66, 0x21, 0x50, 0xb0, 0x51, 0x00, 0x1b, 0x30, 0x40, 0x70,
    0x36, 0x00, 0xa0, 0x5a, 0x00, 0x00, 0x00, 0x1e, 0x01, 0x1d, 0x00, 0x72, 0x51, 0xd0, 0x1e, 0x20,
    0x6e, 0x28, 0x55, 0x00, 0xa0, 0x5a, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0xfd, 0x00, 0x18,
    0x4b, 0x1a, 0x44, 0x17, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x00, 0x00, 0xfc,
    0x00, 0x53, 0x41, 0x4d, 0x53, 0x55, 0x4e, 0x47, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0xdc,
                                                                                                   
    0x02, 0x03, 0x45, 0x74, 0x5a, 0x85, 0x04, 0x02, 0x03, 0x06, 0x07, 0x10, 0x0e, 0x0f, 0x0a, 0x0b,
    0x23, 0x24, 0x14, 0x13, 0x11, 0x12, 0x15, 0x16, 0x1f, 0x1d, 0x1e, 0x19, 0x1a, 0x25, 0x26, 0x38,
    0x09, 0x7f, 0x07, 0x0f, 0x7f, 0x07, 0x15, 0x07, 0x50, 0x3e, 0x1f, 0xc0, 0x4d, 0x02, 0x00, 0x57,
    0x06, 0x00, 0x67, 0x54, 0x00, 0x5f, 0x54, 0x01, 0x83, 0x5f, 0x00, 0x00, 0x68, 0x03, 0x0c, 0x00,
    0x20, 0x00, 0x80, 0x21, 0x00, 0x01, 0x1d, 0x00, 0x72, 0x51, 0xd0, 0x1e, 0x20, 0x6e, 0x28, 0x55,
    0x00, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x1e, 0x01, 0x1d, 0x00, 0xbc, 0x52, 0xd0, 0x1e, 0x20, 0xb8,
    0x28, 0x55, 0x40, 0xc4, 0x8e, 0x21, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb2,
};

/**
\ dvi 1 block 0 extend ; crc ok 
\ dvi device
\ our expect : dvi
*/
static HI_U8 s_g_au8EdidRawTest19[] = 
{
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x65, 0x2E, 0x31, 0x32, 0x01, 0x00, 0x00, 0x00,
    0x01, 0x17, 0x01, 0x03, 0x80, 0x02, 0x01, 0x78, 0x04, 0xEE, 0x91, 0xA3, 0x54, 0x4C, 0x99, 0x26,
    0x0F, 0x50, 0x54, 0x21, 0x08, 0x00, 0xD1, 0xC1, 0x3B, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3A, 0x80, 0xF9, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x00, 0x8E,
};
/**
\ dvi 1 block extend != 0 ; crc error
\ dvi device
\ expect : force mode 
*/
static HI_U8 s_g_au8EdidRawTest20[] = 
{
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
    0xff, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
};

/**
\ dvi 2 block crc ok whole detailed in block 2
\ dvi device
\ expect : dvi
*/
static HI_U8 s_g_au8EdidRawTest21[] = 
{
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x65, 0x2E, 0x31, 0x32, 0x01, 0x00, 0x00, 0x00,
    0x01, 0x17, 0x01, 0x03, 0x80, 0x02, 0x01, 0x78, 0x04, 0xEE, 0x91, 0xA3, 0x54, 0x4C, 0x99, 0x26,
    0x0F, 0x50, 0x54, 0x21, 0x08, 0x00, 0xD1, 0xC1, 0x3B, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3A, 0x80, 0xF9, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0x8D,
                                                                                                   
    0x02, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x1D, 0x00, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE2,
};
/**
\ dvi 2 block crc err
\ dvi device
\ expect : force mode 
*/
static HI_U8 s_g_au8EdidRawTest22[] = 
{
    0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x65, 0x2E, 0x31, 0x32, 0x01, 0x00, 0x00, 0x00,
    0x01, 0x17, 0x01, 0x03, 0x80, 0x02, 0x01, 0x78, 0x04, 0xEE, 0x91, 0xA3, 0x54, 0x4C, 0x99, 0x26,
    0x0F, 0x50, 0x54, 0x21, 0x08, 0x00, 0xD1, 0xC1, 0x3B, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x3A, 0x80, 0xF9, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0x8E,
                                                                                                   
    0x02, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0x1D, 0x00, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE2,
};

/**
\ header err, base&extend crc err, extend version err
\ HDMI device
\ expect : force mode 
*/
static HI_U8 s_g_au8EdidRawTest23[] = 
{
    0x00, 0x55, 0x00, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x4d, 0x10, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xfa, 0x01, 0x03, 0x00, 0x86, 0x0d, 0x1c, 0x2a, 0x1b, 0x00, 0xa2, 0x55, 0x11, 0xb3, 0x26,
    0x00, 0x36, 0x05, 0xaf, 0xce, 0x00, 0x90, 0x40, 0x0f, 0x80, 0x01, 0x88, 0x01, 0x01, 0x08, 0x26,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x02, 0x3a, 0x80, 0xd0, 0x72, 0x38, 0x2d, 0x40, 0x10, 0x2c,
    0x00, 0x33, 0x31, 0x59, 0x28, 0x00, 0xe0, 0x0a, 0x66, 0x21, 0x50, 0xb0, 0x51, 0x00, 0x1b, 0x30,
    0x40, 0x70, 0x20, 0x00, 0x34, 0xcc, 0x31, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xfc, 0x00, 0xc0,
    0x48, 0x00, 0x70, 0x50, 0x20, 0x48, 0x44, 0x4d, 0x49, 0xb0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xbd, 0x50, 0x4c, 0x0e, 0x44, 0x0f, 0x20, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01, 0xc6,
    
    0x00, 0x66, 0x2e, 0x72, 0x50, 0x9f, 0x90, 0x20, 0x0a, 0x20, 0x03, 0x03, 0x12, 0x03, 0x36, 0x02,
    0x0a, 0x07, 0x30, 0x06, 0x00, 0x00, 0x00, 0x07, 0x0a, 0x00, 0x01, 0x00, 0x00, 0xe3, 0x05, 0x00,
    0x00, 0x6c, 0x03, 0x0c, 0x00, 0x10, 0x04, 0x10, 0x1e, 0x40, 0x0c, 0x05, 0x00, 0x00, 0x02, 0x3a,
    0x0d, 0x3f, 0xd4, 0x38, 0x00, 0x70, 0x00, 0x2c, 0x45, 0x00, 0x34, 0xcc, 0x31, 0x00, 0x00, 0x1e,
    0x01, 0x1d, 0x80, 0xd0, 0x72, 0x1c, 0x16, 0x20, 0x10, 0x2c, 0x25, 0x80, 0x34, 0xcc, 0x31, 0x00,
    0xd2, 0x9e, 0x07, 0x9b, 0x03, 0x18, 0x71, 0x0b, 0x16, 0x20, 0x58, 0x2c, 0x25, 0x64, 0x34, 0xcc,
    0x00, 0x08, 0xc2, 0x08, 0x01, 0x1d, 0x00, 0xbc, 0x52, 0xd0, 0x0b, 0x20, 0xb8, 0x03, 0x03, 0x02,
    0x03, 0x03, 0x31, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x3c, 0x0a, 0x00, 0x06, 0xed,
};

/**
\	from sony hdmi2.0 blk1;
\	we change DTDs & checksum for test;
\	ext_blk num is error.
*/
static HI_U8 s_g_au8EdidRawTest24[128] = 
{
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x4d, 0xd9, 0x03, 0x42, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x18, 0x01, 0x03, 0x80, 0x7a, 0x44, 0x78, 0x0a, 0x0d, 0xc9, 0xa0, 0x57, 0x47, 0x98, 0x27, 
	0x12, 0x48, 0x4c, 0x21, 0x08, 0x00, 0x81, 0x80, 0xa9, 0xc0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01,  
	
	/*DTDs from CEA-861-D Page120*/
	//0x8C,0x0A, 0xD0, 0x8A, 0x20, 0xE0, 0x2D, 0x10, 0x10, 0x3E, 0x96, 0x00, 0x58, 0xC2, 0x21, 0x00, 0x00, 0x18, 
	/*DTDs from CEA-861-D Page122*/
    0x01, 0x1D, 0x00 ,0x72 ,0x51 ,0xD0 ,0x1E ,0x20 ,0x6E ,0x28 ,0x55 ,0x00 ,0x20 ,0xC2 ,0x31 ,0x00 ,0x00 ,0x1E ,
    /*DTDs sony OLD*/
										/*0x02,0x3a, 0x80, 0x18, 0x71, 0x38, 0x2d, 0x40, 0x58, 0x2c, 
	0x45, 0x00, 0xc2, 0xad, 0x42, 0x00, 0x00, 0x1e, */ 0x01,0x1d, 0x00, 0x72, 0x51, 0xd0, 0x1e, 0x20, 
	0x6e, 0x28, 0x55, 0x00, 0xc2, 0xad, 0x42, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x53, 
	0x4f, 0x4e, 0x59, 0x20, 0x54, 0x56, 0x20, 0x20, 0x2a, 0x30, 0x37, 0x0a, 0x00, 0x00, 0x00, 0xfd, 
	0x00, 0x30, 0x3e, 0x0e, 0x46, 0x0f, 0x00, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x01,/*0x13,*/0x6b,/*0xf4,*/  
};



typedef struct{
	HI_U8 		*pu8Addr;
	HI_S32		s32Size;
}EDID_TEST_RAW_S;

static EDID_TEST_RAW_S s_g_stEdidTestTable[] = {
		{ s_g_au8EdidRawTest0,  sizeof(s_g_au8EdidRawTest0)  },
		{ s_g_au8EdidRawTest1,  sizeof(s_g_au8EdidRawTest1)  },
		{ s_g_au8EdidRawTest2,  sizeof(s_g_au8EdidRawTest2)  },
		{ s_g_au8EdidRawTest3,  sizeof(s_g_au8EdidRawTest3)  },
		{ s_g_au8EdidRawTest4,  sizeof(s_g_au8EdidRawTest4)  },
		{ s_g_au8EdidRawTest5,  sizeof(s_g_au8EdidRawTest5)  },
		{ s_g_au8EdidRawTest6,  sizeof(s_g_au8EdidRawTest6)  },
		{ s_g_au8EdidRawTest7,  sizeof(s_g_au8EdidRawTest7)  },
		{ s_g_au8EdidRawTest8,  sizeof(s_g_au8EdidRawTest8)  },
		{ s_g_au8EdidRawTest9,  sizeof(s_g_au8EdidRawTest9)  },
		{ s_g_au8EdidRawTest10, sizeof(s_g_au8EdidRawTest10) },
		{ s_g_au8EdidRawTest11, sizeof(s_g_au8EdidRawTest11) },
		{ s_g_au8EdidRawTest12, sizeof(s_g_au8EdidRawTest12) },
		{ s_g_au8EdidRawTest13, sizeof(s_g_au8EdidRawTest13) },
		{ s_g_au8EdidRawTest14, sizeof(s_g_au8EdidRawTest14) },
		{ s_g_au8EdidRawTest15, sizeof(s_g_au8EdidRawTest15) },
		{ s_g_au8EdidRawTest16, sizeof(s_g_au8EdidRawTest16) },
		{ s_g_au8EdidRawTest17, sizeof(s_g_au8EdidRawTest17) },
		{ s_g_au8EdidRawTest18, sizeof(s_g_au8EdidRawTest18) },
		{ s_g_au8EdidRawTest19, sizeof(s_g_au8EdidRawTest19) },
		{ s_g_au8EdidRawTest20, sizeof(s_g_au8EdidRawTest20) },
		{ s_g_au8EdidRawTest21, sizeof(s_g_au8EdidRawTest21) },
		{ s_g_au8EdidRawTest22, sizeof(s_g_au8EdidRawTest22) },
		{ s_g_au8EdidRawTest23, sizeof(s_g_au8EdidRawTest23) },
		{ s_g_au8EdidRawTest24, sizeof(s_g_au8EdidRawTest24) },
		{NULL,0}
};

#define EDID_TEST_TABLE_SIZE (sizeof(s_g_stEdidTestTable)/sizeof(s_g_stEdidTestTable[0]))

HI_S32 DRV_HDMI_EdidTestRawRead(HDMI_EDID_UPDATE_MODE_E enMode,
											HI_U8 *pau8Data,
											HI_U32 u32Len)
{
	EDID_TEST_RAW_S *pstEdidTest = HI_NULL;
	
	if (   ( HDMI_EDID_UPDATE_TEST0 > enMode )
		|| ( HDMI_EDID_UPDATE_BUTT <= enMode )
		|| ( EDID_TEST_TABLE_SIZE  < (enMode-HDMI_EDID_UPDATE_TEST0))
		|| (HI_NULL == pau8Data)
		|| (u32Len > HDMI_EDID_TOTAL_SIZE)    )
	{
		return HI_FAILURE;	
	}
	
	pstEdidTest = &s_g_stEdidTestTable[enMode-HDMI_EDID_UPDATE_TEST0] ;
	
	if (pstEdidTest)
	{
		HDMI_MEMCPY(pau8Data,pstEdidTest->pu8Addr,pstEdidTest->s32Size);
		return pstEdidTest->s32Size;
	}
	else
	{
		return 0;
	}
	
}


#endif /* HDMI_EDID_RAW_TEST */

