/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

This software file (the "File") is owned and distributed by Marvell 
International Ltd. and/or its affiliates ("Marvell") under the following
alternative licensing terms.  Once you have made an election to distribute the
File under one of the following license alternatives, please (i) delete this
introductory statement regarding license alternatives, (ii) delete the two
license alternatives that you have not elected to use and (iii) preserve the
Marvell copyright notice above.

********************************************************************************
Marvell Commercial License Option

If you received this File from Marvell and you have entered into a commercial
license agreement (a "Commercial License") with Marvell, the File is licensed
to you under the terms of the applicable Commercial License.

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.
********************************************************************************
Marvell BSD License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File under the following licensing terms. 
Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    *   Redistributions of source code must retain the above copyright notice,
	    this list of conditions and the following disclaimer. 

    *   Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution. 

    *   Neither the name of Marvell nor the names of its contributors may be 
        used to endorse or promote products derived from this software without 
        specific prior written permission. 
    
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/



#include "mvUart.h"


/* static variables */
static volatile MV_UART_PORT* uartBase[MV_UART_MAX_CHAN]; 


/*******************************************************************************
* mvUartInit - Init a uart port.
*
* DESCRIPTION:
*       This routine Initialize one of the uarts ports (channels).
*	It initialize the baudrate, stop bit,parity bit etc.
*
* INPUT:
*       port - uart port number.
*	baudDivisor - baud divisior to use for the uart port.
*
* OUTPUT:
*       None.
*
* RETURN:
*	None.
*
*******************************************************************************/
MV_VOID mvUartInit(MV_U32 port, MV_U32 baudDivisor, MV_UART_PORT* base)
{
	volatile MV_UART_PORT *pUartPort;

	uartBase[port] = pUartPort = (volatile MV_UART_PORT *)base;

	pUartPort->ier = 0x00;
	pUartPort->lcr = LCR_DIVL_EN;           /* Access baud rate */
	pUartPort->dll = baudDivisor & 0xff;    /* 9600 baud */
	pUartPort->dlm = (baudDivisor >> 8) & 0xff;
#if defined(CONFIG_KUROBOX_PLATFORM) && !defined(ORG_PCB)
	if (port == 0){
		// for serial console
		pUartPort->lcr = LCR_8N1;               /* 8 data, 1 stop, no parity */
	}else{
		// for micon control
		pUartPort->lcr = 0x1f ;				/* 8bit even-party, 2stop */
	}
#else
	pUartPort->lcr = LCR_8N1;               /* 8 data, 1 stop, no parity */
#endif

	/* Clear & enable FIFOs */
	pUartPort->fcr = FCR_FIFO_EN | FCR_RXSR | FCR_TXSR;
	return;
}

/*******************************************************************************
* mvUartInit - Init a uart port.
*
* DESCRIPTION:
*       This routine puts one charachetr on one of the uart ports.
*
* INPUT:
*       port - uart port number.
*	c - character.
*
* OUTPUT:
*       None.
*
* RETURN:
*	None.
*
*******************************************************************************/
MV_VOID	mvUartPutc(MV_U32 port, MV_U8 c)
{
	volatile MV_UART_PORT *pUartPort = uartBase[port];
	while ((pUartPort->lsr & LSR_THRE) == 0) ;
	pUartPort->thr = c;
	return;
}

/*******************************************************************************
* mvUartInit - Init a uart port.
*
* DESCRIPTION:
*       This routine gets one charachetr from one of the uart ports.
*
* INPUT:
*       port - uart port number.
*
* OUTPUT:
*       None.
*
* RETURN:
*	carachter from the uart port.
*
*******************************************************************************/
MV_U8	mvUartGetc(MV_U32 port)
{
	volatile MV_UART_PORT *pUartPort = uartBase[port];
	while ((pUartPort->lsr & LSR_DR) == 0) ;
	return (pUartPort->rbr);
}
/*******************************************************************************
* mvUartInit - Init a uart port.
*
* DESCRIPTION:
*       This routine heck if a charachter is ready to be read from one of the
*	the uart ports.
*
* INPUT:
*       port - uart port number.
*
* OUTPUT:
*       None.
*
* RETURN:
*	None.
*
*******************************************************************************/
MV_BOOL mvUartTstc(MV_U32 port)
{
	volatile MV_UART_PORT *pUartPort = uartBase[port];
	return ((pUartPort->lsr & LSR_DR) != 0);
}

/*******************************************************************************
*
* DESCRIPTION:
*
* micon communication
*
*
* INPUT:
*      
*
* OUTPUT:
*       None.
*
* RETURN:
*	None.
*
*******************************************************************************/
/*saito change*/
#if defined(CONFIG_KUROBOX_PLATFORM)

MV_VOID send_micon_packet(MV_U8 data_num,MV_U8 *data)
{
#if defined(ORG_PCB)
	return;
#else
	MV_U8 loop ;
	MV_U8 sum  = 0;
	for(loop = 0 ;loop < data_num ;loop++)
	{
			mvUartPutc(1, *data);
			sum += *data ;
			*data ++;
   		mvOsDelay(200);
   	}
	sum = 0 - sum ;
	mvUartPutc(1, sum);
#endif
}

MV_U8 rcv_micon_packet(MV_U8 *data)
{
	MV_U8 loop ;
	MV_U8 sum  = 0;
	MV_U8 tmp_d ;
	MV_U8 data_num ;
	volatile MV_UART_PORT *pUartPort = uartBase[1];
	/* Clear & enable FIFOs */
	data_num = mvUartGetc(1) ;
	if((data_num & 0x7f) > 32)
	{
		printf("Invalid Receive Data size :%d \n",data_num) ;
		pUartPort->fcr = FCR_FIFO_EN | FCR_RXSR | FCR_TXSR;
		return 0xff ;
	}
	sum += data_num ;
	tmp_d = mvUartGetc(1) ;
	sum += tmp_d ;
/*	printf("Command %x h:",tmp_d) ;*/
	mvOsDelay(200);
	for(loop = 0 ;loop < (data_num & 0x7f)  +1 ;loop++)
	{
			tmp_d = mvUartGetc(1) ;
			sum += tmp_d ;
			*data = tmp_d ;
			data ++ ;
/*			printf(" %xh:",tmp_d) ;*/
   			mvOsDelay(200);
   	}
	if(sum != 0)
	{
		printf("Check Sum Error \n") ;
		return 0xff ;
	}
/*		printf("\n") ;*/
	return 0 ;
}
/*
MV_VOID lcd_disp_chara(unsigned char disp_plane, MV_U8 *data)
{
 MV_U8 send_data[34] ;
 MV_U8 get_disp[]= {0x80,0x32} ;
 int loop ;
volatile MV_UART_PORT *pUartPort = uartBase[1];
pUartPort->fcr = FCR_FIFO_EN | FCR_RXSR | FCR_TXSR;
 loop = 0 ;
 send_data[loop ++] = 32 ;
 if (disp_plane > 2)
 {
 	return ;
 }
 send_data[loop ++] = 0x90 + disp_plane ;
 for (loop = 2 ;loop < 34 ; loop++)
 {
 	send_data[loop] = *data;
 	data ++ ;
 }
	send_micon_packet(34,&send_data) ;
	rcv_micon_packet(&send_data) ;
	send_micon_packet(2,&get_disp) ;
	rcv_micon_packet(&send_data) ;
	send_data[2] =  send_data[0] | (0x20 << disp_plane) ;
	send_data[1] = 0x32 ; 
	send_data[0] = 0x01 ;
	send_micon_packet(3,&send_data) ;
	rcv_micon_packet(&send_data) ;
	send_data[0] = 0 ;
	send_data[1] = 0x25 +disp_plane ;
	send_micon_packet(2,&send_data) ;
	rcv_micon_packet(&send_data) ;
}
*/
MV_VOID peri_error(MV_U8 *data)
{
	 MV_U8 send_data[34] ;
	 int loop ;
	volatile MV_UART_PORT *pUartPort = uartBase[1];
	/* Clear & enable FIFOs */
	pUartPort->fcr = FCR_FIFO_EN | FCR_RXSR | FCR_TXSR;
	 loop = 0 ;
	 send_data[loop ++] = 32 ;
	 send_data[loop ++] = 0x93 ; /*peri_error*/
	 for (loop = 2 ;loop < 34 ; loop++)
	 {
	 	send_data[loop] = *data;
	 	data ++ ;
	 }
		send_micon_packet(34,&send_data) ;
		rcv_micon_packet(&send_data) ;
}
MV_VOID tftp_alarm(void)
{
/*	unsigned char disp_plane[]= "  TFTP MODE     System from Eth." ;*/
 	MV_U8 send_data[34] ;
 	MV_U8 BZ_05_03[]= {0x01,0x30,0x10} ;
 	MV_U8 LED_ERR3[]= {0x02,0x54,0x00,0x06} ;
	char *get_ip ;
 	int loop ;
	volatile MV_UART_PORT *pUartPort = uartBase[1];


			send_micon_packet(4,&LED_ERR3) ;
			rcv_micon_packet(&send_data) ;
	
			send_micon_packet(3,&BZ_05_03) ;
			rcv_micon_packet(&send_data) ;
}
MV_VOID fl_ok(void)
{
#if !defined(ORG_PCB)
/*	mvUartPutc(1, 0);
	mvUartPutc(1, 2);
	mvUartPutc(1, 0xfe);*/
#endif
}
MV_VOID phy_ng(void)
{
	volatile MV_UART_PORT *pUartPort = uartBase[1];
	/* Clear & enable FIFOs */
	printf("<<%s>>\n",__FUNCTION__);
		MV_U8 data[] = { 0,0x28} ;
		send_micon_packet(2,&data) ;
}



MV_VOID system_not_found(void)
{
	printf("<<%s>>\n",__FUNCTION__);
#if !defined(ORG_PCB)
	mvUartPutc(1, 0);
	mvUartPutc(1, 0x2a);
	mvUartPutc(1, 0xd6);
#endif
}
MV_VOID system_bootend(void)
{
    MV_U8 rcv_data[34] ;
	MV_U8 data[] = { 0,0x03} ;
	MV_U8 fun_high_data[] = { 1,0x33,0x02} ;
	printf("<<%s>>\n",__FUNCTION__);
	send_micon_packet(2,&data) ;
	rcv_micon_packet(&rcv_data) ;
	send_micon_packet(3,&fun_high_data) ;
	rcv_micon_packet(&rcv_data) ;
}
MV_VOID stop_sound(void)
{
	MV_U8 data[] = { 1,0x30,00} ;
	printf("<<%s>>\n",__FUNCTION__);
	send_micon_packet(3,&data) ;
}
MV_VOID system_shutdown(void)
{
	MV_U8 data1[] = { 0,0x0c} ;
	MV_U8 data2[] = { 0,0x06} ;
	printf("<<%s>>\n",__FUNCTION__);
	send_micon_packet(2,&data1) ;
   		mvOsDelay(200);
	send_micon_packet(2,&data2) ;
}
MV_U8 is_em_mode(void)
{
#if !defined(ORG_PCB)
	volatile MV_UART_PORT *pUartPort = uartBase[1];
	/* Clear & enable FIFOs */
	MV_U8 ss;
	pUartPort->fcr = FCR_FIFO_EN | FCR_RXSR | FCR_TXSR;
	mvUartPutc(1, 0x80);
	mvUartPutc(1, 0x3e);
	mvUartPutc(1, 0x42);

	ss = mvUartGetc(1) ;
	ss = mvUartGetc(1) ;
	ss = mvUartGetc(1) ;
	 mvUartGetc(1) ;
		return ss ;
#else
	return 0;
#endif
}

#if !defined(ORG_PCB)
MV_U32 mcon_get_borad_id(void)
{
	volatile MV_UART_PORT *pUartPort = uartBase[1];
	int clock_divisor2 = (CFG_TCLK / 16)/ 38400 ;
 	mvUartInit(1, clock_divisor2, mvUartBase(1));
	/* Clear & enable FIFOs */
	MV_U8 ss;
	MV_U32 tt;
	pUartPort->fcr = FCR_FIFO_EN | FCR_RXSR | FCR_TXSR;
   		mvOsDelay(200);
	mvUartPutc(1, 0x80);
	mvUartPutc(1, 0x3f);
	mvUartPutc(1, 0x41);
   		mvOsDelay(200);
	ss = mvUartGetc(1) ;
	ss = mvUartGetc(1) ;
	ss = mvUartGetc(1) ;
	tt = (MV_U32)ss ;
	 mvUartGetc(1) ;
		return  tt;

}
#endif

#endif

