#ifndef _EEPROM_H__
#define _EEPROM_H__

#include <linux/ioctl.h> /* needed for the _IOW etc */ 

#undef PDEBUG
#ifdef EEPROM_DEBUG
#  ifdef __KERNEL__
#    define PDEBUG(fmt, args...) printk( KERN_DEBUG "eeprom: " fmt, ## args)
#  else
#    define PDEBUG(fmt, args...) fprintf(stderr, fmt, ## args)
#  endif
#else
#  define PDEBUG(fmt, args...) 
#endif

#define EEPROM_MAJOR    0
#define EEPROM_MINOR    0
#define EEPROM_NR_DEVS  1
#define EEPROM_SLAVE_ADDR  0x50
#define EEPROM_MAX_SIZE 1024

typedef struct ioblock
{
    unsigned int offset;
    unsigned int count;
} ioblock_t;

/*
 * Ioctl definitions
 */

/* Use 'e' as magic number */
#define EEPROM_IOC_MAGIC  'e'

#define EEPROM_IOCGETSIZE _IOR(EEPROM_IOC_MAGIC,  1, int)
#define EEPROM_IOCSETSIZE _IOW(EEPROM_IOC_MAGIC,  2, int)
#define EEPROM_IOCSETADDR _IOW(EEPROM_IOC_MAGIC,  3, int)
#define EEPROM_IOCGETBUFF _IO(EEPROM_IOC_MAGIC,  4)
#define EEPROM_IOCSETBUFF _IO(EEPROM_IOC_MAGIC,  5)
#define EEPROM_IOCGETBUFFBLK _IOW(EEPROM_IOC_MAGIC,  6, ioblock_t)
#define EEPROM_IOCSETBUFFBLK _IOW(EEPROM_IOC_MAGIC,  7, ioblock_t)

#define EEPROM_IOC_MAXNR 7

#endif
