/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/list.h>
#include <linux/device.h>
#include <linux/slab.h>
#include <linux/string.h>
#include <linux/sysdev.h>
#include <asm/mach/time.h>
#if defined(CONFIG_MTD_PHYSMAP) 
#include <linux/mtd/physmap.h>
#endif
#include <asm/hardware.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/mach-types.h>

#include <asm/mach/arch.h>
#include <asm/mach/flash.h>
#include <asm/mach/irq.h>
#include <asm/mach/map.h>
#include <asm/arch/system.h>
#include <asm/arch/orion_ver.h>

#include <asm/vfp.h>

#include <linux/tty.h>
#include <linux/serial_core.h>
#include <linux/serial.h>
#include <linux/serialP.h>
#include <linux/serial_reg.h>
#include <asm/serial.h>

#include <asm/arch/serial.h>

#include "mvCtrlEnvLib.h"
#include "mvCpuIf.h"
#include "mvDevice.h"
#include "mvBoardEnvLib.h"
#include "mvDebug.h"
#include "mvSysHwConfig.h"
#include "mvPexRegs.h"
#ifdef CONFIG_MV_INCLUDE_IDMA
#   include "mvIdma.h"
#endif
#ifdef CONFIG_MV_INCLUDE_USB
#   include "mvUsb.h"
#endif

#ifdef CONFIG_MV_INCLUDE_CESA
#include "mvCesa.h"
#include "mvMD5.h"
#include "mvSHA1.h"
#endif

#if defined (MV_INCLUDE_INTEG_MFLASH) || defined (MV_INCLUDE_SPI)
#include <mvCtrlEnvLib.h>
#endif

#ifdef MV_INCLUDE_SPI
#include <mvSFlash.h>
#include <mvSFlashSpec.h>
#endif

#ifdef MV_INCLUDE_INTEG_MFLASH
#include <mvMFlash.h>
#include <mvMFlashSpec.h>
#endif

#ifdef CONFIG_DEBUG_LL
void printascii(char *);

/* for debug putstr */
static char arr[256];
void mv_early_printk(char *fmt,...)
{
	va_list args;
	va_start(args, fmt);
	vsprintf(arr,fmt,args);
	va_end(args);
	printascii(arr);
}
#endif


extern void __init mv_map_io(void);
extern void __init mv_init_irq(void);
extern MV_CPU_DEC_WIN* mv_sys_map(void);
extern MV_U32 boardGetDevCSNum(MV_32 devNum, MV_BOARD_DEV_CLASS devType);
#if defined(CONFIG_MV_INCLUDE_CESA)
extern u32 mv_crypo_base_get(void);
#endif
#if defined(MV_INCLUDE_DEVICE_CS1)
extern u32 mv_device_cs1_base_get(void);
#endif
unsigned int mv_orion_ver = 0x0;
unsigned int mv_orion_has_vfp = 0x0;
unsigned int mv_vfp_always_on = 0x0;
unsigned int support_wait_for_interrupt = 0x1;

u32 mvTclk = 166666667;
u32 mvSysclk = 200000000;
u32 mvIsUsbHost = 1;

#ifdef CONFIG_UBOOT_STRUCT

u32 overEthAddr = 0;
/*#ifdef CONFIG_MV_INCLUDE_UNM_ETH*/
u8	mvMacAddr[6] = {0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};
/*#endif*/
extern MV_U32 gBoardId; 
extern unsigned int elf_hwcap;
 
static int __init parse_tag_mv_uboot(const struct tag *tag)
{
    unsigned int mvUbootVer = 0;
 
	mvUbootVer = tag->u.mv_uboot.uboot_version;
	mvIsUsbHost = tag->u.mv_uboot.isUsbHost;

        printk("Using UBoot passing parameters structure\n");
  
	gBoardId =  (mvUbootVer & 0xff);
		
      if( mvUbootVer > 0x01040100 )  /* releases after 1.4.2 */
      {
		overEthAddr = tag->u.mv_uboot.overEthAddr;        
/*#ifdef CONFIG_MV_INCLUDE_UNM_ETH*/
    	/*U-boot version => 1.9.2*/			
	    if (mvUbootVer >= 0x01090200)					
	    {
		    memcpy(mvMacAddr, tag->u.mv_uboot.macAddr, 6);
	    }
		memcpy(mvMacAddr, tag->u.mv_uboot.macAddr, 6);
/*#endif*/
      }
    return 0;
}
                                                                                                                             
__tagtable(ATAG_MV_UBOOT, parse_tag_mv_uboot);
#else
	mvTclk = 166666667;
	mvSysclk = 200000000;
#ifdef CONFIG_MV_USB_HOST
    	mvIsUsbHost = 1;
#else
    	mvIsUsbHost = 0;
#endif
#endif

#ifdef CONFIG_MV_INCLUDE_CESA
unsigned char*  mv_sram_usage_get(int* sram_size_ptr)
{
    int used_size = 0;

#if defined(CONFIG_MV_CESA)
    used_size = sizeof(MV_CESA_SRAM_MAP);
#endif

    if(sram_size_ptr != NULL)
        *sram_size_ptr = _8K - used_size;

    return (char *)(mv_crypo_base_get() + used_size);
}
#endif

#ifdef CONFIG_MV_INCLUDE_IDMA
/* Return number of free IDMA engines */
int mv_idma_usage_get(int* free_map)
{
    int idma, free;

    free = MV_IDMA_MAX_CHAN;
    for(idma=0; idma<MV_IDMA_MAX_CHAN; idma++)
    {
        free_map[idma] = 1;
    }
#if defined(CONFIG_MV_CESA)
    /* CESA uses Idma channel #0. Idma engine #1 used when CESA use two channels */
    for(idma=0; idma<MV_CESA_MAX_CHAN; idma++)
    {
        free_map[idma] = 0;
        free--;
    }
#endif /* CONFIG_MV_CESA */

#ifdef CONFIG_MV_DMA_COPYUSER
    free_map[2] = 0;
    free_map[3] = 0;
    free -= 2;
#endif /* CONFIG_MV_DMA_COPYUSER */

    return free;
}
#endif /* CONFIG_MV_INCLUDE_IDMA */


EXPORT_SYMBOL(mvCtrlPwrClckGet);
EXPORT_SYMBOL(mvTclk);
EXPORT_SYMBOL(mvSysclk);
EXPORT_SYMBOL(mvCtrlModelGet);
EXPORT_SYMBOL(mvOsIoUncachedMalloc);
EXPORT_SYMBOL(mvOsIoUncachedFree);
EXPORT_SYMBOL(mvOsIoCachedMalloc);
EXPORT_SYMBOL(mvOsIoCachedFree);
EXPORT_SYMBOL(mvOsCacheFlush);
EXPORT_SYMBOL(mvDebugMemDump);
EXPORT_SYMBOL(mvHexToBin);
EXPORT_SYMBOL(mvBinToHex);
#ifdef CONFIG_MV_INCLUDE_USB
EXPORT_SYMBOL(mvIsUsbHost);
EXPORT_SYMBOL(mvCtrlUsbMaxGet);
#endif
EXPORT_SYMBOL(mvCtrlModelRevGet);

#ifdef CONFIG_MV_INCLUDE_IDMA
EXPORT_SYMBOL(mv_idma_usage_get);
EXPORT_SYMBOL(mvDmaTransfer);
EXPORT_SYMBOL(mvDmaStateGet);
#endif
#ifdef CONFIG_MV_INCLUDE_USB
EXPORT_SYMBOL(mvUsbGetCapRegAddr);
EXPORT_SYMBOL(mvUsbGppInit);
EXPORT_SYMBOL(mvUsbBackVoltageUpdate);
#endif /* CONFIG_MV_INCLUDE_USB */

#ifdef CONFIG_MV_INCLUDE_CESA
EXPORT_SYMBOL(mvCesaInit);
EXPORT_SYMBOL(mvCesaSessionOpen);
EXPORT_SYMBOL(mvCesaSessionClose);
EXPORT_SYMBOL(mvCesaAction);
EXPORT_SYMBOL(mvCesaReadyGet);
EXPORT_SYMBOL(mvCesaCopyFromMbuf);
EXPORT_SYMBOL(mvCesaCopyToMbuf);
EXPORT_SYMBOL(mvCesaMbufCopy);
EXPORT_SYMBOL(mvCesaCryptoIvSet);
EXPORT_SYMBOL(mvMD5);
EXPORT_SYMBOL(mvSHA1);

EXPORT_SYMBOL(mvCesaDebugQueue);
EXPORT_SYMBOL(mvCesaDebugSram);
EXPORT_SYMBOL(mvCesaDebugSAD);
EXPORT_SYMBOL(mvCesaDebugStatus);
EXPORT_SYMBOL(mvCesaDebugMbuf);
EXPORT_SYMBOL(mvCesaDebugSA);
#endif /* CONFIG_MV_CESA */
#ifdef CONFIG_MV_INCLUDE_CESA
EXPORT_SYMBOL(mv_sram_usage_get);
#endif

#if defined (MV_INCLUDE_INTEG_MFLASH) || defined (MV_INCLUDE_SPI)
EXPORT_SYMBOL(mvCtrlSpiBusModeDetect);
#endif

#ifdef MV_INCLUDE_INTEG_MFLASH
EXPORT_SYMBOL(mvMFlashInit);
EXPORT_SYMBOL(mvMFlashChipErase);
EXPORT_SYMBOL(mvMFlashMainErase);
EXPORT_SYMBOL(mvMFlashInfErase);
EXPORT_SYMBOL(mvMFlashSecErase);
EXPORT_SYMBOL(mvMFlashBlockWr);
EXPORT_SYMBOL(mvMFlashInfBlockWr);
EXPORT_SYMBOL(mvMFlashBlockRd);
EXPORT_SYMBOL(mvMFlashBlockInfRd);
EXPORT_SYMBOL(mvMFlashReadConfig);
EXPORT_SYMBOL(mvMFlashSetConfig);
EXPORT_SYMBOL(mvMFlashSetSlewRate);
EXPORT_SYMBOL(mvMFlashWriteProtectSet);
EXPORT_SYMBOL(mvMFlashWriteProtectGet);
EXPORT_SYMBOL(mvMFlashSectorSizeSet);
EXPORT_SYMBOL(mvMFlashPrefetchSet);
EXPORT_SYMBOL(mvMFlashShutdownSet);
EXPORT_SYMBOL(mvMFlashIdGet);
EXPORT_SYMBOL(mvMFlashReset);
#endif

#ifdef MV_INCLUDE_SPI
EXPORT_SYMBOL(mvSFlashInit);
EXPORT_SYMBOL(mvSFlashSectorErase);
EXPORT_SYMBOL(mvSFlashChipErase);
EXPORT_SYMBOL(mvSFlashBlockRd);
EXPORT_SYMBOL(mvSFlashBlockWr);
EXPORT_SYMBOL(mvSFlashIdGet);
EXPORT_SYMBOL(mvSFlashWpRegionSet);
EXPORT_SYMBOL(mvSFlashWpRegionGet);
EXPORT_SYMBOL(mvSFlashStatRegLock);
EXPORT_SYMBOL(mvSFlashSizeGet);
EXPORT_SYMBOL(mvSFlashPowerSaveEnter);
EXPORT_SYMBOL(mvSFlashPowerSaveExit);
EXPORT_SYMBOL(mvSFlashModelGet);
#endif


void print_board_info(void)
{
    char name_buff[50];
    printk("\n  Marvell Development Board (LSP Version %s)",LSP_VERSION);

    mvBoardNameGet(name_buff);
    printk("-- %s ",name_buff);

    mvCtrlModelRevNameGet(name_buff);
    printk(" Soc: %s",  name_buff);

    printk("\n\n");
    printk(" Detected Tclk %d and SysClk %d \n",mvTclk, mvSysclk);
}

#if 0
/* Add the uart to the console list (ttyS0) . */
static void serial_initialize(void)
{
    struct uart_port        serial_req;

    memset(&serial_req, 0, sizeof(serial_req));
    serial_req.line = 0;
    serial_req.uartclk = BASE_BAUD * 16;
    serial_req.irq = IRQ_UART0;
    serial_req.flags = STD_COM_FLAGS;
    serial_req.iotype = SERIAL_IO_MEM;
    serial_req.membase = (char *)PORT0_BASE;
    serial_req.regshift = 2;

    if (early_serial_setup(&serial_req) != 0) {
        printk("Early serial init of port 0 failed\n");
    }
    return;
}
#endif
#if defined(CONFIG_MTD_PHYSMAP) 
static void mv_mtd_initialize(void)
{
    u32 size = 0, boardId = 0;
#if defined(CONFIG_MV88F1181) || defined(CONFIG_MV88F1281) 
	u32 base = FLASH_CS;
#else
 #if defined(MV_INCLUDE_DEVICE_CS1)
    u32 base = mv_device_cs1_base_get();
 #else
  #error "DEVICE CS1 Not Defined"
 #endif
#endif
    u32 bankwidth = mvBoardGetDeviceBusWidth(1,BOARD_DEV_NOR_FLASH) / 8;
    
    boardId = mvBoardIdGet();
    switch(boardId) {
	case(RD_88F5181L_VOIP_FXO_GE):
		    bankwidth = mvBoardGetDeviceBusWidth(0,BOARD_DEV_NOR_FLASH) / 8;
        case(RD_88F5181_VOIP):
	    size = _8M;	
	    break;
        case(DB_88F5X81_DDR2):
        case(DB_88F5X81_DDR1):
            size = _32M;
            break;
        case(RD_88F5181_POS_NAS):
            size = 0;
            break;
        case(DB_88F5181_5281_DDR1):
        case(DB_88F5181_5281_DDR2):
            size = _16M;
            break;  
        case(DB_88F5182_DDR2):
        case(DB_88W8660_DDR2):
	    case(DB_88F5181L_DDR2_2XTDM):
            size = _16M;
            break;
        case(RD_88F5182_2XSATA):
        case(RD_88F5182_2XSATA3):
            size = _256K;
            base = mvCpuIfTargetWinBaseLowGet(DEV_BOOCS);
			bankwidth = mvBoardGetDeviceBusWidth(0,BOARD_DEV_NOR_FLASH) / 8;
            break;
	case(RD_88W8660_AP82S_DDR1):
        case(RD_88F5181L_VOIP_FE):
	case(RD_88F5181L_VOIP_GE):
	case(RD_88W8660_DDR1):
            size = mvCpuIfTargetWinSizeGet(DEV_BOOCS);
            base =  mvCpuIfTargetWinBaseLowGet(DEV_BOOCS);
            bankwidth = mvBoardGetDeviceBusWidth(0,BOARD_DEV_NOR_FLASH) / 8;
            printk("Flash bankwidth %d, base %x, size %x\n", bankwidth, base, size); 
            break;
        case(DB_88F1281_DDR2):
            size = 0;
            break;
        default:
            printk(" %s Error : Unknown board \n", __FUNCTION__);
            size = 0;
    }
    if(size == 0)
        return;

    physmap_configure(base, size, bankwidth, NULL);

    return;
}
#endif


static void __init mv_init(void)
{

       unsigned int orion_has_vfp = 0x0;
       unsigned int vfp_always_on = 0x0;

        /* init the Board environment */
        if (mvBoardIdGet() != RD_88F6082_NAS_PH)  /* excluded for HDD power problem - to be fixed */
		mvBoardEnvInit();

        /* init the controller environment */
        if( mvCtrlEnvInit() ) {
            printk( "Controller env initialization failed.\n" );
            return;
        }

	/* Init the CPU windows setting and the access protection windows. */
	if( mvCpuIfInit(mv_sys_map()) ) {

		printk( "Cpu Interface initialization failed.\n" );
		return;
	}

    /* Init Tclk & SysClk */
    mvTclk = mvBoardTclkGet();
    mvSysclk = mvBoardSysClkGet();

	if(mvTclk == 166000000)
	    mvTclk = 166666667;
    if(mvTclk == 133000000)
	    mvTclk = 133333334;
    if(mvSysclk == 166000000)
	    mvSysclk = 166666667;
    if(mvSysclk == 133000000)
            mvSysclk = 133333334;

	printk("Sys Clk = %d, Tclk = %d\n",mvSysclk ,mvTclk  );
	

    	if ((mvCtrlModelGet() == MV_5281_DEV_ID) || (mvCtrlModelGet() == MV_1281_DEV_ID))
            mv_orion_ver = MV_ORION2; /* Orion II */    
    	else
            mv_orion_ver = MV_ORION1; /* Orion I */ 
            
	if(mvCtrlModelGet() == MV_5281_DEV_ID)
	{
	    orion_has_vfp = 1;
	    if (mvCtrlRevGet() <= MV_5281_D0_REV)
		vfp_always_on = 1;
	}

        /* Implement workaround for FEr# CPU-C16: Wait for interrupt command */ 
        /* is not processed properly, the workaround is not to use this command */
        /* the erratum is relevant for 5281 devices with revision less than C0 */
        if((mvCtrlModelGet() == MV_5281_DEV_ID)
         && (mvCtrlRevGet() < MV_5281_C0_REV))
        {
            support_wait_for_interrupt = 0;
        }

#ifdef CONFIG_JTAG_DEBUG
            support_wait_for_interrupt = 0; /* assaf for Lauterbach */
#endif

#if defined(CONFIG_VFP) || defined(CONFIG_VFP_RUN_FAST_MODE)
         if(orion_has_vfp)
        {
            elf_hwcap |= HWCAP_VFP;
        }
#endif
        if(mvCtrlModelGet() != MV_5281_DEV_ID)
        {   
            elf_hwcap &= ~HWCAP_EDSP;
        }
        elf_hwcap &= ~HWCAP_JAVA;

#define vfpreg(_vfp_) #_vfp_

#define fmrx(_vfp_) {			\
	u32 __v;			\
	asm("mrc%? p10, 7, %0, " vfpreg(_vfp_) ", cr0, 0 @ fmrx	%0, " #_vfp_	\
	    : "=r" (__v));		\
	__v;				\
 }

#define fmxr(_vfp_,_var_)		\
	asm("mcr%? p10, 7, %0, " vfpreg(_vfp_) ", cr0, 0 @ fmxr	" #_vfp_ ", %0"	\
	   : : "r" (_var_))

        if(orion_has_vfp)
        { 
#if defined(CONFIG_VFP)     
	    /* Enable VFP in early phase in case Orion2 D0 and below */
	    if (vfp_always_on)
	    {
                /* init and Enable VFP to Run Fast Mode */
                printk("Orion2 D0 or less. Enable VFP.\n");
                /* Enable */
                fmxr(FPEXC, fmrx(FPEXC) | FPEXC_ENABLE);
	    }
#elif defined CONFIG_VFP_RUN_FAST_MODE
            /* init and Enable VFP to Run Fast Mode */
            printk("VFP initialized to Run Fast Mode.\n");
            /* Enable */
            fmxr(FPEXC, fmrx(FPEXC) | FPEXC_ENABLE);
            /* Run Fast Mode */
            fmxr(FPSCR, fmrx(FPSCR) | (FPSCR_DEFAULT_NAN | FPSCR_FLUSHTOZERO));        
#endif
	}

	/* Only after the VFP initialized we can update the global parameters 		*/
	/* The global paramters are used by the sched. Sched access the FPSCR of VFP 	*/
	/* If FPSCR is accessed while the VFP is off we will get an exception that 	*/
	/* will confuse the system to think there is no VFP in the system		*/
	mv_orion_has_vfp = orion_has_vfp;
	mv_vfp_always_on = vfp_always_on;
#if 0
	serial_initialize();
#endif
	/* At this point, the CPU windows are configured according to default definitions in mvSysHwConfig.h */
	/* and cpuAddrWinMap table in mvCpuIf.c. Now it's time to change defaults for each platform.         */
	mvCpuIfAddDecShow();


#if defined(CONFIG_MTD_PHYSMAP)
	mv_mtd_initialize();
#endif
    	print_board_info();

#ifdef CONFIG_MV_INCLUDE_IDMA
    mvDmaInit();
#endif

    return;
}

#include "asm/arch/time.h"

static void __init mv_init_timer(void)
{
        mv_time_init();
}

static struct sys_timer mv_timer = {
        .init           = mv_init_timer,
        .offset         = mv_gettimeoffset,
};

MACHINE_START(FEROCEON ,"Feroceon")
	/* MAINTAINER("MARVELL") */
	.phys_io	= 0xf1000000,
	.io_pg_offst	= (0xf1000000 >> 18) & 0xfffc,
	.boot_params	= 0x00000100,
	.timer		= &mv_timer,
	.map_io		= mv_map_io,
	.init_irq	= mv_init_irq,
	.init_machine	= mv_init,
MACHINE_END

