/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.

*******************************************************************************/
/*******************************************************************************
* mvSysHwCfg.h - Marvell system HW configuration file
*
* DESCRIPTION:
*       None.
*
* DEPENDENCIES:
*       None.
*
*******************************************************************************/

#ifndef __INCmvSysHwConfigh
#define __INCmvSysHwConfigh


#define MV_CACHEABLE(address) ((address) | 0x80000000)

/* includes */
#define _1K         0x00000400
#define _4K         0x00001000
#define _8K         0x00002000
#define _16K        0x00004000
#define _32K        0x00008000
#define _64K        0x00010000
#define _128K       0x00020000
#define _256K       0x00040000
#define _512K       0x00080000

#define _1M         0x00100000
#define _2M         0x00200000
#define _4M         0x00400000
#define _8M         0x00800000
#define _16M        0x01000000
#define _32M        0x02000000
#define _64M        0x04000000
#define _128M       0x08000000
#define _256M       0x10000000
#define _512M       0x20000000

#define _1G         0x40000000
#define _2G         0x80000000

/* 
 *  System memory mapping 
 */


/* SDRAM: actual mapping is auto detected */
#define SDRAM_CS0_BASE  0x00000000
#define SDRAM_CS0_SIZE  _256M

#define SDRAM_CS1_BASE  0x10000000
#define SDRAM_CS1_SIZE  _256M

#define SDRAM_CS2_BASE  0x20000000
#define SDRAM_CS2_SIZE  _256M

#define SDRAM_CS3_BASE  0x30000000
#define SDRAM_CS3_SIZE  _256M

/* PEX */
#define PEX0_MEM_BASE 0x90000000
#define PEX0_MEM_SIZE _128M

#define PEX0_IO_BASE 0xf0000000
#define PEX0_IO_SIZE _1M

/* PEX Work arround */
/* the target we will use for the workarround */
#define PEX_CONFIG_RW_WA_TARGET PEX0_MEM
/*a flag that indicates if we are going to use the 
size and base of the target we using for the workarround
window */
#define PEX_CONFIG_RW_WA_USE_ORIGINAL_WIN_VALUES 1
/* if the above flag is 0 then the following values
will be used for the workarround window base and size,
otherwise the following defines will be ignored */
#define PEX_CONFIG_RW_WA_BASE 0x50000000
#define PEX_CONFIG_RW_WA_SIZE _16M


#if defined(MV_88F1181)                              

#define PEX1_MEM_BASE 0x98000000
#define PEX1_MEM_SIZE _128M

#define PEX1_IO_BASE 0xf0100000
#define PEX1_IO_SIZE _1M

#elif defined (MV_88F5181)                           
/* PCI0: IO and memory space */
#if defined (DB_PRPMC) || defined (DB_MNG)
#define PCI0_MEM_BASE  0xa0000000
#define PCI0_MEM_SIZE  _256M
#else
#define PCI0_MEM_BASE  0x98000000
#define PCI0_MEM_SIZE  _128M
#endif /* defined (DB_PRPMC) || defined (DB_MNG) */
#define PCI0_IO_BASE    0xf0100000
#define PCI0_IO_SIZE    _1M

#else                                                
#   error "CHIP not selected"                        
#endif                                               

#if defined(MV_88F5181)                              
/* Device: CS0 - SRAM, CS1 - RTC, CS2 - UART, CS3 - large flash */
#define DEVICE_CS0_BASE 0xfa000000
#define DEVICE_CS0_SIZE _2M

#define DEVICE_CS1_BASE 0xf8000000

#define DEVICE_CS1_SIZE _32M

#ifdef MV_ORIG_LAYOUT
#define DEVICE_CS2_BASE 0xfa800000
#define DEVICE_CS2_SIZE _1M
#else
#define DEVICE_CS2_BASE 0xfa000000
#define DEVICE_CS2_SIZE _1M
#endif

#elif defined (MV_88F1181)                           

#define FLASH_CS_BASE 0xf8000000
#define FLASH_CS_SIZE _16M


#else                                                
#   error "CHIP not selected"                        
#endif                                               

/* Internal registers: size is defined in Controllerenvironment */
#define INTER_REGS_BASE	0xF1000000


#if defined(RD_88F5182) && defined(MV_TINY_IMAGE)

/*  [BB]
#define BOOTDEV_CS_BASE	0xFFFC0000
#define BOOTDEV_CS_SIZE _256K
*/

#define BOOTDEV_CS_BASE	0xFF000000
#define BOOTDEV_CS_SIZE _16M


#elif defined(RD_88F5182_3) && defined(MV_TINY_IMAGE)

#define BOOTDEV_CS_BASE	0xFFFC0000
#define BOOTDEV_CS_SIZE _256K

#elif defined(RD_88F5181L_FE) || defined(RD_88F5181L_GE) || defined(RD_88F5182) || \
					defined(RD_88W8660)

#define BOOTDEV_CS_BASE	0xFF000000
#define BOOTDEV_CS_SIZE _16M

#elif defined(RD_88W8660_AP82S)

#if defined(MV_8MB_NOR)

#define BOOTDEV_CS_BASE	0xFF800000
#define BOOTDEV_CS_SIZE _8M

#elif defined(MV_4MB_NOR)

#define BOOTDEV_CS_BASE	0xFFC00000
#define BOOTDEV_CS_SIZE _4M

#else

#if defined(MV_NAND_BOOT)
#define BOOTDEV_CS_BASE	0xFFC00000
#define BOOTDEV_CS_SIZE _4M
#endif

#endif

#else

#define BOOTDEV_CS_BASE	0xff800000
#define BOOTDEV_CS_SIZE _8M

#endif

#if defined(MV_88F5182) || defined (MV_88F5181L)

#define CRYPT_ENG_BASE	0xFB000000
#define CRYPT_ENG_SIZE	_64K

#endif


/* DRAM detection stuff */
#define MV_DRAM_AUTO_SIZE

/* These addresses defines the place where global parameters will be placed	*/
/* in case running from ROM. We Use SYS_MEM_TOP. See bootInit.c file		*/
#define DRAM_DETECT_FLAG_ADDR 	0x03000000
#define DRAM_CONFIG_ROM_ADDR 	0x03000004

/* We use the following registers to store DRAM interface pre configuration   */
/* auto-detection results													  */
/* IMPORTANT: We are using mask register for that purpose. Before writing     */
/* to units mask register, make sure main maks register is set to disable     */
/* all interrupts.                                                            */
#define DRAM_BUF_REG0	0x1011c	/* sdram bank 0 size	        */  
#define DRAM_BUF_REG1	0x20318	/* sdram config			        */
#define DRAM_BUF_REG2   0x20114	/* sdram mode 			        */
#define DRAM_BUF_REG3	0x20320	/* dunit control low 	        */          
#define DRAM_BUF_REG4	0x20404	/* sdram address control        */
#define DRAM_BUF_REG5	0x2040c	/* sdram timing control low     */
#define DRAM_BUF_REG6	0x40108	/* sdram timing control high    */
#define DRAM_BUF_REG7	0x40114	/* sdram ODT control low        */
#define DRAM_BUF_REG8	0x41910	/* sdram ODT control high       */
#define DRAM_BUF_REG9	0x41a08	/* sdram Dunit ODT control      */
#define DRAM_BUF_REG10	0x41a30	/* sdram Extended Mode		    */

/* Following the pre-configuration registers default values restored after    */
/* auto-detection is done                                                     */
#define DRAM_BUF_REG0_DV    0           /* GPIO Interrupt Level Mask Reg      */
#define DRAM_BUF_REG1_DV	0           /* ARM Timer 1 reload register        */
#define DRAM_BUF_REG2_DV    0           /* AHB to MBUS Bridge int Mask Reg    */
#define DRAM_BUF_REG3_DV	0           /* ARM Watchdog Timer Register        */
#define DRAM_BUF_REG4_DV	0           /* Host to ARM Doorbel Mask Register  */
#define DRAM_BUF_REG5_DV	0           /* ARM To Host Doorbel Mask Register  */
#define DRAM_BUF_REG6_DV	0           /* PCI Exp Uncorrectable Err Mask Reg */
#define DRAM_BUF_REG7_DV	0           /* PCI Exp Correctable Err Mask Reg   */
#define DRAM_BUF_REG8_DV	0           /* PCI Express interrupt Mask Reg     */
#define DRAM_BUF_REG9_DV	0           /* PCI Express Spare Register         */
#define DRAM_BUF_REG10_DV	0x012C0004  /* PCI Exp Acknowledge Timers (x4) Reg*/
 

#if defined (MV_88F5181)                         

/* Pex\PCI stuff */
#define PEX0_HOST_BUS_NUM		0
#define PEX0_HOST_DEV_NUM		0

#define PCI0_HOST_BUS_NUM		1
#define PCI0_HOST_DEV_NUM		0

/* no pci1 in MV_88F5181 */
#define PCI1_HOST_BUS_NUM		0
#define PCI1_HOST_DEV_NUM		0
/* no pex1 in MV_88F5181 */
#define PEX1_HOST_BUS_NUM		0
#define PEX1_HOST_DEV_NUM		0

#define PCI_ARBITER_CTRL    /* Use/unuse the Marvell integrated PCI arbiter	*/
#undef	PCI_ARBITER_BOARD	/* Use/unuse the PCI arbiter on board			*/

/* Check macro validity */
#if defined(PCI_ARBITER_CTRL) && defined (PCI_ARBITER_BOARD)
	#error "Please select either integrated PCI arbiter or board arbiter"
#endif




#elif defined (MV_88F1181)                           
/* Pex\PCI stuff */
#define PEX0_HOST_BUS_NUM		0
#define PEX0_HOST_DEV_NUM		0
/* we have a bridge */
#define PEX1_HOST_BUS_NUM		2
#define PEX1_HOST_DEV_NUM		0

/* no pci in MV_88F5181 */
#define PCI0_HOST_BUS_NUM		0
#define PCI0_HOST_DEV_NUM		0
#define PCI1_HOST_BUS_NUM		0
#define PCI1_HOST_DEV_NUM		0

#else                                                
#   error "CHIP not selected"                        
#endif                                               


/* Board clock detection */
#define TCLK_AUTO_DETECT    /* Use Tclk auto detection 		*/
#define SYSCLK_AUTO_DETECT	/* Use SysClk auto detection 	*/
#define PCLCK_AUTO_DETECT  /* Use PClk auto detection */


/* Memory uncached, HW or SW cache coherency is not needed */
#define MV_UNCACHED             0   
/* Memory cached, HW cache coherency supported in WriteThrough mode */
#define MV_CACHE_COHER_HW_WT    1
/* Memory cached, HW cache coherency supported in WriteBack mode */
#define MV_CACHE_COHER_HW_WB    2
/* Memory cached, No HW cache coherency, Cache coherency must be in SW */
#define MV_CACHE_COHER_SW       3


#if defined(MV_88F5181)                   
/************* Ethernet driver configuration ********************/

/*#define ETH_JUMBO_SUPPORT*/
/* HW cache coherency configuration */
#define DMA_RAM_COHER	    NO_COHERENCY
#define ETHER_DRAM_COHER    MV_UNCACHED 
#define INTEG_SRAM_COHER    MV_UNCACHED  /* Where integrated SRAM available */

#define ETH_DESCR_IN_SDRAM
#undef  ETH_DESCR_IN_SRAM

#if (ETHER_DRAM_COHER == MV_CACHE_COHER_HW_WB)
#   define ETH_SDRAM_CONFIG_STR      "MV_CACHE_COHER_HW_WB"
#elif (ETHER_DRAM_COHER == MV_CACHE_COHER_HW_WT)
#   define ETH_SDRAM_CONFIG_STR      "MV_CACHE_COHER_HW_WT"
#elif (ETHER_DRAM_COHER == MV_CACHE_COHER_SW)
#   define ETH_SDRAM_CONFIG_STR      "MV_CACHE_COHER_SW"
#elif (ETHER_DRAM_COHER == MV_UNCACHED)
#   define ETH_SDRAM_CONFIG_STR      "MV_UNCACHED"
#else
#   error "Unexpected ETHER_DRAM_COHER value"
 
#endif /* ETHER_DRAM_COHER */


/*********** Idma default configuration ***********/
#define UBOOT_CNTRL_DMA_DV     (ICCLR_DST_BURST_LIM_8BYTE | \
				ICCLR_SRC_INC | \
				ICCLR_DST_INC | \
				ICCLR_SRC_BURST_LIM_8BYTE | \
				ICCLR_NON_CHAIN_MODE | \
				ICCLR_BLOCK_MODE )
			   
#elif defined (MV_88F1181)                           


#else                                                
#   error "CHIP not selected"                        
#endif                                               
			   
#endif /* __INCmvSysHwConfigh */
