/*******************************************************************************
Copyright (C) Marvell International Ltd. and its affiliates

********************************************************************************
Marvell GPL License Option

If you received this File from Marvell, you may opt to use, redistribute and/or 
modify this File in accordance with the terms and conditions of the General 
Public License Version 2, June 1991 (the "GPL License"), a copy of which is 
available along with the File in the license.txt file or by writing to the Free 
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 or 
on the worldwide web at http://www.gnu.org/licenses/gpl.txt. 

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED 
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY 
DISCLAIMED.  The GPL License provides additional details about this warranty 
disclaimer.

*******************************************************************************/

#include <common.h>
#include <net.h>
#include <malloc.h>
#include "mvOs.h"
#include "mvSysHwConfig.h"
#include "mvEth.h"
#include "mvEthPhy.h"
#include "mvBoardEnvLib.h"

#undef MV_DEBUG

#ifdef MV_DEBUG
#define DB(x) x
#else
#define DB(x)
#endif

/****************************************************** 
 * driver internal definitions --                     *
 ******************************************************/ 
/* use only tx-queue0 and rx-queue0 */
#define EGIGA_DEF_TXQ 0
#define EGIGA_DEF_RXQ 0

/* rx buffer size */ 
#define ETH_HLEN       14
#define WRAP           (2 + ETH_HLEN + 4 + 32)  /* 2(HW hdr) 14(MAC hdr) 4(CRC) 32(extra for cache prefetch)*/
#define MTU            1500
#define RX_BUFFER_SIZE (MTU + WRAP)

/* rings length */
#define EGIGA_TXQ_LEN   20
#define EGIGA_RXQ_LEN   20


typedef struct _egigaPriv
{
	int port;
	MV_VOID *halPriv;
	MV_U32 rxqCount;
	MV_U32 txqCount;
	MV_BOOL devInit;
} egigaPriv; 



/****************************************************** 
 * functions prototype --                             *
 ******************************************************/
static int mvEgigaLoad( int port, char *name, char *enet_addr );

static int mvEgigaInit( struct eth_device *dev, bd_t *p );
static int mvEgigaHalt( struct eth_device *dev );
static int mvEgigaTx( struct eth_device *dev, volatile MV_VOID *packet, int len );
static int mvEgigaRx( struct eth_device *dev );

#if defined(MV_88F5182)
MV_VOID mvEgigaStrToMac( MV_8 *source , MV_8 *dest );
#else
static MV_VOID mvEgigaStrToMac( char *source , char *dest );
#endif
static unsigned int mvEgigaStrToHex( char ch );



/*********************************************************** 
 * mv_eth_initialize --                                    *
 *   main driver initialization. loading the interfaces.   *
 ***********************************************************/
int mv_eth_initialize( bd_t *bis ) 
{

	int port,i,j;
	MV_8 enet_addr[6*2+1];
	MV_8 name[NAMESIZE+1];
	MV_8 enetvar[9];
	MV_8 *tmp;

	mvEthInit();

	/* load interface(s) */
	for( port=0; port < mvCtrlEthMaxPortGet(); port++ ) {
		/* interface name */
		sprintf( name, "egiga%d", port );
		/* interface MAC addr extract */
		sprintf( enetvar, port ? "eth%daddr" : "ethaddr", port );
		tmp = getenv( enetvar );
		for( i = 0, j = 0;i < 6*2+1 ; j++ ){ 
			if( tmp[j] != ':' ) {
				enet_addr[i] = tmp[j];
				i++;
			}
		}		
			
		mvEgigaLoad( port, name, enet_addr );
	}

	return 0;
}


/*********************************************************** 
 * mvEgigaLoad --                                          *
 *   load a network interface into uboot network core.     *
 *   initialize sw structures e.g. private, rings, etc.    *
 ***********************************************************/
static int mvEgigaLoad( int port, char *name, char *enet_addr ) 
{
	struct eth_device *dev = NULL;
	egigaPriv *priv = NULL;
	ETH_PORT_CTRL dummy_port_handle;

	DB( printf( "%s: %s load - ", __FUNCTION__, name ) );

	

	dev = malloc( sizeof(struct eth_device) );
	priv = malloc( sizeof(egigaPriv) );

	if( !dev ) {
		DB( printf( "%s: %s falied to alloc eth_device (error)\n", __FUNCTION__, name ) );
		goto error;
	}

	if( !priv ) {
		DB( printf( "%s: %s falied to alloc egiga_priv (error)\n", __FUNCTION__, name ) );
		goto error;
	}

	memset( priv, 0, sizeof(egigaPriv) );

	/* init device methods */
	memcpy( dev->name, name, NAMESIZE );
	mvEgigaStrToMac( enet_addr, dev->enetaddr );

	/* set MAC addres even if port was not used yet. */
	dummy_port_handle.portNo = port;
	mvEthMacAddrSet( &dummy_port_handle, dev->enetaddr, EGIGA_DEF_RXQ);

	dev->init = (void *)mvEgigaInit;
	dev->halt = (void *)mvEgigaHalt;
	dev->send = (void *)mvEgigaTx;
	dev->recv = (void *)mvEgigaRx;
	dev->priv = priv;
	dev->iobase = 0;
	priv->port = port;

	/* register the interface */
	eth_register(dev);


	DB( printf( "%s: %s load ok\n", __FUNCTION__, name ) );
	return 0;

	error:
	printf( "%s: %s load failed\n", __FUNCTION__, name );
	if( priv ) free( dev->priv );
	if( dev ) free( dev );
	return -1;
}

unsigned int egiga_init=0;

static int mvEgigaInit( struct eth_device *dev, bd_t *p )
{
	egigaPriv *priv = dev->priv;
	MV_ETH_PORT_INIT halInitStruct;
       	MV_PKT_INFO pktInfo;
    	MV_BUF_INFO bufInfo;
	MV_STATUS status;
	int i;

	DB( printf( "%s: %s init - ", __FUNCTION__, dev->name ) );

	/* maen egiga not ready */
	DB( printf ("mvBoardPhyAddrGet()=0x%x , priv->port =0x%x\n",mvBoardPhyAddrGet(priv->port),priv->port));

	if ((DB_88F5181_DDR1_PRPMC != mvBoardIdGet())&&
		(DB_88F5181_DDR1_MNG != mvBoardIdGet())&&
		(RD_88F5181_VOIP != mvBoardIdGet()) &&
		(RD_88F5181L_VOIP_GE != mvBoardIdGet()) &&
		(RD_88F5181L_VOIP_FE != mvBoardIdGet())
		)
	{
		/* Check Link status on phy */
		if( mvEthPhyCheckLink( mvBoardPhyAddrGet(priv->port) ) == MV_FALSE ) {
			printf( "%s no link\n", dev->name );
			return 0;
		}
		else DB( printf( "link up\n" ) );
	}

	egiga_init = 1;

	/* init the hal -- create internal port control structure and descriptor rings, */
	/* open address decode windows, disable rx and tx operations. mask interrupts.  */
	halInitStruct.maxRxPktSize = RX_BUFFER_SIZE;
	halInitStruct.rxDefQ = EGIGA_DEF_RXQ;

	halInitStruct.txDescrNum[0] = EGIGA_TXQ_LEN;
	halInitStruct.rxDescrNum[0] = EGIGA_RXQ_LEN;

	priv->halPriv = mvEthPortInit( priv->port, &halInitStruct );

	if( !priv->halPriv ) {
		DB( printf( "falied to init eth port (error)\n" ) );
		goto error;
	}

    /* set new addr in hw */
    if( mvEthMacAddrSet( priv->halPriv, dev->enetaddr, EGIGA_DEF_RXQ) != MV_OK ) {
        printf("%s: ethSetMacAddr failed\n", dev->name );
	    goto error;
    }

	priv->devInit = MV_TRUE;

	/* fill rx ring with buffers */
	for( i=0; i<EGIGA_RXQ_LEN; i++ ) {

		MV_U8 *buf = (MV_U8 *)memalign( 32, RX_BUFFER_SIZE ); /* align on 32B */
		if( !buf ) {
			DB( printf( "failed to alloc buffer#%i\n", i ) );
			break;
		}

		if( ((MV_U32)buf) & 0xf ) 
            printf( "un-align rx buffer %x\n", (MV_U32)buf );

        bufInfo.bufVirtPtr = buf;
        bufInfo.bufSize = RX_BUFFER_SIZE;
        pktInfo.osInfo = (MV_ULONG)buf;
        pktInfo.pFrags = &bufInfo;
	    pktInfo.pktSize = RX_BUFFER_SIZE; /* how much to invalidate */

		/* give the buffer to hal */
		status = mvEthPortRxDone( priv->halPriv, EGIGA_DEF_RXQ, &pktInfo );
		if( status == MV_OK ) {
			priv->rxqCount++;
		}
		else if( status == MV_FULL ) {
			/* the ring is full */
			priv->rxqCount++;
			DB( printf( "ring full\n" ) );
			break;
		} 
		else {
			printf( "error\n" );
			goto error;
		}
	}

#ifdef MV_DEBUG
	ethPortQueues(priv->port, EGIGA_DEF_RXQ, EGIGA_DEF_TXQ, 1);

	printf("%s : after calling ethPortQueues\n",__FUNCTION__);

#endif


	/* start the hal - rx/tx activity */
	if( mvEthPortEnable( priv->halPriv ) != MV_OK ) {
		printf( "%s: %s mvEthPortEnalbe failed (error)\n", __FUNCTION__, dev->name );
		goto error;
	}

#ifdef MV_DEBUG
	ethRegs();
	ethPortRegs(0);
	ethPortStatus(0);

	ethPortQueues(priv->port, EGIGA_DEF_RXQ, -1/*EGIGA_DEF_TXQ*/, 0);
#endif

	/*while(1);*/
	
	DB( printf( "%s: %s complete ok\n", __FUNCTION__, dev->name ) );
	return 1;

	error:
	if( priv->devInit )
		mvEgigaHalt( dev );
	printf( "%s: %s failed\n", __FUNCTION__, dev->name );
	return 0;
}

static int mvEgigaHalt( struct eth_device *dev )
{
	egigaPriv *priv = dev->priv;
	MV_PKT_INFO pktInfo;


	/*return 0;*/
	DB( printf( "%s: %s halt - ", __FUNCTION__, dev->name ) );

	if( priv->devInit == MV_TRUE ) {

		/* stop the port activity, mask all interrupts */
		if( mvEthPortDisable( priv->halPriv ) != MV_OK ) 
			printf( "mvEthPortDisable failed (error)\n" );
    
		/* free the buffs in the rx ring */
		while( mvEthPortForceRx( priv->halPriv, EGIGA_DEF_RXQ, &pktInfo) == MV_OK ) {
			priv->rxqCount--;
			if( pktInfo.osInfo )
				free( (void *)pktInfo.osInfo );
			else 
				printf( "mvEthPortForceRx failed (error)\n" );
		}

		mvEthPortFinish( priv->halPriv );

		priv->devInit = MV_FALSE;

	}

	egiga_init = 0;

	DB( printf( "%s: %s complete\n", __FUNCTION__, dev->name ) );
	return 0;
}

static int mvEgigaTx( struct eth_device *dev, volatile void *buf, int len )
{
	egigaPriv *priv = dev->priv;
	MV_BUF_INFO bufInfo;
    MV_PKT_INFO pktInfo;
	MV_STATUS status;

	/* if no link exist */
	if(!egiga_init) return 0;

#ifdef MV_DEBUG
	{
		#if 0
		int i,j;
		for (i=0;i<150;i+=10)
		{
			for (j=0;j<10;j++)
			{
				tempPacket[i+j] = j;
				tempPacket[i+j] = 0xff;
				/*tempPacket[i+j] = 0x00;*/
			}
		}
		#endif

	}
#endif

    pktInfo.osInfo = (MV_ULONG)0x44CAFE44;
    pktInfo.pktSize = len;
    pktInfo.pFrags = &bufInfo;
    pktInfo.status = 0;
    pktInfo.numFrags = 1;
    bufInfo.bufVirtPtr = (MV_U8*)buf;
    bufInfo.bufSize = len;

#ifdef MV_DEBUG
if (0){ 
int x; char *p;
printf("%s: pktInfo: [size %d] [info %08x]\n", __FUNCTION__, pktInfo.byteCnt, pktInfo.userInfo1);
p = ((char *)pktInfo.pData) ; 
printf("---\n"); 
for(x=0; x<64; x++, p++) printf("%02x ", *p); 
printf("\n---\n"); 
}
#endif


	/* send the packet */
	status = mvEthPortTx( priv->halPriv, EGIGA_DEF_TXQ, &pktInfo );

	if( status != MV_OK ) {
		if( status == MV_NO_RESOURCE )
			DB( printf( "ring is full (error)\n" ) );
		else if( status == MV_ERROR )
			DB( printf( "error\n" ) );
		else
			DB( printf( "unrecognize status (error) ethPortSend\n" ) );
		goto error;
	} 
	else DB( printf( "ok\n" ) );

	priv->txqCount++;

	/* release the transmitted packet(s) */
	while( 1 ) {

		DB( printf( "%s: %s tx-done - ", __FUNCTION__, dev->name ) );

		/* get a packet */
		status = mvEthPortTxDone( priv->halPriv, EGIGA_DEF_TXQ, &pktInfo );

		if( status == MV_OK ) {

			priv->txqCount--;

			/* validate skb */
			if( pktInfo.osInfo != 0x44CAFE44 ) {
				DB( printf( "error\n" ) );
				goto error;
			}

			/* handle tx error */
			if( pktInfo.status & (ETH_ERROR_SUMMARY_BIT) ) {
				DB( printf( "bad status (error)\n" ) );
				goto error;
			}
			DB( printf( "ok\n" ) );
		}
		else if( status == MV_EMPTY ) {
			/* no more work */
			DB( printf( "no more work\n" ) );
			break;
		}
		else if( status == MV_NOT_FOUND ) {
			/* hw still in tx */
			DB( printf( "hw still in tx\n" ) );
			break;
		}
		else {
			DB( printf( "unrecognize status (error) ethTxReturnDesc\n" ) );
			goto error;
		}
	}

	DB( printf( "%s: %s complete ok\n", __FUNCTION__, dev->name ) );

	return 0;

	error:
	DB( printf( "%s: %s failed\n", __FUNCTION__, dev->name ) );
	return 1;
}


static int mvEgigaRx( struct eth_device *dev )
{
	egigaPriv*  priv = dev->priv;
    MV_PKT_INFO pktInfo;
    MV_BUF_INFO bufInfo;
	MV_STATUS   status;

	/* if no link exist */
	if(!egiga_init) return 0;

	while( 1 ) {

		/* get rx packet from hal */
		status = mvEthPortRx( priv->halPriv, EGIGA_DEF_RXQ, &pktInfo);

		if( status == MV_OK ) {
			/*DB( printf( "good rx\n" ) );*/
			priv->rxqCount--;

#ifdef MV_DEBUG
        if (0)
        { 
            int x; char *p;
            printf("%s: pktInfo: [size %d] [info %08x]\n", __FUNCTION__, pktInfo.byteCnt, pktInfo.userInfo1);
            p = ((char *)pktInfo.userInfo1) + 2; 
            printf("---\n"); 
            for(x=0; x<64; x++, p++) printf("%02x ", *p); 
            printf("\n---\n"); 
        }
        printf("%s: pktInfo: [size %d] [info %08x]\n", __FUNCTION__, pktInfo.byteCnt, pktInfo.userInfo1);
		if (1){/*dump a message */

			unsigned int i,j;
			unsigned char p;
			printf("---\n"); 
			for (i=0; i < pktInfo.byteCnt; i+=16)
			{
				for (j=0; j < 16 ;j++)
				{
					if ((i+j) == pktInfo.byteCnt) break;
					p = *(unsigned char*)((unsigned int)pktInfo.userInfo1+2+i+j);
					printf("%02x ",p);
				}

			}
			printf("\n---\n"); 			
			
		}
#endif
			/* check rx error status */
			if( pktInfo.status & (ETH_ERROR_SUMMARY_MASK) ) {
				MV_U32 err = pktInfo.status & ETH_RX_ERROR_CODE_MASK;
				/*DB( printf( "bad rx status %08x, ", (MV_U32)pktInfo.cmdSts ) );*/
				if( err == ETH_RX_RESOURCE_ERROR )
					DB( printf( "(resource error)" ) );
				else if( err == ETH_RX_MAX_FRAME_LEN_ERROR )
					DB( printf( "(max frame length error)" ) );
				else if( err == ETH_RX_OVERRUN_ERROR )
					DB( printf( "(overrun error)" ) );
				else if( err == ETH_RX_CRC_ERROR )
					DB( printf( "(crc error)" ) );
				else {
					DB( printf( "(unknown error)" ) );
					goto error;
				}
				DB( printf( "\n" ) );
			}
			else {

				DB( printf( "%s: %s calling NetRecieve ", __FUNCTION__, dev->name) );
				/* good rx - push the packet up (skip on two first empty bytes) */
				NetReceive( ((MV_U8 *)pktInfo.osInfo) + 2, (int)pktInfo.pktSize );
			}


			DB( printf( "%s: %s refill rx buffer - ", __FUNCTION__, dev->name) );

			/* give the buffer back to hal (re-init the buffer address) */
            bufInfo.bufVirtPtr = (MV_U8*)pktInfo.osInfo;
            bufInfo.bufSize = RX_BUFFER_SIZE;
            pktInfo.pFrags = &bufInfo;
	        pktInfo.pktSize = RX_BUFFER_SIZE; /* how much to invalidate */

			status = mvEthPortRxDone( priv->halPriv, EGIGA_DEF_RXQ, &pktInfo );
	
			if( status == MV_OK ) {
				priv->rxqCount++;
			}
			else if( status == MV_FULL ) {
				/* this buffer made the ring full */
				priv->rxqCount++;
				DB( printf( "ring full\n" ) );
				break;
			} 
			else {
				printf( "error\n" );
				goto error;
			}

		} else if( status == MV_NO_MORE ) {
			/* no more rx packets ready */
			/*DB( printf( "no more work\n" ) );*/
			break;
		} else if( status == MV_NO_RESOURCE ) {
			/* no buffers for rx */
			DB( printf( "no resource (error)\n" ) );
			goto error;
		} else {
			DB( printf( "unrecognize status (error) ethRxReturnBuff\n" ) );
			goto error;
		}
	}

	/*DB( printf( "%s: %s complete ok\n", __FUNCTION__, dev->name ) );*/
	return 0;

	error:
	DB( printf( "%s: %s failed\n", __FUNCTION__, dev->name ) );
	return 1;
}


/*********************************************************** 
 * string helpers for mac address setting                  *
 ***********************************************************/
#if defined(MV_88F5182)
MV_VOID mvEgigaStrToMac( MV_8 *source , MV_8 *dest ) 
#else
static MV_VOID mvEgigaStrToMac( MV_8 *source , MV_8 *dest ) 
#endif
{
	dest[0] = (mvEgigaStrToHex( source[0] ) << 4) + mvEgigaStrToHex( source[1] );
	dest[1] = (mvEgigaStrToHex( source[2] ) << 4) + mvEgigaStrToHex( source[3] );
	dest[2] = (mvEgigaStrToHex( source[4] ) << 4) + mvEgigaStrToHex( source[5] );
	dest[3] = (mvEgigaStrToHex( source[6] ) << 4) + mvEgigaStrToHex( source[7] );
	dest[4] = (mvEgigaStrToHex( source[8] ) << 4) + mvEgigaStrToHex( source[9] );
	dest[5] = (mvEgigaStrToHex( source[10] ) << 4) + mvEgigaStrToHex( source[11] );
}

static MV_U32 mvEgigaStrToHex( MV_8 ch ) 
{
	if( (ch >= '0') && (ch <= '9') ) return( ch - '0' );
	if( (ch >= 'a') && (ch <= 'f') ) return( ch - 'a' + 10 );
	if( (ch >= 'A') && (ch <= 'F') ) return( ch - 'A' + 10 );

	return 0;
}


