

#include "mvSysHwConfig.h"
#include "mvCpuIf.h"
#include <asm/mach/map.h>

/* for putstr */
/* #include <asm/arch/uncompress.h> */

MV_CPU_DEC_WIN* mv_sys_map(void);
u32 mv_pci_mem_size_get(int ifNum);
u32 mv_pci_io_base_get(int ifNum);
u32 mv_pci_io_size_get(int ifNum);
u32 mv_pci_mem_base_get(int ifNum);
#if defined(CONFIG_MV_INCLUDE_CESA)
u32 mv_crypo_base_get(void);
#endif
#if defined(MV_INCLUDE_DEVICE_CS1)
u32 mv_device_cs1_base_get(void);
#endif

#if defined(MV_88F5182)

/* 
 *  System memory mapping 
 */

/* SDRAM: actual mapping is auto detected */
#define SDRAM_CS0_BASE  0x00000000
#define SDRAM_CS0_SIZE  _256M

#define SDRAM_CS1_BASE  0x10000000
#define SDRAM_CS1_SIZE  _256M

#define SDRAM_CS2_BASE  0x20000000
#define SDRAM_CS2_SIZE  _256M

#define SDRAM_CS3_BASE  0x30000000
#define SDRAM_CS3_SIZE  _256M

/* PEX */
#define PEX0_MEM_BASE 0xe0000000
#define PEX0_MEM_SIZE _128M

#define PEX0_IO_BASE 0xf2000000
#define PEX0_IO_SIZE _1M

/* PCI0: IO and memory space */
#define PCI0_MEM_BASE  0xe8000000
#define PCI0_MEM_SIZE  _128M

#define PCI0_IO_BASE    0xf2100000
#define PCI0_IO_SIZE    _1M

/* Device Chip Selects */
#define DEVICE_CS0_BASE 0xfa000000
#define DEVICE_CS0_SIZE _2M

#define DEVICE_CS1_BASE 0xf4000000
#define DEVICE_CS1_SIZE _32M

// Ajith - CPLD at 0xfa000000
#ifdef MV_ORIG_LAYOUT
#define DEVICE_CS2_BASE 0xfa800000
#define DEVICE_CS2_SIZE _1M
#else
#define DEVICE_CS2_BASE 0xfa000000
#define DEVICE_CS2_SIZE _1M
#endif

#define CRYPT_ENG_BASE	0xF0000000
#define CRYPT_ENG_SIZE	_64K

// Ajith - Seenergy boards have 16M starting at 0xff000000
#ifdef MV_ORIG_LAYOUT
#define BOOTDEV_CS_BASE	0xff800000
#define BOOTDEV_CS_SIZE _8M
#else
#define BOOTDEV_CS_BASE	0xff000000
#define BOOTDEV_CS_SIZE _16M
#endif

#if defined (MV_INCLUDE_PCI) && defined (MV_INCLUDE_PEX)

#define PCI_IF0_MEM0_BASE 	PEX0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PEX0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PEX0_IO_BASE
#define PCI_IF0_IO_SIZE 	PEX0_IO_SIZE

#define PCI_IF1_MEM0_BASE 	PCI0_MEM_BASE
#define PCI_IF1_MEM0_SIZE 	PCI0_MEM_SIZE
#define PCI_IF1_IO_BASE 	PCI0_IO_BASE
#define PCI_IF1_IO_SIZE 	PCI0_IO_SIZE

#elif defined (MV_INCLUDE_PCI)

#define PCI_IF0_MEM0_BASE 	PCI0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PCI0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PCI0_IO_BASE
#define PCI_IF0_IO_SIZE 	PCI0_IO_SIZE

#elif defined (MV_INCLUDE_PEX)

#define PCI_IF0_MEM0_BASE 	PEX0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PEX0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PEX0_IO_BASE
#define PCI_IF0_IO_SIZE 	PEX0_IO_SIZE

#endif


struct map_desc  MEM_TABLE[] =	{	
  { PCI_IF0_MEM0_BASE,  	__phys_to_pfn(PCI_IF0_MEM0_BASE),   	PCI_IF0_MEM0_SIZE,  	MT_DEVICE},
  { PCI_IF1_MEM0_BASE,  	__phys_to_pfn(PCI_IF1_MEM0_BASE),   	PCI_IF1_MEM0_SIZE, 	MT_DEVICE},
  { INTER_REGS_BASE, 		__phys_to_pfn(INTER_REGS_BASE), 	SZ_1M,  	     	MT_DEVICE},
  { PCI_IF0_IO_BASE,   		__phys_to_pfn(PCI_IF0_IO_BASE),   	PCI_IF0_IO_SIZE,  	MT_DEVICE},
  { PCI_IF1_IO_BASE,   		__phys_to_pfn(PCI_IF1_IO_BASE),   	PCI_IF1_IO_SIZE, 	MT_DEVICE},
  /* For Orion NAS, this one also cover the Internal SRAM */
  { PEX_CONFIG_RW_WA_BASE, 	__phys_to_pfn(PEX_CONFIG_RW_WA_BASE), 	PEX_CONFIG_RW_WA_SIZE , MT_DEVICE},
  { DEVICE_CS2_BASE, 		__phys_to_pfn(DEVICE_CS2_BASE), 	DEVICE_CS2_SIZE, 	MT_DEVICE},
  { DEVICE_CS0_BASE, 		__phys_to_pfn(DEVICE_CS0_BASE), 	DEVICE_CS0_SIZE, 	MT_DEVICE},
};

/* The same table used for both RD NAS2 and RD NAS3 */
MV_CPU_DEC_WIN SYSMAP_RD_88F5182[] = {
	/* base low      base high     size            WinNum     enable */
	{{SDRAM_CS0_BASE ,    0,      SDRAM_CS0_SIZE} ,0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0,      SDRAM_CS1_SIZE} ,0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0,      SDRAM_CS2_SIZE} ,0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0,      SDRAM_CS3_SIZE} ,0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0,      PEX0_MEM_SIZE } ,0x0       ,EN}, 
	{{PEX0_IO_BASE   ,    0,      PEX0_IO_SIZE  } ,0x2       ,EN}, 
	{{PCI0_MEM_BASE  ,    0,      PCI0_MEM_SIZE } ,0x1     	 ,EN}, 
	{{PCI0_IO_BASE   ,    0,      PCI0_IO_SIZE  } ,0x3       ,EN}, 
	{{INTER_REGS_BASE,    0,      INTER_REGS_SIZE},0x8       ,EN}, 
	{{DEVICE_CS0_BASE,    0,      DEVICE_CS0_SIZE},0x5       ,DIS},
// Ajith - Seenergy boards have no device at CS1
#ifdef MV_ORIG_LAYOUT
	{{DEVICE_CS1_BASE,    0,      DEVICE_CS1_SIZE},0x6       ,EN},
	{{DEVICE_CS2_BASE,    0,      DEVICE_CS2_SIZE},0x7       ,DIS}, 
#else
	{{DEVICE_CS1_BASE,    0,      DEVICE_CS1_SIZE},0x6       ,DIS},
	{{DEVICE_CS2_BASE,    0,      DEVICE_CS2_SIZE},0x6       ,EN}, 
#endif
	{{BOOTDEV_CS_BASE,    0,      BOOTDEV_CS_SIZE},0x4       ,EN}, 
	{{CRYPT_ENG_BASE,     0,      CRYPT_ENG_SIZE} ,0x7  	 ,EN},
    	/* Table terminator */						
    	{{TBL_TERM, TBL_TERM, TBL_TERM}, TBL_TERM,TBL_TERM}
};

MV_CPU_DEC_WIN SYSMAP_DB_88F5182_DDR2_BP[] = {
	/* base low      base high     size            WinNum     enable */
	{{SDRAM_CS0_BASE ,    0,      SDRAM_CS0_SIZE} ,0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0,      SDRAM_CS1_SIZE} ,0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0,      SDRAM_CS2_SIZE} ,0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0,      SDRAM_CS3_SIZE} ,0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0,      PEX0_MEM_SIZE } ,0x0       ,EN}, 
	{{PEX0_IO_BASE   ,    0,      PEX0_IO_SIZE  } ,0x2       ,EN}, 
	{{PCI0_MEM_BASE  ,    0,      PCI0_MEM_SIZE } ,0x1     	 ,EN}, 
	{{PCI0_IO_BASE   ,    0,      PCI0_IO_SIZE  } ,0x3       ,EN}, 
	{{INTER_REGS_BASE,    0,      INTER_REGS_SIZE},0x8       ,EN}, 
	{{DEVICE_CS0_BASE,    0,      DEVICE_CS0_SIZE},0x5	 ,EN},
	{{DEVICE_CS1_BASE,    0,      DEVICE_CS1_SIZE},0x6	 ,EN},
	{{DEVICE_CS2_BASE,    0,      DEVICE_CS2_SIZE},0x7       ,DIS}, 
	{{BOOTDEV_CS_BASE,    0,      BOOTDEV_CS_SIZE},0x4       ,EN}, 
	{{CRYPT_ENG_BASE,     0,      CRYPT_ENG_SIZE} ,0x7  	 ,EN},
    	/* Table terminator */						
    	{{TBL_TERM, TBL_TERM, TBL_TERM}, TBL_TERM,TBL_TERM}
};

#elif defined(CONFIG_MV88F6082)

/* 
 *  System memory mapping 
 */

/* SDRAM: actual mapping is auto detected */
#define SDRAM_CS0_BASE  0x00000000
#define SDRAM_CS0_SIZE  _16M

#define SDRAM_CS1_BASE  0x01000000
#define SDRAM_CS1_SIZE  _16M

#define SDRAM_CS2_BASE  0x20000000
#define SDRAM_CS2_SIZE  _256M

#define SDRAM_CS3_BASE  0x30000000
#define SDRAM_CS3_SIZE  _256M

/* PEX */
#define PEX0_MEM_BASE 0xe0000000
#define PEX0_MEM_SIZE _128M

#define PEX0_IO_BASE 0xf2000000
#define PEX0_IO_SIZE _1M

/* Device: CS0 - N_FLASH, CS1 - M_FLASH, CS2 - S_FLASH, CS3 - BOOTROM, CS4 - DEV_BOOCS */
#define DEVICE_CS0_BASE 0xf9000000
#define DEVICE_CS0_SIZE _2M

#define DEVICE_CS1_BASE 0xf8000000
#define DEVICE_CS1_SIZE _256K

#define DEVICE_CS2_BASE 0xfa000000
#define DEVICE_CS2_SIZE _8M

#define DEVICE_CS3_BASE 0xfb000000
#define DEVICE_CS3_SIZE _1M

#define DEVICE_CS4_BASE 0xfc000000
#define DEVICE_CS4_SIZE _1M


#define CRYPT_ENG_BASE	0xF0000000
#define CRYPT_ENG_SIZE	_64K

/* Tailgate has no PCI interface - only PEX */
#if defined (MV_INCLUDE_PEX)

#define PCI_IF0_MEM0_BASE 	PEX0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PEX0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PEX0_IO_BASE
#define PCI_IF0_IO_SIZE 	PEX0_IO_SIZE

#endif

struct map_desc MEM_TABLE[] = 	{	
 { PCI_IF0_MEM0_BASE,   PCI_IF0_MEM0_BASE,   PCI_IF0_MEM0_SIZE,  MT_DEVICE },	
 { CRYPT_ENG_BASE, CRYPT_ENG_BASE, CRYPT_ENG_SIZE, MT_DEVICE},					
 { INTER_REGS_BASE, INTER_REGS_BASE, SZ_1M,  	     MT_DEVICE },				
 { PCI_IF0_IO_BASE,   PCI_IF0_IO_BASE,   PCI_IF0_IO_SIZE,  MT_DEVICE },			
 { DEVICE_CS1_BASE, DEVICE_CS1_BASE, DEVICE_CS1_SIZE, MT_DEVICE},			
 { DEVICE_CS0_BASE, DEVICE_CS0_BASE, DEVICE_CS0_SIZE, MT_DEVICE},				
 { DEVICE_CS2_BASE, DEVICE_CS2_BASE, DEVICE_CS2_SIZE, MT_DEVICE},				
 { DEVICE_CS3_BASE, DEVICE_CS2_BASE, DEVICE_CS2_SIZE, MT_DEVICE},				
 { DEVICE_CS4_BASE, DEVICE_CS2_BASE, DEVICE_CS2_SIZE, MT_DEVICE}				
};

MV_CPU_DEC_WIN SYSMAP_DB_88F6082_BP[] = {
   	/* base low        base high    size       			WinNum     enable */
	{{SDRAM_CS0_BASE ,    0, SDRAM_CS0_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0, SDRAM_CS1_SIZE } ,			0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0, PEX0_MEM_SIZE  } ,			0x1       ,EN},
	{{PEX0_IO_BASE   ,    0, PEX0_IO_SIZE   } ,			0x0       ,EN},
	{{INTER_REGS_BASE,    0, INTER_REGS_SIZE} ,			0x2       ,EN},
	{{DEVICE_CS0_BASE,    0, DEVICE_CS0_SIZE} ,			0x3	  ,EN},
	{{DEVICE_CS1_BASE,    0, DEVICE_CS1_SIZE} ,			0x4	  ,EN},
	{{DEVICE_CS2_BASE,    0, DEVICE_CS2_SIZE} ,			0x5	  ,EN},
	{{DEVICE_CS3_BASE,    0, DEVICE_CS3_SIZE} ,			0x6	  ,DIS},
	{{DEVICE_CS4_BASE,    0, DEVICE_CS4_SIZE} ,	                0x6       ,EN},
	{{CRYPT_ENG_BASE,     0, CRYPT_ENG_SIZE} ,			0x7  	  ,EN},
   	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

#elif defined(CONFIG_MV88F5181L)

/* 
 *  System memory mapping 
 */

/* SDRAM: actual mapping is auto detected */
#define SDRAM_CS0_BASE  0x00000000
#define SDRAM_CS0_SIZE  _256M

#define SDRAM_CS1_BASE  0x10000000
#define SDRAM_CS1_SIZE  _256M

#define SDRAM_CS2_BASE  0x20000000
#define SDRAM_CS2_SIZE  _256M

#define SDRAM_CS3_BASE  0x30000000
#define SDRAM_CS3_SIZE  _256M

/* PEX */
#define PEX0_MEM_BASE 0xe0000000
#define PEX0_MEM_SIZE _128M

#define PEX0_IO_BASE 0xf2000000
#define PEX0_IO_SIZE _1M

/* PCI0: IO and memory space */
#define PCI0_MEM_BASE  0xe8000000
#define PCI0_MEM_SIZE  _128M

#define PCI0_IO_BASE    0xf2100000
#define PCI0_IO_SIZE    _1M


/* Device: CS0 - SRAM, CS1 - RTC, CS2 - UART, CS3 - large flash */
#define DEVICE_CS0_BASE 0xfa000000
#define DEVICE_CS0_SIZE _2M

#define DEVICE_CS1_BASE 0xfb000000
#define DEVICE_CS1_SIZE_NOR   _16M
#define DEVICE_CS1_SIZE_NAND  _1M
#define DEVICE_CS1_SIZE DEVICE_CS1_SIZE_NOR

#define DEVICE_CS2_BASE 0xfa800000
#define DEVICE_CS2_SIZE _1M

#define BOOTDEV_CS_BASE	0xF4000000
/* BOOTDEV_CS_SIZE per board */
#define BOOTDEV_CS_SIZE_DB_88F5181L	_8M
#define BOOTDEV_CS_SIZE_RD2_5181L_FE_GE _16M
#define BOOTDEV_CS_SIZE_RD2_5181L_FXO	_8M

#define CRYPT_ENG_BASE	0xF0000000
#define CRYPT_ENG_SIZE	_64K

#if defined (MV_INCLUDE_PCI) && defined (MV_INCLUDE_PEX)

#define PCI_IF0_MEM0_BASE 	PEX0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PEX0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PEX0_IO_BASE
#define PCI_IF0_IO_SIZE 	PEX0_IO_SIZE

#define PCI_IF1_MEM0_BASE 	PCI0_MEM_BASE
#define PCI_IF1_MEM0_SIZE 	PCI0_MEM_SIZE
#define PCI_IF1_IO_BASE 	PCI0_IO_BASE
#define PCI_IF1_IO_SIZE 	PCI0_IO_SIZE

#elif defined (MV_INCLUDE_PCI)

#define PCI_IF0_MEM0_BASE 	PCI0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PCI0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PCI0_IO_BASE
#define PCI_IF0_IO_SIZE 	PCI0_IO_SIZE

#elif defined (MV_INCLUDE_PEX)

#define PCI_IF0_MEM0_BASE 	PEX0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PEX0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PEX0_IO_BASE
#define PCI_IF0_IO_SIZE 	PEX0_IO_SIZE

#endif

struct map_desc MEM_TABLE[] = 	{	
  { PCI_IF0_MEM0_BASE,   PCI_IF0_MEM0_BASE,   PCI_IF0_MEM0_SIZE,  MT_DEVICE },
  { PCI_IF1_MEM0_BASE,   PCI_IF1_MEM0_BASE,   PCI_IF1_MEM0_SIZE,  MT_DEVICE },
  { INTER_REGS_BASE, INTER_REGS_BASE, SZ_1M,  	     MT_DEVICE },
  { PCI_IF0_IO_BASE,   PCI_IF0_IO_BASE,   PCI_IF0_IO_SIZE,  MT_DEVICE },
  { PCI_IF1_IO_BASE,   PCI_IF1_IO_BASE,   PCI_IF1_IO_SIZE,  MT_DEVICE },	
  { DEVICE_CS1_BASE, DEVICE_CS1_BASE, DEVICE_CS1_SIZE, MT_DEVICE},				
  { DEVICE_CS0_BASE, DEVICE_CS0_BASE, DEVICE_CS0_SIZE, MT_DEVICE},
  { DEVICE_CS2_BASE, DEVICE_CS2_BASE, DEVICE_CS2_SIZE, MT_DEVICE},
  { CRYPT_ENG_BASE, CRYPT_ENG_BASE, CRYPT_ENG_SIZE, MT_DEVICE}	
};


MV_CPU_DEC_WIN SYSMAP_DB_88F5181L_DDR2_2XTDM[] = {
        /* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0, SDRAM_CS0_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0, SDRAM_CS1_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0, SDRAM_CS2_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0, SDRAM_CS3_SIZE } ,			0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0, PEX0_MEM_SIZE  } ,			0x2       ,EN},
	{{PEX0_IO_BASE   ,    0, PEX0_IO_SIZE   } ,			0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0, PCI0_MEM_SIZE  } ,			0x3       ,EN},
	{{PCI0_IO_BASE   ,    0, PCI0_IO_SIZE   } ,			0x1       ,EN},
	{{INTER_REGS_BASE,    0, INTER_REGS_SIZE} ,			0x8       ,EN},
	{{DEVICE_CS0_BASE,    0, DEVICE_CS0_SIZE} ,			0x5	  ,EN},
#ifdef CONFIG_MV_INCLUDE_NAND
	{{DEVICE_CS1_BASE,    0, DEVICE_CS1_SIZE_NAND} ,		0x6       ,EN},
#else
	{{DEVICE_CS1_BASE,    0, DEVICE_CS1_SIZE_NOR} ,			0x6       ,EN},
#endif
	{{DEVICE_CS2_BASE,    0, DEVICE_CS2_SIZE} ,			0x7  	  ,DIS},
 	{{BOOTDEV_CS_BASE,    0, BOOTDEV_CS_SIZE_DB_88F5181L} ,		0x4       ,EN},
#if defined(CONFIG_MV_INCLUDE_CESA) || defined (USB_UNDERRUN_WA)
	{{CRYPT_ENG_BASE,     0, CRYPT_ENG_SIZE} ,			0x7  	  ,EN},
#else
	{{CRYPT_ENG_BASE,     0, CRYPT_ENG_SIZE} ,			0x7  	  ,DIS},

#endif
   	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};


MV_CPU_DEC_WIN SYSMAP_RD2_5181L_FE_GE[] = {
   	/* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0, SDRAM_CS0_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0, SDRAM_CS1_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0, SDRAM_CS2_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0, SDRAM_CS3_SIZE } ,			0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0, PEX0_MEM_SIZE  } ,			0x2       ,EN},
	{{PEX0_IO_BASE   ,    0, PEX0_IO_SIZE   } ,			0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0, PCI0_MEM_SIZE  } ,			0x3       ,EN},
	{{PCI0_IO_BASE   ,    0, PCI0_IO_SIZE   } ,			0x1       ,EN},
	{{INTER_REGS_BASE,    0, INTER_REGS_SIZE} ,			0x8       ,EN},
	{{DEVICE_CS0_BASE,    0, DEVICE_CS0_SIZE} ,			0x5	  ,DIS},
	{{DEVICE_CS1_BASE,    0, DEVICE_CS1_SIZE} ,			0x6	  ,DIS},
	{{DEVICE_CS2_BASE,    0, DEVICE_CS2_SIZE} ,			0x7	  ,DIS},
	{{BOOTDEV_CS_BASE,    0, BOOTDEV_CS_SIZE_RD2_5181L_FE_GE} ,	0x4       ,EN},
	{{CRYPT_ENG_BASE,     0, CRYPT_ENG_SIZE} ,			0x7  	  ,EN},
   	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

MV_CPU_DEC_WIN SYSMAP_RD2_5181L_FXO[] = {
   	/* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0, SDRAM_CS0_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0, SDRAM_CS1_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0, SDRAM_CS2_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0, SDRAM_CS3_SIZE } ,			0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0, PEX0_MEM_SIZE  } ,			0x2       ,EN},
	{{PEX0_IO_BASE   ,    0, PEX0_IO_SIZE   } ,			0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0, PCI0_MEM_SIZE  } ,			0x3       ,EN},
	{{PCI0_IO_BASE   ,    0, PCI0_IO_SIZE   } ,			0x1       ,EN},
	{{INTER_REGS_BASE,    0, INTER_REGS_SIZE} ,			0x8       ,EN},
	{{DEVICE_CS0_BASE,    0, DEVICE_CS0_SIZE} ,			0x5	  ,DIS},
	{{DEVICE_CS1_BASE,    0, DEVICE_CS1_SIZE} ,			0x6	  ,DIS},
	{{DEVICE_CS2_BASE,    0, DEVICE_CS2_SIZE} ,			0x7	  ,DIS},
	{{BOOTDEV_CS_BASE,    0, BOOTDEV_CS_SIZE_RD2_5181L_FXO} ,	0x4       ,EN},
	{{CRYPT_ENG_BASE,     0, CRYPT_ENG_SIZE} ,			0x7  	  ,EN},
   	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

#elif defined(CONFIG_MV88W8660)

/* 
 *  System memory mapping 
 */

/* SDRAM: actual mapping is auto detected */
#define SDRAM_CS0_BASE  0x00000000
#define SDRAM_CS0_SIZE  _256M

#define SDRAM_CS1_BASE  0x10000000
#define SDRAM_CS1_SIZE  _256M

#define SDRAM_CS2_BASE  0x20000000
#define SDRAM_CS2_SIZE  _256M

#define SDRAM_CS3_BASE  0x30000000
#define SDRAM_CS3_SIZE  _256M

/* PEX */
#define PEX0_MEM_BASE 0xe0000000
#define PEX0_MEM_SIZE _128M

#define PEX0_IO_BASE 0xf2000000
#define PEX0_IO_SIZE _1M


/* PCI0: IO and memory space */
#define PCI0_MEM_BASE  0xe8000000
#define PCI0_MEM_SIZE  _128M

#define PCI0_IO_BASE    0xf2100000
#define PCI0_IO_SIZE    _1M

/* Device: CS0 - SRAM, CS1 - RTC, CS2 - UART, CS3 - large flash */
#define DEVICE_CS0_BASE 0xfa000000
#define DEVICE_CS0_SIZE _2M

#define DEVICE_CS1_BASE 0xfb000000
#define DEVICE_CS1_SIZE _16M

#define DEVICE_CS2_BASE 0xfa800000
#define DEVICE_CS2_SIZE _1M

#define BOOTDEV_CS_BASE	0xF4000000
/* BOOTDEV_CS_SIZE per board */
#define BOOTDEV_CS_SIZE_RD_88W8860_DDR1		_16M
#define BOOTDEV_CS_SIZE_RD_88W8860_AP82S 	_8M
#define BOOTDEV_CS_SIZE_DB_88W8860       	_512K



#if defined (MV_INCLUDE_PCI) && defined (MV_INCLUDE_PEX)

#define PCI_IF0_MEM0_BASE 	PEX0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PEX0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PEX0_IO_BASE
#define PCI_IF0_IO_SIZE 	PEX0_IO_SIZE

#define PCI_IF1_MEM0_BASE 	PCI0_MEM_BASE
#define PCI_IF1_MEM0_SIZE 	PCI0_MEM_SIZE
#define PCI_IF1_IO_BASE 	PCI0_IO_BASE
#define PCI_IF1_IO_SIZE 	PCI0_IO_SIZE

#elif defined (MV_INCLUDE_PCI)

#define PCI_IF0_MEM0_BASE 	PCI0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PCI0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PCI0_IO_BASE
#define PCI_IF0_IO_SIZE 	PCI0_IO_SIZE

#elif defined (MV_INCLUDE_PEX)

#define PCI_IF0_MEM0_BASE 	PEX0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PEX0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PEX0_IO_BASE
#define PCI_IF0_IO_SIZE 	PEX0_IO_SIZE

#endif

struct map_desc MEM_TABLE[] = 	{	
  { PCI_IF0_MEM0_BASE,   __phys_to_pfn(PCI_IF0_MEM0_BASE),   PCI_IF0_MEM0_SIZE,  MT_DEVICE },
  { PCI_IF1_MEM0_BASE,   __phys_to_pfn(PCI_IF1_MEM0_BASE),   PCI_IF1_MEM0_SIZE,  MT_DEVICE },
  { INTER_REGS_BASE, __phys_to_pfn(INTER_REGS_BASE), SZ_1M,  	     MT_DEVICE },
  { PCI_IF0_IO_BASE,   __phys_to_pfn(PCI_IF0_IO_BASE),   PCI_IF0_IO_SIZE,  MT_DEVICE },
  { PCI_IF1_IO_BASE,   __phys_to_pfn(PCI_IF1_IO_BASE),   PCI_IF1_IO_SIZE,  MT_DEVICE },	
  { DEVICE_CS1_BASE, __phys_to_pfn(DEVICE_CS1_BASE), DEVICE_CS1_SIZE, MT_DEVICE},				
  { DEVICE_CS0_BASE, __phys_to_pfn(DEVICE_CS0_BASE), DEVICE_CS0_SIZE, MT_DEVICE},
  { DEVICE_CS2_BASE, __phys_to_pfn(DEVICE_CS2_BASE), DEVICE_CS2_SIZE, MT_DEVICE}
};


MV_CPU_DEC_WIN SYSMAP_RD_88W8860_DDR1[] = {
   	/* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0, SDRAM_CS0_SIZE } ,			0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0, SDRAM_CS1_SIZE } ,			0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0, PEX0_MEM_SIZE  } ,			0x2       ,EN},
	{{PEX0_IO_BASE   ,    0, PEX0_IO_SIZE   } ,			0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0, PCI0_MEM_SIZE  } ,			0x3       ,EN},
	{{PCI0_IO_BASE   ,    0, PCI0_IO_SIZE   } ,			0x1       ,EN},
	{{INTER_REGS_BASE,    0, INTER_REGS_SIZE} ,			0x8       ,EN},
	{{DEVICE_CS0_BASE,    0, DEVICE_CS0_SIZE} ,			0x5	  ,DIS},
	{{DEVICE_CS1_BASE,    0, DEVICE_CS1_SIZE} ,			0x6	  ,DIS},
	{{DEVICE_CS2_BASE,    0, DEVICE_CS2_SIZE} ,			0x7	  ,DIS},
	{{BOOTDEV_CS_BASE,    0, BOOTDEV_CS_SIZE_RD_88W8860_DDR1} ,	0x4       ,EN},
	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

MV_CPU_DEC_WIN SYSMAP_RD_88W8660_AP82S_DDR1[] = {
  	 /* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0, SDRAM_CS0_SIZE },			0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0, SDRAM_CS1_SIZE },			0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0, PEX0_MEM_SIZE  },			0x2       ,EN},
	{{PEX0_IO_BASE   ,    0, PEX0_IO_SIZE   },			0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0, PCI0_MEM_SIZE  },			0x3       ,EN},
	{{PCI0_IO_BASE   ,    0, PCI0_IO_SIZE   },			0x1       ,EN},
	{{INTER_REGS_BASE,    0, INTER_REGS_SIZE},			0x8       ,EN},
	{{DEVICE_CS0_BASE,    0, DEVICE_CS0_SIZE},			0x5	  ,DIS},
	{{DEVICE_CS1_BASE,    0, DEVICE_CS1_SIZE},			0x6	  ,DIS},
	{{DEVICE_CS2_BASE,    0, DEVICE_CS2_SIZE},			0x7	  ,DIS},
	{{BOOTDEV_CS_BASE,    0, BOOTDEV_CS_SIZE_RD_88W8860_AP82S},	0x4       ,EN},
	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

MV_CPU_DEC_WIN SYSMAP_DB_88W8660_DDR2[] = {
   	/* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0, SDRAM_CS0_SIZE },			0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0, SDRAM_CS1_SIZE },			0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0, PEX0_MEM_SIZE  },			0x2       ,EN},
	{{PEX0_IO_BASE   ,    0, PEX0_IO_SIZE   },			0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0, PCI0_MEM_SIZE  },			0x3       ,EN},
	{{PCI0_IO_BASE   ,    0, PCI0_IO_SIZE   },			0x1       ,EN},
	{{INTER_REGS_BASE,    0, INTER_REGS_SIZE},			0x8       ,EN},
	{{DEVICE_CS0_BASE,    0, DEVICE_CS0_SIZE},			0x5	  ,EN},
	{{DEVICE_CS1_BASE,    0, DEVICE_CS1_SIZE},			0x6	  ,EN},
	{{DEVICE_CS2_BASE,    0, DEVICE_CS2_SIZE},			0x7	  ,DIS},
	{{BOOTDEV_CS_BASE,    0, BOOTDEV_CS_SIZE_DB_88W8860},		0x4       ,EN},
	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

#elif defined(CONFIG_MV88F5181)

/* 
 *  System memory mapping 
 */

/* SDRAM: actual mapping is auto detected */
#define SDRAM_CS0_BASE  0x00000000
#define SDRAM_CS0_SIZE  _256M

#define SDRAM_CS1_BASE  0x10000000
#define SDRAM_CS1_SIZE  _256M

#define SDRAM_CS2_BASE  0x20000000
#define SDRAM_CS2_SIZE  _256M

#define SDRAM_CS3_BASE  0x30000000
#define SDRAM_CS3_SIZE  _256M

/* PEX */
#define PEX0_MEM_BASE 0xe0000000
#define PEX0_MEM_SIZE _128M

#define PEX0_IO_BASE 0xf2000000
#define PEX0_IO_SIZE _1M

/* PCI0: IO and memory space */
#define PCI0_MEM_BASE  0xe8000000
#define PCI0_MEM_SIZE  _128M

#define PCI0_IO_BASE    0xf2100000
#define PCI0_IO_SIZE    _1M

/* Chip select base addresses and sizes */
#define DEVICE_CS0_BASE 0xfa000000
#define DEVICE_CS0_SIZE _2M

#define DEVICE_CS1_BASE 0xfc000000
#define DEVICE_CS1_SIZE _32M

#define DEVICE_CS2_BASE 0xfa800000
#define DEVICE_CS2_SIZE _1M

#define BOOTDEV_CS_BASE	0xF4000000
#define BOOTDEV_CS_SIZE _16M

#if defined (MV_INCLUDE_PCI) && defined (MV_INCLUDE_PEX)

#define PCI_IF0_MEM0_BASE 	PEX0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PEX0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PEX0_IO_BASE
#define PCI_IF0_IO_SIZE 	PEX0_IO_SIZE

#define PCI_IF1_MEM0_BASE 	PCI0_MEM_BASE
#define PCI_IF1_MEM0_SIZE 	PCI0_MEM_SIZE
#define PCI_IF1_IO_BASE 	PCI0_IO_BASE
#define PCI_IF1_IO_SIZE 	PCI0_IO_SIZE

#elif defined (MV_INCLUDE_PCI)

#define PCI_IF0_MEM0_BASE 	PCI0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PCI0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PCI0_IO_BASE
#define PCI_IF0_IO_SIZE 	PCI0_IO_SIZE

#elif defined (MV_INCLUDE_PEX)

#define PCI_IF0_MEM0_BASE 	PEX0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PEX0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PEX0_IO_BASE
#define PCI_IF0_IO_SIZE 	PEX0_IO_SIZE

#endif

static struct map_desc MEM_TABLE[] = {
	{
		.virtual	= PCI_IF0_MEM0_BASE,
		.pfn		= __phys_to_pfn(PCI_IF0_MEM0_BASE),
		.length		= PCI_IF0_MEM0_SIZE,
		.type		= MT_DEVICE
	}, {
		.virtual	= PCI_IF1_MEM0_BASE,
		.pfn		= __phys_to_pfn(PCI_IF1_MEM0_BASE),
		.length		= PCI_IF1_MEM0_SIZE,
		.type		= MT_DEVICE
	}, {
		.virtual	= INTER_REGS_BASE,
		.pfn		= __phys_to_pfn(INTER_REGS_BASE),
		.length		= SZ_1M,
		.type		= MT_DEVICE
	}, {
		.virtual 	= PCI_IF0_IO_BASE,
		.pfn		= __phys_to_pfn(PCI_IF0_IO_BASE),
		.length		= PCI_IF0_IO_SIZE,
		.type		= MT_DEVICE
	}, {
		.virtual	= PCI_IF1_IO_BASE,
		.pfn		= __phys_to_pfn(PCI_IF1_IO_BASE),
		.length		= PCI_IF1_IO_SIZE,
		.type		= MT_DEVICE
	}, {
		.virtual	= DEVICE_CS0_BASE,
		.pfn		= __phys_to_pfn(DEVICE_CS0_BASE),
		.length		= DEVICE_CS0_SIZE,
		.type		= MT_DEVICE
	}, {
		.virtual	= DEVICE_CS2_BASE,
		.pfn		= __phys_to_pfn(DEVICE_CS2_BASE),
		.length		= DEVICE_CS2_SIZE,
		.type		= MT_DEVICE}
};


MV_CPU_DEC_WIN SYSMAP_RD_88F5181_GTW_FE_GE[] = {
  	 /* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0,      SDRAM_CS0_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0,      SDRAM_CS1_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0,      SDRAM_CS2_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0,      SDRAM_CS3_SIZE } ,0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0,      PEX0_MEM_SIZE  } ,0x2       ,EN},
	{{PEX0_IO_BASE   ,    0,      PEX0_IO_SIZE   } ,0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0,      PCI0_MEM_SIZE  } ,0x3       ,EN},
	{{PCI0_IO_BASE   ,    0,      PCI0_IO_SIZE   } ,0x1       ,EN},
	{{INTER_REGS_BASE,    0,      INTER_REGS_SIZE} ,0x8       ,EN},
	{{DEVICE_CS0_BASE,    0,      DEVICE_CS0_SIZE} ,0x5	  ,DIS},
	{{DEVICE_CS1_BASE,    0,      DEVICE_CS1_SIZE} ,0x6	  ,DIS},
	{{DEVICE_CS2_BASE,    0,      DEVICE_CS2_SIZE} ,0x7	  ,DIS},
	{{BOOTDEV_CS_BASE,    0,      BOOTDEV_CS_SIZE} ,0x4       ,EN},
	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

MV_CPU_DEC_WIN SYSMAP_RD_88F5181_88SX7042_2xSATA[] = {
  	 /* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0,      SDRAM_CS0_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0,      SDRAM_CS1_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0,      SDRAM_CS2_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0,      SDRAM_CS3_SIZE } ,0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0,      PEX0_MEM_SIZE  } ,0x2       ,EN},
	{{PEX0_IO_BASE   ,    0,      PEX0_IO_SIZE   } ,0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0,      PCI0_MEM_SIZE  } ,0x3       ,EN},
	{{PCI0_IO_BASE   ,    0,      PCI0_IO_SIZE   } ,0x1       ,EN},
	{{INTER_REGS_BASE,    0,      INTER_REGS_SIZE} ,0x8       ,EN},
	{{DEVICE_CS0_BASE,    0,      DEVICE_CS0_SIZE} ,0x5	  ,DIS}, 
	{{DEVICE_CS1_BASE,    0,      DEVICE_CS1_SIZE} ,0x6	  ,EN},	/* Big NOR Flash */
	{{DEVICE_CS2_BASE,    0,      DEVICE_CS2_SIZE} ,0x7	  ,DIS},
	{{BOOTDEV_CS_BASE,    0,      BOOTDEV_CS_SIZE} ,0x4       ,EN},	/* Boot Flash */
	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

MV_CPU_DEC_WIN SYSMAP_DB_88F5181_5281_DDR1_BP[] = {
  	 /* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0,      SDRAM_CS0_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0,      SDRAM_CS1_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0,      SDRAM_CS2_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0,      SDRAM_CS3_SIZE } ,0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0,      PEX0_MEM_SIZE  } ,0x2       ,EN},
	{{PEX0_IO_BASE   ,    0,      PEX0_IO_SIZE   } ,0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0,      PCI0_MEM_SIZE  } ,0x3       ,EN},
	{{PCI0_IO_BASE   ,    0,      PCI0_IO_SIZE   } ,0x1       ,EN},
	{{INTER_REGS_BASE,    0,      INTER_REGS_SIZE} ,0x8       ,EN},
	{{DEVICE_CS0_BASE,    0,      DEVICE_CS0_SIZE} ,0x5	  ,DIS},
	{{DEVICE_CS1_BASE,    0,      DEVICE_CS1_SIZE} ,0x6	  ,EN},	/* Big NOR Flash */
	{{DEVICE_CS2_BASE,    0,      DEVICE_CS2_SIZE} ,0x7	  ,EN}, /* Seven Segment */
	{{BOOTDEV_CS_BASE,    0,      BOOTDEV_CS_SIZE} ,0x4       ,EN}, /* Boot Flash */
	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

MV_CPU_DEC_WIN SYSMAP_DB_88F5181_5281_DDR2_BP[] = {
  	 /* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0,      SDRAM_CS0_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0,      SDRAM_CS1_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0,      SDRAM_CS2_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0,      SDRAM_CS3_SIZE } ,0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0,      PEX0_MEM_SIZE  } ,0x2       ,EN},
	{{PEX0_IO_BASE   ,    0,      PEX0_IO_SIZE   } ,0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0,      PCI0_MEM_SIZE  } ,0x3       ,EN},
	{{PCI0_IO_BASE   ,    0,      PCI0_IO_SIZE   } ,0x1       ,EN},
	{{INTER_REGS_BASE,    0,      INTER_REGS_SIZE} ,0x8       ,EN},
	{{DEVICE_CS0_BASE,    0,      DEVICE_CS0_SIZE} ,0x5	  ,DIS},	
	{{DEVICE_CS1_BASE,    0,      DEVICE_CS1_SIZE} ,0x6	  ,EN},	/* Big NOR Flash */		
	{{DEVICE_CS2_BASE,    0,      DEVICE_CS2_SIZE} ,0x7	  ,DIS},
	{{BOOTDEV_CS_BASE,    0,      BOOTDEV_CS_SIZE} ,0x4       ,EN},	/* Boot Flash */
	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

MV_CPU_DEC_WIN SYSMAP_DB_88F5x81_BP[] = {
  	 /* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0,      SDRAM_CS0_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0,      SDRAM_CS1_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0,      SDRAM_CS2_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0,      SDRAM_CS3_SIZE } ,0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0,      PEX0_MEM_SIZE  } ,0x2       ,EN},
	{{PEX0_IO_BASE   ,    0,      PEX0_IO_SIZE   } ,0x0       ,EN},
	{{PCI0_MEM_BASE  ,    0,      PCI0_MEM_SIZE  } ,0x3       ,EN},
	{{PCI0_IO_BASE   ,    0,      PCI0_IO_SIZE   } ,0x1       ,EN},
	{{INTER_REGS_BASE,    0,      INTER_REGS_SIZE} ,0x8       ,EN},
	{{DEVICE_CS0_BASE,    0,      DEVICE_CS0_SIZE} ,0x5	  ,EN},
	{{DEVICE_CS1_BASE,    0,      DEVICE_CS1_SIZE} ,0x6	  ,EN},
	{{DEVICE_CS2_BASE,    0,      DEVICE_CS2_SIZE} ,0x7	  ,EN},
	{{BOOTDEV_CS_BASE,    0,      BOOTDEV_CS_SIZE} ,0x4       ,EN},
	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

#elif defined(CONFIG_MV88F5082)

/* 
 *  System memory mapping 
 */

/* SDRAM: actual mapping is auto detected */
#define SDRAM_CS0_BASE  0x00000000
#define SDRAM_CS0_SIZE  _256M

#define SDRAM_CS1_BASE  0x10000000
#define SDRAM_CS1_SIZE  _256M

#define SDRAM_CS2_BASE  0x20000000
#define SDRAM_CS2_SIZE  _256M

#define SDRAM_CS3_BASE  0x30000000
#define SDRAM_CS3_SIZE  _256M

/* PEX */
#define PEX0_MEM_BASE 0xe0000000
#define PEX0_MEM_SIZE _128M

#define PEX0_IO_BASE 0xf2000000
#define PEX0_IO_SIZE _1M

/* Device Chip Selects */
#define DEVICE_CS0_BASE 0xfa000000
#define DEVICE_CS0_SIZE _2M

#define DEVICE_CS1_BASE 0xf4000000
#define DEVICE_CS1_SIZE _32M

#define DEVICE_CS2_BASE 0xfa800000
#define DEVICE_CS2_SIZE _1M

#define CRYPT_ENG_BASE	0xF0000000
#define CRYPT_ENG_SIZE	_64K

#define BOOTDEV_CS_BASE	0xff800000
#define BOOTDEV_CS_SIZE _8M

#if defined (MV_INCLUDE_PEX)

#define PCI_IF0_MEM0_BASE 	PEX0_MEM_BASE
#define PCI_IF0_MEM0_SIZE 	PEX0_MEM_SIZE
#define PCI_IF0_IO_BASE 	PEX0_IO_BASE
#define PCI_IF0_IO_SIZE 	PEX0_IO_SIZE

#endif

struct map_desc  MEM_TABLE[] =	{	
  { PCI_IF0_MEM0_BASE,  	__phys_to_pfn(PCI_IF0_MEM0_BASE),   	PCI_IF0_MEM0_SIZE,  	MT_DEVICE},
  { INTER_REGS_BASE, 		__phys_to_pfn(INTER_REGS_BASE), 	SZ_1M,  	     	MT_DEVICE},
  { PCI_IF0_IO_BASE,   		__phys_to_pfn(PCI_IF0_IO_BASE),   	PCI_IF0_IO_SIZE,  	MT_DEVICE},
  { DEVICE_CS2_BASE, 		__phys_to_pfn(DEVICE_CS2_BASE), 	DEVICE_CS2_SIZE, 	MT_DEVICE},
  { DEVICE_CS0_BASE, 		__phys_to_pfn(DEVICE_CS0_BASE), 	DEVICE_CS0_SIZE, 	MT_DEVICE},
  { CRYPT_ENG_BASE, 		__phys_to_pfn(CRYPT_ENG_BASE), 	CRYPT_ENG_SIZE, 	MT_DEVICE}
};


MV_CPU_DEC_WIN SYSMAP_DB_88F5082_BP[] = {
  	 /* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0,      SDRAM_CS0_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0,      SDRAM_CS1_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0,      SDRAM_CS2_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0,      SDRAM_CS3_SIZE } ,0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0,      PEX0_MEM_SIZE  } ,0x1       ,EN},
	{{PEX0_IO_BASE   ,    0,      PEX0_IO_SIZE   } ,0x0       ,EN},
	{{INTER_REGS_BASE,    0,      INTER_REGS_SIZE} ,0x8       ,EN},
	{{DEVICE_CS0_BASE,    0,      DEVICE_CS0_SIZE} ,0x2	  ,EN}, /* Seven Segment */
	{{DEVICE_CS1_BASE,    0,      DEVICE_CS1_SIZE} ,0x3	  ,EN}, /* Gig NOR Flash */
	{{DEVICE_CS2_BASE,    0,      DEVICE_CS2_SIZE} ,0x4	  ,DIS}, 
	{{BOOTDEV_CS_BASE,    0,      BOOTDEV_CS_SIZE} ,0x5       ,EN}, /* Boot Flash */
	{{CRYPT_ENG_BASE,     0,      CRYPT_ENG_SIZE}  ,0x7  	  ,EN},
	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}		
};

/* The same table used for both RD NAS2 and RD NAS3 */
MV_CPU_DEC_WIN SYSMAP_RD_88F5082[] = {
	 /* base low        base high    size       	WinNum     enable */
	{{SDRAM_CS0_BASE ,    0,      SDRAM_CS0_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS1_BASE ,    0,      SDRAM_CS1_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS2_BASE ,    0,      SDRAM_CS2_SIZE } ,0xFFFFFFFF,DIS},
	{{SDRAM_CS3_BASE ,    0,      SDRAM_CS3_SIZE } ,0xFFFFFFFF,DIS},
	{{PEX0_MEM_BASE  ,    0,      PEX0_MEM_SIZE  } ,0x1       ,EN},
	{{PEX0_IO_BASE   ,    0,      PEX0_IO_SIZE   } ,0x0       ,EN},
	{{INTER_REGS_BASE,    0,      INTER_REGS_SIZE} ,0x8       ,EN},
	{{DEVICE_CS0_BASE,    0,      DEVICE_CS0_SIZE} ,0x2	  ,DIS}, 
	{{DEVICE_CS1_BASE,    0,      DEVICE_CS1_SIZE} ,0x3	  ,EN}, /* Gig NOR Flash */
	{{DEVICE_CS2_BASE,    0,      DEVICE_CS2_SIZE} ,0x4	  ,DIS}, 
	{{BOOTDEV_CS_BASE,    0,      BOOTDEV_CS_SIZE} ,0x5       ,EN}, /* Boot Flash */
	{{CRYPT_ENG_BASE,     0,      CRYPT_ENG_SIZE}  ,0x7  	  ,EN},
	{{TBL_TERM,TBL_TERM, TBL_TERM} ,TBL_TERM  ,TBL_TERM}
};

#endif /* SOC type selection */



MV_CPU_DEC_WIN* mv_sys_map(void)
{
	char temp_str[80];
	sprintf(temp_str, "Board ID = %d\n", mvBoardIdGet());
	switch(mvBoardIdGet()) {
#if defined(CONFIG_MV88F5181L) 
		case DB_88F5181L_DDR2_2XTDM:
			return SYSMAP_DB_88F5181L_DDR2_2XTDM;
		case RD_88F5181L_VOIP_FE:
		case RD_88F5181L_VOIP_GE:
			return SYSMAP_RD2_5181L_FE_GE;
		case RD_88F5181L_VOIP_FXO_GE: 
			return SYSMAP_RD2_5181L_FXO;
#elif defined(CONFIG_MV88W8660)
		case RD_88W8660_DDR1:
			return SYSMAP_RD_88W8860_DDR1;
		case RD_88W8660_AP82S_DDR1:
			return SYSMAP_RD_88W8660_AP82S_DDR1;
		case DB_88W8660_DDR2: 
			return SYSMAP_DB_88W8660_DDR2; 
#elif defined(CONFIG_MV88F5181)
		case RD_88F5181_GTW_FE:
		case RD_88F5181_GTW_GE:
			return SYSMAP_RD_88F5181_GTW_FE_GE;
		case RD_88F5181_POS_NAS:
			return SYSMAP_RD_88F5181_88SX7042_2xSATA;
		case DB_88F5181_5281_DDR1:
			return SYSMAP_DB_88F5181_5281_DDR1_BP;
		case DB_88F5181_5281_DDR2:
			return SYSMAP_DB_88F5181_5281_DDR2_BP;
		case DB_88F5X81_DDR2:
		case DB_88F5X81_DDR1:
			return SYSMAP_DB_88F5x81_BP;
#elif defined(CONFIG_MV88F6082)
		case DB_88F6082_BP:
		case RD_88F6082_NAS:
		case DB_88F6082_SA:
		case RD_88F6082_DAS_PLUS:
		case RD_88F6082_GE_SATA:
		case DB_88F6082L_BP:
		case RD_88F6082_NAS_PH:
			return SYSMAP_DB_88F6082_BP;
#elif defined(CONFIG_MV88F5182)
		case RD_88F5182_2XSATA3:
		case RD_88F5182_2XSATA: 
			return SYSMAP_RD_88F5182;
		case DB_88F5182_DDR2: 
		case DB_88F5182_DDR2_A:
			return SYSMAP_DB_88F5182_DDR2_BP;
#elif defined(CONFIG_MV88F5082)
		case DB_88F5082_DDR2:
			return SYSMAP_DB_88F5082_BP;
		case RD_88F5082_2XSATA:
		case RD_88F5082_2XSATA3:
			return SYSMAP_RD_88F5082;

#endif
		default:
			printk("ERROR: can't find system address map\n");
				return NULL;
        }
}

u32 mv_pci_mem_base_get(int ifNum)
{
	if(ifNum == 0)
		return PCI_IF0_MEM0_BASE;
#if defined (MV_INCLUDE_PCI) && defined (MV_INCLUDE_PEX)
	else
		 return PCI_IF1_MEM0_BASE;
#else
		printk("%s: error, IF1 not exists\n", __FUNCTION__);
		return -1;
#endif
}

u32 mv_pci_mem_size_get(int ifNum)
{
	if(ifNum == 0)
		return PCI_IF0_MEM0_SIZE;
#if defined (MV_INCLUDE_PCI) && defined (MV_INCLUDE_PEX)
	else
		 return PCI_IF1_MEM0_SIZE;
#else
		printk("%s: error, IF1 not exists\n", __FUNCTION__);
		return -1;
#endif
}
u32 mv_pci_io_base_get(int ifNum)
{
	if(ifNum == 0)
		return PCI_IF0_IO_BASE;
#if defined (MV_INCLUDE_PCI) && defined (MV_INCLUDE_PEX)
	else
		 return PCI_IF1_IO_BASE;
#else
		printk("%s: error, IF1 not exists\n", __FUNCTION__);
		return -1;
#endif
}

u32 mv_pci_io_size_get(int ifNum)
{
	if(ifNum == 0)
		return PCI_IF0_IO_SIZE;
#if defined (MV_INCLUDE_PCI) && defined (MV_INCLUDE_PEX)
	else
		 return PCI_IF1_IO_SIZE;
#else
		printk("%s: error, IF1 not exists\n", __FUNCTION__);
		return -1;
#endif

}

#if defined(CONFIG_MV_INCLUDE_CESA)
u32 mv_crypo_base_get(void)
{
	return CRYPT_ENG_BASE;
}
#endif

void __init mv_map_io(void)
{
        iotable_init(MEM_TABLE, ARRAY_SIZE(MEM_TABLE));
}

#if defined(MV_INCLUDE_DEVICE_CS1)
u32 mv_device_cs1_base_get(void)
{
	return DEVICE_CS1_BASE;
}
#endif

